/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackReference$AttachOptions;
import com.sun.jna.CallbackReference$CallbackReferenceDisposer;
import com.sun.jna.CallbackReference$DefaultCallbackProxy;
import com.sun.jna.CallbackReference$NativeFunctionHandler;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.internal.Cleaner;
import com.sun.jna.internal.Cleaner$Cleanable;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackReference
extends WeakReference<Callback>
implements Closeable {
    static final Map<Callback, CallbackReference> callbackMap = new WeakHashMap<Callback, CallbackReference>();
    static final Map<Callback, CallbackReference> directCallbackMap = new WeakHashMap<Callback, CallbackReference>();
    static final Map<Pointer, Reference<Callback>[]> pointerCallbackMap = new WeakHashMap<Pointer, Reference<Callback>[]>();
    static final Map<Object, Object> allocations = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Long, Reference<CallbackReference>> allocatedMemory = new ConcurrentHashMap<Long, Reference<CallbackReference>>();
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Class<?> DLL_CALLBACK_CLASS;
    private static final Map<Callback, CallbackThreadInitializer> initializers;
    Cleaner$Cleanable cleanable;
    Pointer cbstruct;
    Pointer trampoline;
    CallbackProxy proxy;
    Method method;
    int callingConvention;

    static CallbackThreadInitializer setCallbackThreadInitializer(Callback callback, CallbackThreadInitializer callbackThreadInitializer) {
        Map<Callback, CallbackThreadInitializer> map = initializers;
        synchronized (map) {
            if (callbackThreadInitializer != null) {
                return initializers.put(callback, callbackThreadInitializer);
            }
            return initializers.remove(callback);
        }
    }

    private static ThreadGroup initializeThread(Callback callback, CallbackReference$AttachOptions callbackReference$AttachOptions) {
        CallbackThreadInitializer callbackThreadInitializer;
        if (callback instanceof CallbackReference$DefaultCallbackProxy) {
            callback = ((CallbackReference$DefaultCallbackProxy)callback).getCallback();
        }
        Object object = initializers;
        synchronized (object) {
            callbackThreadInitializer = initializers.get(callback);
        }
        object = null;
        if (callbackThreadInitializer != null) {
            object = callbackThreadInitializer.getThreadGroup(callback);
            callbackReference$AttachOptions.name = callbackThreadInitializer.getName(callback);
            callbackReference$AttachOptions.daemon = callbackThreadInitializer.isDaemon(callback);
            callbackReference$AttachOptions.detach = callbackThreadInitializer.detach(callback);
            callbackReference$AttachOptions.write();
        }
        return object;
    }

    public static Callback getCallback(Class<?> clazz, Pointer pointer) {
        return CallbackReference.getCallback(clazz, pointer, false);
    }

    private static Callback getCallback(Class<?> clazz, Pointer pointer, boolean bl) {
        if (pointer == null) {
            return null;
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Callback type must be an interface");
        }
        Map<Callback, CallbackReference> map = bl ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            Reference<Callback>[] referenceArray = pointerCallbackMap.get(pointer);
            Callback callback = CallbackReference.getTypeAssignableCallback(clazz, referenceArray);
            if (callback != null) {
                return callback;
            }
            callback = CallbackReference.createCallback(clazz, pointer);
            pointerCallbackMap.put(pointer, CallbackReference.addCallbackToArray(callback, referenceArray));
            map.remove(callback);
            return callback;
        }
    }

    private static Callback getTypeAssignableCallback(Class<?> clazz, Reference<Callback>[] referenceArray) {
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.length; ++i) {
                Callback callback = referenceArray[i].get();
                if (callback == null || !clazz.isAssignableFrom(callback.getClass())) continue;
                return callback;
            }
        }
        return null;
    }

    private static Reference<Callback>[] addCallbackToArray(Callback callback, Reference<Callback>[] referenceArray) {
        int n = 1;
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.length; ++i) {
                if (referenceArray[i].get() == null) {
                    referenceArray[i] = null;
                    continue;
                }
                ++n;
            }
        }
        Reference[] referenceArray2 = new Reference[n];
        n = 0;
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.length; ++i) {
                if (referenceArray[i] == null) continue;
                referenceArray2[n++] = referenceArray[i];
            }
        }
        referenceArray2[n] = new WeakReference<Callback>(callback);
        return referenceArray2;
    }

    private static Callback createCallback(Class<?> clazz, Pointer object) {
        int n = AltCallingConvention.class.isAssignableFrom(clazz) ? 63 : 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(Native.getLibraryOptions(clazz));
        hashMap.put("invoking-method", CallbackReference.getCallbackMethod(clazz));
        object = new CallbackReference$NativeFunctionHandler((Pointer)object, n, hashMap);
        return (Callback)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
    }

    private CallbackReference(Callback callback, int n, boolean bl) {
        super(callback);
        long l;
        Object object;
        TypeMapper typeMapper = Native.getTypeMapper(callback.getClass());
        this.callingConvention = n;
        boolean bl2 = Platform.isPPC();
        if (bl) {
            object = CallbackReference.getCallbackMethod(callback);
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (bl2 && (classArray[i] == Float.TYPE || classArray[i] == Double.TYPE)) {
                    bl = false;
                    break;
                }
                if (typeMapper == null || typeMapper.getFromNativeConverter(classArray[i]) == null) continue;
                bl = false;
                break;
            }
            if (typeMapper != null && typeMapper.getToNativeConverter(((Method)object).getReturnType()) != null) {
                bl = false;
            }
        }
        object = Native.getStringEncoding(callback.getClass());
        if (bl) {
            this.method = CallbackReference.getCallbackMethod(callback);
            Class<?>[] classArray = this.method.getParameterTypes();
            Class<?> clazz = this.method.getReturnType();
            int n2 = 1;
            if (DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(callback)) {
                n2 = 3;
            }
            l = Native.createNativeCallback(callback, this.method, classArray, clazz, n, n2, (String)object);
        } else {
            int n3;
            Object object2;
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new CallbackReference$DefaultCallbackProxy(this, CallbackReference.getCallbackMethod(callback), typeMapper, (String)object);
            Class<?>[] classArray = this.proxy.getParameterTypes();
            Class<?> clazz = this.proxy.getReturnType();
            if (typeMapper != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    object2 = typeMapper.getFromNativeConverter(classArray[i]);
                    if (object2 == null) continue;
                    classArray[i] = object2.nativeType();
                }
                ToNativeConverter toNativeConverter = typeMapper.getToNativeConverter(clazz);
                if (toNativeConverter != null) {
                    clazz = toNativeConverter.nativeType();
                }
            }
            for (n3 = 0; n3 < classArray.length; ++n3) {
                classArray[n3] = this.getNativeType(classArray[n3]);
                if (CallbackReference.isAllowableNativeType(classArray[n3])) continue;
                object2 = "Callback argument " + classArray[n3] + " requires custom type conversion";
                throw new IllegalArgumentException((String)object2);
            }
            if (!CallbackReference.isAllowableNativeType(clazz = this.getNativeType(clazz))) {
                String string = "Callback return type " + clazz + " requires custom type conversion";
                throw new IllegalArgumentException(string);
            }
            n3 = DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(callback) ? 2 : 0;
            l = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, classArray, clazz, n, n3, (String)object);
        }
        Pointer pointer = this.cbstruct = l != 0L ? new Pointer(l) : null;
        if (l != 0L) {
            allocatedMemory.put(l, new WeakReference<CallbackReference>(this));
            this.cleanable = Cleaner.getCleaner().register(this, new CallbackReference$CallbackReferenceDisposer(this.cbstruct));
        }
    }

    private Class<?> getNativeType(Class<?> clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            Structure.validate(clazz);
            if (!Structure.ByValue.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                return NativeMappedConverter.getInstance(clazz).nativeType();
            }
            if (clazz == String.class || clazz == WString.class || clazz == String[].class || clazz == WString[].class || Callback.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        }
        return clazz;
    }

    private static Method checkMethod(Method object) {
        if (((Method)object).getParameterTypes().length > 256) {
            object = "Method signature exceeds the maximum parameter count: " + object;
            throw new UnsupportedOperationException((String)object);
        }
        return object;
    }

    static Class<?> findCallbackClass(Class<?> clazz) {
        while (true) {
            if (!Callback.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getName() + " is not derived from com.sun.jna.Callback");
            }
            if (clazz.isInterface()) {
                return clazz;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Callback.class.isAssignableFrom(classArray[i])) continue;
                try {
                    CallbackReference.getCallbackMethod(classArray[i]);
                    return classArray[i];
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
            }
            if (!Callback.class.isAssignableFrom(clazz.getSuperclass())) break;
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    private static Method getCallbackMethod(Class<?> object) {
        Object object2 = ((Class)object).getDeclaredMethods();
        object = ((Class)object).getMethods();
        object2 = new HashSet<Method>(Arrays.asList(object2));
        object2.retainAll(Arrays.asList(object));
        object = object2.iterator();
        while (object.hasNext()) {
            Method method = (Method)object.next();
            if (!Callback.FORBIDDEN_NAMES.contains(method.getName())) continue;
            object.remove();
        }
        object = object2.toArray(new Method[0]);
        if (((Method[])object).length == 1) {
            return CallbackReference.checkMethod((Method)object[0]);
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            object2 = object[i];
            if (!"callback".equals(((Method)object2).getName())) continue;
            return CallbackReference.checkMethod((Method)object2);
        }
        String string = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException(string);
    }

    private void setCallbackOptions(int n) {
        this.cbstruct.setInt(Native.POINTER_SIZE, n);
    }

    public Pointer getTrampoline() {
        if (this.trampoline == null) {
            this.trampoline = this.cbstruct.getPointer(0L);
        }
        return this.trampoline;
    }

    @Override
    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
        this.cbstruct = null;
    }

    @Deprecated
    protected void dispose() {
        this.close();
    }

    static void disposeAll() {
        Object object = new LinkedList<Reference<CallbackReference>>(allocatedMemory.values());
        object = object.iterator();
        while (object.hasNext()) {
            Reference reference = (Reference)object.next();
            if ((reference = (CallbackReference)reference.get()) == null) continue;
            ((CallbackReference)reference).close();
        }
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback object) {
        if (Proxy.isProxyClass(object.getClass()) && (object = Proxy.getInvocationHandler(object)) instanceof CallbackReference$NativeFunctionHandler) {
            return ((CallbackReference$NativeFunctionHandler)object).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback callback) {
        return CallbackReference.getFunctionPointer(callback, false);
    }

    private static Pointer getFunctionPointer(Callback callback, boolean bl) {
        if (callback == null) {
            return null;
        }
        Object object = CallbackReference.getNativeFunctionPointer(callback);
        if (object != null) {
            return object;
        }
        object = Native.getLibraryOptions(callback.getClass());
        int n = callback instanceof AltCallingConvention ? 63 : (object != null && object.containsKey("calling-convention") ? (Integer)object.get("calling-convention") : 0);
        Map<Callback, CallbackReference> map = bl ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            CallbackReference callbackReference = map.get(callback);
            if (callbackReference == null) {
                callbackReference = new CallbackReference(callback, n, bl);
                map.put(callback, callbackReference);
                pointerCallbackMap.put(callbackReference.getTrampoline(), CallbackReference.addCallbackToArray(callback, null));
                if (initializers.containsKey(callback)) {
                    callbackReference.setCallbackOptions(1);
                }
            }
            return callbackReference.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class<?> clazz) {
        return clazz == Void.TYPE || clazz == Void.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Character.TYPE || clazz == Character.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || Structure.ByValue.class.isAssignableFrom(clazz) && Structure.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz);
    }

    private static Pointer getNativeString(Object object, boolean bl) {
        if (object != null) {
            NativeString nativeString = new NativeString(object.toString(), bl);
            allocations.put(object, nativeString);
            return nativeString.getPointer();
        }
        return null;
    }

    static /* synthetic */ Callback access$000(CallbackReference callbackReference) {
        return callbackReference.getCallback();
    }

    static /* synthetic */ Pointer access$100(Object object, boolean bl) {
        return CallbackReference.getNativeString(object, bl);
    }

    static /* synthetic */ Map access$200() {
        return allocatedMemory;
    }

    static {
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod("callback", Object[].class);
        }
        catch (Exception exception) {
            throw new Error("Error looking up CallbackProxy.callback() method");
        }
        if (Platform.isWindows()) {
            try {
                DLL_CALLBACK_CLASS = Class.forName("com.sun.jna.win32.DLLCallback");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Error loading DLLCallback class", classNotFoundException);
            }
        } else {
            DLL_CALLBACK_CLASS = null;
        }
        initializers = new WeakHashMap<Callback, CallbackThreadInitializer>();
    }
}

