/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser$MSG;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class User32Util$MessageLoopThread
extends Thread {
    private volatile int nativeThreadId = 0;
    private volatile long javaThreadId = 0L;
    private final List<FutureTask> workQueue = Collections.synchronizedList(new ArrayList());
    private static long messageLoopId = 0L;

    public User32Util$MessageLoopThread() {
        this.setName("JNA User32 MessageLoop " + ++messageLoopId);
    }

    @Override
    public void run() {
        int n;
        WinUser$MSG winUser$MSG = new WinUser$MSG();
        User32.INSTANCE.PeekMessage(winUser$MSG, null, 0, 0, 0);
        this.javaThreadId = Thread.currentThread().getId();
        this.nativeThreadId = Kernel32.INSTANCE.GetCurrentThreadId();
        while ((n = User32.INSTANCE.GetMessage(winUser$MSG, null, 0, 0)) != 0) {
            if (n != -1) {
                while (!this.workQueue.isEmpty()) {
                    try {
                        FutureTask futureTask = this.workQueue.remove(0);
                        futureTask.run();
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                User32.INSTANCE.TranslateMessage(winUser$MSG);
                User32.INSTANCE.DispatchMessage(winUser$MSG);
                continue;
            }
            if (!this.getMessageFailed()) continue;
        }
        while (!this.workQueue.isEmpty()) {
            this.workQueue.remove(0).cancel(false);
        }
    }

    public <V> Future<V> runAsync(Callable<V> callable) {
        while (this.nativeThreadId == 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(User32Util$MessageLoopThread.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        this.workQueue.add(futureTask);
        User32.INSTANCE.PostThreadMessage(this.nativeThreadId, 1024, null, null);
        return futureTask;
    }

    public <V> V runOnThread(Callable<V> object) {
        while (this.javaThreadId == 0L) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(User32Util$MessageLoopThread.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        if (this.javaThreadId == Thread.currentThread().getId()) {
            return object.call();
        }
        Object object2 = this.runAsync((Callable<V>)object);
        try {
            return object2.get();
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            throw interruptedException;
        }
        catch (ExecutionException executionException) {
            object = executionException;
            object2 = executionException.getCause();
            if (object2 instanceof Exception) {
                throw (Exception)object2;
            }
            throw object;
        }
    }

    public void exit() {
        User32.INSTANCE.PostThreadMessage(this.nativeThreadId, 18, null, null);
    }

    protected boolean getMessageFailed() {
        int n = Kernel32.INSTANCE.GetLastError();
        Logger.getLogger("com.sun.jna.platform.win32.User32Util.MessageLoopThread").log(Level.WARNING, "Message loop was interrupted by an error. [lastError: {0}]", n);
        return true;
    }
}

