/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osjava.sj.loader.SJProperties;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlSJProperties
extends SJProperties {
    public XmlSJProperties() {
    }

    public XmlSJProperties(Properties properties) {
        super(properties);
    }

    @Override
    public void load(InputStream object) {
        Object object2 = DocumentBuilderFactory.newInstance();
        try {
            object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse((InputStream)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Unable to get DocumentBuilder from factory. " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException("Unable to parse document. " + sAXException.getMessage());
        }
        if (object != null) {
            this.loadDocument((Document)object);
        }
    }

    private void loadDocument(Document node) {
        node = node.getDocumentElement();
        String string = node.getNodeName();
        this.processChildren(string, node);
    }

    private void processChildren(String string, Node object) {
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            this.addNode(string, node);
            if (!node.hasAttributes()) continue;
            String string2 = string + this.getDelimiter() + node.getNodeName();
            this.addAttributes(string2, node.getAttributes());
        }
    }

    private void addNode(String string, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                string = string + this.getDelimiter() + node.getNodeName();
                break;
            }
            case 3: {
                this.store(string, node.getNodeValue());
            }
        }
        this.processChildren(string, node);
    }

    private void addAttributes(String string, NamedNodeMap namedNodeMap) {
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string2 = string + this.getDelimiter() + node.getNodeName();
            this.store(string2, node.getNodeValue());
        }
    }

    private void store(String string, String string2) {
        if (string2.trim().length() > 0) {
            this.setProperty(string, string2);
        }
    }
}

