/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArrayDeque$Companion;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b&\b\u0007\u0018\u0000 [*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001[B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0013\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0016\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0004H\u0002J\u001d\u0010'\u001a\u00020\u00142\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140)H\u0082\bJ\u000b\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\r\u0010,\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010+J\u0016\u0010-\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0015\u00100\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u0004H\u0083\b\u00a2\u0006\u0002\u0010.J\u0011\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0083\bJM\u00103\u001a\u00020\u00172>\u00104\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(\u000e\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u001705H\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020\u0014H\u0016J\u000b\u0010:\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0015\u0010;\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\r\u0010<\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010+J\u0010\u0010=\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004H\u0002J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010B\u001a\u00020\u0017H\u0002J\u0015\u0010C\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010D\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0015\u0010E\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010.J\u000b\u0010F\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\r\u0010G\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010+J\u000b\u0010H\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\r\u0010I\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010+J\u0018\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0014J\u0018\u0010M\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0002J\u0018\u0010N\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0002J\u0016\u0010O\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u001e\u0010P\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010QJ\u001d\u0010R\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bSJ\u0017\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0000\u00a2\u0006\u0004\bU\u0010VJ)\u0010T\u001a\b\u0012\u0004\u0012\u0002HW0\u000b\"\u0004\b\u0001\u0010W2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HW0\u000bH\u0000\u00a2\u0006\u0004\bU\u0010YJ\u0015\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0016\u00a2\u0006\u0002\u0010VJ'\u0010Z\u001a\b\u0012\u0004\u0012\u0002HW0\u000b\"\u0004\b\u0001\u0010W2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HW0\u000bH\u0016\u00a2\u0006\u0002\u0010YR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\\"}, d2={"Lkotlin/collections/ArrayDeque;", "E", "Lkotlin/collections/AbstractMutableList;", "initialCapacity", "", "(I)V", "()V", "elements", "", "(Ljava/util/Collection;)V", "elementData", "", "", "[Ljava/lang/Object;", "head", "<set-?>", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "addFirst", "(Ljava/lang/Object;)V", "addLast", "clear", "contains", "copyCollectionElements", "internalIndex", "copyElements", "newCapacity", "decremented", "ensureCapacity", "minCapacity", "filterInPlace", "predicate", "Lkotlin/Function1;", "first", "()Ljava/lang/Object;", "firstOrNull", "get", "(I)Ljava/lang/Object;", "incremented", "indexOf", "(Ljava/lang/Object;)I", "internalGet", "internalStructure", "structure", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "internalStructure$kotlin_stdlib", "isEmpty", "last", "lastIndexOf", "lastOrNull", "negativeMod", "nullifyNonEmpty", "internalFromIndex", "internalToIndex", "positiveMod", "registerModification", "remove", "removeAll", "removeAt", "removeFirst", "removeFirstOrNull", "removeLast", "removeLastOrNull", "removeRange", "fromIndex", "toIndex", "removeRangeShiftPreceding", "removeRangeShiftSucceeding", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "testRemoveRange", "testRemoveRange$kotlin_stdlib", "testToArray", "testToArray$kotlin_stdlib", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toArray", "Companion", "kotlin-stdlib"})
public final class ArrayDeque<E>
extends AbstractMutableList<E> {
    public static final ArrayDeque$Companion Companion = new ArrayDeque$Companion(null);
    private int head;
    private Object[] elementData;
    private int size;
    private static final Object[] emptyElementData = new Object[0];
    private static final int defaultMinCapacity = 10;

    @Override
    public final int getSize() {
        return this.size;
    }

    public ArrayDeque(int n) {
        Object[] objectArray;
        if (n == 0) {
            objectArray = emptyElementData;
        } else if (n > 0) {
            objectArray = new Object[n];
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = objectArray;
    }

    public ArrayDeque() {
        this.elementData = emptyElementData;
    }

    public ArrayDeque(Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        Collection<E> collection2 = collection;
        collection = collection2;
        collection = collection2;
        this.elementData = collection2.toArray(new Object[0]);
        this.size = this.elementData.length;
        if (this.elementData.length == 0) {
            this.elementData = emptyElementData;
        }
    }

    private final void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalStateException("Deque is too big.");
        }
        if (n <= this.elementData.length) {
            return;
        }
        if (this.elementData == emptyElementData) {
            this.elementData = new Object[RangesKt.coerceAtLeast(n, 10)];
            return;
        }
        n = AbstractList.Companion.newCapacity$kotlin_stdlib(this.elementData.length, n);
        this.copyElements(n);
    }

    private final void copyElements(int n) {
        Object[] objectArray = new Object[n];
        ArraysKt.copyInto(this.elementData, objectArray, 0, this.head, this.elementData.length);
        ArraysKt.copyInto(this.elementData, objectArray, this.elementData.length - this.head, 0, this.head);
        this.head = 0;
        this.elementData = objectArray;
    }

    private final E internalGet(int n) {
        return (E)this.elementData[n];
    }

    private final int positiveMod(int n) {
        if (n >= this.elementData.length) {
            return n - this.elementData.length;
        }
        return n;
    }

    private final int negativeMod(int n) {
        if (n < 0) {
            return n + this.elementData.length;
        }
        return n;
    }

    private final int internalIndex(int n) {
        ArrayDeque arrayDeque = this;
        return arrayDeque.positiveMod(arrayDeque.head + n);
    }

    private final int incremented(int n) {
        if (n == ArraysKt.getLastIndex(this.elementData)) {
            return 0;
        }
        return n + 1;
    }

    private final int decremented(int n) {
        if (n == 0) {
            return ArraysKt.getLastIndex(this.elementData);
        }
        return n - 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        return (E)this.elementData[this.head];
    }

    public final E firstOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)this.elementData[this.head];
    }

    public final E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
    }

    public final E lastOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
    }

    @Override
    public final void addFirst(E e) {
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        this.head = this.decremented(this.head);
        this.elementData[this.head] = e;
        this.size = this.size() + 1;
    }

    @Override
    public final void addLast(E e) {
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        ArrayDeque arrayDeque2 = this;
        this.elementData[arrayDeque2.positiveMod((int)(arrayDeque2.head + this.size()))] = e;
        this.size = this.size() + 1;
    }

    @Override
    public final E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        Object object = this.elementData[this.head];
        this.elementData[this.head] = null;
        this.head = this.incremented(this.head);
        this.size = this.size() - 1;
        return (E)object;
    }

    public final E removeFirstOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public final E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this));
        Object object = this.elementData[n];
        this.elementData[n] = null;
        this.size = this.size() - 1;
        return (E)object;
    }

    public final E removeLastOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public final boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public final void add(int n, E e) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.size());
        if (n == this.size()) {
            this.addLast(e);
            return;
        }
        if (n == 0) {
            this.addFirst(e);
            return;
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + 1);
        ArrayDeque arrayDeque2 = this;
        int n2 = arrayDeque2.positiveMod(arrayDeque2.head + n);
        if (n < this.size() + 1 >> 1) {
            n = this.decremented(n2);
            ArrayDeque arrayDeque3 = this;
            n2 = arrayDeque3.decremented(arrayDeque3.head);
            if (n >= this.head) {
                this.elementData[n2] = this.elementData[this.head];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head, this.head + 1, n + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head - 1, this.head, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, n + 1);
            }
            this.elementData[n] = e;
            this.head = n2;
        } else {
            ArrayDeque arrayDeque4 = this;
            n = arrayDeque4.positiveMod(arrayDeque4.head + this.size());
            if (n2 < n) {
                ArraysKt.copyInto(this.elementData, this.elementData, n2 + 1, n2, n);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, n);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, n2 + 1, n2, this.elementData.length - 1);
            }
            this.elementData[n2] = e;
        }
        this.size = this.size() + 1;
    }

    private final void copyCollectionElements(int n, Collection<? extends E> collection) {
        Iterator<E> iterator2 = collection.iterator();
        int n2 = this.elementData.length;
        while (n < n2 && iterator2.hasNext()) {
            this.elementData[n] = iterator2.next();
            ++n;
        }
        n2 = this.head;
        for (n = 0; n < n2 && iterator2.hasNext(); ++n) {
            this.elementData[n] = iterator2.next();
        }
        this.size = this.size() + collection.size();
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        if (collection.isEmpty()) {
            return false;
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + collection.size());
        ArrayDeque arrayDeque2 = this;
        arrayDeque2.copyCollectionElements(arrayDeque2.positiveMod(arrayDeque2.head + this.size()), collection);
        return true;
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.size());
        if (collection.isEmpty()) {
            return false;
        }
        if (n == this.size()) {
            return this.addAll(collection);
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureCapacity(arrayDeque.size() + collection.size());
        ArrayDeque arrayDeque2 = this;
        int n2 = arrayDeque2.positiveMod(arrayDeque2.head + this.size());
        ArrayDeque arrayDeque3 = this;
        int n3 = arrayDeque3.positiveMod(arrayDeque3.head + n);
        int n4 = collection.size();
        if (n < this.size() + 1 >> 1) {
            n = this.head - n4;
            if (n3 >= this.head) {
                if (n >= 0) {
                    ArraysKt.copyInto(this.elementData, this.elementData, n, this.head, n3);
                } else {
                    n2 = this.elementData.length - (n += this.elementData.length);
                    int n5 = n3 - this.head;
                    if (n2 >= n5) {
                        ArraysKt.copyInto(this.elementData, this.elementData, n, this.head, n3);
                    } else {
                        ArraysKt.copyInto(this.elementData, this.elementData, n, this.head, this.head + n2);
                        ArraysKt.copyInto(this.elementData, this.elementData, 0, this.head + n2, n3);
                    }
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, n, this.head, this.elementData.length);
                if (n4 >= n3) {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - n4, 0, n3);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - n4, 0, n4);
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, n4, n3);
                }
            }
            this.head = n;
            ArrayDeque arrayDeque4 = this;
            arrayDeque4.copyCollectionElements(arrayDeque4.negativeMod(n3 - n4), collection);
        } else {
            n = n3 + n4;
            if (n3 < n2) {
                if (n2 + n4 <= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, n, n3, n2);
                } else if (n >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, n - this.elementData.length, n3, n2);
                } else {
                    int n6 = n2 + n4 - this.elementData.length;
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, n2 - n6, n2);
                    ArraysKt.copyInto(this.elementData, this.elementData, n, n3, n2 - n6);
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, n4, 0, n2);
                if (n >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, n - this.elementData.length, n3, this.elementData.length);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, this.elementData.length - n4, this.elementData.length);
                    ArraysKt.copyInto(this.elementData, this.elementData, n, n3, this.elementData.length - n4);
                }
            }
            this.copyCollectionElements(n3, collection);
        }
        return true;
    }

    @Override
    public final E get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + n)];
    }

    @Override
    public final E set(int n, E e) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        ArrayDeque arrayDeque = this;
        n = arrayDeque.positiveMod(arrayDeque.head + n);
        Object object = this.elementData[n];
        this.elementData[n] = e;
        return (E)object;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int indexOf(Object object) {
        block4: {
            int n;
            int n2;
            block3: {
                ArrayDeque arrayDeque = this;
                n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
                if (this.head >= n2) break block3;
                for (int i = this.head; i < n2; ++i) {
                    if (!Intrinsics.areEqual(object, this.elementData[i])) continue;
                    return i - this.head;
                }
                break block4;
            }
            if (this.head < n2) break block4;
            int n3 = this.elementData.length;
            for (n = this.head; n < n3; ++n) {
                if (!Intrinsics.areEqual(object, this.elementData[n])) continue;
                return n - this.head;
            }
            for (n = 0; n < n2; ++n) {
                if (!Intrinsics.areEqual(object, this.elementData[n])) continue;
                return n + this.elementData.length - this.head;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < n) {
            int n2 = this.head;
            if (n2 <= --n) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n])) {
                        return n - this.head;
                    }
                    if (n != n2) {
                        --n;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.head > n) {
            --n;
            while (n >= 0) {
                if (Intrinsics.areEqual(object, this.elementData[n])) {
                    return n + this.elementData.length - this.head;
                }
                --n;
            }
            int n3 = this.head;
            n = ArraysKt.getLastIndex(this.elementData);
            if (n3 <= n) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n])) {
                        return n - this.head;
                    }
                    if (n == n3) break;
                    --n;
                }
            }
        }
        return -1;
    }

    @Override
    public final boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public final E removeAt(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.size());
        if (n == CollectionsKt.getLastIndex(this)) {
            return this.removeLast();
        }
        if (n == 0) {
            return this.removeFirst();
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + n);
        Object object = this.elementData[n2];
        if (n < this.size() >> 1) {
            if (n2 >= this.head) {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, n2);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, n2);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, this.elementData.length - 1);
            }
            this.elementData[this.head] = null;
            this.head = this.incremented(this.head);
        } else {
            ArrayDeque arrayDeque2 = this;
            n = arrayDeque2.positiveMod(arrayDeque2.head + CollectionsKt.getLastIndex(this));
            if (n2 <= n) {
                int n3 = n2;
                ArraysKt.copyInto(this.elementData, this.elementData, n3, n3 + 1, n + 1);
            } else {
                int n4 = n2;
                ArraysKt.copyInto(this.elementData, this.elementData, n4, n4 + 1, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, n + 1);
            }
            this.elementData[n] = null;
        }
        this.size = this.size() - 1;
        return (E)object;
    }

    @Override
    public final boolean removeAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        ArrayDeque arrayDeque = this;
        if (arrayDeque.isEmpty() || arrayDeque.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque2 = arrayDeque;
        int n = arrayDeque2.positiveMod(arrayDeque2.head + arrayDeque.size());
        int n2 = arrayDeque.head;
        boolean bl = false;
        if (arrayDeque.head < n) {
            for (int i = arrayDeque.head; i < n; ++i) {
                Object object = arrayDeque.elementData[i];
                Object object2 = object;
                if (!collection.contains(object2)) {
                    arrayDeque.elementData[n2++] = object;
                    continue;
                }
                bl = true;
            }
            ArraysKt.fill(arrayDeque.elementData, null, n2, n);
        } else {
            Object object;
            int n3;
            int n4 = arrayDeque.elementData.length;
            for (n3 = arrayDeque.head; n3 < n4; ++n3) {
                Object object3 = arrayDeque.elementData[n3];
                arrayDeque.elementData[n3] = null;
                object = object3;
                if (!collection.contains(object)) {
                    arrayDeque.elementData[n2++] = object3;
                    continue;
                }
                bl = true;
            }
            n2 = arrayDeque.positiveMod(n2);
            for (n3 = 0; n3 < n; ++n3) {
                Object object4 = arrayDeque.elementData[n3];
                arrayDeque.elementData[n3] = null;
                object = object4;
                if (!collection.contains(object)) {
                    arrayDeque.elementData[n2] = object4;
                    n2 = arrayDeque.incremented(n2);
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            arrayDeque.registerModification();
            arrayDeque.size = arrayDeque.negativeMod(n2 - arrayDeque.head);
        }
        return bl;
    }

    @Override
    public final boolean retainAll(Collection<? extends Object> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        ArrayDeque arrayDeque = this;
        if (arrayDeque.isEmpty() || arrayDeque.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque2 = arrayDeque;
        int n = arrayDeque2.positiveMod(arrayDeque2.head + arrayDeque.size());
        int n2 = arrayDeque.head;
        boolean bl = false;
        if (arrayDeque.head < n) {
            for (int i = arrayDeque.head; i < n; ++i) {
                Object object = arrayDeque.elementData[i];
                Object object2 = object;
                if (collection.contains(object2)) {
                    arrayDeque.elementData[n2++] = object;
                    continue;
                }
                bl = true;
            }
            ArraysKt.fill(arrayDeque.elementData, null, n2, n);
        } else {
            Object object;
            int n3;
            int n4 = arrayDeque.elementData.length;
            for (n3 = arrayDeque.head; n3 < n4; ++n3) {
                Object object3 = arrayDeque.elementData[n3];
                arrayDeque.elementData[n3] = null;
                object = object3;
                if (collection.contains(object)) {
                    arrayDeque.elementData[n2++] = object3;
                    continue;
                }
                bl = true;
            }
            n2 = arrayDeque.positiveMod(n2);
            for (n3 = 0; n3 < n; ++n3) {
                Object object4 = arrayDeque.elementData[n3];
                arrayDeque.elementData[n3] = null;
                object = object4;
                if (collection.contains(object)) {
                    arrayDeque.elementData[n2] = object4;
                    n2 = arrayDeque.incremented(n2);
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            arrayDeque.registerModification();
            arrayDeque.size = arrayDeque.negativeMod(n2 - arrayDeque.head);
        }
        return bl;
    }

    private final boolean filterInPlace(Function1<? super E, Boolean> function1) {
        if (this.isEmpty() || this.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int n2 = this.head;
        boolean bl = false;
        if (this.head < n) {
            for (int i = this.head; i < n; ++i) {
                Object object = this.elementData[i];
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n2++] = object;
                    continue;
                }
                bl = true;
            }
            ArraysKt.fill(this.elementData, null, n2, n);
        } else {
            int n3;
            int n4 = this.elementData.length;
            for (n3 = this.head; n3 < n4; ++n3) {
                Object object = this.elementData[n3];
                this.elementData[n3] = null;
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n2++] = object;
                    continue;
                }
                bl = true;
            }
            n2 = this.positiveMod(n2);
            for (n3 = 0; n3 < n; ++n3) {
                Object object = this.elementData[n3];
                this.elementData[n3] = null;
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n2] = object;
                    n2 = this.incremented(n2);
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            this.registerModification();
            this.size = this.negativeMod(n2 - this.head);
        }
        return bl;
    }

    @Override
    public final void clear() {
        if (!((Collection)this).isEmpty()) {
            this.registerModification();
            ArrayDeque arrayDeque = this;
            int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.nullifyNonEmpty(arrayDeque2.head, n);
        }
        this.head = 0;
        this.size = 0;
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        TArray = TArray.length >= this.size() ? TArray : ArraysKt.arrayOfNulls(TArray, this.size());
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < n) {
            ArraysKt.copyInto$default(this.elementData, TArray, 0, this.head, n, 2, null);
        } else if (!((Collection)this).isEmpty()) {
            ArraysKt.copyInto(this.elementData, TArray, 0, this.head, this.elementData.length);
            ArraysKt.copyInto(this.elementData, TArray, this.elementData.length - this.head, 0, n);
        }
        return CollectionsKt.terminateCollectionToArray(this.size(), TArray);
    }

    @Override
    public final Object[] toArray() {
        ArrayDeque arrayDeque = this;
        return arrayDeque.toArray(new Object[arrayDeque.size()]);
    }

    @Override
    protected final void removeRange(int n, int n2) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this.size());
        int n3 = n2 - n;
        if (n3 == 0) {
            return;
        }
        if (n3 == this.size()) {
            this.clear();
            return;
        }
        if (n3 == 1) {
            this.remove(n);
            return;
        }
        this.registerModification();
        if (n < this.size() - n2) {
            this.removeRangeShiftPreceding(n, n2);
            ArrayDeque arrayDeque = this;
            n = arrayDeque.positiveMod(arrayDeque.head + n3);
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.nullifyNonEmpty(arrayDeque2.head, n);
            this.head = n;
        } else {
            this.removeRangeShiftSucceeding(n, n2);
            ArrayDeque arrayDeque = this;
            n = arrayDeque.positiveMod(arrayDeque.head + this.size());
            ArrayDeque arrayDeque3 = this;
            arrayDeque3.nullifyNonEmpty(arrayDeque3.negativeMod(n - n3), n);
        }
        this.size = this.size() - n3;
    }

    private final void removeRangeShiftPreceding(int n, int n2) {
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + (n - 1));
        ArrayDeque arrayDeque2 = this;
        n2 = arrayDeque2.positiveMod(arrayDeque2.head + (n2 - 1));
        while (n > 0) {
            int n4 = n3 + 1;
            int n5 = n2 + 1;
            n4 = Math.min(n, Math.min(n4, n5));
            ArraysKt.copyInto(this.elementData, this.elementData, n2 - n4 + 1, n3 - n4 + 1, n3 + 1);
            n3 = this.negativeMod(n3 - n4);
            n2 = this.negativeMod(n2 - n4);
            n -= n4;
        }
    }

    private final void removeRangeShiftSucceeding(int n, int n2) {
        int n3;
        ArrayDeque arrayDeque = this;
        int n4 = arrayDeque.positiveMod(arrayDeque.head + n2);
        ArrayDeque arrayDeque2 = this;
        n = arrayDeque2.positiveMod(arrayDeque2.head + n);
        for (n2 = this.size() - n2; n2 > 0; n2 -= n3) {
            n3 = this.elementData.length - n4;
            int n5 = this.elementData.length - n;
            n3 = Math.min(n2, Math.min(n3, n5));
            int n6 = n4;
            ArraysKt.copyInto(this.elementData, this.elementData, n, n6, n6 + n3);
            n4 = this.positiveMod(n4 + n3);
            n = this.positiveMod(n + n3);
        }
    }

    private final void nullifyNonEmpty(int n, int n2) {
        if (n < n2) {
            ArraysKt.fill(this.elementData, null, n, n2);
            return;
        }
        ArraysKt.fill(this.elementData, null, n, this.elementData.length);
        ArraysKt.fill(this.elementData, null, 0, n2);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    public final <T> T[] testToArray$kotlin_stdlib(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return this.toArray(TArray);
    }

    public final Object[] testToArray$kotlin_stdlib() {
        return this.toArray();
    }

    public final void testRemoveRange$kotlin_stdlib(int n, int n2) {
        this.removeRange(n, n2);
    }

    public final void internalStructure$kotlin_stdlib(Function2<? super Integer, ? super Object[], Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        ArrayDeque arrayDeque = this;
        int n = arrayDeque.positiveMod(arrayDeque.head + this.size());
        n = this.isEmpty() || this.head < n ? this.head : this.head - this.elementData.length;
        function2.invoke((Integer)n, (Object[])this.toArray());
    }
}

