/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.ExposingBufferByteArrayOutputStream;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FilePathComponentsKt;
import kotlin.io.FilesKt__FileReadWriteKt$readLines$1;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a!\u0010\u0010\u001a\u00020\u0011*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0087\b\u001a!\u0010\u0013\u001a\u00020\u0014*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0087\b\u001aB\u0010\u0015\u001a\u00020\u0007*\u00020\b26\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00070\u0017\u001aJ\u0010\u0015\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000326\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00070\u0017\u001a7\u0010\u001d\u001a\u00020\u0007*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00070\u001e\u001a\r\u0010 \u001a\u00020!*\u00020\bH\u0087\b\u001a\u0014\u0010\"\u001a\n #*\u0004\u0018\u00010\u00050\u0005*\u00020\u000fH\u0000\u001a\r\u0010$\u001a\u00020%*\u00020\bH\u0087\b\u001a\u0017\u0010&\u001a\u00020'*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0087\b\u001a\n\u0010(\u001a\u00020\n*\u00020\b\u001a\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0**\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010+\u001a\u00020\r*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0017\u0010,\u001a\u00020-*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0087\b\u001aL\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0018\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r01\u0012\u0004\u0012\u0002H/0\u001eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0002\u00102\u001a\u0012\u00103\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u00104\u001a\u00020\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u00105\u001a\u00020\u0007*\u0002062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0017\u00107\u001a\u000208*\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0087\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00069"}, d2={"byteBufferForEncoding", "Ljava/nio/ByteBuffer;", "chunkSize", "", "encoder", "Ljava/nio/charset/CharsetEncoder;", "appendBytes", "", "Ljava/io/File;", "array", "", "appendText", "text", "", "charset", "Ljava/nio/charset/Charset;", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "bufferedWriter", "Ljava/io/BufferedWriter;", "forEachBlock", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "buffer", "bytesRead", "blockSize", "forEachLine", "Lkotlin/Function1;", "line", "inputStream", "Ljava/io/FileInputStream;", "newReplaceEncoder", "kotlin.jvm.PlatformType", "outputStream", "Ljava/io/FileOutputStream;", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/InputStreamReader;", "useLines", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/io/File;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "writeText", "writeTextImpl", "Ljava/io/OutputStream;", "writer", "Ljava/io/OutputStreamWriter;", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
class FilesKt__FileReadWriteKt
extends FilesKt__FilePathComponentsKt {
    private static final InputStreamReader reader(File file, Charset charset) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new InputStreamReader((InputStream)new FileInputStream(file), charset);
    }

    static /* synthetic */ InputStreamReader reader$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new InputStreamReader((InputStream)new FileInputStream(file), charset);
    }

    private static final BufferedReader bufferedReader(File object, Charset charset, int n) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return new BufferedReader((Reader)object, n);
    }

    static /* synthetic */ BufferedReader bufferedReader$default(File file, Charset charset, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Object object2 = file;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset);
        return new BufferedReader((Reader)object2, n);
    }

    private static final OutputStreamWriter writer(File file, Charset charset) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    static /* synthetic */ OutputStreamWriter writer$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
    }

    private static final BufferedWriter bufferedWriter(File object, Charset charset, int n) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        return new BufferedWriter((Writer)object, n);
    }

    static /* synthetic */ BufferedWriter bufferedWriter$default(File file, Charset charset, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Object object2 = file;
        object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), charset);
        return new BufferedWriter((Writer)object2, n);
    }

    private static final PrintWriter printWriter(File object, Charset charset) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        return new PrintWriter(new BufferedWriter((Writer)object, 8192));
    }

    static /* synthetic */ PrintWriter printWriter$default(File object, Charset charset, int n, Object object2) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        File file = object;
        object = file;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        return new PrintWriter(new BufferedWriter((Writer)object, 8192));
    }

    public static final byte[] readBytes(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            byte[] byArray;
            int n;
            Object object = (FileInputStream)closeable;
            int n2 = 0;
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("File " + file + " is too big (" + l + " bytes) to fit in memory.");
            }
            int n3 = (int)l;
            byte[] byArray2 = new byte[n3];
            while (n3 > 0 && (n = ((FileInputStream)object).read(byArray2, n2, n3)) >= 0) {
                n3 -= n;
                n2 += n;
            }
            if (n3 > 0) {
                byte[] byArray3 = Arrays.copyOf(byArray2, n2);
                byArray = byArray3;
                Intrinsics.checkNotNullExpressionValue(byArray3, "");
            } else {
                n = ((FileInputStream)object).read();
                if (n == -1) {
                    byArray = byArray2;
                } else {
                    ExposingBufferByteArrayOutputStream exposingBufferByteArrayOutputStream = new ExposingBufferByteArrayOutputStream(8193);
                    exposingBufferByteArrayOutputStream.write(n);
                    ByteStreamsKt.copyTo$default((InputStream)object, exposingBufferByteArrayOutputStream, 0, 2, null);
                    int n4 = byArray2.length + exposingBufferByteArrayOutputStream.size();
                    if (n4 < 0) {
                        throw new OutOfMemoryError("File " + file + " is too big to fit in memory.");
                    }
                    byte[] byArray4 = exposingBufferByteArrayOutputStream.getBuffer();
                    byte[] byArray5 = Arrays.copyOf(byArray2, n4);
                    Intrinsics.checkNotNullExpressionValue(byArray5, "");
                    byArray = ArraysKt.copyInto(byArray4, byArray5, byArray2.length, 0, exposingBufferByteArrayOutputStream.size());
                }
            }
            object = byArray;
            return object;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static final void writeBytes(File object, byte[] byArray) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(byArray, "");
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)object;
            fileOutputStream.write(byArray);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    public static final void appendBytes(File object, byte[] byArray) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(byArray, "");
        object = new FileOutputStream((File)object, true);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)object;
            fileOutputStream.write(byArray);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    public static final String readText(File object, Charset object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            Object object3 = (InputStreamReader)object;
            object3 = TextStreamsKt.readText((Reader)object3);
            return object3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object2 = throwable;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public static /* synthetic */ String readText$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readText(file, charset);
    }

    public static final void writeText(File object, String string, Charset charset) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)object;
            FilesKt.writeTextImpl(fileOutputStream, string, charset);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    public static /* synthetic */ void writeText$default(File file, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.writeText(file, string, charset);
    }

    public static final void appendText(File object, String string, Charset charset) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = new FileOutputStream((File)object, true);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)object;
            FilesKt.writeTextImpl(fileOutputStream, string, charset);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    public static /* synthetic */ void appendText$default(File file, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.appendText(file, string, charset);
    }

    public static final void writeTextImpl(OutputStream object, String string, Charset object2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(object2, "");
        if (string.length() < 16384) {
            byte[] byArray = string.getBytes((Charset)object2);
            Intrinsics.checkNotNullExpressionValue(byArray, "");
            ((OutputStream)object).write(byArray);
            return;
        }
        object2 = FilesKt.newReplaceEncoder((Charset)object2);
        CharBuffer charBuffer = CharBuffer.allocate(8192);
        Intrinsics.checkNotNull(object2);
        ByteBuffer byteBuffer = FilesKt.byteBufferForEncoding(8192, (CharsetEncoder)object2);
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            int n3 = Math.min(8192 - n2, string.length() - n);
            int n4 = n + n3;
            Object object3 = string;
            char[] cArray = charBuffer.array();
            Intrinsics.checkNotNullExpressionValue(cArray, "");
            Object object4 = cArray;
            ((String)object3).getChars(n, n4, (char[])object4, n2);
            charBuffer.limit(n3 + n2);
            object3 = ((CharsetEncoder)object2).encode(charBuffer, byteBuffer, n4 == string.length());
            object4 = object3;
            boolean bl = ((CoderResult)object3).isUnderflow();
            n = bl ? 1 : 0;
            if (!bl) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            ((OutputStream)object).write(byteBuffer.array(), 0, byteBuffer.position());
            if (charBuffer.position() != charBuffer.limit()) {
                charBuffer.put(0, charBuffer.get());
                n2 = 1;
            } else {
                n2 = 0;
            }
            charBuffer.clear();
            byteBuffer.clear();
            n = n4;
        }
    }

    public static final CharsetEncoder newReplaceEncoder(Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "");
        return charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public static final ByteBuffer byteBufferForEncoding(int n, CharsetEncoder charsetEncoder) {
        Intrinsics.checkNotNullParameter(charsetEncoder, "");
        int n2 = (int)Math.ceil(charsetEncoder.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(n * n2);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "");
        return byteBuffer;
    }

    public static final void forEachBlock(File file, Function2<? super byte[], ? super Integer, Unit> function2) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(function2, "");
        FilesKt.forEachBlock(file, 4096, function2);
    }

    public static final void forEachBlock(File object, int n, Function2<? super byte[], ? super Integer, Unit> function2) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(function2, "");
        byte[] byArray = new byte[RangesKt.coerceAtLeast(n, 512)];
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            int n2;
            FileInputStream fileInputStream = (FileInputStream)object;
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                function2.invoke((byte[])byArray, (Integer)n2);
            }
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    public static final void forEachLine(File file, Charset charset, Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(function1, "");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)), function1);
    }

    public static /* synthetic */ void forEachLine$default(File file, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.forEachLine(file, charset, function1);
    }

    private static final FileInputStream inputStream(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        return new FileInputStream(file);
    }

    private static final FileOutputStream outputStream(File file) {
        Intrinsics.checkNotNullParameter(file, "");
        return new FileOutputStream(file);
    }

    public static final List<String> readLines(File file, Charset charset) {
        Intrinsics.checkNotNullParameter(file, "");
        Intrinsics.checkNotNullParameter(charset, "");
        ArrayList<String> arrayList = new ArrayList<String>();
        FilesKt.forEachLine(file, charset, new FilesKt__FileReadWriteKt$readLines$1(arrayList));
        return arrayList;
    }

    public static /* synthetic */ List readLines$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readLines(file, charset);
    }

    public static final <T> T useLines(File object, Charset object2, Function1<? super Sequence<String>, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(object2, "");
        Intrinsics.checkNotNullParameter(function1, "");
        Object object3 = object;
        object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
        object = new BufferedReader((Reader)object3, 8192);
        object2 = null;
        try {
            object3 = (BufferedReader)object;
            object3 = function1.invoke(TextStreamsKt.lineSequence((BufferedReader)object3));
        }
        catch (Throwable throwable) {
            try {
                object3 = throwable;
                object2 = throwable;
                throw object3;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                } else if (object2 == null) {
                    object.close();
                } else {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        } else {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)object3;
    }

    public static /* synthetic */ Object useLines$default(File serializable, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(serializable, "");
        Intrinsics.checkNotNullParameter(charset, "");
        Intrinsics.checkNotNullParameter(function1, "");
        Object object2 = object = serializable;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset);
        object = new BufferedReader((Reader)object2, 8192);
        serializable = null;
        try {
            object2 = (BufferedReader)object;
            object2 = function1.invoke(TextStreamsKt.lineSequence((BufferedReader)object2));
        }
        catch (Throwable throwable) {
            try {
                object2 = throwable;
                serializable = throwable;
                throw object2;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                } else if (serializable == null) {
                    object.close();
                } else {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
        } else {
            object.close();
        }
        InlineMarker.finallyEnd(1);
        return object2;
    }
}

