/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import org.sqlite.core.CoreStatement;
import org.sqlite.jdbc3.JDBC3ResultSet;
import org.sqlite.jdbc4.JDBC4ResultSet$SqliteClob;
import org.sqlite.jdbc4.JDBC4Statement;

public class JDBC4ResultSet
extends JDBC3ResultSet
implements ResultSet,
ResultSetMetaData {
    public JDBC4ResultSet(CoreStatement coreStatement) {
        super(coreStatement);
    }

    @Override
    public void close() {
        boolean bl = this.isOpen();
        super.close();
        if (bl && this.stmt instanceof JDBC4Statement) {
            JDBC4Statement jDBC4Statement = (JDBC4Statement)this.stmt;
            if (jDBC4Statement.closeOnCompletion && !jDBC4Statement.isClosed()) {
                jDBC4Statement.close();
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public RowId getRowId(int n) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String string) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void updateNString(int n, String string) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int n) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String string) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int n) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int n) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String string) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int n) {
        String string = this.getString(n);
        return this.getNCharacterStreamInternal(string);
    }

    private Reader getNCharacterStreamInternal(String object) {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        return object;
    }

    @Override
    public Reader getNCharacterStream(String string) {
        string = this.getString(string);
        return this.getNCharacterStreamInternal(string);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) {
        if (clazz == null) {
            throw new SQLException("requested type cannot be null");
        }
        if (clazz == String.class) {
            return clazz.cast(this.getString(n));
        }
        if (clazz == Boolean.class) {
            return clazz.cast(this.getBoolean(n));
        }
        if (clazz == BigDecimal.class) {
            return clazz.cast(this.getBigDecimal(n));
        }
        if (clazz == byte[].class) {
            return clazz.cast(this.getBytes(n));
        }
        if (clazz == Date.class) {
            return clazz.cast(this.getDate(n));
        }
        if (clazz == Time.class) {
            return clazz.cast(this.getTime(n));
        }
        if (clazz == Timestamp.class) {
            return clazz.cast(this.getTimestamp(n));
        }
        if (clazz == LocalDate.class) {
            block25: {
                try {
                    Date date = this.getDate(n);
                    if (date == null) break block25;
                    return clazz.cast(date.toLocalDate());
                }
                catch (SQLException sQLException) {
                    return clazz.cast(LocalDate.parse(this.getString(n)));
                }
            }
            return null;
        }
        if (clazz == LocalTime.class) {
            block26: {
                try {
                    Time time = this.getTime(n);
                    if (time == null) break block26;
                    return clazz.cast(time.toLocalTime());
                }
                catch (SQLException sQLException) {
                    return clazz.cast(LocalTime.parse(this.getString(n)));
                }
            }
            return null;
        }
        if (clazz == LocalDateTime.class) {
            block27: {
                try {
                    Timestamp timestamp = this.getTimestamp(n);
                    if (timestamp == null) break block27;
                    return clazz.cast(timestamp.toLocalDateTime());
                }
                catch (SQLException sQLException) {
                    return clazz.cast(LocalDateTime.parse(this.getString(n)));
                }
            }
            return null;
        }
        JDBC4ResultSet jDBC4ResultSet = this;
        int n2 = jDBC4ResultSet.safeGetColumnType(jDBC4ResultSet.markCol(n));
        if (clazz == Double.class) {
            if (n2 == 1 || n2 == 2) {
                return clazz.cast(this.getDouble(n));
            }
            throw new SQLException("Bad value for type Double");
        }
        if (clazz == Long.class) {
            if (n2 == 1 || n2 == 2) {
                return clazz.cast(this.getLong(n));
            }
            throw new SQLException("Bad value for type Long");
        }
        if (clazz == Float.class) {
            if (n2 == 1 || n2 == 2) {
                return clazz.cast(Float.valueOf(this.getFloat(n)));
            }
            throw new SQLException("Bad value for type Float");
        }
        if (clazz == Integer.class) {
            if (n2 == 1 || n2 == 2) {
                return clazz.cast(this.getInt(n));
            }
            throw new SQLException("Bad value for type Integer");
        }
        throw this.unsupported();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        JDBC4ResultSet jDBC4ResultSet = this;
        return jDBC4ResultSet.getObject(jDBC4ResultSet.findColumn(string), clazz);
    }

    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    @Override
    public Array getArray(int n) {
        throw this.unsupported();
    }

    @Override
    public Array getArray(String string) {
        throw this.unsupported();
    }

    @Override
    public InputStream getAsciiStream(int n) {
        String string = this.getString(n);
        return this.getAsciiStreamInternal(string);
    }

    @Override
    public InputStream getAsciiStream(String string) {
        string = this.getString(string);
        return this.getAsciiStreamInternal(string);
    }

    private InputStream getAsciiStreamInternal(String object) {
        if (object == null) {
            return null;
        }
        try {
            object = new ByteArrayInputStream(((String)object).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return object;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) {
        throw this.unsupported();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) {
        throw this.unsupported();
    }

    @Override
    public Blob getBlob(int n) {
        throw this.unsupported();
    }

    @Override
    public Blob getBlob(String string) {
        throw this.unsupported();
    }

    @Override
    public Clob getClob(int n) {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new JDBC4ResultSet$SqliteClob(this, string);
    }

    @Override
    public Clob getClob(String string) {
        if ((string = this.getString(string)) == null) {
            return null;
        }
        return new JDBC4ResultSet$SqliteClob(this, string);
    }

    public Object getObject(int n, Map map) {
        throw this.unsupported();
    }

    public Object getObject(String string, Map map) {
        throw this.unsupported();
    }

    @Override
    public Ref getRef(int n) {
        throw this.unsupported();
    }

    @Override
    public Ref getRef(String string) {
        throw this.unsupported();
    }

    @Override
    public InputStream getUnicodeStream(int n) {
        return this.getAsciiStream(n);
    }

    @Override
    public InputStream getUnicodeStream(String string) {
        return this.getAsciiStream(string);
    }

    @Override
    public URL getURL(int n) {
        throw this.unsupported();
    }

    @Override
    public URL getURL(String string) {
        throw this.unsupported();
    }

    @Override
    public void insertRow() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public void moveToCurrentRow() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public void moveToInsertRow() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean previous() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean relative(int n) {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean absolute(int n) {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public void afterLast() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public void beforeFirst() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean first() {
        throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
    }

    @Override
    public void cancelRowUpdates() {
        throw this.unsupported();
    }

    @Override
    public void deleteRow() {
        throw this.unsupported();
    }

    @Override
    public void updateArray(int n, Array array) {
        throw this.unsupported();
    }

    @Override
    public void updateArray(String string, Array array) {
        throw this.unsupported();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) {
        throw this.unsupported();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) {
        throw this.unsupported();
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) {
        throw this.unsupported();
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        throw this.unsupported();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) {
        throw this.unsupported();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) {
        throw this.unsupported();
    }

    @Override
    public void updateBlob(int n, Blob blob) {
        throw this.unsupported();
    }

    @Override
    public void updateBlob(String string, Blob blob) {
        throw this.unsupported();
    }

    @Override
    public void updateBoolean(int n, boolean bl) {
        throw this.unsupported();
    }

    @Override
    public void updateBoolean(String string, boolean bl) {
        throw this.unsupported();
    }

    @Override
    public void updateByte(int n, byte by) {
        throw this.unsupported();
    }

    @Override
    public void updateByte(String string, byte by) {
        throw this.unsupported();
    }

    @Override
    public void updateBytes(int n, byte[] byArray) {
        throw this.unsupported();
    }

    @Override
    public void updateBytes(String string, byte[] byArray) {
        throw this.unsupported();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) {
        throw this.unsupported();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) {
        throw this.unsupported();
    }

    @Override
    public void updateClob(int n, Clob clob) {
        throw this.unsupported();
    }

    @Override
    public void updateClob(String string, Clob clob) {
        throw this.unsupported();
    }

    @Override
    public void updateDate(int n, Date date) {
        throw this.unsupported();
    }

    @Override
    public void updateDate(String string, Date date) {
        throw this.unsupported();
    }

    @Override
    public void updateDouble(int n, double d) {
        throw this.unsupported();
    }

    @Override
    public void updateDouble(String string, double d) {
        throw this.unsupported();
    }

    @Override
    public void updateFloat(int n, float f) {
        throw this.unsupported();
    }

    @Override
    public void updateFloat(String string, float f) {
        throw this.unsupported();
    }

    @Override
    public void updateInt(int n, int n2) {
        throw this.unsupported();
    }

    @Override
    public void updateInt(String string, int n) {
        throw this.unsupported();
    }

    @Override
    public void updateLong(int n, long l) {
        throw this.unsupported();
    }

    @Override
    public void updateLong(String string, long l) {
        throw this.unsupported();
    }

    @Override
    public void updateNull(int n) {
        throw this.unsupported();
    }

    @Override
    public void updateNull(String string) {
        throw this.unsupported();
    }

    @Override
    public void updateObject(int n, Object object) {
        throw this.unsupported();
    }

    @Override
    public void updateObject(int n, Object object, int n2) {
        throw this.unsupported();
    }

    @Override
    public void updateObject(String string, Object object) {
        throw this.unsupported();
    }

    @Override
    public void updateObject(String string, Object object, int n) {
        throw this.unsupported();
    }

    @Override
    public void updateRef(int n, Ref ref) {
        throw this.unsupported();
    }

    @Override
    public void updateRef(String string, Ref ref) {
        throw this.unsupported();
    }

    @Override
    public void updateRow() {
        throw this.unsupported();
    }

    @Override
    public void updateShort(int n, short s) {
        throw this.unsupported();
    }

    @Override
    public void updateShort(String string, short s) {
        throw this.unsupported();
    }

    @Override
    public void updateString(int n, String string) {
        throw this.unsupported();
    }

    @Override
    public void updateString(String string, String string2) {
        throw this.unsupported();
    }

    @Override
    public void updateTime(int n, Time time) {
        throw this.unsupported();
    }

    @Override
    public void updateTime(String string, Time time) {
        throw this.unsupported();
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) {
        throw this.unsupported();
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        throw this.unsupported();
    }

    @Override
    public void refreshRow() {
        throw this.unsupported();
    }

    static /* synthetic */ InputStream access$000(JDBC4ResultSet jDBC4ResultSet, String string) {
        return jDBC4ResultSet.getAsciiStreamInternal(string);
    }

    static /* synthetic */ Reader access$100(JDBC4ResultSet jDBC4ResultSet, String string) {
        return jDBC4ResultSet.getNCharacterStreamInternal(string);
    }
}

