import React, { HTMLAttributes } from 'react';
declare type Props<TTag extends keyof JSX.IntrinsicElements> = HTMLAttributes<TTag> & {
    children: React.ReactNode;
    /** Determines whether drag functionality is enabled, defaults to true */
    allowDrag?: boolean;
    /** Called when the user finishes a sorting gesture. */
    onSortEnd: (oldIndex: number, newIndex: number) => void;
    /** Class applied to the item being dragged */
    draggedItemClassName?: string;
    /** Determines which type of html tag will be used for a container element */
    as?: TTag;
    /** Determines if an axis should be locked */
    lockAxis?: 'x' | 'y';
    /** Reference to the Custom Holder element */
    customHolderRef?: React.RefObject<HTMLElement | null>;
};
declare const SortableList: <TTag extends "symbol" | "object" | "div" | "a" | "abbr" | "address" | "area" | "article" | "aside" | "audio" | "b" | "base" | "bdi" | "bdo" | "big" | "blockquote" | "body" | "br" | "button" | "canvas" | "caption" | "cite" | "code" | "col" | "colgroup" | "data" | "datalist" | "dd" | "del" | "details" | "dfn" | "dialog" | "dl" | "dt" | "em" | "embed" | "fieldset" | "figcaption" | "figure" | "footer" | "form" | "h1" | "h2" | "h3" | "h4" | "h5" | "h6" | "head" | "header" | "hgroup" | "hr" | "html" | "i" | "iframe" | "img" | "input" | "ins" | "kbd" | "keygen" | "label" | "legend" | "li" | "link" | "main" | "map" | "mark" | "menu" | "menuitem" | "meta" | "meter" | "nav" | "noindex" | "noscript" | "ol" | "optgroup" | "option" | "output" | "p" | "param" | "picture" | "pre" | "progress" | "q" | "rp" | "rt" | "ruby" | "s" | "samp" | "slot" | "script" | "section" | "select" | "small" | "source" | "span" | "strong" | "style" | "sub" | "summary" | "sup" | "table" | "template" | "tbody" | "td" | "textarea" | "tfoot" | "th" | "thead" | "time" | "title" | "tr" | "track" | "u" | "ul" | "var" | "video" | "wbr" | "webview" | "svg" | "animate" | "animateMotion" | "animateTransform" | "circle" | "clipPath" | "defs" | "desc" | "ellipse" | "feBlend" | "feColorMatrix" | "feComponentTransfer" | "feComposite" | "feConvolveMatrix" | "feDiffuseLighting" | "feDisplacementMap" | "feDistantLight" | "feDropShadow" | "feFlood" | "feFuncA" | "feFuncB" | "feFuncG" | "feFuncR" | "feGaussianBlur" | "feImage" | "feMerge" | "feMergeNode" | "feMorphology" | "feOffset" | "fePointLight" | "feSpecularLighting" | "feSpotLight" | "feTile" | "feTurbulence" | "filter" | "foreignObject" | "g" | "image" | "line" | "linearGradient" | "marker" | "mask" | "metadata" | "mpath" | "path" | "pattern" | "polygon" | "polyline" | "radialGradient" | "rect" | "stop" | "switch" | "text" | "textPath" | "tspan" | "use" | "view" = "div">({ children, allowDrag, onSortEnd, draggedItemClassName, as, lockAxis, customHolderRef, ...rest }: Props<TTag>) => React.ReactElement<{
    ref: React.MutableRefObject<HTMLElement | null>;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: boolean | "true" | "false" | "inherit" | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: boolean | "true" | "false" | undefined;
    hidden?: boolean | undefined;
    id?: string | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: boolean | "true" | "false" | undefined;
    style?: React.CSSProperties | undefined;
    tabIndex?: number | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    role?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: boolean | "true" | "false" | undefined;
    'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
    'aria-busy'?: boolean | "true" | "false" | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "step" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-disabled'?: boolean | "true" | "false" | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "execute" | "move" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: boolean | "true" | "false" | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: boolean | "true" | "false" | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "listbox" | "tree" | "grid" | undefined;
    'aria-hidden'?: boolean | "true" | "false" | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: boolean | "true" | "false" | undefined;
    'aria-multiline'?: boolean | "true" | "false" | undefined;
    'aria-multiselectable'?: boolean | "true" | "false" | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: boolean | "true" | "false" | undefined;
    'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: boolean | "true" | "false" | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: boolean | "true" | "false" | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCopyCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCut?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCutCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onPaste?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onPasteCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCompositionEnd?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionEndCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionStart?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionStartCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionUpdate?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionUpdateCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onFocus?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onFocusCapture?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onBlur?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onBlurCapture?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onChange?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onChangeCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onBeforeInput?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onBeforeInputCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInput?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInputCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onReset?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onResetCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onSubmit?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onSubmitCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInvalid?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInvalidCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onLoad?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onError?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onErrorCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onKeyDown?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyDownCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyPress?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyPressCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyUp?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyUpCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onAbort?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onAbortCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlay?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayThrough?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayThroughCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onDurationChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onDurationChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEmptied?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEmptiedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEncrypted?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEncryptedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEnded?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEndedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedData?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedDataCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedMetadata?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedMetadataCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadStart?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadStartCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPause?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPauseCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlay?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlayCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlaying?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlayingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onProgress?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onProgressCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onRateChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onRateChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeeked?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeekedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeeking?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeekingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onStalled?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onStalledCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSuspend?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSuspendCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTimeUpdate?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTimeUpdateCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onVolumeChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onVolumeChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onWaiting?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onWaitingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onAuxClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onAuxClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onContextMenu?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onContextMenuCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDoubleClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDoubleClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDrag?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnd?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEndCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnter?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnterCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragExit?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragExitCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragLeave?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragLeaveCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragOver?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragOverCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragStart?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragStartCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDrop?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDropCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onMouseDown?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseDownCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseEnter?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseLeave?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseMove?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseMoveCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOut?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOutCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOver?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOverCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseUp?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseUpCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onSelect?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSelectCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTouchCancel?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchCancelCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchEnd?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchEndCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchMove?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchMoveCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchStart?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchStartCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onPointerDown?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerDownCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerMove?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerMoveCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerUp?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerUpCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerCancel?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerCancelCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerEnter?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerEnterCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerLeave?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerLeaveCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOver?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOverCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOut?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOutCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onGotPointerCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onGotPointerCaptureCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onLostPointerCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onLostPointerCaptureCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onScroll?: ((event: React.UIEvent<TTag, UIEvent>) => void) | undefined;
    onScrollCapture?: ((event: React.UIEvent<TTag, UIEvent>) => void) | undefined;
    onWheel?: ((event: React.WheelEvent<TTag>) => void) | undefined;
    onWheelCapture?: ((event: React.WheelEvent<TTag>) => void) | undefined;
    onAnimationStart?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationStartCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationEnd?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationEndCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationIteration?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationIterationCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onTransitionEnd?: ((event: React.TransitionEvent<TTag>) => void) | undefined;
    onTransitionEndCapture?: ((event: React.TransitionEvent<TTag>) => void) | undefined;
} | {
    ref: React.MutableRefObject<HTMLElement | null>;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: boolean | "true" | "false" | "inherit" | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: boolean | "true" | "false" | undefined;
    hidden?: boolean | undefined;
    id?: string | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: boolean | "true" | "false" | undefined;
    style?: React.CSSProperties | undefined;
    tabIndex?: number | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    role?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: boolean | "true" | "false" | undefined;
    'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
    'aria-busy'?: boolean | "true" | "false" | undefined;
    'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "true" | "false" | "page" | "step" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-disabled'?: boolean | "true" | "false" | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "execute" | "move" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: boolean | "true" | "false" | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: boolean | "true" | "false" | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "listbox" | "tree" | "grid" | undefined;
    'aria-hidden'?: boolean | "true" | "false" | undefined;
    'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: boolean | "true" | "false" | undefined;
    'aria-multiline'?: boolean | "true" | "false" | undefined;
    'aria-multiselectable'?: boolean | "true" | "false" | undefined;
    'aria-orientation'?: "horizontal" | "vertical" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
    'aria-readonly'?: boolean | "true" | "false" | undefined;
    'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: boolean | "true" | "false" | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: boolean | "true" | "false" | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCopyCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCut?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCutCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onPaste?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onPasteCapture?: ((event: React.ClipboardEvent<TTag>) => void) | undefined;
    onCompositionEnd?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionEndCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionStart?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionStartCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionUpdate?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onCompositionUpdateCapture?: ((event: React.CompositionEvent<TTag>) => void) | undefined;
    onFocus?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onFocusCapture?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onBlur?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onBlurCapture?: ((event: React.FocusEvent<TTag>) => void) | undefined;
    onChange?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onChangeCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onBeforeInput?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onBeforeInputCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInput?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInputCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onReset?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onResetCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onSubmit?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onSubmitCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInvalid?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onInvalidCapture?: ((event: React.FormEvent<TTag>) => void) | undefined;
    onLoad?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onError?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onErrorCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onKeyDown?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyDownCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyPress?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyPressCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyUp?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onKeyUpCapture?: ((event: React.KeyboardEvent<TTag>) => void) | undefined;
    onAbort?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onAbortCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlay?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayThrough?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onCanPlayThroughCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onDurationChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onDurationChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEmptied?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEmptiedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEncrypted?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEncryptedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEnded?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onEndedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedData?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedDataCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedMetadata?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadedMetadataCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadStart?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onLoadStartCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPause?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPauseCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlay?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlayCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlaying?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onPlayingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onProgress?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onProgressCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onRateChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onRateChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeeked?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeekedCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeeking?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSeekingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onStalled?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onStalledCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSuspend?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSuspendCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTimeUpdate?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTimeUpdateCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onVolumeChange?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onVolumeChangeCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onWaiting?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onWaitingCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onAuxClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onAuxClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onContextMenu?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onContextMenuCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDoubleClick?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDoubleClickCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onDrag?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnd?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEndCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnter?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragEnterCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragExit?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragExitCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragLeave?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragLeaveCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragOver?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragOverCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragStart?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDragStartCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDrop?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onDropCapture?: ((event: React.DragEvent<TTag>) => void) | undefined;
    onMouseDown: ((e: React.MouseEvent<HTMLElement, MouseEvent>) => void) | ((event: React.MouseEvent<TTag, MouseEvent>) => void);
    onMouseDownCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseEnter?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseLeave?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseMove?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseMoveCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOut?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOutCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOver?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseOverCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseUp?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onMouseUpCapture?: ((event: React.MouseEvent<TTag, MouseEvent>) => void) | undefined;
    onSelect?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onSelectCapture?: ((event: React.SyntheticEvent<TTag, Event>) => void) | undefined;
    onTouchCancel?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchCancelCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchEnd?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchEndCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchMove?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchMoveCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchStart?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onTouchStartCapture?: ((event: React.TouchEvent<TTag>) => void) | undefined;
    onPointerDown?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerDownCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerMove?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerMoveCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerUp?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerUpCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerCancel?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerCancelCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerEnter?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerEnterCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerLeave?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerLeaveCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOver?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOverCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOut?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onPointerOutCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onGotPointerCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onGotPointerCaptureCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onLostPointerCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onLostPointerCaptureCapture?: ((event: React.PointerEvent<TTag>) => void) | undefined;
    onScroll?: ((event: React.UIEvent<TTag, UIEvent>) => void) | undefined;
    onScrollCapture?: ((event: React.UIEvent<TTag, UIEvent>) => void) | undefined;
    onWheel?: ((event: React.WheelEvent<TTag>) => void) | undefined;
    onWheelCapture?: ((event: React.WheelEvent<TTag>) => void) | undefined;
    onAnimationStart?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationStartCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationEnd?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationEndCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationIteration?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onAnimationIterationCapture?: ((event: React.AnimationEvent<TTag>) => void) | undefined;
    onTransitionEnd?: ((event: React.TransitionEvent<TTag>) => void) | undefined;
    onTransitionEndCapture?: ((event: React.TransitionEvent<TTag>) => void) | undefined;
}, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)>;
export default SortableList;
declare type ItemProps = {
    children: React.ReactElement;
};
/**
 * SortableItem only adds a ref to its children so that we can register it to the main Sortable
 */
export declare const SortableItem: ({ children }: ItemProps) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)>;
export declare const SortableKnob: ({ children }: ItemProps) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)>;
//# sourceMappingURL=index.d.ts.map