package com.ustadmobile.libcache.db.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.libcache.db.entities.RetentionLock
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class RetentionLockDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract fun insert(retentionLock: RetentionLock): Long

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract fun upsertList(retentionLocks: List<RetentionLock>)

  @Delete(entity = Any::class)
  public actual abstract fun delete(retentionLocks: List<RetentionLock>)

  @Query(`value` =
      "\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey IN \n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = :batchId)\n    ")
  public actual abstract fun findByBatchId(batchId: Int): List<RetentionLock>

  @Query(`value` =
      "\n        SELECT RetentionLock.*\n          FROM RetentionLock\n         WHERE RetentionLock.lockKey = :urlKey \n    ")
  public actual abstract fun findByKey(urlKey: String): List<RetentionLock>
}
