package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.entities.RequestedEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class RequestedEntryDao_Impl extends RequestedEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<RequestedEntry> __insertionAdapterOfRequestedEntry;

  private final SharedSQLiteStatement __preparedStmtOfDeleteBatch;

  public RequestedEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfRequestedEntry = new EntityInsertionAdapter<RequestedEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `RequestedEntry` (`id`,`requestSha256`,`requestedKey`,`batchId`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final RequestedEntry entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getRequestSha256());
        statement.bindString(3, entity.getRequestedKey());
        statement.bindLong(4, entity.getBatchId());
      }
    };
    this.__preparedStmtOfDeleteBatch = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        DELETE FROM RequestedEntry\n"
                + "         WHERE RequestedEntry.batchId = ?    \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public void insertList(final List<RequestedEntry> requestedSha256s) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfRequestedEntry.insert(requestedSha256s);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<RequestedEntry> requestedSha256s,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfRequestedEntry.insert(requestedSha256s);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void deleteBatch(final int batchId) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteBatch.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, batchId);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteBatch.release(_stmt);
    }
  }

  @Override
  public List<String> findKeysNotPresent(final int batchId) {
    final String _sql = "\n"
            + "        SELECT RequestedEntry.requestedKey\n"
            + "          FROM RequestedEntry\n"
            + "         WHERE RequestedEntry.batchId = ? \n"
            + "           AND NOT EXISTS(\n"
            + "               SELECT CacheEntry.key\n"
            + "                 FROM CacheEntry\n"
            + "                WHERE CacheEntry.key = RequestedEntry.requestedKey\n"
            + "           )\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, batchId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<String> _result = new ArrayList<String>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final String _item;
        _item = _cursor.getString(0);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
