package com.ustadmobile.centralappconfigdb.sqlite

import app.cash.sqldelight.Transacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.ustadmobile.centralappconfigdb.db.LearningSpaceQueries
import com.ustadmobile.centralappconfigdb.db.SystemConfigAuthQueries
import com.ustadmobile.centralappconfigdb.sqlite.libcentralappconfigdbsqldelight.newInstance
import com.ustadmobile.centralappconfigdb.sqlite.libcentralappconfigdbsqldelight.schema
import kotlin.Unit

public interface CentralAppConfigDb : Transacter {
  public val learningSpaceQueries: LearningSpaceQueries

  public val systemConfigAuthQueries: SystemConfigAuthQueries

  public companion object {
    public val Schema: SqlSchema<QueryResult.Value<Unit>>
      get() = CentralAppConfigDb::class.schema

    public operator fun invoke(driver: SqlDriver): CentralAppConfigDb =
        CentralAppConfigDb::class.newInstance(driver)
  }
}
