package com.ustadmobile.centralappconfigdb.sqlite.libcentralappconfigdbsqldelight

import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.ustadmobile.centralappconfigdb.db.LearningSpaceQueries
import com.ustadmobile.centralappconfigdb.db.SystemConfigAuthQueries
import com.ustadmobile.centralappconfigdb.sqlite.CentralAppConfigDb
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<CentralAppConfigDb>.schema: SqlSchema<QueryResult.Value<Unit>>
  get() = CentralAppConfigDbImpl.Schema

internal fun KClass<CentralAppConfigDb>.newInstance(driver: SqlDriver): CentralAppConfigDb =
    CentralAppConfigDbImpl(driver)

private class CentralAppConfigDbImpl(
  driver: SqlDriver,
) : TransacterImpl(driver), CentralAppConfigDb {
  override val learningSpaceQueries: LearningSpaceQueries = LearningSpaceQueries(driver)

  override val systemConfigAuthQueries: SystemConfigAuthQueries = SystemConfigAuthQueries(driver)

  public object Schema : SqlSchema<QueryResult.Value<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.Value<Unit> {
      driver.execute(null, """
          |CREATE TABLE LearningSpaceEntity (
          |    lsUid INTEGER PRIMARY KEY NOT NULL,
          |    lsUrl TEXT NOT NULL,
          |    lsName TEXT NOT NULL,
          |    lsDescription TEXT NOT NULL,
          |    lsLastModified INTEGER NOT NULL DEFAULT 0,
          |    lsDbUrl TEXT NOT NULL,
          |    lsDbUsername TEXT,
          |    lsDbPassword TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE SystemConfigAuth(
          |    scaUid INTEGER PRIMARY KEY NOT NULL,
          |    scaAuthType INTEGER NOT NULL DEFAULT 0,
          |    scaAuthId TEXT NOT NULL,
          |    scaAuthCredential TEXT NOT NULL,
          |    scaAuthSalt TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      return QueryResult.Unit
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.Value<Unit> = QueryResult.Unit
  }
}
