/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzInviteDao;
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz;
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzInvite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ClazzInviteDao_Impl
extends ClazzInviteDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite;
    private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite_1;
    private final EntityInsertionAdapter<ClazzInvite> __insertionAdapterOfClazzInvite_2;
    private final EntityDeletionOrUpdateAdapter<ClazzInvite> __updateAdapterOfClazzInvite;
    private final EntityDeletionOrUpdateAdapter<ClazzInvite> __updateAdapterOfClazzInvite_1;
    private final SharedSQLiteStatement __preparedStmtOfUpdateInviteStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateClazzInviteToRevokeInvite;

    public ClazzInviteDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazzInvite = new EntityInsertionAdapter<ClazzInvite>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzInvite entity) {
                statement.bindLong(1, entity.getCiUid());
                statement.bindLong(2, entity.getCiPersonUid());
                statement.bindLong(3, entity.getCiRoleId());
                statement.bindLong(4, entity.getCiClazzUid());
                statement.bindLong(5, (long)entity.getInviteType());
                statement.bindString(6, entity.getInviteContact());
                statement.bindString(7, entity.getInviteToken());
                statement.bindLong(8, (long)entity.getInviteStatus());
                statement.bindLong(9, entity.getInviteExpire());
                statement.bindLong(10, entity.getInviteLct());
            }
        };
        this.__insertionAdapterOfClazzInvite_1 = new EntityInsertionAdapter<ClazzInvite>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzInvite entity) {
                statement.bindLong(1, entity.getCiUid());
                statement.bindLong(2, entity.getCiPersonUid());
                statement.bindLong(3, entity.getCiRoleId());
                statement.bindLong(4, entity.getCiClazzUid());
                statement.bindLong(5, (long)entity.getInviteType());
                statement.bindString(6, entity.getInviteContact());
                statement.bindString(7, entity.getInviteToken());
                statement.bindLong(8, (long)entity.getInviteStatus());
                statement.bindLong(9, entity.getInviteExpire());
                statement.bindLong(10, entity.getInviteLct());
            }
        };
        this.__insertionAdapterOfClazzInvite_2 = new EntityInsertionAdapter<ClazzInvite>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `ClazzInvite` (`ciUid`,`ciPersonUid`,`ciRoleId`,`ciClazzUid`,`inviteType`,`inviteContact`,`inviteToken`,`inviteStatus`,`inviteExpire`,`inviteLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzInvite entity) {
                statement.bindLong(1, entity.getCiUid());
                statement.bindLong(2, entity.getCiPersonUid());
                statement.bindLong(3, entity.getCiRoleId());
                statement.bindLong(4, entity.getCiClazzUid());
                statement.bindLong(5, (long)entity.getInviteType());
                statement.bindString(6, entity.getInviteContact());
                statement.bindString(7, entity.getInviteToken());
                statement.bindLong(8, (long)entity.getInviteStatus());
                statement.bindLong(9, entity.getInviteExpire());
                statement.bindLong(10, entity.getInviteLct());
            }
        };
        this.__updateAdapterOfClazzInvite = new EntityDeletionOrUpdateAdapter<ClazzInvite>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ClazzInvite` SET `ciUid` = ?,`ciPersonUid` = ?,`ciRoleId` = ?,`ciClazzUid` = ?,`inviteType` = ?,`inviteContact` = ?,`inviteToken` = ?,`inviteStatus` = ?,`inviteExpire` = ?,`inviteLct` = ? WHERE `ciUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzInvite entity) {
                statement.bindLong(1, entity.getCiUid());
                statement.bindLong(2, entity.getCiPersonUid());
                statement.bindLong(3, entity.getCiRoleId());
                statement.bindLong(4, entity.getCiClazzUid());
                statement.bindLong(5, (long)entity.getInviteType());
                statement.bindString(6, entity.getInviteContact());
                statement.bindString(7, entity.getInviteToken());
                statement.bindLong(8, (long)entity.getInviteStatus());
                statement.bindLong(9, entity.getInviteExpire());
                statement.bindLong(10, entity.getInviteLct());
                statement.bindLong(11, entity.getCiUid());
            }
        };
        this.__updateAdapterOfClazzInvite_1 = new EntityDeletionOrUpdateAdapter<ClazzInvite>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR IGNORE `ClazzInvite` SET `ciUid` = ?,`ciPersonUid` = ?,`ciRoleId` = ?,`ciClazzUid` = ?,`inviteType` = ?,`inviteContact` = ?,`inviteToken` = ?,`inviteStatus` = ?,`inviteExpire` = ?,`inviteLct` = ? WHERE `ciUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzInvite entity) {
                statement.bindLong(1, entity.getCiUid());
                statement.bindLong(2, entity.getCiPersonUid());
                statement.bindLong(3, entity.getCiRoleId());
                statement.bindLong(4, entity.getCiClazzUid());
                statement.bindLong(5, (long)entity.getInviteType());
                statement.bindString(6, entity.getInviteContact());
                statement.bindString(7, entity.getInviteToken());
                statement.bindLong(8, (long)entity.getInviteStatus());
                statement.bindLong(9, entity.getInviteExpire());
                statement.bindLong(10, entity.getInviteLct());
                statement.bindLong(11, entity.getCiUid());
            }
        };
        this.__preparedStmtOfUpdateInviteStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzInvite \n           SET inviteStatus = ?,\n               inviteLct = ?\n         WHERE ClazzInvite.ciUid =?\n    ";
                return "\n        UPDATE ClazzInvite \n           SET inviteStatus = ?,\n               inviteLct = ?\n         WHERE ClazzInvite.ciUid =?\n    ";
            }
        };
        this.__preparedStmtOfUpdateClazzInviteToRevokeInvite = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzInvite \n          SET inviteStatus = 3\n        WHERE inviteContact = ?";
                return "\n        UPDATE ClazzInvite \n          SET inviteStatus = 3\n        WHERE inviteContact = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ClazzInvite entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzInvite.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ClazzInvite entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzInviteDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzInviteDao_Impl.this.__insertionAdapterOfClazzInvite.insertAndReturnId((Object)entity);
                    ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ClazzInvite> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzInvite.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object replace(final ClazzInvite entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzInviteDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzInviteDao_Impl.this.__insertionAdapterOfClazzInvite_1.insertAndReturnId((Object)entity);
                    ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertAll(final List<ClazzInvite> entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzInviteDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzInviteDao_Impl.this.__insertionAdapterOfClazzInvite_2.insert((Iterable)entity);
                    ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(ClazzInvite entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazzInvite.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAll(final List<ClazzInvite> entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzInviteDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzInviteDao_Impl.this.__updateAdapterOfClazzInvite_1.handleMultiple((Iterable)entity);
                    ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateInviteStatus(final int status, final long ciUid, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzInviteDao_Impl.this.__preparedStmtOfUpdateInviteStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, ciUid);
                try {
                    Unit unit;
                    ClazzInviteDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ClazzInviteDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ClazzInviteDao_Impl.this.__preparedStmtOfUpdateInviteStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateClazzInviteToRevokeInvite(final String inviteContact, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzInviteDao_Impl.this.__preparedStmtOfUpdateClazzInviteToRevokeInvite.acquire();
                int _argIndex = 1;
                _stmt.bindString(_argIndex, inviteContact);
                try {
                    Integer n;
                    ClazzInviteDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        ClazzInviteDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        ClazzInviteDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzInviteDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    ClazzInviteDao_Impl.this.__preparedStmtOfUpdateClazzInviteToRevokeInvite.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findInviteAsync(Continuation<? super List<ClazzInvite>> $completion) {
        String _sql = "SELECT * FROM ClazzInvite";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzInvite", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzInvite>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzInvite> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzInviteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciUid");
                    int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciPersonUid");
                    int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciRoleId");
                    int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciClazzUid");
                    int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteType");
                    int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteContact");
                    int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteToken");
                    int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteStatus");
                    int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteExpire");
                    int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteLct");
                    ArrayList<ClazzInvite> _result2 = new ArrayList<ClazzInvite>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
                        long _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
                        long _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
                        long _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
                        int _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
                        String _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
                        String _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
                        int _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
                        long _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
                        long _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
                        ClazzInvite _item = new ClazzInvite(_tmpCiUid, _tmpCiPersonUid, _tmpCiRoleId, _tmpCiClazzUid, _tmpInviteType, _tmpInviteContact, _tmpInviteToken, _tmpInviteStatus, _tmpInviteExpire, _tmpInviteLct);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzInvite> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findClazzInviteEntityForInviteToken(String inviteTokenUid, Continuation<? super ClazzInviteWithTimeZone> $completion) {
        String _sql = "\n    SELECT ClazzInvite.*, \n           COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n      FROM ClazzInvite\n           LEFT JOIN Clazz \n                     ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = ?\n";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n    SELECT ClazzInvite.*, \n           COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n      FROM ClazzInvite\n           LEFT JOIN Clazz \n                     ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = ?\n", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, inviteTokenUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzInviteWithTimeZone>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzInviteWithTimeZone call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzInviteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzInviteWithTimeZone _result2;
                    int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciUid");
                    int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciPersonUid");
                    int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciRoleId");
                    int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciClazzUid");
                    int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteType");
                    int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteContact");
                    int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteToken");
                    int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteStatus");
                    int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteExpire");
                    int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteLct");
                    int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeZone");
                    if (_cursor.moveToFirst()) {
                        ClazzInvite _tmpClazzInvite;
                        String _tmpTimeZone = _cursor.isNull(_cursorIndexOfTimeZone) ? null : _cursor.getString(_cursorIndexOfTimeZone);
                        if (!(_cursor.isNull(_cursorIndexOfCiUid) && _cursor.isNull(_cursorIndexOfCiPersonUid) && _cursor.isNull(_cursorIndexOfCiRoleId) && _cursor.isNull(_cursorIndexOfCiClazzUid) && _cursor.isNull(_cursorIndexOfInviteType) && _cursor.isNull(_cursorIndexOfInviteContact) && _cursor.isNull(_cursorIndexOfInviteToken) && _cursor.isNull(_cursorIndexOfInviteStatus) && _cursor.isNull(_cursorIndexOfInviteExpire) && _cursor.isNull(_cursorIndexOfInviteLct))) {
                            long _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
                            long _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
                            long _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
                            long _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
                            int _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
                            String _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
                            String _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
                            int _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
                            long _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
                            long _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
                            _tmpClazzInvite = new ClazzInvite(_tmpCiUid, _tmpCiPersonUid, _tmpCiRoleId, _tmpCiClazzUid, _tmpInviteType, _tmpInviteContact, _tmpInviteToken, _tmpInviteStatus, _tmpInviteExpire, _tmpInviteLct);
                        } else {
                            _tmpClazzInvite = null;
                        }
                        _result2 = new ClazzInviteWithTimeZone(_tmpClazzInvite, _tmpTimeZone);
                    } else {
                        _result2 = null;
                    }
                    ClazzInviteWithTimeZone clazzInviteWithTimeZone = _result2;
                    return clazzInviteWithTimeZone;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ClazzInviteAndClazz> findClazzInviteEntityForInviteTokenAsFlow(String inviteTokenUid) {
        String _sql = "\n    SELECT ClazzInvite.*, Clazz.*\n      FROM ClazzInvite\n           JOIN Clazz \n                ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n    SELECT ClazzInvite.*, Clazz.*\n      FROM ClazzInvite\n           JOIN Clazz \n                ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, inviteTokenUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzInvite", "Clazz"}, (Callable)new Callable<ClazzInviteAndClazz>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzInviteAndClazz call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzInviteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzInviteAndClazz _result2;
                    int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciUid");
                    int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciPersonUid");
                    int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciRoleId");
                    int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciClazzUid");
                    int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteType");
                    int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteContact");
                    int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteToken");
                    int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteStatus");
                    int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteExpire");
                    int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteLct");
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    if (_cursor.moveToFirst()) {
                        Clazz _tmpClazz;
                        ClazzInvite _tmpClazzInvite;
                        if (!(_cursor.isNull(_cursorIndexOfCiUid) && _cursor.isNull(_cursorIndexOfCiPersonUid) && _cursor.isNull(_cursorIndexOfCiRoleId) && _cursor.isNull(_cursorIndexOfCiClazzUid) && _cursor.isNull(_cursorIndexOfInviteType) && _cursor.isNull(_cursorIndexOfInviteContact) && _cursor.isNull(_cursorIndexOfInviteToken) && _cursor.isNull(_cursorIndexOfInviteStatus) && _cursor.isNull(_cursorIndexOfInviteExpire) && _cursor.isNull(_cursorIndexOfInviteLct))) {
                            long _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
                            long _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
                            long _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
                            long _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
                            int _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
                            String _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
                            String _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
                            int _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
                            long _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
                            long _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
                            _tmpClazzInvite = new ClazzInvite(_tmpCiUid, _tmpCiPersonUid, _tmpCiRoleId, _tmpCiClazzUid, _tmpInviteType, _tmpInviteContact, _tmpInviteToken, _tmpInviteStatus, _tmpInviteExpire, _tmpInviteLct);
                        } else {
                            _tmpClazzInvite = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
                            _tmpClazz = new Clazz();
                            long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                            _tmpClazz.setClazzUid(_tmpClazzUid);
                            String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                            _tmpClazz.setClazzName(_tmpClazzName);
                            String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                            _tmpClazz.setClazzDesc(_tmpClazzDesc);
                            float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                            _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                            long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                            _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                            long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                            _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                            int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                            boolean _tmpIsClazzActive = _tmp != 0;
                            _tmpClazz.setClazzActive(_tmpIsClazzActive);
                            long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                            _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                            long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                            _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                            long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                            _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                            long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                            _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                            long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                            _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                            int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                            _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                            long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                            _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                            long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                            _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                            long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                            _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                            int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                            _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                            long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                            _tmpClazz.setClazzLct(_tmpClazzLct);
                            String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                            _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                            long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                            _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                            long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                            _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                            long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                            _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                            long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                            _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                            String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                            _tmpClazz.setClazzCode(_tmpClazzCode);
                            long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                            _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        } else {
                            _tmpClazz = null;
                        }
                        _result2 = new ClazzInviteAndClazz(_tmpClazzInvite, _tmpClazz);
                    } else {
                        _result2 = null;
                    }
                    ClazzInviteAndClazz clazzInviteAndClazz = _result2;
                    return clazzInviteAndClazz;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, ClazzInvite> findPendingInviteByPersonUid(long ciPersonUid, long clazzUid, long currentTime) {
        String _sql = "SELECT * FROM ClazzInvite \n                 WHERE ciPersonUid = ? AND ciClazzUid = ? \n              AND inviteExpire > ? AND inviteStatus = 0";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzInvite \n                 WHERE ciPersonUid = ? AND ciClazzUid = ? \n              AND inviteExpire > ? AND inviteStatus = 0", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, ciPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, currentTime);
        return new LimitOffsetPagingSource<ClazzInvite>(_statement, this.__db, new String[]{"ClazzInvite"}){

            @NonNull
            protected List<ClazzInvite> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ciUid");
                int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ciPersonUid");
                int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ciRoleId");
                int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ciClazzUid");
                int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteType");
                int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteContact");
                int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteToken");
                int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteStatus");
                int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteExpire");
                int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"inviteLct");
                ArrayList<ClazzInvite> _result2 = new ArrayList<ClazzInvite>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpCiUid = cursor.getLong(_cursorIndexOfCiUid);
                    long _tmpCiPersonUid = cursor.getLong(_cursorIndexOfCiPersonUid);
                    long _tmpCiRoleId = cursor.getLong(_cursorIndexOfCiRoleId);
                    long _tmpCiClazzUid = cursor.getLong(_cursorIndexOfCiClazzUid);
                    int _tmpInviteType = cursor.getInt(_cursorIndexOfInviteType);
                    String _tmpInviteContact = cursor.getString(_cursorIndexOfInviteContact);
                    String _tmpInviteToken = cursor.getString(_cursorIndexOfInviteToken);
                    int _tmpInviteStatus = cursor.getInt(_cursorIndexOfInviteStatus);
                    long _tmpInviteExpire = cursor.getLong(_cursorIndexOfInviteExpire);
                    long _tmpInviteLct = cursor.getLong(_cursorIndexOfInviteLct);
                    ClazzInvite _item = new ClazzInvite(_tmpCiUid, _tmpCiPersonUid, _tmpCiRoleId, _tmpCiClazzUid, _tmpInviteType, _tmpInviteContact, _tmpInviteToken, _tmpInviteStatus, _tmpInviteExpire, _tmpInviteLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findClazzInviteFromContact(String inviteContact, Continuation<? super ClazzInvite> $completion) {
        String _sql = "SELECT * FROM ClazzInvite WHERE inviteContact = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzInvite WHERE inviteContact = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, inviteContact);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzInvite>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzInvite call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzInviteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzInvite _result2;
                    int _cursorIndexOfCiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciUid");
                    int _cursorIndexOfCiPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciPersonUid");
                    int _cursorIndexOfCiRoleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciRoleId");
                    int _cursorIndexOfCiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ciClazzUid");
                    int _cursorIndexOfInviteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteType");
                    int _cursorIndexOfInviteContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteContact");
                    int _cursorIndexOfInviteToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteToken");
                    int _cursorIndexOfInviteStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteStatus");
                    int _cursorIndexOfInviteExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteExpire");
                    int _cursorIndexOfInviteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"inviteLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCiUid = _cursor.getLong(_cursorIndexOfCiUid);
                        long _tmpCiPersonUid = _cursor.getLong(_cursorIndexOfCiPersonUid);
                        long _tmpCiRoleId = _cursor.getLong(_cursorIndexOfCiRoleId);
                        long _tmpCiClazzUid = _cursor.getLong(_cursorIndexOfCiClazzUid);
                        int _tmpInviteType = _cursor.getInt(_cursorIndexOfInviteType);
                        String _tmpInviteContact = _cursor.getString(_cursorIndexOfInviteContact);
                        String _tmpInviteToken = _cursor.getString(_cursorIndexOfInviteToken);
                        int _tmpInviteStatus = _cursor.getInt(_cursorIndexOfInviteStatus);
                        long _tmpInviteExpire = _cursor.getLong(_cursorIndexOfInviteExpire);
                        long _tmpInviteLct = _cursor.getLong(_cursorIndexOfInviteLct);
                        _result2 = new ClazzInvite(_tmpCiUid, _tmpCiPersonUid, _tmpCiRoleId, _tmpCiClazzUid, _tmpInviteType, _tmpInviteContact, _tmpInviteToken, _tmpInviteStatus, _tmpInviteExpire, _tmpInviteLct);
                    } else {
                        _result2 = null;
                    }
                    ClazzInvite clazzInvite = _result2;
                    return clazzInvite;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

