package com.ustadmobile.libcache.db.dao

import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry
import kotlin.Long
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public actual abstract class NeighborCacheEntryDao {
  public actual abstract fun upsertList(neighborCacheEntryList: List<NeighborCacheEntry>)

  public actual abstract fun allEntriesAsFlow(): Flow<List<NeighborCacheEntry>>

  public actual abstract fun findAvailableEntries(urlHashes: List<Long>): List<Long>

  public actual abstract fun findAvailableNeighborsByUrlHash(urlHash: Long):
      List<NeighborCacheEntryAndNeighborCache>
}
