package com.ustadmobile.libcache.db.dao

import com.ustadmobile.door.DoorDbType
import com.ustadmobile.door.EntityInsertionAdapter
import com.ustadmobile.door.PreparedStatementConfig
import com.ustadmobile.door.ext.createArrayOrProxyArrayOf
import com.ustadmobile.door.ext.prepareAndUseStatement
import com.ustadmobile.door.ext.prepareAndUseStatementAsync
import com.ustadmobile.door.flow.doorFlow
import com.ustadmobile.door.jdbc.PreparedStatement
import com.ustadmobile.door.jdbc.ext.executeQueryAsyncKmp
import com.ustadmobile.door.jdbc.ext.getStringNonNull
import com.ustadmobile.door.jdbc.ext.mapRows
import com.ustadmobile.door.jdbc.ext.useResults
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache
import com.ustadmobile.libcache.db.entities.NeighborCache
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry
import kotlin.Boolean
import kotlin.IllegalArgumentException
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class NeighborCacheEntryDao_JdbcImpl(
  public val _db: RoomDatabase,
) : NeighborCacheEntryDao() {
  public val _insertAdapterNeighborCacheEntry_upsert: EntityInsertionAdapter<NeighborCacheEntry> =
      object : EntityInsertionAdapter<NeighborCacheEntry>(_db) {
    override fun makeSql(returnsId: Boolean): String = when(dbType) {
      DoorDbType.SQLITE -> {
        "INSERT OR REPLACE INTO NeighborCacheEntry (nceNeighborUid, nceUrlHash) VALUES(?, ?)"
      }
      DoorDbType.POSTGRES ->  {
        "INSERT INTO NeighborCacheEntry (nceNeighborUid, nceUrlHash) VALUES(?, ?) ON CONFLICT (nceNeighborUid, nceUrlHash) DO UPDATE SET " + if(returnsId) { " RETURNING nceNeighborUid" } else "" 
      }
      else -> {
        throw IllegalArgumentException("Unsupported db type")
      }
    }

    override fun bindPreparedStmtToEntity(stmt: PreparedStatement, entity: NeighborCacheEntry) {
      stmt.setLong(1, entity.nceNeighborUid)
      stmt.setLong(2, entity.nceUrlHash)
    }
  }

  override fun upsertList(neighborCacheEntryList: List<NeighborCacheEntry>) {
    _insertAdapterNeighborCacheEntry_upsert.insertList(neighborCacheEntryList)
  }

  override fun allEntriesAsFlow(): Flow<List<NeighborCacheEntry>> =
      _db.doorFlow(arrayOf("NeighborCacheEntry")) {
    _db.prepareAndUseStatementAsync(PreparedStatementConfig(
      sql = """
      |
      |        SELECT NeighborCacheEntry.* 
      |          FROM NeighborCacheEntry
      |    
      """.trimMargin(),
      readOnly = true,)
    ) { _stmt -> 
      _stmt.executeQueryAsyncKmp().useResults{ _result -> 
        _result.mapRows {
          val _tmp_nceNeighborUid = _result.getLong("nceNeighborUid")
          val _tmp_nceUrlHash = _result.getLong("nceUrlHash")
          NeighborCacheEntry().apply {
            this.nceNeighborUid = _tmp_nceNeighborUid
            this.nceUrlHash = _tmp_nceUrlHash
          }
        }
      }
    }
  }

  override fun findAvailableEntries(urlHashes: List<Long>): List<Long> =
      _db.prepareAndUseStatement(PreparedStatementConfig(
    sql = """
    |
    |        SELECT NeighborCacheEntry.nceUrlHash
    |          FROM NeighborCacheEntry
    |         WHERE NeighborCacheEntry.nceUrlHash IN (?) 
    |    
    """.trimMargin(),
    hasListParams = true,
    readOnly = true,)
  ) { _stmt -> 
    _stmt.setArray(1, _stmt.getConnection().createArrayOrProxyArrayOf("BIGINT",
        urlHashes.toTypedArray()))
    _stmt.executeQuery().useResults{ _result -> 
      _result.mapRows {
        _result.getLong(1)
      }
    }
  }

  override fun findAvailableNeighborsByUrlHash(urlHash: Long):
      List<NeighborCacheEntryAndNeighborCache> = _db.prepareAndUseStatement(PreparedStatementConfig(
    sql = """
    |
    |        SELECT NeighborCacheEntry.*,
    |               NeighborCache.*
    |          FROM NeighborCacheEntry
    |               JOIN NeighborCache
    |                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid
    |         WHERE NeighborCacheEntry.nceUrlHash = ?
    |           AND NeighborCache.neighborStatus = 1
    |    
    """.trimMargin(),
    readOnly = true,)
  ) { _stmt -> 
    _stmt.setLong(1,urlHash)
    _stmt.executeQuery().useResults{ _result -> 
      _result.mapRows {
        var _tmp_NeighborCache_nullCount = 0
        val _tmp_neighborUid = _result.getLong("neighborUid")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborDeviceName = _result.getStringNonNull("neighborDeviceName")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborIp = _result.getStringNonNull("neighborIp")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborUdpPort = _result.getInt("neighborUdpPort")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborHttpPort = _result.getInt("neighborHttpPort")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborDiscovered = _result.getLong("neighborDiscovered")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborPingTime = _result.getInt("neighborPingTime")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborLastSeen = _result.getLong("neighborLastSeen")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_neighborStatus = _result.getInt("neighborStatus")
        if(_result.wasNull()) _tmp_NeighborCache_nullCount++
        val _tmp_NeighborCache_isAllNull = _tmp_NeighborCache_nullCount == 9
        var _tmp_NeighborCacheEntry_nullCount = 0
        val _tmp_nceNeighborUid = _result.getLong("nceNeighborUid")
        if(_result.wasNull()) _tmp_NeighborCacheEntry_nullCount++
        val _tmp_nceUrlHash = _result.getLong("nceUrlHash")
        if(_result.wasNull()) _tmp_NeighborCacheEntry_nullCount++
        val _tmp_NeighborCacheEntry_isAllNull = _tmp_NeighborCacheEntry_nullCount == 2
        NeighborCacheEntryAndNeighborCache().apply {
          if(!_tmp_NeighborCache_isAllNull) {
            this.neighborCache = NeighborCache().apply {
              this.neighborUid = _tmp_neighborUid
              this.neighborDeviceName = _tmp_neighborDeviceName
              this.neighborIp = _tmp_neighborIp
              this.neighborUdpPort = _tmp_neighborUdpPort
              this.neighborHttpPort = _tmp_neighborHttpPort
              this.neighborDiscovered = _tmp_neighborDiscovered
              this.neighborPingTime = _tmp_neighborPingTime
              this.neighborLastSeen = _tmp_neighborLastSeen
              this.neighborStatus = _tmp_neighborStatus
            }
          }
          if(!_tmp_NeighborCacheEntry_isAllNull) {
            this.neighborCacheEntry = NeighborCacheEntry().apply {
              this.nceNeighborUid = _tmp_nceNeighborUid
              this.nceUrlHash = _tmp_nceUrlHash
            }
          }
        }
      }
    }
  }
}
