package com.ustadmobile.libcache.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.libcache.db.entities.NeighborCache
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class NeighborCacheDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertAsync(neighborCache: NeighborCache)

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract fun upsert(neighborCache: NeighborCache)

  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract fun insertOrIgnore(neighborCache: NeighborCache)

  @Query(`value` =
      "\n        DELETE FROM NeighborCache\n         WHERE neighborUid = :neighborUid\n    ")
  public actual abstract suspend fun deleteAsync(neighborUid: Long)

  @Query(`value` =
      "\n        SELECT NeighborCache.*\n          FROM NeighborCache\n         WHERE NeighborCache.neighborStatus = 1 \n    ")
  public actual abstract fun allNeighborsAsFlow(): Flow<List<NeighborCache>>

  @Query(`value` = "\n        SELECT NeighborCache.*\n          FROM NeighborCache\n    ")
  public actual abstract fun allNeighbors(): List<NeighborCache>

  @Query(`value` =
      "\n        UPDATE NeighborCache\n           SET neighborHttpPort = :httpPort\n         WHERE neighborUid = :neighborUid\n           AND neighborHttpPort != :httpPort\n    ")
  public actual abstract fun updateHttpPort(neighborUid: Long, httpPort: Int)

  @Query(`value` =
      "\n        UPDATE NeighborCache\n           SET neighborPingTime = :pingTime,\n               neighborLastSeen = :timeNow\n         WHERE neighborUid = :neighborUid  \n    ")
  public actual abstract fun updatePingTime(
    neighborUid: Long,
    pingTime: Int,
    timeNow: Long,
  ): Int

  @Query(`value` =
      "\n        UPDATE NeighborCache\n           SET neighborStatus = CAST(((:timeNow - NeighborCache.neighborLastSeen) < :lostThreshold) AS INTEGER)\n         WHERE neighborStatus != CAST(((:timeNow - NeighborCache.neighborLastSeen) < :lostThreshold) AS INTEGER)   \n    ")
  public actual abstract fun updateStatuses(timeNow: Long, lostThreshold: Long)

  @Query(`value` =
      "\n        UPDATE NeighborCache\n           SET neighborDeviceName = :deviceName\n        WHERE neighborUid = :neighborUid\n          AND neighborDeviceName != :deviceName   \n    ")
  public actual abstract fun updateDeviceName(neighborUid: Long, deviceName: String)
}
