package com.ustadmobile.libcache.db

import com.ustadmobile.door.DoorDatabaseWrapper
import com.ustadmobile.door.log.DoorLogger
import com.ustadmobile.door.message.DoorMessageCallback
import com.ustadmobile.door.nodeevent.NodeEventManagerCommon
import com.ustadmobile.door.nodeevent.NodeEventManagerJvm
import com.ustadmobile.door.room.InvalidationTracker
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.dao.CacheEntryDao
import com.ustadmobile.libcache.db.dao.NeighborCacheDao
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao
import com.ustadmobile.libcache.db.dao.RequestedEntryDao
import com.ustadmobile.libcache.db.dao.RetentionLockDao
import kotlin.Any
import kotlin.IllegalArgumentException
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlinx.coroutines.Runnable

@Suppress("REDUNDANT_PROJECTION", "ClassName")
public class UstadCacheDb_DoorWrapper(
  private val _db: UstadCacheDb,
  override val nodeId: Long,
  private val messageCallback: DoorMessageCallback<UstadCacheDb>,
  logger: DoorLogger,
  dbName: String,
) : UstadCacheDb(), DoorDatabaseWrapper<UstadCacheDb> {
  override val dbVersion: Int
    get() = 15

  override val dbName: String
    get() = "DoorWrapper for [${_db.toString()}]"

  override val cacheEntryDao: CacheEntryDao
    get() = _db.cacheEntryDao

  override val requestedEntryDao: RequestedEntryDao
    get() = _db.requestedEntryDao

  override val retentionLockDao: RetentionLockDao
    get() = _db.retentionLockDao

  override val neighborCacheDao: NeighborCacheDao
    get() = _db.neighborCacheDao

  override val neighborCacheEntryDao: NeighborCacheEntryDao
    get() = _db.neighborCacheEntryDao

  override val newCacheEntryDao: NewCacheEntryDao
    get() = _db.newCacheEntryDao

  override val realDatabase: RoomDatabase
    get() = _db

  override val nodeEventManager: NodeEventManagerCommon<UstadCacheDb> = NodeEventManagerJvm(_db,
      messageCallback, logger, dbName)


  override val invalidationTracker: InvalidationTracker
    get() = _db.invalidationTracker

  override fun createAllTables(): List<String> = _db.createAllTables()

  override fun clearAllTables() {
    _db.clearAllTables()
  }

  override fun runInTransaction(runnable: Runnable) {
    _db.runInTransaction(runnable)
  }

  @Suppress("UNCHECKED_CAST")
  override fun <T : Any> getDaoByClass(daoClass: KClass<T>): T = when(daoClass) {
    CacheEntryDao::class -> cacheEntryDao as T
    RequestedEntryDao::class -> requestedEntryDao as T
    RetentionLockDao::class -> retentionLockDao as T
    NeighborCacheDao::class -> neighborCacheDao as T
    NeighborCacheEntryDao::class -> neighborCacheEntryDao as T
    NewCacheEntryDao::class -> newCacheEntryDao as T
    else -> throw IllegalArgumentException("No such DAO on this DB")
  }

  override fun close() {
    _db.close()
  }
}
