package com.ustadmobile.libcache.db.dao

import com.ustadmobile.libcache.db.entities.NeighborCache
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public actual abstract class NeighborCacheDao {
  public actual abstract suspend fun upsertAsync(neighborCache: NeighborCache)

  public actual abstract fun upsert(neighborCache: NeighborCache)

  public actual abstract fun insertOrIgnore(neighborCache: NeighborCache)

  public actual abstract suspend fun deleteAsync(neighborUid: Long)

  public actual abstract fun allNeighborsAsFlow(): Flow<List<NeighborCache>>

  public actual abstract fun allNeighbors(): List<NeighborCache>

  public actual abstract fun updateHttpPort(neighborUid: Long, httpPort: Int)

  public actual abstract fun updatePingTime(
    neighborUid: Long,
    pingTime: Int,
    timeNow: Long,
  ): Int

  public actual abstract fun updateStatuses(timeNow: Long, lostThreshold: Long)

  public actual abstract fun updateDeviceName(neighborUid: Long, deviceName: String)
}
