/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed;

import com.ustadmobile.door.ext.DoorDatabaseExtJvmKt;
import com.ustadmobile.door.ext.MapExtKt;
import com.ustadmobile.door.room.InvalidationTrackerObserver;
import com.ustadmobile.door.room.RoomDatabase;
import com.ustadmobile.door.util.SystemTimeKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.request.RequestBuilder;
import com.ustadmobile.ihttp.request.RequestBuilderKt;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.dao.NeighborCacheDao;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import com.ustadmobile.libcache.db.entities.NewCacheEntry;
import com.ustadmobile.libcache.distributed.DistributedCacheHashtable;
import com.ustadmobile.libcache.distributed.XXStringHasherExtKt;
import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCachePing;
import com.ustadmobile.libcache.distributed.model.DistributedCachePong;
import com.ustadmobile.libcache.distributed.model.DistributedHashCacheEntry;
import com.ustadmobile.libcache.distributed.model.DistributedHashEntries;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import com.ustadmobile.xxhashkmp.XXStringHasher;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u001c\u0018\u0000 42\u00020\u0001:\u0006456789BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020,J,\u0010.\u001a\u00020**\u00020\u00132\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0010002\u0006\u00101\u001a\u00020\u00162\b\b\u0002\u00102\u001a\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "Ljava/io/Closeable;", "cacheDb", "Lcom/ustadmobile/libcache/db/UstadCacheDb;", "httpPort", "", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "xxStringHasher", "Lcom/ustadmobile/xxhashkmp/XXStringHasher;", "mtu", "pingInterval", "", "neighborLostThreshold", "deviceName", "Lkotlin/Function0;", "", "(Lcom/ustadmobile/libcache/db/UstadCacheDb;ILcom/ustadmobile/libcache/logging/UstadCacheLogger;Lcom/ustadmobile/xxhashkmp/XXStringHasher;IJJLkotlin/jvm/functions/Function0;)V", "datagramSocket", "Ljava/net/DatagramSocket;", "discoveredNeighbors", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCache;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "logPrefix", "newCacheEntryInvalidationCallback", "com/ustadmobile/libcache/distributed/DistributedCacheHashtable$newCacheEntryInvalidationCallback$1", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$newCacheEntryInvalidationCallback$1;", "pendingPings", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$PendingPing;", "pingIdAtomic", "Lkotlinx/atomicfu/AtomicInt;", "port", "getPort", "()I", "scope", "Lkotlinx/coroutines/CoroutineScope;", "sendLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "localRequestFor", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "request", "sendDistributedHashEntries", "urls", "", "neighborCache", "neighborAddress", "Ljava/net/InetAddress;", "Companion", "PendingPing", "ReceivePacketsRunnable", "SendNeighborHashesRunnable", "SendNewCacheEntriesRunnable", "SendPingsRunnable", "lib-cache"})
@SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,401:1\n1855#2:402\n1549#2:403\n1620#2,3:404\n1856#2:407\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable\n*L\n98#1:402\n101#1:403\n101#1:404,3\n98#1:407\n*E\n"})
public final class DistributedCacheHashtable
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UstadCacheDb cacheDb;
    private final int httpPort;
    @NotNull
    private final UstadCacheLogger logger;
    @NotNull
    private final XXStringHasher xxStringHasher;
    private final int mtu;
    private final long neighborLostThreshold;
    @NotNull
    private final Function0<String> deviceName;
    @NotNull
    private final CoroutineScope scope;
    private final ScheduledExecutorService executorService;
    @NotNull
    private final DatagramSocket datagramSocket;
    @NotNull
    private final Map<Long, NeighborCache> discoveredNeighbors;
    @NotNull
    private final String logPrefix;
    @NotNull
    private final Map<Integer, PendingPing> pendingPings;
    @NotNull
    private final AtomicInt pingIdAtomic;
    @NotNull
    private final ReentrantLock sendLock;
    @NotNull
    private final newCacheEntryInvalidationCallback.1 newCacheEntryInvalidationCallback;
    public static final int DEFAULT_MTU = 1500;
    public static final int DATABASE_CHUNK_SIZE = 1000;
    public static final long DEFAULT_PING_INTERVAL = 3000L;
    public static final long DEFAULT_NEIGHBOR_LOST_THRESHOLD = 10000L;

    public DistributedCacheHashtable(@NotNull UstadCacheDb cacheDb, int httpPort, @NotNull UstadCacheLogger logger, @NotNull XXStringHasher xxStringHasher, int mtu, long pingInterval, long neighborLostThreshold, @NotNull Function0<String> deviceName) {
        Intrinsics.checkNotNullParameter((Object)((Object)cacheDb), (String)"cacheDb");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)xxStringHasher, (String)"xxStringHasher");
        Intrinsics.checkNotNullParameter(deviceName, (String)"deviceName");
        this.cacheDb = cacheDb;
        this.httpPort = httpPort;
        this.logger = logger;
        this.xxStringHasher = xxStringHasher;
        this.mtu = mtu;
        this.neighborLostThreshold = neighborLostThreshold;
        this.deviceName = deviceName;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        this.executorService = Executors.newScheduledThreadPool(2);
        this.datagramSocket = new DatagramSocket();
        this.discoveredNeighbors = MapExtKt.concurrentSafeMapOf((Pair[])new Pair[0]);
        this.logPrefix = "DistributedCacheHashtable(" + this.getPort() + " " + this.deviceName.invoke() + ")";
        this.pendingPings = MapExtKt.concurrentSafeMapOf((Pair[])new Pair[0]);
        this.pingIdAtomic = AtomicFU.atomic((int)0);
        this.sendLock = new ReentrantLock();
        String[] stringArray = new String[]{"NewCacheEntry"};
        String[] stringArray2 = stringArray;
        this.newCacheEntryInvalidationCallback = new InvalidationTrackerObserver(this, stringArray2){
            final /* synthetic */ DistributedCacheHashtable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onInvalidated(@NotNull Set<String> tables) {
                Intrinsics.checkNotNullParameter(tables, (String)"tables");
                DistributedCacheHashtable.access$getExecutorService$p(this.this$0).submit(this.this$0.new SendNewCacheEntriesRunnable());
            }
        };
        if (this.httpPort == 0) {
            throw new IllegalArgumentException("DistributedCacheHashtable: httpPort cannot be 0");
        }
        UstadCacheLogger.DefaultImpls.i$default(this.logger, "DistCache", this.logPrefix + " initialized on udp port " + this.getPort(), null, 4, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DistributedCacheHashtable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.cacheDb.getNeighborCacheDao().allNeighborsAsFlow().collect(new FlowCollector(){

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object emit(@NotNull List<NeighborCache> neighborList, @NotNull Continuation<? super Unit> $completion) {
                                void $this$forEach$iv;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Iterable iterable = neighborList;
                                DistributedCacheHashtable distributedCacheHashtable = this$0;
                                boolean $i$f$filter = false;
                                Iterator iterator = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$filterTo = false;
                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                    NeighborCache it = (NeighborCache)element$iv$iv;
                                    boolean bl = false;
                                    if (!(!distributedCacheHashtable.discoveredNeighbors.containsKey(Boxing.boxLong((long)it.getNeighborUid())))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                List newNeighbors = (List)destination$iv$iv;
                                $this$filter$iv = newNeighbors;
                                distributedCacheHashtable = this$0;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    NeighborCache it = (NeighborCache)element$iv;
                                    boolean bl = false;
                                    UstadCacheLogger.DefaultImpls.d$default(distributedCacheHashtable.logger, "DistCache", distributedCacheHashtable.logPrefix + " new neighbor " + it.getNeighborIp() + ":" + it.getNeighborUdpPort(), null, 4, null);
                                    distributedCacheHashtable.discoveredNeighbors.put(Boxing.boxLong((long)it.getNeighborUid()), it);
                                    distributedCacheHashtable.executorService.submit(distributedCacheHashtable.new SendNeighborHashesRunnable(it));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.cacheDb.getInvalidationTracker().addObserver((InvalidationTrackerObserver)this.newCacheEntryInvalidationCallback);
        this.executorService.submit(new ReceivePacketsRunnable());
        this.executorService.scheduleWithFixedDelay(new SendPingsRunnable(), pingInterval, pingInterval, TimeUnit.MILLISECONDS);
    }

    public /* synthetic */ DistributedCacheHashtable(UstadCacheDb ustadCacheDb, int n, UstadCacheLogger ustadCacheLogger, XXStringHasher xXStringHasher, int n2, long l, long l2, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n2 = 1500;
        }
        if ((n3 & 0x20) != 0) {
            l = 3000L;
        }
        if ((n3 & 0x40) != 0) {
            l2 = 10000L;
        }
        this(ustadCacheDb, n, ustadCacheLogger, xXStringHasher, n2, l, l2, (Function0<String>)function0);
    }

    public final int getPort() {
        return this.datagramSocket.getLocalPort();
    }

    /*
     * WARNING - void declaration
     */
    private final void sendDistributedHashEntries(DatagramSocket $this$sendDistributedHashEntries, List<String> urls, NeighborCache neighborCache, InetAddress neighborAddress) {
        UstadCacheLogger.DefaultImpls.d$default(this.logger, "DistCache", this.logPrefix + " Sending " + urls.size() + " url hash(es) to " + neighborCache.getNeighborIp() + ":" + neighborCache.getNeighborUdpPort(), null, 4, null);
        int entriesPerPacket = DistributedHashEntries.Companion.numEntriesFor(this.mtu);
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)urls, (int)entriesPerPacket);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<DistributedHashCacheEntry> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List urlList = (List)element$iv;
            boolean bl = false;
            Iterable iterable = urlList;
            int n = this.httpPort;
            byte by = 0;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new DistributedHashCacheEntry(this.xxStringHasher.hash((String)it), 0L, 0L));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 1;
            List list = collection;
            int n3 = n;
            byte by2 = by;
            DistributedHashEntries hashEntries = new DistributedHashEntries(by2, n3, list, n2, defaultConstructorMarker);
            byte[] hashEntryBytes = hashEntries.toBytes();
            DatagramPacket packet = new DatagramPacket(hashEntryBytes, hashEntryBytes.length, neighborAddress, neighborCache.getNeighborUdpPort());
            $this$sendDistributedHashEntries.send(packet);
        }
    }

    static /* synthetic */ void sendDistributedHashEntries$default(DistributedCacheHashtable distributedCacheHashtable, DatagramSocket datagramSocket, List list, NeighborCache neighborCache, InetAddress inetAddress, int n, Object object) {
        if ((n & 4) != 0) {
            InetAddress inetAddress2 = InetAddress.getByName(neighborCache.getNeighborIp());
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(...)");
            inetAddress = inetAddress2;
        }
        distributedCacheHashtable.sendDistributedHashEntries(datagramSocket, list, neighborCache, inetAddress);
    }

    @Nullable
    public final IHttpRequest localRequestFor(@NotNull IHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() != IHttpRequest.Companion.Method.GET) {
            return null;
        }
        long urlHash = this.xxStringHasher.hash(request.getUrl());
        List<NeighborCacheEntryAndNeighborCache> localResults = this.cacheDb.getNeighborCacheEntryDao().findAvailableNeighborsByUrlHash(urlHash);
        if (localResults.isEmpty()) {
            return null;
        }
        NeighborCacheEntryAndNeighborCache selectedNeighbor = (NeighborCacheEntryAndNeighborCache)CollectionsKt.first(localResults);
        return RequestBuilderKt.iRequestBuilder((String)("http://" + selectedNeighbor.getNeighborCache().getNeighborIp() + ":" + selectedNeighbor.getNeighborCache().getNeighborHttpPort() + "/dcache?url=" + URLEncoder.encode(request.getUrl(), "UTF-8")), (Function1)((Function1)new Function1<RequestBuilder, Unit>(request){
            final /* synthetic */ IHttpRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RequestBuilder $this$iRequestBuilder) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$iRequestBuilder, (String)"$this$iRequestBuilder");
                Iterable iterable = this.$request.getHeaders().names();
                IHttpRequest iHttpRequest = this.$request;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String headerName = (String)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = iHttpRequest.getHeaders().getAllByName(headerName);
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String headerVal = (String)element$iv2;
                        boolean bl2 = false;
                        $this$iRequestBuilder.header(headerName, headerVal);
                    }
                }
            }
        }));
    }

    @Override
    public void close() {
        this.cacheDb.getInvalidationTracker().removeObserver((InvalidationTrackerObserver)this.newCacheEntryInvalidationCallback);
        this.executorService.shutdown();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        this.datagramSocket.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$Companion;", "", "()V", "DATABASE_CHUNK_SIZE", "", "DEFAULT_MTU", "DEFAULT_NEIGHBOR_LOST_THRESHOLD", "", "DEFAULT_PING_INTERVAL", "lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$PendingPing;", "", "id", "", "timeSent", "", "remoteAddress", "Ljava/net/InetAddress;", "(IJLjava/net/InetAddress;)V", "getId", "()I", "getRemoteAddress", "()Ljava/net/InetAddress;", "getTimeSent", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "lib-cache"})
    public static final class PendingPing {
        private final int id;
        private final long timeSent;
        @NotNull
        private final InetAddress remoteAddress;

        public PendingPing(int id, long timeSent, @NotNull InetAddress remoteAddress) {
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            this.id = id;
            this.timeSent = timeSent;
            this.remoteAddress = remoteAddress;
        }

        public final int getId() {
            return this.id;
        }

        public final long getTimeSent() {
            return this.timeSent;
        }

        @NotNull
        public final InetAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public final int component1() {
            return this.id;
        }

        public final long component2() {
            return this.timeSent;
        }

        @NotNull
        public final InetAddress component3() {
            return this.remoteAddress;
        }

        @NotNull
        public final PendingPing copy(int id, long timeSent, @NotNull InetAddress remoteAddress) {
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            return new PendingPing(id, timeSent, remoteAddress);
        }

        public static /* synthetic */ PendingPing copy$default(PendingPing pendingPing, int n, long l, InetAddress inetAddress, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pendingPing.id;
            }
            if ((n2 & 2) != 0) {
                l = pendingPing.timeSent;
            }
            if ((n2 & 4) != 0) {
                inetAddress = pendingPing.remoteAddress;
            }
            return pendingPing.copy(n, l, inetAddress);
        }

        @NotNull
        public String toString() {
            return "PendingPing(id=" + this.id + ", timeSent=" + this.timeSent + ", remoteAddress=" + this.remoteAddress + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + Long.hashCode(this.timeSent);
            result = result * 31 + this.remoteAddress.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PendingPing)) {
                return false;
            }
            PendingPing pendingPing = (PendingPing)other;
            if (this.id != pendingPing.id) {
                return false;
            }
            if (this.timeSent != pendingPing.timeSent) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remoteAddress, (Object)pendingPing.remoteAddress);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$ReceivePacketsRunnable;", "Ljava/lang/Runnable;", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "lib-cache"})
    public final class ReceivePacketsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " waiting to receive hashes from neighbors", null, 4, null);
            DatagramPacket packet = new DatagramPacket(new byte[DistributedCacheHashtable.this.mtu], DistributedCacheHashtable.this.mtu);
            while (!Thread.interrupted()) {
                try {
                    DistributedCachePacket dCachePacket;
                    DistributedCacheHashtable.this.datagramSocket.receive(packet);
                    UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " received hashes from " + packet.getSocketAddress(), null, 4, null);
                    XXStringHasher xXStringHasher = DistributedCacheHashtable.this.xxStringHasher;
                    InetAddress inetAddress = packet.getAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
                    long neighborUid = XXStringHasherExtKt.neighborUid(xXStringHasher, inetAddress, packet.getPort());
                    byte[] byArray = packet.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                    DistributedCachePacket distributedCachePacket = dCachePacket = DistributedCachePacket.Companion.fromBytes(byArray, packet.getOffset(), packet.getLength());
                    if (distributedCachePacket instanceof DistributedHashEntries) {
                        DoorDatabaseExtJvmKt.withDoorTransaction$default((RoomDatabase)DistributedCacheHashtable.this.cacheDb, null, (Function1)((Function1)new Function1<UstadCacheDb, Unit>(DistributedCacheHashtable.this, dCachePacket, neighborUid, packet){
                            final /* synthetic */ DistributedCacheHashtable this$0;
                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                            final /* synthetic */ long $neighborUid;
                            final /* synthetic */ DatagramPacket $packet;
                            {
                                this.this$0 = $receiver;
                                this.$dCachePacket = $dCachePacket;
                                this.$neighborUid = $neighborUid;
                                this.$packet = $packet;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull UstadCacheDb it) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                ReceivePacketsRunnable.access$run$insertNeighborIfNeeded(this.this$0, this.$neighborUid, this.$packet, this.$dCachePacket);
                                Iterable iterable = ((DistributedHashEntries)this.$dCachePacket).getEntries();
                                long l = this.$neighborUid;
                                NeighborCacheEntryDao neighborCacheEntryDao = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheEntryDao();
                                boolean $i$f$map = false;
                                void var6_6 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    DistributedHashCacheEntry distributedHashCacheEntry = (DistributedHashCacheEntry)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new NeighborCacheEntry(l, it2.getUrlHash()));
                                }
                                neighborCacheEntryDao.upsertList((List)destination$iv$iv);
                            }
                        }), (int)1, null);
                        UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " saved hashes from " + packet.getSocketAddress() + " to database", null, 4, null);
                        continue;
                    }
                    if (distributedCachePacket instanceof DistributedCachePing) {
                        DistributedCachePong pongReply = new DistributedCachePong(((DistributedCachePing)dCachePacket).getId(), dCachePacket.getHttpPort(), ((DistributedCachePing)dCachePacket).getPayload());
                        byte[] replyBytes = pongReply.toBytes();
                        DatagramPacket replyPacket = new DatagramPacket(replyBytes, replyBytes.length, packet.getAddress(), packet.getPort());
                        DoorDatabaseExtJvmKt.withDoorTransaction$default((RoomDatabase)DistributedCacheHashtable.this.cacheDb, null, (Function1)((Function1)new Function1<UstadCacheDb, Unit>(DistributedCacheHashtable.this, neighborUid, dCachePacket, packet){
                            final /* synthetic */ DistributedCacheHashtable this$0;
                            final /* synthetic */ long $neighborUid;
                            final /* synthetic */ DistributedCachePacket $dCachePacket;
                            final /* synthetic */ DatagramPacket $packet;
                            {
                                this.this$0 = $receiver;
                                this.$neighborUid = $neighborUid;
                                this.$dCachePacket = $dCachePacket;
                                this.$packet = $packet;
                                super(1);
                            }

                            public final void invoke(@NotNull UstadCacheDb it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                ReceivePacketsRunnable.access$run$insertNeighborIfNeeded(this.this$0, this.$neighborUid, this.$packet, this.$dCachePacket);
                                DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().updateDeviceName(this.$neighborUid, ((DistributedCachePing)this.$dCachePacket).getDeviceName());
                            }
                        }), (int)1, null);
                        Lock lock = DistributedCacheHashtable.this.sendLock;
                        DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
                        lock.lock();
                        try {
                            boolean bl = false;
                            distributedCacheHashtable.datagramSocket.send(replyPacket);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                        UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " sent pong reply to " + packet.getSocketAddress(), null, 4, null);
                        continue;
                    }
                    if (!(distributedCachePacket instanceof DistributedCachePong)) continue;
                    PendingPing pendingPing = (PendingPing)DistributedCacheHashtable.this.pendingPings.remove(((DistributedCachePong)dCachePacket).getId());
                    if (pendingPing != null) {
                        long pingTime = Math.max(SystemTimeKt.systemTimeInMillis() - pendingPing.getTimeSent(), 1L);
                        NeighborCacheDao neighborCacheDao = DistributedCacheHashtable.this.cacheDb.getNeighborCacheDao();
                        XXStringHasher xXStringHasher2 = DistributedCacheHashtable.this.xxStringHasher;
                        InetAddress inetAddress2 = packet.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getAddress(...)");
                        int updates = neighborCacheDao.updatePingTime(XXStringHasherExtKt.neighborUid(xXStringHasher2, inetAddress2, packet.getPort()), (int)pingTime, SystemTimeKt.systemTimeInMillis());
                        UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " ping time to " + packet.getSocketAddress() + " is " + pingTime + "ms updates=" + updates, null, 4, null);
                        continue;
                    }
                    UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", "Could not find pending ping for id " + ((DistributedCachePong)dCachePacket).getId(), null, 4, null);
                }
                catch (Exception e) {
                    DistributedCacheHashtable.this.logger.e("DistCache", DistributedCacheHashtable.this.logPrefix + " exception reading incoming packet", e);
                }
            }
        }

        private static final void run$insertNeighborIfNeeded(DistributedCacheHashtable this$0, long neighborUid, DatagramPacket packet, DistributedCachePacket dCachePacket) {
            DoorDatabaseExtJvmKt.withDoorTransaction$default((RoomDatabase)this$0.cacheDb, null, (Function1)((Function1)new Function1<UstadCacheDb, Unit>(this$0, neighborUid, packet, dCachePacket){
                final /* synthetic */ DistributedCacheHashtable this$0;
                final /* synthetic */ long $neighborUid;
                final /* synthetic */ DatagramPacket $packet;
                final /* synthetic */ DistributedCachePacket $dCachePacket;
                {
                    this.this$0 = $receiver;
                    this.$neighborUid = $neighborUid;
                    this.$packet = $packet;
                    this.$dCachePacket = $dCachePacket;
                    super(1);
                }

                public final void invoke(@NotNull UstadCacheDb it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    NeighborCacheDao neighborCacheDao = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao();
                    String string = this.$packet.getAddress().getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
                    neighborCacheDao.insertOrIgnore(new NeighborCache(this.$neighborUid, null, string, this.$packet.getPort(), this.$dCachePacket.getHttpPort(), 0L, 0, 0L, 0, 482, null));
                    DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().updateHttpPort(this.$neighborUid, this.$dCachePacket.getHttpPort());
                }
            }), (int)1, null);
        }

        public static final /* synthetic */ void access$run$insertNeighborIfNeeded(DistributedCacheHashtable this$0, long neighborUid, DatagramPacket packet, DistributedCachePacket dCachePacket) {
            ReceivePacketsRunnable.run$insertNeighborIfNeeded(this$0, neighborUid, packet, dCachePacket);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNeighborHashesRunnable;", "Ljava/lang/Runnable;", "neighborCache", "Lcom/ustadmobile/libcache/db/entities/NeighborCache;", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;Lcom/ustadmobile/libcache/db/entities/NeighborCache;)V", "run", "", "lib-cache"})
    @SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNeighborHashesRunnable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
    public final class SendNeighborHashesRunnable
    implements Runnable {
        @NotNull
        private final NeighborCache neighborCache;

        public SendNeighborHashesRunnable(NeighborCache neighborCache) {
            Intrinsics.checkNotNullParameter((Object)neighborCache, (String)"neighborCache");
            this.neighborCache = neighborCache;
        }

        @Override
        public void run() {
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " starting new neighbor run for " + this.neighborCache.getNeighborIp() + ":" + this.neighborCache.getNeighborUdpPort(), null, 4, null);
            List<String> urls = null;
            int offset = 0;
            InetAddress neighborAddress = InetAddress.getByName(this.neighborCache.getNeighborIp());
            while (true) {
                List<String> list;
                List<String> it = list = DistributedCacheHashtable.this.cacheDb.getCacheEntryDao().getEntryUrlsInOrder(offset, 1000);
                boolean bl = false;
                urls = it;
                if (!(!((Collection)list).isEmpty())) break;
                DatagramSocket datagramSocket = DistributedCacheHashtable.this.datagramSocket;
                Intrinsics.checkNotNull((Object)neighborAddress);
                DistributedCacheHashtable.this.sendDistributedHashEntries(datagramSocket, urls, this.neighborCache, neighborAddress);
                offset += 1000;
            }
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " finished new neighbor run for " + this.neighborCache.getNeighborIp() + ":" + this.neighborCache.getNeighborUdpPort(), null, 4, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable;", "Ljava/lang/Runnable;", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "lib-cache"})
    @SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,401:1\n1855#2:402\n1549#2:403\n1620#2,3:404\n1856#2:407\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendNewCacheEntriesRunnable\n*L\n273#1:402\n275#1:403\n275#1:404,3\n273#1:407\n*E\n"})
    public final class SendNewCacheEntriesRunnable
    implements Runnable {
        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$forEach$iv;
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + " SendNewCacheEntriesRunnable: Looking for new cache entries to send out", null, 4, null);
            Pair pair = (Pair)DoorDatabaseExtJvmKt.withDoorTransaction$default((RoomDatabase)DistributedCacheHashtable.this.cacheDb, null, (Function1)((Function1)new Function1<UstadCacheDb, Pair<? extends List<? extends NewCacheEntry>, ? extends List<? extends NeighborCache>>>(DistributedCacheHashtable.this){
                final /* synthetic */ DistributedCacheHashtable this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Pair<List<NewCacheEntry>, List<NeighborCache>> invoke(@NotNull UstadCacheDb it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    List<NewCacheEntry> entries = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNewCacheEntryDao().findAllNewEntries();
                    List<NeighborCache> nodes = DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNeighborCacheDao().allNeighbors();
                    DistributedCacheHashtable.access$getCacheDb$p(this.this$0).getNewCacheEntryDao().clearAll();
                    return new Pair(entries, nodes);
                }
            }), (int)1, null);
            List newEntries = (List)pair.component1();
            List allNodes = (List)pair.component2();
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", "SendNewCacheEntriesRunnable: sending " + newEntries.size() + " new entry hashes to " + allNodes.size() + " nodes ", null, 4, null);
            Iterable iterable = allNodes;
            DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                NeighborCache neighbor = (NeighborCache)element$iv;
                boolean bl = false;
                Iterable iterable2 = newEntries;
                DatagramSocket datagramSocket = distributedCacheHashtable.datagramSocket;
                DistributedCacheHashtable distributedCacheHashtable2 = distributedCacheHashtable;
                boolean $i$f$map = false;
                void var15_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NewCacheEntry newCacheEntry = (NewCacheEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getNceUrl());
                }
                collection = (List)destination$iv$iv;
                DistributedCacheHashtable.sendDistributedHashEntries$default(distributedCacheHashtable2, datagramSocket, (List)collection, neighbor, null, 4, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable;", "Ljava/lang/Runnable;", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;)V", "run", "", "lib-cache"})
    @SourceDebugExtension(value={"SMAP\nDistributedCacheHashtable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,401:1\n1855#2,2:402\n*S KotlinDebug\n*F\n+ 1 DistributedCacheHashtable.kt\ncom/ustadmobile/libcache/distributed/DistributedCacheHashtable$SendPingsRunnable\n*L\n288#1:402,2\n*E\n"})
    public final class SendPingsRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$forEach$iv;
            List<NeighborCache> allNodes = DistributedCacheHashtable.this.cacheDb.getNeighborCacheDao().allNeighbors();
            UstadCacheLogger.DefaultImpls.d$default(DistributedCacheHashtable.this.logger, "DistCache", DistributedCacheHashtable.this.logPrefix + ": sending pings to " + allNodes.size() + " nodes", null, 4, null);
            String deviceNameVal = (String)DistributedCacheHashtable.this.deviceName.invoke();
            Iterable iterable = allNodes;
            DistributedCacheHashtable distributedCacheHashtable = DistributedCacheHashtable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NeighborCache neighbor = (NeighborCache)element$iv;
                boolean bl = false;
                try {
                    InetAddress address = InetAddress.getByName(neighbor.getNeighborIp());
                    int n = distributedCacheHashtable.pingIdAtomic.incrementAndGet();
                    int n2 = distributedCacheHashtable.httpPort;
                    Object object = new byte[]{};
                    DistributedCachePing ping = new DistributedCachePing(n, n2, deviceNameVal, (byte[])object);
                    Map map = distributedCacheHashtable.pendingPings;
                    Integer n3 = ping.getId();
                    int n4 = ping.getId();
                    long l = SystemTimeKt.systemTimeInMillis();
                    Intrinsics.checkNotNull((Object)address);
                    map.put(n3, new PendingPing(n4, l, address));
                    byte[] pingPacketBytes = ping.toBytes();
                    Lock lock = distributedCacheHashtable.sendLock;
                    lock.lock();
                    try {
                        boolean bl2 = false;
                        distributedCacheHashtable.datagramSocket.send(new DatagramPacket(pingPacketBytes, pingPacketBytes.length, address, neighbor.getNeighborUdpPort()));
                        object = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                    UstadCacheLogger.DefaultImpls.d$default(distributedCacheHashtable.logger, "DistCache", distributedCacheHashtable.logPrefix + ": send ping to " + address.getHostAddress() + ":" + neighbor.getNeighborUdpPort(), null, 4, null);
                }
                catch (Throwable e) {
                    distributedCacheHashtable.logger.e("DistCache", distributedCacheHashtable.logPrefix + " exception sending ping to " + neighbor, e);
                }
            }
            DistributedCacheHashtable.this.cacheDb.getNeighborCacheDao().updateStatuses(SystemTimeKt.systemTimeInMillis(), DistributedCacheHashtable.this.neighborLostThreshold);
        }
    }
}

