/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ErrorReportDao;
import com.ustadmobile.lib.db.entities.ErrorReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class ErrorReportDao_Impl
extends ErrorReportDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ErrorReport> __insertionAdapterOfErrorReport;

    public ErrorReportDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfErrorReport = new EntityInsertionAdapter<ErrorReport>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ErrorReport` (`errUid`,`errPcsn`,`errLcsn`,`errLcb`,`errLct`,`severity`,`timestamp`,`presenterUri`,`appVersion`,`versionCode`,`errorCode`,`operatingSys`,`osVersion`,`stackTrace`,`message`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ErrorReport entity) {
                statement.bindLong(1, entity.getErrUid());
                statement.bindLong(2, entity.getErrPcsn());
                statement.bindLong(3, entity.getErrLcsn());
                statement.bindLong(4, (long)entity.getErrLcb());
                statement.bindLong(5, entity.getErrLct());
                statement.bindLong(6, (long)entity.getSeverity());
                statement.bindLong(7, entity.getTimestamp());
                if (entity.getPresenterUri() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getPresenterUri());
                }
                if (entity.getAppVersion() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getAppVersion());
                }
                statement.bindLong(10, (long)entity.getVersionCode());
                statement.bindLong(11, (long)entity.getErrorCode());
                if (entity.getOperatingSys() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindString(12, entity.getOperatingSys());
                }
                if (entity.getOsVersion() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindString(13, entity.getOsVersion());
                }
                if (entity.getStackTrace() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getStackTrace());
                }
                if (entity.getMessage() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getMessage());
                }
            }
        };
    }

    @Override
    public Object insertAsync(final ErrorReport errorReport, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ErrorReportDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ErrorReportDao_Impl.this.__insertionAdapterOfErrorReport.insertAndReturnId((Object)errorReport);
                    ErrorReportDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ErrorReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long errUid, Continuation<? super ErrorReport> $completion) {
        String _sql = "\n        SELECT ErrorReport.* \n          FROM ErrorReport\n         WHERE errUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ErrorReport.* \n          FROM ErrorReport\n         WHERE errUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, errUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ErrorReport>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ErrorReport call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ErrorReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ErrorReport _result2;
                    int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errUid");
                    int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errPcsn");
                    int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLcsn");
                    int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLcb");
                    int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLct");
                    int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"severity");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"presenterUri");
                    int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appVersion");
                    int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"versionCode");
                    int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errorCode");
                    int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"operatingSys");
                    int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"osVersion");
                    int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stackTrace");
                    int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ErrorReport();
                        long _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
                        _result2.setErrUid(_tmpErrUid);
                        long _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
                        _result2.setErrPcsn(_tmpErrPcsn);
                        long _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
                        _result2.setErrLcsn(_tmpErrLcsn);
                        int _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
                        _result2.setErrLcb(_tmpErrLcb);
                        long _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
                        _result2.setErrLct(_tmpErrLct);
                        int _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
                        _result2.setSeverity(_tmpSeverity);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result2.setTimestamp(_tmpTimestamp);
                        String _tmpPresenterUri = _cursor.isNull(_cursorIndexOfPresenterUri) ? null : _cursor.getString(_cursorIndexOfPresenterUri);
                        _result2.setPresenterUri(_tmpPresenterUri);
                        String _tmpAppVersion = _cursor.isNull(_cursorIndexOfAppVersion) ? null : _cursor.getString(_cursorIndexOfAppVersion);
                        _result2.setAppVersion(_tmpAppVersion);
                        int _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
                        _result2.setVersionCode(_tmpVersionCode);
                        int _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
                        _result2.setErrorCode(_tmpErrorCode);
                        String _tmpOperatingSys = _cursor.isNull(_cursorIndexOfOperatingSys) ? null : _cursor.getString(_cursorIndexOfOperatingSys);
                        _result2.setOperatingSys(_tmpOperatingSys);
                        String _tmpOsVersion = _cursor.isNull(_cursorIndexOfOsVersion) ? null : _cursor.getString(_cursorIndexOfOsVersion);
                        _result2.setOsVersion(_tmpOsVersion);
                        String _tmpStackTrace = _cursor.isNull(_cursorIndexOfStackTrace) ? null : _cursor.getString(_cursorIndexOfStackTrace);
                        _result2.setStackTrace(_tmpStackTrace);
                        String _tmpMessage = _cursor.isNull(_cursorIndexOfMessage) ? null : _cursor.getString(_cursorIndexOfMessage);
                        _result2.setMessage(_tmpMessage);
                    } else {
                        _result2 = null;
                    }
                    ErrorReport errorReport = _result2;
                    return errorReport;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByErrorCode(int errCode, Continuation<? super List<ErrorReport>> $completion) {
        String _sql = "\n        SELECT ErrorReport.*\n          FROM ErrorReport\n         WHERE errorCode = ?  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ErrorReport.*\n          FROM ErrorReport\n         WHERE errorCode = ?  \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)errCode);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ErrorReport>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ErrorReport> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ErrorReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errUid");
                    int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errPcsn");
                    int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLcsn");
                    int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLcb");
                    int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errLct");
                    int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"severity");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"presenterUri");
                    int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appVersion");
                    int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"versionCode");
                    int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"errorCode");
                    int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"operatingSys");
                    int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"osVersion");
                    int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stackTrace");
                    int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
                    ArrayList<ErrorReport> _result2 = new ArrayList<ErrorReport>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ErrorReport _item = new ErrorReport();
                        long _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
                        _item.setErrUid(_tmpErrUid);
                        long _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
                        _item.setErrPcsn(_tmpErrPcsn);
                        long _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
                        _item.setErrLcsn(_tmpErrLcsn);
                        int _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
                        _item.setErrLcb(_tmpErrLcb);
                        long _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
                        _item.setErrLct(_tmpErrLct);
                        int _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
                        _item.setSeverity(_tmpSeverity);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        String _tmpPresenterUri = _cursor.isNull(_cursorIndexOfPresenterUri) ? null : _cursor.getString(_cursorIndexOfPresenterUri);
                        _item.setPresenterUri(_tmpPresenterUri);
                        String _tmpAppVersion = _cursor.isNull(_cursorIndexOfAppVersion) ? null : _cursor.getString(_cursorIndexOfAppVersion);
                        _item.setAppVersion(_tmpAppVersion);
                        int _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
                        _item.setVersionCode(_tmpVersionCode);
                        int _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
                        _item.setErrorCode(_tmpErrorCode);
                        String _tmpOperatingSys = _cursor.isNull(_cursorIndexOfOperatingSys) ? null : _cursor.getString(_cursorIndexOfOperatingSys);
                        _item.setOperatingSys(_tmpOperatingSys);
                        String _tmpOsVersion = _cursor.isNull(_cursorIndexOfOsVersion) ? null : _cursor.getString(_cursorIndexOfOsVersion);
                        _item.setOsVersion(_tmpOsVersion);
                        String _tmpStackTrace = _cursor.isNull(_cursorIndexOfStackTrace) ? null : _cursor.getString(_cursorIndexOfStackTrace);
                        _item.setStackTrace(_tmpStackTrace);
                        String _tmpMessage = _cursor.isNull(_cursorIndexOfMessage) ? null : _cursor.getString(_cursorIndexOfMessage);
                        _item.setMessage(_tmpMessage);
                        _result2.add(_item);
                    }
                    ArrayList<ErrorReport> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

