/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionFileDao;
import com.ustadmobile.lib.db.composites.CourseAssignmentSubmissionFileAndTransferJob;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionFile;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseAssignmentSubmissionFileDao_Impl
extends CourseAssignmentSubmissionFileDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseAssignmentSubmissionFile> __insertionAdapterOfCourseAssignmentSubmissionFile;
    private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionFile> __updateAdapterOfCourseAssignmentSubmissionFile;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUri;
    private final SharedSQLiteStatement __preparedStmtOfSetDeleted;

    public CourseAssignmentSubmissionFileDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseAssignmentSubmissionFile = new EntityInsertionAdapter<CourseAssignmentSubmissionFile>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseAssignmentSubmissionFile` (`casaUid`,`casaSubmissionUid`,`casaSubmitterUid`,`casaCaUid`,`casaClazzUid`,`casaMimeType`,`casaFileName`,`casaUri`,`casaSize`,`casaTimestamp`,`casaDeleted`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentSubmissionFile entity) {
                statement.bindLong(1, entity.getCasaUid());
                statement.bindLong(2, entity.getCasaSubmissionUid());
                statement.bindLong(3, entity.getCasaSubmitterUid());
                statement.bindLong(4, entity.getCasaCaUid());
                statement.bindLong(5, entity.getCasaClazzUid());
                if (entity.getCasaMimeType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCasaMimeType());
                }
                if (entity.getCasaFileName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getCasaFileName());
                }
                if (entity.getCasaUri() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getCasaUri());
                }
                statement.bindLong(9, (long)entity.getCasaSize());
                statement.bindLong(10, entity.getCasaTimestamp());
                int _tmp = entity.getCasaDeleted() ? 1 : 0;
                statement.bindLong(11, (long)_tmp);
            }
        };
        this.__updateAdapterOfCourseAssignmentSubmissionFile = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionFile>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseAssignmentSubmissionFile` SET `casaUid` = ?,`casaSubmissionUid` = ?,`casaSubmitterUid` = ?,`casaCaUid` = ?,`casaClazzUid` = ?,`casaMimeType` = ?,`casaFileName` = ?,`casaUri` = ?,`casaSize` = ?,`casaTimestamp` = ?,`casaDeleted` = ? WHERE `casaUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentSubmissionFile entity) {
                statement.bindLong(1, entity.getCasaUid());
                statement.bindLong(2, entity.getCasaSubmissionUid());
                statement.bindLong(3, entity.getCasaSubmitterUid());
                statement.bindLong(4, entity.getCasaCaUid());
                statement.bindLong(5, entity.getCasaClazzUid());
                if (entity.getCasaMimeType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCasaMimeType());
                }
                if (entity.getCasaFileName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getCasaFileName());
                }
                if (entity.getCasaUri() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getCasaUri());
                }
                statement.bindLong(9, (long)entity.getCasaSize());
                statement.bindLong(10, entity.getCasaTimestamp());
                int _tmp = entity.getCasaDeleted() ? 1 : 0;
                statement.bindLong(11, (long)_tmp);
                statement.bindLong(12, entity.getCasaUid());
            }
        };
        this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CourseAssignmentSubmissionFile\n           SET casaUri = ?,\n               casaTimestamp = ?\n         WHERE casaUid = ?\n    ";
                return "\n        UPDATE CourseAssignmentSubmissionFile\n           SET casaUri = ?,\n               casaTimestamp = ?\n         WHERE casaUid = ?\n    ";
            }
        };
        this.__preparedStmtOfSetDeleted = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CourseAssignmentSubmissionFile\n           SET casaDeleted = ?,\n               casaTimestamp = ?\n         WHERE casaUid = ?\n    ";
                return "\n        UPDATE CourseAssignmentSubmissionFile\n           SET casaDeleted = ?,\n               casaTimestamp = ?\n         WHERE casaUid = ?\n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseAssignmentSubmissionFile entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseAssignmentSubmissionFile.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseAssignmentSubmissionFile entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseAssignmentSubmissionFileDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseAssignmentSubmissionFileDao_Impl.this.__insertionAdapterOfCourseAssignmentSubmissionFile.insertAndReturnId((Object)entity);
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseAssignmentSubmissionFile> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseAssignmentSubmissionFile.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<CourseAssignmentSubmissionFile> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseAssignmentSubmissionFileDao_Impl.this.__db.beginTransaction();
                try {
                    CourseAssignmentSubmissionFileDao_Impl.this.__insertionAdapterOfCourseAssignmentSubmissionFile.insert((Iterable)entityList);
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(CourseAssignmentSubmissionFile entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseAssignmentSubmissionFile.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateUri(final long casaUid, final String uri, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CourseAssignmentSubmissionFileDao_Impl.this.__preparedStmtOfUpdateUri.acquire();
                int _argIndex = 1;
                _stmt.bindString(_argIndex, uri);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, casaUid);
                try {
                    Unit unit;
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CourseAssignmentSubmissionFileDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CourseAssignmentSubmissionFileDao_Impl.this.__preparedStmtOfUpdateUri.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object setDeleted(final long casaUid, final boolean deleted, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CourseAssignmentSubmissionFileDao_Impl.this.__preparedStmtOfSetDeleted.acquire();
                int _argIndex = 1;
                int _tmp = deleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, casaUid);
                try {
                    Unit unit;
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CourseAssignmentSubmissionFileDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CourseAssignmentSubmissionFileDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CourseAssignmentSubmissionFileDao_Impl.this.__preparedStmtOfSetDeleted.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getBySubmissionUid(long submissionUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid = ?\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid = ?\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submissionUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmissionFile", "TransferJobItem"}, (Callable)new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionFileDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUid");
                    int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmissionUid");
                    int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmitterUid");
                    int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaCaUid");
                    int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaClazzUid");
                    int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaMimeType");
                    int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaFileName");
                    int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUri");
                    int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSize");
                    int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaTimestamp");
                    int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaDeleted");
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> _result2 = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        TransferJobItem _tmpTransferJobItem;
                        CourseAssignmentSubmissionFile _tmpSubmissionFile;
                        if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
                            long _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
                            long _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
                            long _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
                            long _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
                            long _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
                            String _tmpCasaMimeType = _cursor.isNull(_cursorIndexOfCasaMimeType) ? null : _cursor.getString(_cursorIndexOfCasaMimeType);
                            String _tmpCasaFileName = _cursor.isNull(_cursorIndexOfCasaFileName) ? null : _cursor.getString(_cursorIndexOfCasaFileName);
                            String _tmpCasaUri = _cursor.isNull(_cursorIndexOfCasaUri) ? null : _cursor.getString(_cursorIndexOfCasaUri);
                            int _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
                            long _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
                            int _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
                            boolean _tmpCasaDeleted = _tmp != 0;
                            _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid, _tmpCasaSubmissionUid, _tmpCasaSubmitterUid, _tmpCasaCaUid, _tmpCasaClazzUid, _tmpCasaMimeType, _tmpCasaFileName, _tmpCasaUri, _tmpCasaSize, _tmpCasaTimestamp, _tmpCasaDeleted);
                        } else {
                            _tmpSubmissionFile = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
                            int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                            int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                            long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                            long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                            int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                            String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                            String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                            int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                            int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                            int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                            long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                            long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                            long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                            String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                            _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        } else {
                            _tmpTransferJobItem = null;
                        }
                        CourseAssignmentSubmissionFileAndTransferJob _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile, _tmpTransferJobItem);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getByAssignmentUidAndPersonUid(long accountPersonUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid IN\n               (SELECT CourseAssignmentSubmission.casUid\n                  FROM CourseAssignmentSubmission\n                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                   AND CourseAssignmentSubmission.casSubmitterUid = \n                       (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ))\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted        \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid IN\n               (SELECT CourseAssignmentSubmission.casUid\n                  FROM CourseAssignmentSubmission\n                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                   AND CourseAssignmentSubmission.casSubmitterUid = \n                       (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    ))\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted        \n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmissionFile", "TransferJobItem", "CourseAssignmentSubmission", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember"}, (Callable)new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionFileDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUid");
                    int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmissionUid");
                    int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmitterUid");
                    int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaCaUid");
                    int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaClazzUid");
                    int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaMimeType");
                    int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaFileName");
                    int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUri");
                    int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSize");
                    int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaTimestamp");
                    int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaDeleted");
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> _result2 = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        TransferJobItem _tmpTransferJobItem;
                        CourseAssignmentSubmissionFile _tmpSubmissionFile;
                        if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
                            long _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
                            long _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
                            long _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
                            long _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
                            long _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
                            String _tmpCasaMimeType = _cursor.isNull(_cursorIndexOfCasaMimeType) ? null : _cursor.getString(_cursorIndexOfCasaMimeType);
                            String _tmpCasaFileName = _cursor.isNull(_cursorIndexOfCasaFileName) ? null : _cursor.getString(_cursorIndexOfCasaFileName);
                            String _tmpCasaUri = _cursor.isNull(_cursorIndexOfCasaUri) ? null : _cursor.getString(_cursorIndexOfCasaUri);
                            int _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
                            long _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
                            int _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
                            boolean _tmpCasaDeleted = _tmp != 0;
                            _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid, _tmpCasaSubmissionUid, _tmpCasaSubmitterUid, _tmpCasaCaUid, _tmpCasaClazzUid, _tmpCasaMimeType, _tmpCasaFileName, _tmpCasaUri, _tmpCasaSize, _tmpCasaTimestamp, _tmpCasaDeleted);
                        } else {
                            _tmpSubmissionFile = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
                            int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                            int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                            long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                            long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                            int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                            String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                            String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                            int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                            int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                            int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                            long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                            long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                            long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                            String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                            _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        } else {
                            _tmpTransferJobItem = null;
                        }
                        CourseAssignmentSubmissionFileAndTransferJob _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile, _tmpTransferJobItem);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getAllSubmissionFilesFromSubmitterAsFlow(long submitterUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmitterUid = ?\n           AND CourseAssignmentSubmissionFile.casaCaUid = ?\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n          FROM CourseAssignmentSubmissionFile\n               LEFT JOIN TransferJobItem\n                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n                            AND TransferJobItem.tjiTableId = 90\n         WHERE CourseAssignmentSubmissionFile.casaSubmitterUid = ?\n           AND CourseAssignmentSubmissionFile.casaCaUid = ?\n           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmissionFile", "TransferJobItem"}, (Callable)new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionFileDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUid");
                    int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmissionUid");
                    int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSubmitterUid");
                    int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaCaUid");
                    int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaClazzUid");
                    int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaMimeType");
                    int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaFileName");
                    int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaUri");
                    int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaSize");
                    int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaTimestamp");
                    int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casaDeleted");
                    int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiUid");
                    int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTjUid");
                    int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTotalSize");
                    int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTransferred");
                    int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjAttemptCount");
                    int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiSrc");
                    int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiDest");
                    int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiType");
                    int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiStatus");
                    int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiTableId");
                    int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityUid");
                    int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiEntityEtag");
                    int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiLockIdToRelease");
                    int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjiPartialTmpFile");
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> _result2 = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        TransferJobItem _tmpTransferJobItem;
                        CourseAssignmentSubmissionFile _tmpSubmissionFile;
                        if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
                            long _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
                            long _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
                            long _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
                            long _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
                            long _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
                            String _tmpCasaMimeType = _cursor.isNull(_cursorIndexOfCasaMimeType) ? null : _cursor.getString(_cursorIndexOfCasaMimeType);
                            String _tmpCasaFileName = _cursor.isNull(_cursorIndexOfCasaFileName) ? null : _cursor.getString(_cursorIndexOfCasaFileName);
                            String _tmpCasaUri = _cursor.isNull(_cursorIndexOfCasaUri) ? null : _cursor.getString(_cursorIndexOfCasaUri);
                            int _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
                            long _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
                            int _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
                            boolean _tmpCasaDeleted = _tmp != 0;
                            _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid, _tmpCasaSubmissionUid, _tmpCasaSubmitterUid, _tmpCasaCaUid, _tmpCasaClazzUid, _tmpCasaMimeType, _tmpCasaFileName, _tmpCasaUri, _tmpCasaSize, _tmpCasaTimestamp, _tmpCasaDeleted);
                        } else {
                            _tmpSubmissionFile = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
                            int _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
                            int _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
                            long _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
                            long _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
                            int _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
                            String _tmpTjiSrc = _cursor.isNull(_cursorIndexOfTjiSrc) ? null : _cursor.getString(_cursorIndexOfTjiSrc);
                            String _tmpTjiDest = _cursor.isNull(_cursorIndexOfTjiDest) ? null : _cursor.getString(_cursorIndexOfTjiDest);
                            int _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
                            int _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
                            int _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
                            long _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
                            long _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
                            long _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
                            String _tmpTjiPartialTmpFile = _cursor.isNull(_cursorIndexOfTjiPartialTmpFile) ? null : _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
                            _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid, _tmpTjiTjUid, _tmpTjTotalSize, _tmpTjTransferred, _tmpTjAttemptCount, _tmpTjiSrc, _tmpTjiDest, _tmpTjiType, _tmpTjiStatus, _tmpTjiTableId, _tmpTjiEntityUid, _tmpTjiEntityEtag, _tmpTjiLockIdToRelease, _tmpTjiPartialTmpFile);
                        } else {
                            _tmpTransferJobItem = null;
                        }
                        CourseAssignmentSubmissionFileAndTransferJob _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile, _tmpTransferJobItem);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmissionFileAndTransferJob> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

