/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class LanguageVariantDao_Impl
extends LanguageVariantDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LanguageVariant> __insertionAdapterOfLanguageVariant;
    private final EntityDeletionOrUpdateAdapter<LanguageVariant> __updateAdapterOfLanguageVariant;

    public LanguageVariantDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLanguageVariant = new EntityInsertionAdapter<LanguageVariant>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `LanguageVariant` (`langVariantUid`,`langUid`,`countryCode`,`name`,`langVariantLocalChangeSeqNum`,`langVariantMasterChangeSeqNum`,`langVariantLastChangedBy`,`langVariantLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull LanguageVariant entity) {
                statement.bindLong(1, entity.getLangVariantUid());
                statement.bindLong(2, entity.getLangUid());
                if (entity.getCountryCode() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCountryCode());
                }
                if (entity.getName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getName());
                }
                statement.bindLong(5, entity.getLangVariantLocalChangeSeqNum());
                statement.bindLong(6, entity.getLangVariantMasterChangeSeqNum());
                statement.bindLong(7, (long)entity.getLangVariantLastChangedBy());
                statement.bindLong(8, entity.getLangVariantLct());
            }
        };
        this.__updateAdapterOfLanguageVariant = new EntityDeletionOrUpdateAdapter<LanguageVariant>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `LanguageVariant` SET `langVariantUid` = ?,`langUid` = ?,`countryCode` = ?,`name` = ?,`langVariantLocalChangeSeqNum` = ?,`langVariantMasterChangeSeqNum` = ?,`langVariantLastChangedBy` = ?,`langVariantLct` = ? WHERE `langVariantUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull LanguageVariant entity) {
                statement.bindLong(1, entity.getLangVariantUid());
                statement.bindLong(2, entity.getLangUid());
                if (entity.getCountryCode() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCountryCode());
                }
                if (entity.getName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getName());
                }
                statement.bindLong(5, entity.getLangVariantLocalChangeSeqNum());
                statement.bindLong(6, entity.getLangVariantMasterChangeSeqNum());
                statement.bindLong(7, (long)entity.getLangVariantLastChangedBy());
                statement.bindLong(8, entity.getLangVariantLct());
                statement.bindLong(9, entity.getLangVariantUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(LanguageVariant entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfLanguageVariant.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final LanguageVariant entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                LanguageVariantDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = LanguageVariantDao_Impl.this.__insertionAdapterOfLanguageVariant.insertAndReturnId((Object)entity);
                    LanguageVariantDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    LanguageVariantDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends LanguageVariant> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLanguageVariant.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(LanguageVariant entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfLanguageVariant.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LanguageVariant findByCode(String countryCode) {
        String _sql = "SELECT * FROM LanguageVariant WHERE countryCode = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LanguageVariant WHERE countryCode = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, countryCode);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            LanguageVariant _result2;
            int _cursorIndexOfLangVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langVariantUid");
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfLangVariantLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langVariantLocalChangeSeqNum");
            int _cursorIndexOfLangVariantMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langVariantMasterChangeSeqNum");
            int _cursorIndexOfLangVariantLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langVariantLastChangedBy");
            int _cursorIndexOfLangVariantLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langVariantLct");
            if (_cursor.moveToFirst()) {
                _result2 = new LanguageVariant();
                long _tmpLangVariantUid = _cursor.getLong(_cursorIndexOfLangVariantUid);
                _result2.setLangVariantUid(_tmpLangVariantUid);
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _result2.setLangUid(_tmpLangUid);
                String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                _result2.setCountryCode(_tmpCountryCode);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                long _tmpLangVariantLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantLocalChangeSeqNum);
                _result2.setLangVariantLocalChangeSeqNum(_tmpLangVariantLocalChangeSeqNum);
                long _tmpLangVariantMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantMasterChangeSeqNum);
                _result2.setLangVariantMasterChangeSeqNum(_tmpLangVariantMasterChangeSeqNum);
                int _tmpLangVariantLastChangedBy = _cursor.getInt(_cursorIndexOfLangVariantLastChangedBy);
                _result2.setLangVariantLastChangedBy(_tmpLangVariantLastChangedBy);
                long _tmpLangVariantLct = _cursor.getLong(_cursorIndexOfLangVariantLct);
                _result2.setLangVariantLct(_tmpLangVariantLct);
            } else {
                _result2 = null;
            }
            LanguageVariant languageVariant = _result2;
            return languageVariant;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

