package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ContentCategory
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ContentCategoryDao : BaseDao<ContentCategory> {
  @Query(`value` = "SELECT ContentCategory.* FROM ContentCategory")
  public actual abstract fun publicContentCategories(): List<ContentCategory>

  @Query(`value` =
      "SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = :schemaId AND name = :name")
  public actual abstract fun findCategoryBySchemaIdAndName(schemaId: Long, name: String):
      ContentCategory?
}
