package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.TransferJobError;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class TransferJobErrorDao_Impl extends TransferJobErrorDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TransferJobError> __insertionAdapterOfTransferJobError;

  private final SharedSQLiteStatement __preparedStmtOfDismissErrorByJobId;

  public TransferJobErrorDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTransferJobError = new EntityInsertionAdapter<TransferJobError>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `TransferJobError` (`tjeId`,`tjeTjUid`,`tjeTime`,`tjeErrorStr`,`tjeDismissed`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TransferJobError entity) {
        statement.bindLong(1, entity.getTjeId());
        statement.bindLong(2, entity.getTjeTjUid());
        statement.bindLong(3, entity.getTjeTime());
        if (entity.getTjeErrorStr() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getTjeErrorStr());
        }
        final int _tmp = entity.getTjeDismissed() ? 1 : 0;
        statement.bindLong(5, _tmp);
      }
    };
    this.__preparedStmtOfDismissErrorByJobId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobError\n"
                + "           SET tjeDismissed = ?\n"
                + "         WHERE TransferJobError.tjeTjUid = ?  \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final TransferJobError error,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfTransferJobError.insert(error);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object dismissErrorByJobId(final int jobUid, final boolean dismissed,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDismissErrorByJobId.acquire();
        int _argIndex = 1;
        final int _tmp = dismissed ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDismissErrorByJobId.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByJobId(final int jobUid,
      final Continuation<? super List<TransferJobError>> $completion) {
    final String _sql = "\n"
            + "        SELECT TransferJobError.*\n"
            + "          FROM TransferJobError\n"
            + "         WHERE TransferJobError.tjeTjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<TransferJobError>>() {
      @Override
      @NonNull
      public List<TransferJobError> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjeId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjeId");
          final int _cursorIndexOfTjeTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjeTjUid");
          final int _cursorIndexOfTjeTime = CursorUtil.getColumnIndexOrThrow(_cursor, "tjeTime");
          final int _cursorIndexOfTjeErrorStr = CursorUtil.getColumnIndexOrThrow(_cursor, "tjeErrorStr");
          final int _cursorIndexOfTjeDismissed = CursorUtil.getColumnIndexOrThrow(_cursor, "tjeDismissed");
          final List<TransferJobError> _result = new ArrayList<TransferJobError>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJobError _item;
            final int _tmpTjeId;
            _tmpTjeId = _cursor.getInt(_cursorIndexOfTjeId);
            final int _tmpTjeTjUid;
            _tmpTjeTjUid = _cursor.getInt(_cursorIndexOfTjeTjUid);
            final long _tmpTjeTime;
            _tmpTjeTime = _cursor.getLong(_cursorIndexOfTjeTime);
            final String _tmpTjeErrorStr;
            if (_cursor.isNull(_cursorIndexOfTjeErrorStr)) {
              _tmpTjeErrorStr = null;
            } else {
              _tmpTjeErrorStr = _cursor.getString(_cursorIndexOfTjeErrorStr);
            }
            final boolean _tmpTjeDismissed;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfTjeDismissed);
            _tmpTjeDismissed = _tmp != 0;
            _item = new TransferJobError(_tmpTjeId,_tmpTjeTjUid,_tmpTjeTime,_tmpTjeErrorStr,_tmpTjeDismissed);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
