package com.ustadmobile.core.db.dao;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CoursePicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CoursePictureDao_Impl extends CoursePictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CoursePicture> __insertionAdapterOfCoursePicture;

  private final SharedSQLiteStatement __preparedStmtOfUpdateUri;

  public CoursePictureDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCoursePicture = new EntityInsertionAdapter<CoursePicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CoursePicture` (`coursePictureUid`,`coursePictureLct`,`coursePictureUri`,`coursePictureThumbnailUri`,`coursePictureActive`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CoursePicture entity) {
        statement.bindLong(1, entity.getCoursePictureUid());
        statement.bindLong(2, entity.getCoursePictureLct());
        if (entity.getCoursePictureUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCoursePictureUri());
        }
        if (entity.getCoursePictureThumbnailUri() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCoursePictureThumbnailUri());
        }
        final int _tmp = entity.getCoursePictureActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
      }
    };
    this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CoursePicture\n"
                + "           SET coursePictureUri = ?,\n"
                + "               coursePictureThumbnailUri = ?,\n"
                + "               coursePictureLct = ?\n"
                + "        WHERE coursePictureUid = ?       \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object upsertAsync(final CoursePicture coursePicture,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCoursePicture.insert(coursePicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateUri(final long uid, final String uri, final String thumbnailUri,
      final long time, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateUri.acquire();
        int _argIndex = 1;
        if (uri == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, uri);
        }
        _argIndex = 2;
        if (thumbnailUri == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, thumbnailUri);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateUri.release(_stmt);
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
