package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.VerbLangMapEntry
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class VerbLangMapEntryDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertList(list: List<VerbLangMapEntry>)

  @Query(`value` =
      "\n        SELECT VerbLangMapEntry.*\n          FROM VerbLangMapEntry\n         WHERE VerbLangMapEntry.vlmeVerbUid = :verbUid\n    ")
  public actual abstract suspend fun findByVerbUidAsync(verbUid: Long): List<VerbLangMapEntry>
}
