package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Holiday;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class HolidayDao_Impl extends HolidayDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Holiday> __insertionAdapterOfHoliday;

  private final EntityDeletionOrUpdateAdapter<Holiday> __updateAdapterOfHoliday;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public HolidayDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfHoliday = new EntityInsertionAdapter<Holiday>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Holiday` (`holUid`,`holMasterCsn`,`holLocalCsn`,`holLastModBy`,`holLct`,`holActive`,`holHolidayCalendarUid`,`holStartTime`,`holEndTime`,`holName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Holiday entity) {
        statement.bindLong(1, entity.getHolUid());
        statement.bindLong(2, entity.getHolMasterCsn());
        statement.bindLong(3, entity.getHolLocalCsn());
        statement.bindLong(4, entity.getHolLastModBy());
        statement.bindLong(5, entity.getHolLct());
        final int _tmp = entity.getHolActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
        statement.bindLong(7, entity.getHolHolidayCalendarUid());
        statement.bindLong(8, entity.getHolStartTime());
        statement.bindLong(9, entity.getHolEndTime());
        if (entity.getHolName() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getHolName());
        }
      }
    };
    this.__updateAdapterOfHoliday = new EntityDeletionOrUpdateAdapter<Holiday>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Holiday` SET `holUid` = ?,`holMasterCsn` = ?,`holLocalCsn` = ?,`holLastModBy` = ?,`holLct` = ?,`holActive` = ?,`holHolidayCalendarUid` = ?,`holStartTime` = ?,`holEndTime` = ?,`holName` = ? WHERE `holUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Holiday entity) {
        statement.bindLong(1, entity.getHolUid());
        statement.bindLong(2, entity.getHolMasterCsn());
        statement.bindLong(3, entity.getHolLocalCsn());
        statement.bindLong(4, entity.getHolLastModBy());
        statement.bindLong(5, entity.getHolLct());
        final int _tmp = entity.getHolActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
        statement.bindLong(7, entity.getHolHolidayCalendarUid());
        statement.bindLong(8, entity.getHolStartTime());
        statement.bindLong(9, entity.getHolEndTime());
        if (entity.getHolName() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getHolName());
        }
        statement.bindLong(11, entity.getHolUid());
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Holiday \n"
                + "           SET holActive = ?, \n"
                + "               holLct = ?\n"
                + "         WHERE holUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Holiday entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfHoliday.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Holiday entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfHoliday.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Holiday> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfHoliday.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Holiday> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfHoliday.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateAsync(final Holiday entity, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfHoliday.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final Holiday entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfHoliday.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends Holiday> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfHoliday.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void updateActiveByUid(final long holidayUid, final boolean active,
      final long changeTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
    int _argIndex = 1;
    final int _tmp = active ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changeTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, holidayUid);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateActiveByUid.release(_stmt);
    }
  }

  @Override
  public List<Holiday> findByHolidayCalendaUid(final long holidayCalendarUid) {
    final String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, holidayCalendarUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holUid");
      final int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holMasterCsn");
      final int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holLocalCsn");
      final int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "holLastModBy");
      final int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "holLct");
      final int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "holActive");
      final int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holHolidayCalendarUid");
      final int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holStartTime");
      final int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holEndTime");
      final int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow(_cursor, "holName");
      final List<Holiday> _result = new ArrayList<Holiday>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Holiday _item;
        _item = new Holiday();
        final long _tmpHolUid;
        _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
        _item.setHolUid(_tmpHolUid);
        final long _tmpHolMasterCsn;
        _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
        _item.setHolMasterCsn(_tmpHolMasterCsn);
        final long _tmpHolLocalCsn;
        _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
        _item.setHolLocalCsn(_tmpHolLocalCsn);
        final int _tmpHolLastModBy;
        _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
        _item.setHolLastModBy(_tmpHolLastModBy);
        final long _tmpHolLct;
        _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
        _item.setHolLct(_tmpHolLct);
        final boolean _tmpHolActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfHolActive);
        _tmpHolActive = _tmp != 0;
        _item.setHolActive(_tmpHolActive);
        final long _tmpHolHolidayCalendarUid;
        _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
        _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
        final long _tmpHolStartTime;
        _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
        _item.setHolStartTime(_tmpHolStartTime);
        final long _tmpHolEndTime;
        _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
        _item.setHolEndTime(_tmpHolEndTime);
        final String _tmpHolName;
        if (_cursor.isNull(_cursorIndexOfHolName)) {
          _tmpHolName = null;
        } else {
          _tmpHolName = _cursor.getString(_cursorIndexOfHolName);
        }
        _item.setHolName(_tmpHolName);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByHolidayCalendaUidAsync(final long holidayCalendarUid,
      final Continuation<? super List<Holiday>> $completion) {
    final String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, holidayCalendarUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Holiday>>() {
      @Override
      @NonNull
      public List<Holiday> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holUid");
          final int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holMasterCsn");
          final int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "holLocalCsn");
          final int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "holLastModBy");
          final int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "holLct");
          final int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "holActive");
          final int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "holHolidayCalendarUid");
          final int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holStartTime");
          final int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "holEndTime");
          final int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow(_cursor, "holName");
          final List<Holiday> _result = new ArrayList<Holiday>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Holiday _item;
            _item = new Holiday();
            final long _tmpHolUid;
            _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
            _item.setHolUid(_tmpHolUid);
            final long _tmpHolMasterCsn;
            _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
            _item.setHolMasterCsn(_tmpHolMasterCsn);
            final long _tmpHolLocalCsn;
            _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
            _item.setHolLocalCsn(_tmpHolLocalCsn);
            final int _tmpHolLastModBy;
            _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
            _item.setHolLastModBy(_tmpHolLastModBy);
            final long _tmpHolLct;
            _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
            _item.setHolLct(_tmpHolLct);
            final boolean _tmpHolActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHolActive);
            _tmpHolActive = _tmp != 0;
            _item.setHolActive(_tmpHolActive);
            final long _tmpHolHolidayCalendarUid;
            _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
            _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
            final long _tmpHolStartTime;
            _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
            _item.setHolStartTime(_tmpHolStartTime);
            final long _tmpHolEndTime;
            _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
            _item.setHolEndTime(_tmpHolEndTime);
            final String _tmpHolName;
            if (_cursor.isNull(_cursorIndexOfHolName)) {
              _tmpHolName = null;
            } else {
              _tmpHolName = _cursor.getString(_cursorIndexOfHolName);
            }
            _item.setHolName(_tmpHolName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
