package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseAssignmentSubmissionDao_Impl extends CourseAssignmentSubmissionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseAssignmentSubmission> __insertionAdapterOfCourseAssignmentSubmission;

  private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission> __updateAdapterOfCourseAssignmentSubmission;

  public CourseAssignmentSubmissionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseAssignmentSubmission = new EntityInsertionAdapter<CourseAssignmentSubmission>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseAssignmentSubmission` (`casUid`,`casAssignmentUid`,`casSubmitterUid`,`casSubmitterPersonUid`,`casText`,`casType`,`casTimestamp`,`casClazzUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentSubmission entity) {
        statement.bindLong(1, entity.getCasUid());
        statement.bindLong(2, entity.getCasAssignmentUid());
        statement.bindLong(3, entity.getCasSubmitterUid());
        statement.bindLong(4, entity.getCasSubmitterPersonUid());
        if (entity.getCasText() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCasText());
        }
        statement.bindLong(6, entity.getCasType());
        statement.bindLong(7, entity.getCasTimestamp());
        statement.bindLong(8, entity.getCasClazzUid());
      }
    };
    this.__updateAdapterOfCourseAssignmentSubmission = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseAssignmentSubmission` SET `casUid` = ?,`casAssignmentUid` = ?,`casSubmitterUid` = ?,`casSubmitterPersonUid` = ?,`casText` = ?,`casType` = ?,`casTimestamp` = ?,`casClazzUid` = ? WHERE `casUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentSubmission entity) {
        statement.bindLong(1, entity.getCasUid());
        statement.bindLong(2, entity.getCasAssignmentUid());
        statement.bindLong(3, entity.getCasSubmitterUid());
        statement.bindLong(4, entity.getCasSubmitterPersonUid());
        if (entity.getCasText() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCasText());
        }
        statement.bindLong(6, entity.getCasType());
        statement.bindLong(7, entity.getCasTimestamp());
        statement.bindLong(8, entity.getCasClazzUid());
        statement.bindLong(9, entity.getCasUid());
      }
    };
  }

  @Override
  public long insert(final CourseAssignmentSubmission entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseAssignmentSubmission entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseAssignmentSubmission> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseAssignmentSubmission.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<CourseAssignmentSubmission> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseAssignmentSubmission.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseAssignmentSubmission entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmission.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public PagingSource<Integer, CourseAssignmentSubmission> getAllSubmissionsFromSubmitter(
      final long assignmentUid, final long submitterUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "      ORDER BY casTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    return new LimitOffsetPagingSource<CourseAssignmentSubmission>(_statement, __db, "CourseAssignmentSubmission") {
      @Override
      @NonNull
      protected List<CourseAssignmentSubmission> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(cursor, "casUid");
        final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "casAssignmentUid");
        final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "casSubmitterUid");
        final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "casSubmitterPersonUid");
        final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(cursor, "casText");
        final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(cursor, "casType");
        final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "casTimestamp");
        final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "casClazzUid");
        final List<CourseAssignmentSubmission> _result = new ArrayList<CourseAssignmentSubmission>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CourseAssignmentSubmission _item;
          final long _tmpCasUid;
          _tmpCasUid = cursor.getLong(_cursorIndexOfCasUid);
          final long _tmpCasAssignmentUid;
          _tmpCasAssignmentUid = cursor.getLong(_cursorIndexOfCasAssignmentUid);
          final long _tmpCasSubmitterUid;
          _tmpCasSubmitterUid = cursor.getLong(_cursorIndexOfCasSubmitterUid);
          final long _tmpCasSubmitterPersonUid;
          _tmpCasSubmitterPersonUid = cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
          final String _tmpCasText;
          if (cursor.isNull(_cursorIndexOfCasText)) {
            _tmpCasText = null;
          } else {
            _tmpCasText = cursor.getString(_cursorIndexOfCasText);
          }
          final int _tmpCasType;
          _tmpCasType = cursor.getInt(_cursorIndexOfCasType);
          final long _tmpCasTimestamp;
          _tmpCasTimestamp = cursor.getLong(_cursorIndexOfCasTimestamp);
          final long _tmpCasClazzUid;
          _tmpCasClazzUid = cursor.getLong(_cursorIndexOfCasClazzUid);
          _item = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Flow<List<CourseAssignmentSubmission>> getAllSubmissionsForUser(
      final long accountPersonUid, final long assignmentUid) {
    final String _sql = "\n"
            + "         SELECT CourseAssignmentSubmission.*\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission",
        "ClazzAssignment", "ClazzEnrolment",
        "CourseGroupMember"}, new Callable<List<CourseAssignmentSubmission>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final List<CourseAssignmentSubmission> _result = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmission _item;
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _item = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentSubmission>> getAllSubmissionsFromSubmitterAsFlow(
      final long submitterUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmission.*\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "           AND CourseAssignmentSubmission.casSubmitterUid = ?\n"
            + "      ORDER BY CourseAssignmentSubmission.casTimestamp DESC      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission"}, new Callable<List<CourseAssignmentSubmission>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final List<CourseAssignmentSubmission> _result = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmission _item;
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _item = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getLatestSubmissionForUserAsync(final long accountPersonUid,
      final long assignmentUid,
      final Continuation<? super CourseAssignmentSubmission> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmission.*\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "           AND CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "      ORDER BY casTimestamp DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseAssignmentSubmission>() {
      @Override
      @Nullable
      public CourseAssignmentSubmission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final CourseAssignmentSubmission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _result = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object doesUserHaveSubmissions(final long accountPersonUid, final long assignmentUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS\n"
            + "               (SELECT CourseAssignmentSubmission.casUid\n"
            + "                  FROM CourseAssignmentSubmission\n"
            + "                 WHERE CourseAssignmentSubmission.casSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "                   AND CourseAssignmentSubmission.casAssignmentUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object countFileSubmissionFromStudent(final long assignmentUid, final long submitterUid,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "        SELECT Count(casUid)\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "           AND casType = 2\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object countSubmissionsFromSubmitter(final long assignmentUid, final long submitterUid,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "        SELECT Count(casUid)\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Integer> getStatusOfAssignmentForSubmitter(final long assignmentUid,
      final long submitterUid) {
    final String _sql = "\n"
            + "           SELECT COALESCE((\n"
            + "                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n"
            + "                             THEN 2\n"
            + "                             ELSE 1 \n"
            + "                             END) AS status\n"
            + "                  FROM CourseAssignmentSubmission\n"
            + "                       \n"
            + "                       LEFT JOIN CourseAssignmentMark\n"
            + "                       ON CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                       AND CourseAssignmentMark.camSubmitterUid = ?\n"
            + "                       \n"
            + "                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                   AND CourseAssignmentSubmission.casSubmitterUid = ?\n"
            + "                 LIMIT 1\n"
            + "           ),0) AS Status\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, submitterUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission",
        "CourseAssignmentMark"}, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findLastSubmissionFromStudent(final long submitterUid, final long assignmentUid,
      final Continuation<? super CourseAssignmentSubmission> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "           AND CourseAssignmentSubmission.casSubmitterUid = ?\n"
            + "      ORDER BY casTimestamp DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseAssignmentSubmission>() {
      @Override
      @Nullable
      public CourseAssignmentSubmission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final CourseAssignmentSubmission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _result = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Boolean> checkNoSubmissionsMade(final long assignmentUid) {
    final String _sql = "\n"
            + "         SELECT NOT EXISTS(SELECT 1\n"
            + "                        FROM CourseAssignmentSubmission\n"
            + "                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                       LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object checkNoSubmissionsMadeAsync(final long assignmentUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "         SELECT NOT EXISTS(SELECT 1\n"
            + "                        FROM CourseAssignmentSubmission\n"
            + "                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                       LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Boolean> checkNoSubmissionsMadeFlow(final long assignmentUid) {
    final String _sql = "\n"
            + "         SELECT NOT EXISTS(SELECT 1\n"
            + "                        FROM CourseAssignmentSubmission\n"
            + "                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                       LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<CourseAssignmentSubmission> findByUidAsFlow(final long submissionUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmission.*\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submissionUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission"}, new Callable<CourseAssignmentSubmission>() {
      @Override
      @Nullable
      public CourseAssignmentSubmission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final CourseAssignmentSubmission _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _result = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentSubmission>> findByAssignmentUidAndAccountPersonUid(
      final long accountPersonUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmission.*\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "           AND CourseAssignmentSubmission.casSubmitterUid = \n"
            + "               (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "      ORDER BY CourseAssignmentSubmission.casTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmission",
        "ClazzAssignment", "ClazzEnrolment",
        "CourseGroupMember"}, new Callable<List<CourseAssignmentSubmission>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final List<CourseAssignmentSubmission> _result = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmission _item;
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _item = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
