package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.TransferJobError
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.collections.List

@Dao
public actual abstract class TransferJobErrorDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertAsync(error: TransferJobError)

  @Query(`value` =
      "\n        SELECT TransferJobError.*\n          FROM TransferJobError\n         WHERE TransferJobError.tjeTjUid = :jobUid\n    ")
  public actual abstract suspend fun findByJobId(jobUid: Int): List<TransferJobError>

  @Query(`value` =
      "\n        UPDATE TransferJobError\n           SET tjeDismissed = :dismissed\n         WHERE TransferJobError.tjeTjUid = :jobUid  \n    ")
  public actual abstract suspend fun dismissErrorByJobId(jobUid: Int, dismissed: Boolean)
}
