package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ActivityLangMapEntryDao.findAllByActivityUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_activityUid : Long = request.queryParam("activityUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findAllByActivityUid = findAllByActivityUid(
    activityUid = _arg_activityUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllByActivityUid.map {
        _row ->
        DoorReplicationEntity(tableId = 6_442,
          orUid = 0,
          entity = json.encodeToJsonElement(ActivityLangMapEntry.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
