/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.SiteDao;
import com.ustadmobile.lib.db.entities.Site;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class SiteDao_Impl
extends SiteDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Site> __insertionAdapterOfSite;
    private final EntityInsertionAdapter<Site> __insertionAdapterOfSite_1;
    private final EntityDeletionOrUpdateAdapter<Site> __updateAdapterOfSite;

    public SiteDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSite = new EntityInsertionAdapter<Site>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Site entity) {
                statement.bindLong(1, entity.getSiteUid());
                statement.bindLong(2, entity.getSitePcsn());
                statement.bindLong(3, entity.getSiteLcsn());
                statement.bindLong(4, (long)entity.getSiteLcb());
                statement.bindLong(5, entity.getSiteLct());
                if (entity.getSiteName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getSiteName());
                }
                int _tmp = entity.getGuestLogin() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                if (entity.getAuthSalt() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getAuthSalt());
                }
            }
        };
        this.__insertionAdapterOfSite_1 = new EntityInsertionAdapter<Site>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Site entity) {
                statement.bindLong(1, entity.getSiteUid());
                statement.bindLong(2, entity.getSitePcsn());
                statement.bindLong(3, entity.getSiteLcsn());
                statement.bindLong(4, (long)entity.getSiteLcb());
                statement.bindLong(5, entity.getSiteLct());
                if (entity.getSiteName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getSiteName());
                }
                int _tmp = entity.getGuestLogin() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                if (entity.getAuthSalt() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getAuthSalt());
                }
            }
        };
        this.__updateAdapterOfSite = new EntityDeletionOrUpdateAdapter<Site>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Site` SET `siteUid` = ?,`sitePcsn` = ?,`siteLcsn` = ?,`siteLcb` = ?,`siteLct` = ?,`siteName` = ?,`guestLogin` = ?,`registrationAllowed` = ?,`authSalt` = ? WHERE `siteUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Site entity) {
                statement.bindLong(1, entity.getSiteUid());
                statement.bindLong(2, entity.getSitePcsn());
                statement.bindLong(3, entity.getSiteLcsn());
                statement.bindLong(4, (long)entity.getSiteLcb());
                statement.bindLong(5, entity.getSiteLct());
                if (entity.getSiteName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getSiteName());
                }
                int _tmp = entity.getGuestLogin() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                if (entity.getAuthSalt() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getAuthSalt());
                }
                statement.bindLong(10, entity.getSiteUid());
            }
        };
    }

    @Override
    public Object replaceAsync(final Site site, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                SiteDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = SiteDao_Impl.this.__insertionAdapterOfSite.insertAndReturnId((Object)site);
                    SiteDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    SiteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Site site) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfSite_1.insertAndReturnId((Object)site);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Site site, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                SiteDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = SiteDao_Impl.this.__insertionAdapterOfSite_1.insertAndReturnId((Object)site);
                    SiteDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    SiteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateAsync(final Site workspace, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SiteDao_Impl.this.__db.beginTransaction();
                try {
                    SiteDao_Impl.this.__updateAdapterOfSite.handle((Object)workspace);
                    SiteDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SiteDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Site getSite() {
        String _sql = "SELECT * FROM Site LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Site LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Site _result2;
            int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteUid");
            int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sitePcsn");
            int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcsn");
            int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcb");
            int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLct");
            int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteName");
            int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"guestLogin");
            int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"registrationAllowed");
            int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authSalt");
            if (_cursor.moveToFirst()) {
                _result2 = new Site();
                long _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
                _result2.setSiteUid(_tmpSiteUid);
                long _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
                _result2.setSitePcsn(_tmpSitePcsn);
                long _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
                _result2.setSiteLcsn(_tmpSiteLcsn);
                int _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
                _result2.setSiteLcb(_tmpSiteLcb);
                long _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
                _result2.setSiteLct(_tmpSiteLct);
                String _tmpSiteName = _cursor.isNull(_cursorIndexOfSiteName) ? null : _cursor.getString(_cursorIndexOfSiteName);
                _result2.setSiteName(_tmpSiteName);
                int _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
                boolean _tmpGuestLogin = _tmp != 0;
                _result2.setGuestLogin(_tmpGuestLogin);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
                boolean _tmpRegistrationAllowed = _tmp_1 != 0;
                _result2.setRegistrationAllowed(_tmpRegistrationAllowed);
                String _tmpAuthSalt = _cursor.isNull(_cursorIndexOfAuthSalt) ? null : _cursor.getString(_cursorIndexOfAuthSalt);
                _result2.setAuthSalt(_tmpAuthSalt);
            } else {
                _result2 = null;
            }
            Site site = _result2;
            return site;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object getSiteAsync(Continuation<? super Site> $completion) {
        String _sql = "SELECT * FROM Site LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Site LIMIT 1", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Site>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Site call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Site _result2;
                    int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteUid");
                    int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sitePcsn");
                    int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcsn");
                    int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcb");
                    int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLct");
                    int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteName");
                    int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"guestLogin");
                    int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"registrationAllowed");
                    int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authSalt");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Site();
                        long _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
                        _result2.setSiteUid(_tmpSiteUid);
                        long _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
                        _result2.setSitePcsn(_tmpSitePcsn);
                        long _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
                        _result2.setSiteLcsn(_tmpSiteLcsn);
                        int _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
                        _result2.setSiteLcb(_tmpSiteLcb);
                        long _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
                        _result2.setSiteLct(_tmpSiteLct);
                        String _tmpSiteName = _cursor.isNull(_cursorIndexOfSiteName) ? null : _cursor.getString(_cursorIndexOfSiteName);
                        _result2.setSiteName(_tmpSiteName);
                        int _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
                        boolean _tmpGuestLogin = _tmp != 0;
                        _result2.setGuestLogin(_tmpGuestLogin);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
                        boolean _tmpRegistrationAllowed = _tmp_1 != 0;
                        _result2.setRegistrationAllowed(_tmpRegistrationAllowed);
                        String _tmpAuthSalt = _cursor.isNull(_cursorIndexOfAuthSalt) ? null : _cursor.getString(_cursorIndexOfAuthSalt);
                        _result2.setAuthSalt(_tmpAuthSalt);
                    } else {
                        _result2 = null;
                    }
                    Site site = _result2;
                    return site;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getSiteAuthSaltAsync(Continuation<? super String> $completion) {
        String _sql = "SELECT authSalt FROM Site LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT authSalt FROM Site LIMIT 1", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Site> getSiteAsFlow() {
        String _sql = "SELECT * FROM Site LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Site LIMIT 1", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Site"}, (Callable)new Callable<Site>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Site call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SiteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Site _result2;
                    int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteUid");
                    int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sitePcsn");
                    int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcsn");
                    int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLcb");
                    int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteLct");
                    int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"siteName");
                    int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"guestLogin");
                    int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"registrationAllowed");
                    int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"authSalt");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Site();
                        long _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
                        _result2.setSiteUid(_tmpSiteUid);
                        long _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
                        _result2.setSitePcsn(_tmpSitePcsn);
                        long _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
                        _result2.setSiteLcsn(_tmpSiteLcsn);
                        int _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
                        _result2.setSiteLcb(_tmpSiteLcb);
                        long _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
                        _result2.setSiteLct(_tmpSiteLct);
                        String _tmpSiteName = _cursor.isNull(_cursorIndexOfSiteName) ? null : _cursor.getString(_cursorIndexOfSiteName);
                        _result2.setSiteName(_tmpSiteName);
                        int _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
                        boolean _tmpGuestLogin = _tmp != 0;
                        _result2.setGuestLogin(_tmpGuestLogin);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
                        boolean _tmpRegistrationAllowed = _tmp_1 != 0;
                        _result2.setRegistrationAllowed(_tmpRegistrationAllowed);
                        String _tmpAuthSalt = _cursor.isNull(_cursorIndexOfAuthSalt) ? null : _cursor.getString(_cursorIndexOfAuthSalt);
                        _result2.setAuthSalt(_tmpAuthSalt);
                    } else {
                        _result2 = null;
                    }
                    Site site = _result2;
                    return site;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

