package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.CourseAssignmentSubmissionFileAndTransferJob;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionFile;
import com.ustadmobile.lib.db.entities.TransferJobItem;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseAssignmentSubmissionFileDao_Impl extends CourseAssignmentSubmissionFileDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseAssignmentSubmissionFile> __insertionAdapterOfCourseAssignmentSubmissionFile;

  private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionFile> __updateAdapterOfCourseAssignmentSubmissionFile;

  private final SharedSQLiteStatement __preparedStmtOfUpdateUri;

  private final SharedSQLiteStatement __preparedStmtOfSetDeleted;

  public CourseAssignmentSubmissionFileDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseAssignmentSubmissionFile = new EntityInsertionAdapter<CourseAssignmentSubmissionFile>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseAssignmentSubmissionFile` (`casaUid`,`casaSubmissionUid`,`casaSubmitterUid`,`casaCaUid`,`casaClazzUid`,`casaMimeType`,`casaFileName`,`casaUri`,`casaSize`,`casaTimestamp`,`casaDeleted`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentSubmissionFile entity) {
        statement.bindLong(1, entity.getCasaUid());
        statement.bindLong(2, entity.getCasaSubmissionUid());
        statement.bindLong(3, entity.getCasaSubmitterUid());
        statement.bindLong(4, entity.getCasaCaUid());
        statement.bindLong(5, entity.getCasaClazzUid());
        if (entity.getCasaMimeType() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCasaMimeType());
        }
        if (entity.getCasaFileName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getCasaFileName());
        }
        if (entity.getCasaUri() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCasaUri());
        }
        statement.bindLong(9, entity.getCasaSize());
        statement.bindLong(10, entity.getCasaTimestamp());
        final int _tmp = entity.getCasaDeleted() ? 1 : 0;
        statement.bindLong(11, _tmp);
      }
    };
    this.__updateAdapterOfCourseAssignmentSubmissionFile = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmissionFile>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseAssignmentSubmissionFile` SET `casaUid` = ?,`casaSubmissionUid` = ?,`casaSubmitterUid` = ?,`casaCaUid` = ?,`casaClazzUid` = ?,`casaMimeType` = ?,`casaFileName` = ?,`casaUri` = ?,`casaSize` = ?,`casaTimestamp` = ?,`casaDeleted` = ? WHERE `casaUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentSubmissionFile entity) {
        statement.bindLong(1, entity.getCasaUid());
        statement.bindLong(2, entity.getCasaSubmissionUid());
        statement.bindLong(3, entity.getCasaSubmitterUid());
        statement.bindLong(4, entity.getCasaCaUid());
        statement.bindLong(5, entity.getCasaClazzUid());
        if (entity.getCasaMimeType() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCasaMimeType());
        }
        if (entity.getCasaFileName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getCasaFileName());
        }
        if (entity.getCasaUri() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCasaUri());
        }
        statement.bindLong(9, entity.getCasaSize());
        statement.bindLong(10, entity.getCasaTimestamp());
        final int _tmp = entity.getCasaDeleted() ? 1 : 0;
        statement.bindLong(11, _tmp);
        statement.bindLong(12, entity.getCasaUid());
      }
    };
    this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseAssignmentSubmissionFile\n"
                + "           SET casaUri = ?,\n"
                + "               casaTimestamp = ?\n"
                + "         WHERE casaUid = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfSetDeleted = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseAssignmentSubmissionFile\n"
                + "           SET casaDeleted = ?,\n"
                + "               casaTimestamp = ?\n"
                + "         WHERE casaUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseAssignmentSubmissionFile entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseAssignmentSubmissionFile.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseAssignmentSubmissionFile entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseAssignmentSubmissionFile.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseAssignmentSubmissionFile> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseAssignmentSubmissionFile.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<CourseAssignmentSubmissionFile> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseAssignmentSubmissionFile.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseAssignmentSubmissionFile entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmissionFile.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateUri(final long casaUid, final String uri, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateUri.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, uri);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, casaUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateUri.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object setDeleted(final long casaUid, final boolean deleted, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetDeleted.acquire();
        int _argIndex = 1;
        final int _tmp = deleted ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, casaUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfSetDeleted.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getBySubmissionUid(
      final long submissionUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n"
            + "          FROM CourseAssignmentSubmissionFile\n"
            + "               LEFT JOIN TransferJobItem\n"
            + "                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n"
            + "                            AND TransferJobItem.tjiTableId = 90\n"
            + "         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid = ?\n"
            + "           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submissionUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmissionFile",
        "TransferJobItem"}, new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUid");
          final int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmissionUid");
          final int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmitterUid");
          final int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaCaUid");
          final int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaClazzUid");
          final int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "casaMimeType");
          final int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow(_cursor, "casaFileName");
          final int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUri");
          final int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSize");
          final int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casaTimestamp");
          final int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "casaDeleted");
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<CourseAssignmentSubmissionFileAndTransferJob> _result = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmissionFileAndTransferJob _item;
            final CourseAssignmentSubmissionFile _tmpSubmissionFile;
            if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
              final long _tmpCasaUid;
              _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
              final long _tmpCasaSubmissionUid;
              _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
              final long _tmpCasaSubmitterUid;
              _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
              final long _tmpCasaCaUid;
              _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
              final long _tmpCasaClazzUid;
              _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
              final String _tmpCasaMimeType;
              if (_cursor.isNull(_cursorIndexOfCasaMimeType)) {
                _tmpCasaMimeType = null;
              } else {
                _tmpCasaMimeType = _cursor.getString(_cursorIndexOfCasaMimeType);
              }
              final String _tmpCasaFileName;
              if (_cursor.isNull(_cursorIndexOfCasaFileName)) {
                _tmpCasaFileName = null;
              } else {
                _tmpCasaFileName = _cursor.getString(_cursorIndexOfCasaFileName);
              }
              final String _tmpCasaUri;
              if (_cursor.isNull(_cursorIndexOfCasaUri)) {
                _tmpCasaUri = null;
              } else {
                _tmpCasaUri = _cursor.getString(_cursorIndexOfCasaUri);
              }
              final int _tmpCasaSize;
              _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
              final long _tmpCasaTimestamp;
              _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
              final boolean _tmpCasaDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
              _tmpCasaDeleted = _tmp != 0;
              _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid,_tmpCasaSubmissionUid,_tmpCasaSubmitterUid,_tmpCasaCaUid,_tmpCasaClazzUid,_tmpCasaMimeType,_tmpCasaFileName,_tmpCasaUri,_tmpCasaSize,_tmpCasaTimestamp,_tmpCasaDeleted);
            } else {
              _tmpSubmissionFile = null;
            }
            final TransferJobItem _tmpTransferJobItem;
            if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
              final int _tmpTjiUid;
              _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
              final int _tmpTjiTjUid;
              _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
              final long _tmpTjTotalSize;
              _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
              final long _tmpTjTransferred;
              _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
              final int _tmpTjAttemptCount;
              _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
              final String _tmpTjiSrc;
              if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
                _tmpTjiSrc = null;
              } else {
                _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
              }
              final String _tmpTjiDest;
              if (_cursor.isNull(_cursorIndexOfTjiDest)) {
                _tmpTjiDest = null;
              } else {
                _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
              }
              final int _tmpTjiType;
              _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
              final int _tmpTjiStatus;
              _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
              final int _tmpTjiTableId;
              _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
              final long _tmpTjiEntityUid;
              _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
              final long _tmpTjiEntityEtag;
              _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
              final long _tmpTjiLockIdToRelease;
              _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
              final String _tmpTjiPartialTmpFile;
              if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
                _tmpTjiPartialTmpFile = null;
              } else {
                _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
              }
              _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            } else {
              _tmpTransferJobItem = null;
            }
            _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile,_tmpTransferJobItem);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getByAssignmentUidAndPersonUid(
      final long accountPersonUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n"
            + "          FROM CourseAssignmentSubmissionFile\n"
            + "               LEFT JOIN TransferJobItem\n"
            + "                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n"
            + "                            AND TransferJobItem.tjiTableId = 90\n"
            + "         WHERE CourseAssignmentSubmissionFile.casaSubmissionUid IN\n"
            + "               (SELECT CourseAssignmentSubmission.casUid\n"
            + "                  FROM CourseAssignmentSubmission\n"
            + "                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                   AND CourseAssignmentSubmission.casSubmitterUid = \n"
            + "                       (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    ))\n"
            + "           AND NOT CourseAssignmentSubmissionFile.casaDeleted        \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmissionFile",
        "TransferJobItem", "CourseAssignmentSubmission", "ClazzAssignment", "ClazzEnrolment",
        "CourseGroupMember"}, new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUid");
          final int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmissionUid");
          final int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmitterUid");
          final int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaCaUid");
          final int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaClazzUid");
          final int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "casaMimeType");
          final int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow(_cursor, "casaFileName");
          final int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUri");
          final int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSize");
          final int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casaTimestamp");
          final int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "casaDeleted");
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<CourseAssignmentSubmissionFileAndTransferJob> _result = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmissionFileAndTransferJob _item;
            final CourseAssignmentSubmissionFile _tmpSubmissionFile;
            if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
              final long _tmpCasaUid;
              _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
              final long _tmpCasaSubmissionUid;
              _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
              final long _tmpCasaSubmitterUid;
              _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
              final long _tmpCasaCaUid;
              _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
              final long _tmpCasaClazzUid;
              _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
              final String _tmpCasaMimeType;
              if (_cursor.isNull(_cursorIndexOfCasaMimeType)) {
                _tmpCasaMimeType = null;
              } else {
                _tmpCasaMimeType = _cursor.getString(_cursorIndexOfCasaMimeType);
              }
              final String _tmpCasaFileName;
              if (_cursor.isNull(_cursorIndexOfCasaFileName)) {
                _tmpCasaFileName = null;
              } else {
                _tmpCasaFileName = _cursor.getString(_cursorIndexOfCasaFileName);
              }
              final String _tmpCasaUri;
              if (_cursor.isNull(_cursorIndexOfCasaUri)) {
                _tmpCasaUri = null;
              } else {
                _tmpCasaUri = _cursor.getString(_cursorIndexOfCasaUri);
              }
              final int _tmpCasaSize;
              _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
              final long _tmpCasaTimestamp;
              _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
              final boolean _tmpCasaDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
              _tmpCasaDeleted = _tmp != 0;
              _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid,_tmpCasaSubmissionUid,_tmpCasaSubmitterUid,_tmpCasaCaUid,_tmpCasaClazzUid,_tmpCasaMimeType,_tmpCasaFileName,_tmpCasaUri,_tmpCasaSize,_tmpCasaTimestamp,_tmpCasaDeleted);
            } else {
              _tmpSubmissionFile = null;
            }
            final TransferJobItem _tmpTransferJobItem;
            if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
              final int _tmpTjiUid;
              _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
              final int _tmpTjiTjUid;
              _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
              final long _tmpTjTotalSize;
              _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
              final long _tmpTjTransferred;
              _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
              final int _tmpTjAttemptCount;
              _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
              final String _tmpTjiSrc;
              if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
                _tmpTjiSrc = null;
              } else {
                _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
              }
              final String _tmpTjiDest;
              if (_cursor.isNull(_cursorIndexOfTjiDest)) {
                _tmpTjiDest = null;
              } else {
                _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
              }
              final int _tmpTjiType;
              _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
              final int _tmpTjiStatus;
              _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
              final int _tmpTjiTableId;
              _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
              final long _tmpTjiEntityUid;
              _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
              final long _tmpTjiEntityEtag;
              _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
              final long _tmpTjiLockIdToRelease;
              _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
              final String _tmpTjiPartialTmpFile;
              if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
                _tmpTjiPartialTmpFile = null;
              } else {
                _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
              }
              _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            } else {
              _tmpTransferJobItem = null;
            }
            _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile,_tmpTransferJobItem);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentSubmissionFileAndTransferJob>> getAllSubmissionFilesFromSubmitterAsFlow(
      final long submitterUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentSubmissionFile.*, TransferJobItem.*\n"
            + "          FROM CourseAssignmentSubmissionFile\n"
            + "               LEFT JOIN TransferJobItem\n"
            + "                         ON TransferJobItem.tjiEntityUid = CourseAssignmentSubmissionFile.casaUid\n"
            + "                            AND TransferJobItem.tjiTableId = 90\n"
            + "         WHERE CourseAssignmentSubmissionFile.casaSubmitterUid = ?\n"
            + "           AND CourseAssignmentSubmissionFile.casaCaUid = ?\n"
            + "           AND NOT CourseAssignmentSubmissionFile.casaDeleted\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentSubmissionFile",
        "TransferJobItem"}, new Callable<List<CourseAssignmentSubmissionFileAndTransferJob>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmissionFileAndTransferJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUid");
          final int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmissionUid");
          final int _cursorIndexOfCasaSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSubmitterUid");
          final int _cursorIndexOfCasaCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaCaUid");
          final int _cursorIndexOfCasaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casaClazzUid");
          final int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "casaMimeType");
          final int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow(_cursor, "casaFileName");
          final int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow(_cursor, "casaUri");
          final int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow(_cursor, "casaSize");
          final int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casaTimestamp");
          final int _cursorIndexOfCasaDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "casaDeleted");
          final int _cursorIndexOfTjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiUid");
          final int _cursorIndexOfTjiTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTjUid");
          final int _cursorIndexOfTjTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTotalSize");
          final int _cursorIndexOfTjTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTransferred");
          final int _cursorIndexOfTjAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "tjAttemptCount");
          final int _cursorIndexOfTjiSrc = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiSrc");
          final int _cursorIndexOfTjiDest = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiDest");
          final int _cursorIndexOfTjiType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiType");
          final int _cursorIndexOfTjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiStatus");
          final int _cursorIndexOfTjiTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiTableId");
          final int _cursorIndexOfTjiEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityUid");
          final int _cursorIndexOfTjiEntityEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiEntityEtag");
          final int _cursorIndexOfTjiLockIdToRelease = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiLockIdToRelease");
          final int _cursorIndexOfTjiPartialTmpFile = CursorUtil.getColumnIndexOrThrow(_cursor, "tjiPartialTmpFile");
          final List<CourseAssignmentSubmissionFileAndTransferJob> _result = new ArrayList<CourseAssignmentSubmissionFileAndTransferJob>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmissionFileAndTransferJob _item;
            final CourseAssignmentSubmissionFile _tmpSubmissionFile;
            if (!(_cursor.isNull(_cursorIndexOfCasaUid) && _cursor.isNull(_cursorIndexOfCasaSubmissionUid) && _cursor.isNull(_cursorIndexOfCasaSubmitterUid) && _cursor.isNull(_cursorIndexOfCasaCaUid) && _cursor.isNull(_cursorIndexOfCasaClazzUid) && _cursor.isNull(_cursorIndexOfCasaMimeType) && _cursor.isNull(_cursorIndexOfCasaFileName) && _cursor.isNull(_cursorIndexOfCasaUri) && _cursor.isNull(_cursorIndexOfCasaSize) && _cursor.isNull(_cursorIndexOfCasaTimestamp) && _cursor.isNull(_cursorIndexOfCasaDeleted))) {
              final long _tmpCasaUid;
              _tmpCasaUid = _cursor.getLong(_cursorIndexOfCasaUid);
              final long _tmpCasaSubmissionUid;
              _tmpCasaSubmissionUid = _cursor.getLong(_cursorIndexOfCasaSubmissionUid);
              final long _tmpCasaSubmitterUid;
              _tmpCasaSubmitterUid = _cursor.getLong(_cursorIndexOfCasaSubmitterUid);
              final long _tmpCasaCaUid;
              _tmpCasaCaUid = _cursor.getLong(_cursorIndexOfCasaCaUid);
              final long _tmpCasaClazzUid;
              _tmpCasaClazzUid = _cursor.getLong(_cursorIndexOfCasaClazzUid);
              final String _tmpCasaMimeType;
              if (_cursor.isNull(_cursorIndexOfCasaMimeType)) {
                _tmpCasaMimeType = null;
              } else {
                _tmpCasaMimeType = _cursor.getString(_cursorIndexOfCasaMimeType);
              }
              final String _tmpCasaFileName;
              if (_cursor.isNull(_cursorIndexOfCasaFileName)) {
                _tmpCasaFileName = null;
              } else {
                _tmpCasaFileName = _cursor.getString(_cursorIndexOfCasaFileName);
              }
              final String _tmpCasaUri;
              if (_cursor.isNull(_cursorIndexOfCasaUri)) {
                _tmpCasaUri = null;
              } else {
                _tmpCasaUri = _cursor.getString(_cursorIndexOfCasaUri);
              }
              final int _tmpCasaSize;
              _tmpCasaSize = _cursor.getInt(_cursorIndexOfCasaSize);
              final long _tmpCasaTimestamp;
              _tmpCasaTimestamp = _cursor.getLong(_cursorIndexOfCasaTimestamp);
              final boolean _tmpCasaDeleted;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCasaDeleted);
              _tmpCasaDeleted = _tmp != 0;
              _tmpSubmissionFile = new CourseAssignmentSubmissionFile(_tmpCasaUid,_tmpCasaSubmissionUid,_tmpCasaSubmitterUid,_tmpCasaCaUid,_tmpCasaClazzUid,_tmpCasaMimeType,_tmpCasaFileName,_tmpCasaUri,_tmpCasaSize,_tmpCasaTimestamp,_tmpCasaDeleted);
            } else {
              _tmpSubmissionFile = null;
            }
            final TransferJobItem _tmpTransferJobItem;
            if (!(_cursor.isNull(_cursorIndexOfTjiUid) && _cursor.isNull(_cursorIndexOfTjiTjUid) && _cursor.isNull(_cursorIndexOfTjTotalSize) && _cursor.isNull(_cursorIndexOfTjTransferred) && _cursor.isNull(_cursorIndexOfTjAttemptCount) && _cursor.isNull(_cursorIndexOfTjiSrc) && _cursor.isNull(_cursorIndexOfTjiDest) && _cursor.isNull(_cursorIndexOfTjiType) && _cursor.isNull(_cursorIndexOfTjiStatus) && _cursor.isNull(_cursorIndexOfTjiTableId) && _cursor.isNull(_cursorIndexOfTjiEntityUid) && _cursor.isNull(_cursorIndexOfTjiEntityEtag) && _cursor.isNull(_cursorIndexOfTjiLockIdToRelease) && _cursor.isNull(_cursorIndexOfTjiPartialTmpFile))) {
              final int _tmpTjiUid;
              _tmpTjiUid = _cursor.getInt(_cursorIndexOfTjiUid);
              final int _tmpTjiTjUid;
              _tmpTjiTjUid = _cursor.getInt(_cursorIndexOfTjiTjUid);
              final long _tmpTjTotalSize;
              _tmpTjTotalSize = _cursor.getLong(_cursorIndexOfTjTotalSize);
              final long _tmpTjTransferred;
              _tmpTjTransferred = _cursor.getLong(_cursorIndexOfTjTransferred);
              final int _tmpTjAttemptCount;
              _tmpTjAttemptCount = _cursor.getInt(_cursorIndexOfTjAttemptCount);
              final String _tmpTjiSrc;
              if (_cursor.isNull(_cursorIndexOfTjiSrc)) {
                _tmpTjiSrc = null;
              } else {
                _tmpTjiSrc = _cursor.getString(_cursorIndexOfTjiSrc);
              }
              final String _tmpTjiDest;
              if (_cursor.isNull(_cursorIndexOfTjiDest)) {
                _tmpTjiDest = null;
              } else {
                _tmpTjiDest = _cursor.getString(_cursorIndexOfTjiDest);
              }
              final int _tmpTjiType;
              _tmpTjiType = _cursor.getInt(_cursorIndexOfTjiType);
              final int _tmpTjiStatus;
              _tmpTjiStatus = _cursor.getInt(_cursorIndexOfTjiStatus);
              final int _tmpTjiTableId;
              _tmpTjiTableId = _cursor.getInt(_cursorIndexOfTjiTableId);
              final long _tmpTjiEntityUid;
              _tmpTjiEntityUid = _cursor.getLong(_cursorIndexOfTjiEntityUid);
              final long _tmpTjiEntityEtag;
              _tmpTjiEntityEtag = _cursor.getLong(_cursorIndexOfTjiEntityEtag);
              final long _tmpTjiLockIdToRelease;
              _tmpTjiLockIdToRelease = _cursor.getLong(_cursorIndexOfTjiLockIdToRelease);
              final String _tmpTjiPartialTmpFile;
              if (_cursor.isNull(_cursorIndexOfTjiPartialTmpFile)) {
                _tmpTjiPartialTmpFile = null;
              } else {
                _tmpTjiPartialTmpFile = _cursor.getString(_cursorIndexOfTjiPartialTmpFile);
              }
              _tmpTransferJobItem = new TransferJobItem(_tmpTjiUid,_tmpTjiTjUid,_tmpTjTotalSize,_tmpTjTransferred,_tmpTjAttemptCount,_tmpTjiSrc,_tmpTjiDest,_tmpTjiType,_tmpTjiStatus,_tmpTjiTableId,_tmpTjiEntityUid,_tmpTjiEntityEtag,_tmpTjiLockIdToRelease,_tmpTjiPartialTmpFile);
            } else {
              _tmpTransferJobItem = null;
            }
            _item = new CourseAssignmentSubmissionFileAndTransferJob(_tmpSubmissionFile,_tmpTransferJobItem);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
