package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.DiscussionPostAndPosterNames;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.DiscussionPost;
import com.ustadmobile.lib.db.entities.DiscussionPostWithDetails;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DiscussionPostDao_Impl extends DiscussionPostDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DiscussionPost> __insertionAdapterOfDiscussionPost;

  private final EntityInsertionAdapter<DiscussionPost> __insertionAdapterOfDiscussionPost_1;

  private final EntityDeletionOrUpdateAdapter<DiscussionPost> __updateAdapterOfDiscussionPost;

  private final SharedSQLiteStatement __preparedStmtOfSetDeletedAsync;

  public DiscussionPostDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDiscussionPost = new EntityInsertionAdapter<DiscussionPost>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `DiscussionPost` (`discussionPostUid`,`discussionPostReplyToPostUid`,`discussionPostTitle`,`discussionPostMessage`,`discussionPostStartDate`,`discussionPostCourseBlockUid`,`dpDeleted`,`discussionPostStartedPersonUid`,`discussionPostClazzUid`,`discussionPostLct`,`discussionPostVisible`,`discussionPostArchive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DiscussionPost entity) {
        statement.bindLong(1, entity.getDiscussionPostUid());
        statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
        if (entity.getDiscussionPostTitle() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDiscussionPostTitle());
        }
        if (entity.getDiscussionPostMessage() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getDiscussionPostMessage());
        }
        statement.bindLong(5, entity.getDiscussionPostStartDate());
        statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
        final int _tmp = entity.getDpDeleted() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
        statement.bindLong(9, entity.getDiscussionPostClazzUid());
        statement.bindLong(10, entity.getDiscussionPostLct());
        final int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
        statement.bindLong(11, _tmp_1);
        final int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
        statement.bindLong(12, _tmp_2);
      }
    };
    this.__insertionAdapterOfDiscussionPost_1 = new EntityInsertionAdapter<DiscussionPost>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `DiscussionPost` (`discussionPostUid`,`discussionPostReplyToPostUid`,`discussionPostTitle`,`discussionPostMessage`,`discussionPostStartDate`,`discussionPostCourseBlockUid`,`dpDeleted`,`discussionPostStartedPersonUid`,`discussionPostClazzUid`,`discussionPostLct`,`discussionPostVisible`,`discussionPostArchive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DiscussionPost entity) {
        statement.bindLong(1, entity.getDiscussionPostUid());
        statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
        if (entity.getDiscussionPostTitle() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDiscussionPostTitle());
        }
        if (entity.getDiscussionPostMessage() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getDiscussionPostMessage());
        }
        statement.bindLong(5, entity.getDiscussionPostStartDate());
        statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
        final int _tmp = entity.getDpDeleted() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
        statement.bindLong(9, entity.getDiscussionPostClazzUid());
        statement.bindLong(10, entity.getDiscussionPostLct());
        final int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
        statement.bindLong(11, _tmp_1);
        final int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
        statement.bindLong(12, _tmp_2);
      }
    };
    this.__updateAdapterOfDiscussionPost = new EntityDeletionOrUpdateAdapter<DiscussionPost>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `DiscussionPost` SET `discussionPostUid` = ?,`discussionPostReplyToPostUid` = ?,`discussionPostTitle` = ?,`discussionPostMessage` = ?,`discussionPostStartDate` = ?,`discussionPostCourseBlockUid` = ?,`dpDeleted` = ?,`discussionPostStartedPersonUid` = ?,`discussionPostClazzUid` = ?,`discussionPostLct` = ?,`discussionPostVisible` = ?,`discussionPostArchive` = ? WHERE `discussionPostUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DiscussionPost entity) {
        statement.bindLong(1, entity.getDiscussionPostUid());
        statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
        if (entity.getDiscussionPostTitle() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDiscussionPostTitle());
        }
        if (entity.getDiscussionPostMessage() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getDiscussionPostMessage());
        }
        statement.bindLong(5, entity.getDiscussionPostStartDate());
        statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
        final int _tmp = entity.getDpDeleted() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
        statement.bindLong(9, entity.getDiscussionPostClazzUid());
        statement.bindLong(10, entity.getDiscussionPostLct());
        final int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
        statement.bindLong(11, _tmp_1);
        final int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
        statement.bindLong(12, _tmp_2);
        statement.bindLong(13, entity.getDiscussionPostUid());
      }
    };
    this.__preparedStmtOfSetDeletedAsync = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE DiscussionPost\n"
                + "           SET dpDeleted = ?,\n"
                + "               discussionPostLct = ?\n"
                + "         WHERE discussionPostUid = ?   \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final DiscussionPost entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfDiscussionPost.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final DiscussionPost entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfDiscussionPost.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends DiscussionPost> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfDiscussionPost.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertAsync(final DiscussionPost entity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfDiscussionPost_1.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final DiscussionPost entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDiscussionPost.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final DiscussionPost entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfDiscussionPost.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object setDeletedAsync(final long uid, final boolean deleted, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetDeletedAsync.acquire();
        int _argIndex = 1;
        final int _tmp = deleted ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfSetDeletedAsync.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, DiscussionPostWithDetails> getTopLevelPostsByCourseBlockUid(
      final long courseBlockUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.*,\n"
            + "               Person.firstNames as authorPersonFirstNames,\n"
            + "               Person.lastName as authorPersonLastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS authorPictureUri,\n"
            + "               MostRecentReply.discussionPostMessage AS postLatestMessage,\n"
            + "               COALESCE(MostRecentReply.discussionPostStartDate, 0) AS postLatestMessageTimestamp,\n"
            + "               (SELECT COUNT(*)\n"
            + "                  FROM DiscussionPost DiscussionPostReplies\n"
            + "                 WHERE DiscussionPostReplies.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n"
            + "                   AND NOT DiscussionPostReplies.dpDeleted\n"
            + "               ) AS postRepliesCount\n"
            + "          FROM DiscussionPost\n"
            + "               LEFT JOIN DiscussionPost AS MostRecentReply\n"
            + "                         ON MostRecentReply.discussionPostUid = \n"
            + "                            (SELECT MostRecentReplyInner.discussionPostUid\n"
            + "                               FROM DiscussionPost AS MostRecentReplyInner\n"
            + "                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n"
            + "                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n"
            + "                              LIMIT 1  \n"
            + "                            )\n"
            + "               LEFT JOIN Person \n"
            + "                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n"
            + "           AND DiscussionPost.discussionPostReplyToPostUid = 0\n"
            + "           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)\n"
            + "      ORDER BY DiscussionPost.discussionPostStartDate DESC          \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseBlockUid);
    _argIndex = 2;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<DiscussionPostWithDetails>(_statement, __db, "DiscussionPost", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<DiscussionPostWithDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostUid");
        final int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostReplyToPostUid");
        final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostTitle");
        final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostMessage");
        final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartDate");
        final int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostCourseBlockUid");
        final int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "dpDeleted");
        final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartedPersonUid");
        final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostClazzUid");
        final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostLct");
        final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostVisible");
        final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostArchive");
        final int _cursorIndexOfAuthorPersonFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "authorPersonFirstNames");
        final int _cursorIndexOfAuthorPersonLastName = CursorUtil.getColumnIndexOrThrow(cursor, "authorPersonLastName");
        final int _cursorIndexOfAuthorPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "authorPictureUri");
        final int _cursorIndexOfPostLatestMessage = CursorUtil.getColumnIndexOrThrow(cursor, "postLatestMessage");
        final int _cursorIndexOfPostLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "postLatestMessageTimestamp");
        final int _cursorIndexOfPostRepliesCount = CursorUtil.getColumnIndexOrThrow(cursor, "postRepliesCount");
        final List<DiscussionPostWithDetails> _result = new ArrayList<DiscussionPostWithDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final DiscussionPostWithDetails _item;
          _item = new DiscussionPostWithDetails();
          final long _tmpDiscussionPostUid;
          _tmpDiscussionPostUid = cursor.getLong(_cursorIndexOfDiscussionPostUid);
          _item.setDiscussionPostUid(_tmpDiscussionPostUid);
          final long _tmpDiscussionPostReplyToPostUid;
          _tmpDiscussionPostReplyToPostUid = cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
          _item.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
          final String _tmpDiscussionPostTitle;
          if (cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
            _tmpDiscussionPostTitle = null;
          } else {
            _tmpDiscussionPostTitle = cursor.getString(_cursorIndexOfDiscussionPostTitle);
          }
          _item.setDiscussionPostTitle(_tmpDiscussionPostTitle);
          final String _tmpDiscussionPostMessage;
          if (cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
            _tmpDiscussionPostMessage = null;
          } else {
            _tmpDiscussionPostMessage = cursor.getString(_cursorIndexOfDiscussionPostMessage);
          }
          _item.setDiscussionPostMessage(_tmpDiscussionPostMessage);
          final long _tmpDiscussionPostStartDate;
          _tmpDiscussionPostStartDate = cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
          _item.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
          final long _tmpDiscussionPostCourseBlockUid;
          _tmpDiscussionPostCourseBlockUid = cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
          _item.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
          final boolean _tmpDpDeleted;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfDpDeleted);
          _tmpDpDeleted = _tmp_1 != 0;
          _item.setDpDeleted(_tmpDpDeleted);
          final long _tmpDiscussionPostStartedPersonUid;
          _tmpDiscussionPostStartedPersonUid = cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
          _item.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
          final long _tmpDiscussionPostClazzUid;
          _tmpDiscussionPostClazzUid = cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
          _item.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
          final long _tmpDiscussionPostLct;
          _tmpDiscussionPostLct = cursor.getLong(_cursorIndexOfDiscussionPostLct);
          _item.setDiscussionPostLct(_tmpDiscussionPostLct);
          final boolean _tmpDiscussionPostVisible;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfDiscussionPostVisible);
          _tmpDiscussionPostVisible = _tmp_2 != 0;
          _item.setDiscussionPostVisible(_tmpDiscussionPostVisible);
          final boolean _tmpDiscussionPostArchive;
          final int _tmp_3;
          _tmp_3 = cursor.getInt(_cursorIndexOfDiscussionPostArchive);
          _tmpDiscussionPostArchive = _tmp_3 != 0;
          _item.setDiscussionPostArchive(_tmpDiscussionPostArchive);
          final String _tmpAuthorPersonFirstNames;
          if (cursor.isNull(_cursorIndexOfAuthorPersonFirstNames)) {
            _tmpAuthorPersonFirstNames = null;
          } else {
            _tmpAuthorPersonFirstNames = cursor.getString(_cursorIndexOfAuthorPersonFirstNames);
          }
          _item.setAuthorPersonFirstNames(_tmpAuthorPersonFirstNames);
          final String _tmpAuthorPersonLastName;
          if (cursor.isNull(_cursorIndexOfAuthorPersonLastName)) {
            _tmpAuthorPersonLastName = null;
          } else {
            _tmpAuthorPersonLastName = cursor.getString(_cursorIndexOfAuthorPersonLastName);
          }
          _item.setAuthorPersonLastName(_tmpAuthorPersonLastName);
          final String _tmpAuthorPictureUri;
          if (cursor.isNull(_cursorIndexOfAuthorPictureUri)) {
            _tmpAuthorPictureUri = null;
          } else {
            _tmpAuthorPictureUri = cursor.getString(_cursorIndexOfAuthorPictureUri);
          }
          _item.setAuthorPictureUri(_tmpAuthorPictureUri);
          final String _tmpPostLatestMessage;
          if (cursor.isNull(_cursorIndexOfPostLatestMessage)) {
            _tmpPostLatestMessage = null;
          } else {
            _tmpPostLatestMessage = cursor.getString(_cursorIndexOfPostLatestMessage);
          }
          _item.setPostLatestMessage(_tmpPostLatestMessage);
          final long _tmpPostLatestMessageTimestamp;
          _tmpPostLatestMessageTimestamp = cursor.getLong(_cursorIndexOfPostLatestMessageTimestamp);
          _item.setPostLatestMessageTimestamp(_tmpPostLatestMessageTimestamp);
          final int _tmpPostRepliesCount;
          _tmpPostRepliesCount = cursor.getInt(_cursorIndexOfPostRepliesCount);
          _item.setPostRepliesCount(_tmpPostRepliesCount);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object getTopLevelPostsByCourseBlockUidPersons(final long courseBlockUid,
      final Continuation<? super List<PersonAndPicture>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN\n"
            + "               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n"
            + "                  FROM DiscussionPost\n"
            + "                 WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n"
            + "                   AND DiscussionPost.discussionPostReplyToPostUid = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseBlockUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndPicture>>() {
      @Override
      @NonNull
      public List<PersonAndPicture> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndPicture _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getTopLevelPostsByCourseBlockUidLatestMessage(final long courseBlockUid,
      final Continuation<? super List<? extends DiscussionPost>> $completion) {
    final String _sql = "\n"
            + "        SELECT MostRecentReply.*\n"
            + "          FROM DiscussionPost\n"
            + "               JOIN DiscussionPost AS MostRecentReply\n"
            + "                         ON MostRecentReply.discussionPostUid = \n"
            + "                            (SELECT MostRecentReplyInner.discussionPostUid\n"
            + "                               FROM DiscussionPost AS MostRecentReplyInner\n"
            + "                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n"
            + "                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n"
            + "                              LIMIT 1  \n"
            + "                            )\n"
            + "         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n"
            + "           AND DiscussionPost.discussionPostReplyToPostUid = 0 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseBlockUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<DiscussionPost>>() {
      @Override
      @NonNull
      public List<DiscussionPost> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostUid");
          final int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostReplyToPostUid");
          final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostTitle");
          final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostMessage");
          final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartDate");
          final int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostCourseBlockUid");
          final int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "dpDeleted");
          final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartedPersonUid");
          final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostClazzUid");
          final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostLct");
          final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostVisible");
          final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostArchive");
          final List<DiscussionPost> _result = new ArrayList<DiscussionPost>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final DiscussionPost _item;
            _item = new DiscussionPost();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _item.setDiscussionPostUid(_tmpDiscussionPostUid);
            final long _tmpDiscussionPostReplyToPostUid;
            _tmpDiscussionPostReplyToPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
            _item.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
            final String _tmpDiscussionPostTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = _cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _item.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = _cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _item.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _item.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostCourseBlockUid;
            _tmpDiscussionPostCourseBlockUid = _cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
            _item.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
            final boolean _tmpDpDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDpDeleted);
            _tmpDpDeleted = _tmp != 0;
            _item.setDpDeleted(_tmpDpDeleted);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _item.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _item.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _item.setDiscussionPostLct(_tmpDiscussionPostLct);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp_1 != 0;
            _item.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_2 != 0;
            _item.setDiscussionPostArchive(_tmpDiscussionPostArchive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getPostTitle(final long postUid, final Continuation<? super String> $completion) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.discussionPostTitle \n"
            + "          FROM DiscussionPost \n"
            + "         WHERE DiscussionPost.discussionPostUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUid(final long uid, final Continuation<? super DiscussionPost> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM DiscussionPost\n"
            + "        WHERE DiscussionPost.discussionPostUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<DiscussionPost>() {
      @Override
      @Nullable
      public DiscussionPost call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostUid");
          final int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostReplyToPostUid");
          final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostTitle");
          final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostMessage");
          final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartDate");
          final int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostCourseBlockUid");
          final int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "dpDeleted");
          final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostStartedPersonUid");
          final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostClazzUid");
          final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostLct");
          final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostVisible");
          final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(_cursor, "discussionPostArchive");
          final DiscussionPost _result;
          if (_cursor.moveToFirst()) {
            _result = new DiscussionPost();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _result.setDiscussionPostUid(_tmpDiscussionPostUid);
            final long _tmpDiscussionPostReplyToPostUid;
            _tmpDiscussionPostReplyToPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
            _result.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
            final String _tmpDiscussionPostTitle;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = _cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _result.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (_cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = _cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _result.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _result.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostCourseBlockUid;
            _tmpDiscussionPostCourseBlockUid = _cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
            _result.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
            final boolean _tmpDpDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDpDeleted);
            _tmpDpDeleted = _tmp != 0;
            _result.setDpDeleted(_tmpDpDeleted);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _result.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _result.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _result.setDiscussionPostLct(_tmpDiscussionPostLct);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp_1 != 0;
            _result.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_2 != 0;
            _result.setDiscussionPostArchive(_tmpDiscussionPostArchive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<String> getTitleByUidAsFlow(final long uid) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.discussionPostTitle\n"
            + "          FROM DiscussionPost\n"
            + "         WHERE DiscussionPost.discussionPostUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"DiscussionPost"}, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, DiscussionPostAndPosterNames> findByPostIdWithAllReplies(
      final long postUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT DiscussionPost.*,\n"
            + "               Person.firstNames,\n"
            + "               Person.lastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS personPictureUri\n"
            + "          FROM DiscussionPost\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n"
            + "         WHERE (DiscussionPost.discussionPostUid = ?\n"
            + "                 OR DiscussionPost.discussionPostReplyToPostUid= ?)\n"
            + "           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)      \n"
            + "            -- Always get the starting post first, followed by replies\n"
            + "      ORDER BY CASE(DiscussionPost.discussionPostReplyToPostUid)\n"
            + "               WHEN 0 THEN 0\n"
            + "               ELSE 1 END ASC,\n"
            + "               DiscussionPost.discussionPostStartDate DESC \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, postUid);
    _argIndex = 3;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<DiscussionPostAndPosterNames>(_statement, __db, "DiscussionPost", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<DiscussionPostAndPosterNames> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostUid");
        final int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostReplyToPostUid");
        final int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostTitle");
        final int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostMessage");
        final int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartDate");
        final int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostCourseBlockUid");
        final int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "dpDeleted");
        final int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostStartedPersonUid");
        final int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostClazzUid");
        final int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostLct");
        final int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostVisible");
        final int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow(cursor, "discussionPostArchive");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final List<DiscussionPostAndPosterNames> _result = new ArrayList<DiscussionPostAndPosterNames>(cursor.getCount());
        while (cursor.moveToNext()) {
          final DiscussionPostAndPosterNames _item;
          final String _tmpFirstNames;
          if (cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpPersonPictureUri;
          if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
            _tmpPersonPictureUri = null;
          } else {
            _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
          }
          final DiscussionPost _tmpDiscussionPost;
          if (!(cursor.isNull(_cursorIndexOfDiscussionPostUid) && cursor.isNull(_cursorIndexOfDiscussionPostReplyToPostUid) && cursor.isNull(_cursorIndexOfDiscussionPostTitle) && cursor.isNull(_cursorIndexOfDiscussionPostMessage) && cursor.isNull(_cursorIndexOfDiscussionPostStartDate) && cursor.isNull(_cursorIndexOfDiscussionPostCourseBlockUid) && cursor.isNull(_cursorIndexOfDpDeleted) && cursor.isNull(_cursorIndexOfDiscussionPostStartedPersonUid) && cursor.isNull(_cursorIndexOfDiscussionPostClazzUid) && cursor.isNull(_cursorIndexOfDiscussionPostLct) && cursor.isNull(_cursorIndexOfDiscussionPostVisible) && cursor.isNull(_cursorIndexOfDiscussionPostArchive))) {
            _tmpDiscussionPost = new DiscussionPost();
            final long _tmpDiscussionPostUid;
            _tmpDiscussionPostUid = cursor.getLong(_cursorIndexOfDiscussionPostUid);
            _tmpDiscussionPost.setDiscussionPostUid(_tmpDiscussionPostUid);
            final long _tmpDiscussionPostReplyToPostUid;
            _tmpDiscussionPostReplyToPostUid = cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
            _tmpDiscussionPost.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
            final String _tmpDiscussionPostTitle;
            if (cursor.isNull(_cursorIndexOfDiscussionPostTitle)) {
              _tmpDiscussionPostTitle = null;
            } else {
              _tmpDiscussionPostTitle = cursor.getString(_cursorIndexOfDiscussionPostTitle);
            }
            _tmpDiscussionPost.setDiscussionPostTitle(_tmpDiscussionPostTitle);
            final String _tmpDiscussionPostMessage;
            if (cursor.isNull(_cursorIndexOfDiscussionPostMessage)) {
              _tmpDiscussionPostMessage = null;
            } else {
              _tmpDiscussionPostMessage = cursor.getString(_cursorIndexOfDiscussionPostMessage);
            }
            _tmpDiscussionPost.setDiscussionPostMessage(_tmpDiscussionPostMessage);
            final long _tmpDiscussionPostStartDate;
            _tmpDiscussionPostStartDate = cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
            _tmpDiscussionPost.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
            final long _tmpDiscussionPostCourseBlockUid;
            _tmpDiscussionPostCourseBlockUid = cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
            _tmpDiscussionPost.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
            final boolean _tmpDpDeleted;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfDpDeleted);
            _tmpDpDeleted = _tmp_1 != 0;
            _tmpDiscussionPost.setDpDeleted(_tmpDpDeleted);
            final long _tmpDiscussionPostStartedPersonUid;
            _tmpDiscussionPostStartedPersonUid = cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
            _tmpDiscussionPost.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
            final long _tmpDiscussionPostClazzUid;
            _tmpDiscussionPostClazzUid = cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
            _tmpDiscussionPost.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
            final long _tmpDiscussionPostLct;
            _tmpDiscussionPostLct = cursor.getLong(_cursorIndexOfDiscussionPostLct);
            _tmpDiscussionPost.setDiscussionPostLct(_tmpDiscussionPostLct);
            final boolean _tmpDiscussionPostVisible;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfDiscussionPostVisible);
            _tmpDiscussionPostVisible = _tmp_2 != 0;
            _tmpDiscussionPost.setDiscussionPostVisible(_tmpDiscussionPostVisible);
            final boolean _tmpDiscussionPostArchive;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfDiscussionPostArchive);
            _tmpDiscussionPostArchive = _tmp_3 != 0;
            _tmpDiscussionPost.setDiscussionPostArchive(_tmpDiscussionPostArchive);
          } else {
            _tmpDiscussionPost = null;
          }
          _item = new DiscussionPostAndPosterNames(_tmpDiscussionPost,_tmpFirstNames,_tmpLastName,_tmpPersonPictureUri);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findByPostIdWithAllRepliesPersons(final long postUid,
      final Continuation<? super List<PersonAndPicture>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN\n"
            + "               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n"
            + "                  FROM DiscussionPost\n"
            + "                 WHERE DiscussionPost.discussionPostUid = ?\n"
            + "                    OR DiscussionPost.discussionPostReplyToPostUid= ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, postUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndPicture>>() {
      @Override
      @NonNull
      public List<PersonAndPicture> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndPicture _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
