package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ErrorReport;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ErrorReportDao_Impl extends ErrorReportDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ErrorReport> __insertionAdapterOfErrorReport;

  public ErrorReportDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfErrorReport = new EntityInsertionAdapter<ErrorReport>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ErrorReport` (`errUid`,`errPcsn`,`errLcsn`,`errLcb`,`errLct`,`severity`,`timestamp`,`presenterUri`,`appVersion`,`versionCode`,`errorCode`,`operatingSys`,`osVersion`,`stackTrace`,`message`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ErrorReport entity) {
        statement.bindLong(1, entity.getErrUid());
        statement.bindLong(2, entity.getErrPcsn());
        statement.bindLong(3, entity.getErrLcsn());
        statement.bindLong(4, entity.getErrLcb());
        statement.bindLong(5, entity.getErrLct());
        statement.bindLong(6, entity.getSeverity());
        statement.bindLong(7, entity.getTimestamp());
        if (entity.getPresenterUri() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPresenterUri());
        }
        if (entity.getAppVersion() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getAppVersion());
        }
        statement.bindLong(10, entity.getVersionCode());
        statement.bindLong(11, entity.getErrorCode());
        if (entity.getOperatingSys() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getOperatingSys());
        }
        if (entity.getOsVersion() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getOsVersion());
        }
        if (entity.getStackTrace() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getStackTrace());
        }
        if (entity.getMessage() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getMessage());
        }
      }
    };
  }

  @Override
  public Object insertAsync(final ErrorReport errorReport,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfErrorReport.insertAndReturnId(errorReport);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long errUid,
      final Continuation<? super ErrorReport> $completion) {
    final String _sql = "\n"
            + "        SELECT ErrorReport.* \n"
            + "          FROM ErrorReport\n"
            + "         WHERE errUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, errUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ErrorReport>() {
      @Override
      @Nullable
      public ErrorReport call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "errUid");
          final int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errPcsn");
          final int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcsn");
          final int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcb");
          final int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow(_cursor, "errLct");
          final int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow(_cursor, "severity");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow(_cursor, "presenterUri");
          final int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "appVersion");
          final int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow(_cursor, "versionCode");
          final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
          final int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow(_cursor, "operatingSys");
          final int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "osVersion");
          final int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow(_cursor, "stackTrace");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final ErrorReport _result;
          if (_cursor.moveToFirst()) {
            _result = new ErrorReport();
            final long _tmpErrUid;
            _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
            _result.setErrUid(_tmpErrUid);
            final long _tmpErrPcsn;
            _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
            _result.setErrPcsn(_tmpErrPcsn);
            final long _tmpErrLcsn;
            _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
            _result.setErrLcsn(_tmpErrLcsn);
            final int _tmpErrLcb;
            _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
            _result.setErrLcb(_tmpErrLcb);
            final long _tmpErrLct;
            _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
            _result.setErrLct(_tmpErrLct);
            final int _tmpSeverity;
            _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
            _result.setSeverity(_tmpSeverity);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _result.setTimestamp(_tmpTimestamp);
            final String _tmpPresenterUri;
            if (_cursor.isNull(_cursorIndexOfPresenterUri)) {
              _tmpPresenterUri = null;
            } else {
              _tmpPresenterUri = _cursor.getString(_cursorIndexOfPresenterUri);
            }
            _result.setPresenterUri(_tmpPresenterUri);
            final String _tmpAppVersion;
            if (_cursor.isNull(_cursorIndexOfAppVersion)) {
              _tmpAppVersion = null;
            } else {
              _tmpAppVersion = _cursor.getString(_cursorIndexOfAppVersion);
            }
            _result.setAppVersion(_tmpAppVersion);
            final int _tmpVersionCode;
            _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
            _result.setVersionCode(_tmpVersionCode);
            final int _tmpErrorCode;
            _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
            _result.setErrorCode(_tmpErrorCode);
            final String _tmpOperatingSys;
            if (_cursor.isNull(_cursorIndexOfOperatingSys)) {
              _tmpOperatingSys = null;
            } else {
              _tmpOperatingSys = _cursor.getString(_cursorIndexOfOperatingSys);
            }
            _result.setOperatingSys(_tmpOperatingSys);
            final String _tmpOsVersion;
            if (_cursor.isNull(_cursorIndexOfOsVersion)) {
              _tmpOsVersion = null;
            } else {
              _tmpOsVersion = _cursor.getString(_cursorIndexOfOsVersion);
            }
            _result.setOsVersion(_tmpOsVersion);
            final String _tmpStackTrace;
            if (_cursor.isNull(_cursorIndexOfStackTrace)) {
              _tmpStackTrace = null;
            } else {
              _tmpStackTrace = _cursor.getString(_cursorIndexOfStackTrace);
            }
            _result.setStackTrace(_tmpStackTrace);
            final String _tmpMessage;
            if (_cursor.isNull(_cursorIndexOfMessage)) {
              _tmpMessage = null;
            } else {
              _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            }
            _result.setMessage(_tmpMessage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByErrorCode(final int errCode,
      final Continuation<? super List<ErrorReport>> $completion) {
    final String _sql = "\n"
            + "        SELECT ErrorReport.*\n"
            + "          FROM ErrorReport\n"
            + "         WHERE errorCode = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, errCode);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ErrorReport>>() {
      @Override
      @NonNull
      public List<ErrorReport> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "errUid");
          final int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errPcsn");
          final int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcsn");
          final int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcb");
          final int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow(_cursor, "errLct");
          final int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow(_cursor, "severity");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow(_cursor, "presenterUri");
          final int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "appVersion");
          final int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow(_cursor, "versionCode");
          final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
          final int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow(_cursor, "operatingSys");
          final int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "osVersion");
          final int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow(_cursor, "stackTrace");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final List<ErrorReport> _result = new ArrayList<ErrorReport>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ErrorReport _item;
            _item = new ErrorReport();
            final long _tmpErrUid;
            _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
            _item.setErrUid(_tmpErrUid);
            final long _tmpErrPcsn;
            _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
            _item.setErrPcsn(_tmpErrPcsn);
            final long _tmpErrLcsn;
            _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
            _item.setErrLcsn(_tmpErrLcsn);
            final int _tmpErrLcb;
            _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
            _item.setErrLcb(_tmpErrLcb);
            final long _tmpErrLct;
            _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
            _item.setErrLct(_tmpErrLct);
            final int _tmpSeverity;
            _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
            _item.setSeverity(_tmpSeverity);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _item.setTimestamp(_tmpTimestamp);
            final String _tmpPresenterUri;
            if (_cursor.isNull(_cursorIndexOfPresenterUri)) {
              _tmpPresenterUri = null;
            } else {
              _tmpPresenterUri = _cursor.getString(_cursorIndexOfPresenterUri);
            }
            _item.setPresenterUri(_tmpPresenterUri);
            final String _tmpAppVersion;
            if (_cursor.isNull(_cursorIndexOfAppVersion)) {
              _tmpAppVersion = null;
            } else {
              _tmpAppVersion = _cursor.getString(_cursorIndexOfAppVersion);
            }
            _item.setAppVersion(_tmpAppVersion);
            final int _tmpVersionCode;
            _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
            _item.setVersionCode(_tmpVersionCode);
            final int _tmpErrorCode;
            _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
            _item.setErrorCode(_tmpErrorCode);
            final String _tmpOperatingSys;
            if (_cursor.isNull(_cursorIndexOfOperatingSys)) {
              _tmpOperatingSys = null;
            } else {
              _tmpOperatingSys = _cursor.getString(_cursorIndexOfOperatingSys);
            }
            _item.setOperatingSys(_tmpOperatingSys);
            final String _tmpOsVersion;
            if (_cursor.isNull(_cursorIndexOfOsVersion)) {
              _tmpOsVersion = null;
            } else {
              _tmpOsVersion = _cursor.getString(_cursorIndexOfOsVersion);
            }
            _item.setOsVersion(_tmpOsVersion);
            final String _tmpStackTrace;
            if (_cursor.isNull(_cursorIndexOfStackTrace)) {
              _tmpStackTrace = null;
            } else {
              _tmpStackTrace = _cursor.getString(_cursorIndexOfStackTrace);
            }
            _item.setStackTrace(_tmpStackTrace);
            final String _tmpMessage;
            if (_cursor.isNull(_cursorIndexOfMessage)) {
              _tmpMessage = null;
            } else {
              _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            }
            _item.setMessage(_tmpMessage);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
