package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonPasskey;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonPasskeyDao_Impl extends PersonPasskeyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonPasskey> __insertionAdapterOfPersonPasskey;

  private final SharedSQLiteStatement __preparedStmtOfRevokePersonPasskey;

  public PersonPasskeyDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonPasskey = new EntityInsertionAdapter<PersonPasskey>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonPasskey` (`personPasskeyUid`,`ppPersonUid`,`ppAttestationObj`,`ppClientDataJson`,`ppOriginString`,`ppId`,`ppChallengeString`,`ppPublicKey`,`isRevoked`,`ppPasskeyLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonPasskey entity) {
        statement.bindLong(1, entity.getPersonPasskeyUid());
        statement.bindLong(2, entity.getPpPersonUid());
        if (entity.getPpAttestationObj() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPpAttestationObj());
        }
        if (entity.getPpClientDataJson() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPpClientDataJson());
        }
        if (entity.getPpOriginString() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getPpOriginString());
        }
        if (entity.getPpId() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPpId());
        }
        if (entity.getPpChallengeString() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getPpChallengeString());
        }
        if (entity.getPpPublicKey() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getPpPublicKey());
        }
        statement.bindLong(9, entity.isRevoked());
        statement.bindLong(10, entity.getPpPasskeyLct());
      }
    };
    this.__preparedStmtOfRevokePersonPasskey = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonPasskey\n"
                + "          set isRevoked = 1\n"
                + "         WHERE PersonPasskey.personPasskeyUid = ? \n"
                + "              ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final PersonPasskey personPasskey,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonPasskey.insertAndReturnId(personPasskey);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object revokePersonPasskey(final long uid, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfRevokePersonPasskey.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfRevokePersonPasskey.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object allPasskey(final Continuation<? super List<String>> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonPasskey.ppId\n"
            + "          FROM PersonPasskey\n"
            + "              ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<String>>() {
      @Override
      @NonNull
      public List<String> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<String> _result = new ArrayList<String>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final String _item;
            _item = _cursor.getString(0);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<PersonPasskey>> getAllActivePasskeys(final long uid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM PersonPasskey\n"
            + "         WHERE isRevoked = 0\n"
            + "         AND PersonPasskey.ppPersonUid = ?\n"
            + "              ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PersonPasskey"}, new Callable<List<PersonPasskey>>() {
      @Override
      @NonNull
      public List<PersonPasskey> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPasskeyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPasskeyUid");
          final int _cursorIndexOfPpPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPersonUid");
          final int _cursorIndexOfPpAttestationObj = CursorUtil.getColumnIndexOrThrow(_cursor, "ppAttestationObj");
          final int _cursorIndexOfPpClientDataJson = CursorUtil.getColumnIndexOrThrow(_cursor, "ppClientDataJson");
          final int _cursorIndexOfPpOriginString = CursorUtil.getColumnIndexOrThrow(_cursor, "ppOriginString");
          final int _cursorIndexOfPpId = CursorUtil.getColumnIndexOrThrow(_cursor, "ppId");
          final int _cursorIndexOfPpChallengeString = CursorUtil.getColumnIndexOrThrow(_cursor, "ppChallengeString");
          final int _cursorIndexOfPpPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPublicKey");
          final int _cursorIndexOfIsRevoked = CursorUtil.getColumnIndexOrThrow(_cursor, "isRevoked");
          final int _cursorIndexOfPpPasskeyLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPasskeyLct");
          final List<PersonPasskey> _result = new ArrayList<PersonPasskey>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonPasskey _item;
            final long _tmpPersonPasskeyUid;
            _tmpPersonPasskeyUid = _cursor.getLong(_cursorIndexOfPersonPasskeyUid);
            final long _tmpPpPersonUid;
            _tmpPpPersonUid = _cursor.getLong(_cursorIndexOfPpPersonUid);
            final String _tmpPpAttestationObj;
            if (_cursor.isNull(_cursorIndexOfPpAttestationObj)) {
              _tmpPpAttestationObj = null;
            } else {
              _tmpPpAttestationObj = _cursor.getString(_cursorIndexOfPpAttestationObj);
            }
            final String _tmpPpClientDataJson;
            if (_cursor.isNull(_cursorIndexOfPpClientDataJson)) {
              _tmpPpClientDataJson = null;
            } else {
              _tmpPpClientDataJson = _cursor.getString(_cursorIndexOfPpClientDataJson);
            }
            final String _tmpPpOriginString;
            if (_cursor.isNull(_cursorIndexOfPpOriginString)) {
              _tmpPpOriginString = null;
            } else {
              _tmpPpOriginString = _cursor.getString(_cursorIndexOfPpOriginString);
            }
            final String _tmpPpId;
            if (_cursor.isNull(_cursorIndexOfPpId)) {
              _tmpPpId = null;
            } else {
              _tmpPpId = _cursor.getString(_cursorIndexOfPpId);
            }
            final String _tmpPpChallengeString;
            if (_cursor.isNull(_cursorIndexOfPpChallengeString)) {
              _tmpPpChallengeString = null;
            } else {
              _tmpPpChallengeString = _cursor.getString(_cursorIndexOfPpChallengeString);
            }
            final String _tmpPpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPpPublicKey)) {
              _tmpPpPublicKey = null;
            } else {
              _tmpPpPublicKey = _cursor.getString(_cursorIndexOfPpPublicKey);
            }
            final int _tmpIsRevoked;
            _tmpIsRevoked = _cursor.getInt(_cursorIndexOfIsRevoked);
            final long _tmpPpPasskeyLct;
            _tmpPpPasskeyLct = _cursor.getLong(_cursorIndexOfPpPasskeyLct);
            _item = new PersonPasskey(_tmpPersonPasskeyUid,_tmpPpPersonUid,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpId,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpPasskeyLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, PersonPasskey> getAllActivePasskeysPaging(final long uid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM PersonPasskey\n"
            + "         WHERE isRevoked = 0\n"
            + "          AND PersonPasskey.ppPersonUid = ?\n"
            + "              ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return new LimitOffsetPagingSource<PersonPasskey>(_statement, __db, "PersonPasskey") {
      @Override
      @NonNull
      protected List<PersonPasskey> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonPasskeyUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPasskeyUid");
        final int _cursorIndexOfPpPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "ppPersonUid");
        final int _cursorIndexOfPpAttestationObj = CursorUtil.getColumnIndexOrThrow(cursor, "ppAttestationObj");
        final int _cursorIndexOfPpClientDataJson = CursorUtil.getColumnIndexOrThrow(cursor, "ppClientDataJson");
        final int _cursorIndexOfPpOriginString = CursorUtil.getColumnIndexOrThrow(cursor, "ppOriginString");
        final int _cursorIndexOfPpId = CursorUtil.getColumnIndexOrThrow(cursor, "ppId");
        final int _cursorIndexOfPpChallengeString = CursorUtil.getColumnIndexOrThrow(cursor, "ppChallengeString");
        final int _cursorIndexOfPpPublicKey = CursorUtil.getColumnIndexOrThrow(cursor, "ppPublicKey");
        final int _cursorIndexOfIsRevoked = CursorUtil.getColumnIndexOrThrow(cursor, "isRevoked");
        final int _cursorIndexOfPpPasskeyLct = CursorUtil.getColumnIndexOrThrow(cursor, "ppPasskeyLct");
        final List<PersonPasskey> _result = new ArrayList<PersonPasskey>(cursor.getCount());
        while (cursor.moveToNext()) {
          final PersonPasskey _item;
          final long _tmpPersonPasskeyUid;
          _tmpPersonPasskeyUid = cursor.getLong(_cursorIndexOfPersonPasskeyUid);
          final long _tmpPpPersonUid;
          _tmpPpPersonUid = cursor.getLong(_cursorIndexOfPpPersonUid);
          final String _tmpPpAttestationObj;
          if (cursor.isNull(_cursorIndexOfPpAttestationObj)) {
            _tmpPpAttestationObj = null;
          } else {
            _tmpPpAttestationObj = cursor.getString(_cursorIndexOfPpAttestationObj);
          }
          final String _tmpPpClientDataJson;
          if (cursor.isNull(_cursorIndexOfPpClientDataJson)) {
            _tmpPpClientDataJson = null;
          } else {
            _tmpPpClientDataJson = cursor.getString(_cursorIndexOfPpClientDataJson);
          }
          final String _tmpPpOriginString;
          if (cursor.isNull(_cursorIndexOfPpOriginString)) {
            _tmpPpOriginString = null;
          } else {
            _tmpPpOriginString = cursor.getString(_cursorIndexOfPpOriginString);
          }
          final String _tmpPpId;
          if (cursor.isNull(_cursorIndexOfPpId)) {
            _tmpPpId = null;
          } else {
            _tmpPpId = cursor.getString(_cursorIndexOfPpId);
          }
          final String _tmpPpChallengeString;
          if (cursor.isNull(_cursorIndexOfPpChallengeString)) {
            _tmpPpChallengeString = null;
          } else {
            _tmpPpChallengeString = cursor.getString(_cursorIndexOfPpChallengeString);
          }
          final String _tmpPpPublicKey;
          if (cursor.isNull(_cursorIndexOfPpPublicKey)) {
            _tmpPpPublicKey = null;
          } else {
            _tmpPpPublicKey = cursor.getString(_cursorIndexOfPpPublicKey);
          }
          final int _tmpIsRevoked;
          _tmpIsRevoked = cursor.getInt(_cursorIndexOfIsRevoked);
          final long _tmpPpPasskeyLct;
          _tmpPpPasskeyLct = cursor.getLong(_cursorIndexOfPpPasskeyLct);
          _item = new PersonPasskey(_tmpPersonPasskeyUid,_tmpPpPersonUid,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpId,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpPasskeyLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findPersonPasskeyFromClientDataJson(final String id,
      final Continuation<? super PersonPasskey> $completion) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM PersonPasskey\n"
            + "         WHERE PersonPasskey.ppId = ? \n"
            + "              ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, id);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonPasskey>() {
      @Override
      @Nullable
      public PersonPasskey call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPasskeyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPasskeyUid");
          final int _cursorIndexOfPpPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPersonUid");
          final int _cursorIndexOfPpAttestationObj = CursorUtil.getColumnIndexOrThrow(_cursor, "ppAttestationObj");
          final int _cursorIndexOfPpClientDataJson = CursorUtil.getColumnIndexOrThrow(_cursor, "ppClientDataJson");
          final int _cursorIndexOfPpOriginString = CursorUtil.getColumnIndexOrThrow(_cursor, "ppOriginString");
          final int _cursorIndexOfPpId = CursorUtil.getColumnIndexOrThrow(_cursor, "ppId");
          final int _cursorIndexOfPpChallengeString = CursorUtil.getColumnIndexOrThrow(_cursor, "ppChallengeString");
          final int _cursorIndexOfPpPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPublicKey");
          final int _cursorIndexOfIsRevoked = CursorUtil.getColumnIndexOrThrow(_cursor, "isRevoked");
          final int _cursorIndexOfPpPasskeyLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppPasskeyLct");
          final PersonPasskey _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonPasskeyUid;
            _tmpPersonPasskeyUid = _cursor.getLong(_cursorIndexOfPersonPasskeyUid);
            final long _tmpPpPersonUid;
            _tmpPpPersonUid = _cursor.getLong(_cursorIndexOfPpPersonUid);
            final String _tmpPpAttestationObj;
            if (_cursor.isNull(_cursorIndexOfPpAttestationObj)) {
              _tmpPpAttestationObj = null;
            } else {
              _tmpPpAttestationObj = _cursor.getString(_cursorIndexOfPpAttestationObj);
            }
            final String _tmpPpClientDataJson;
            if (_cursor.isNull(_cursorIndexOfPpClientDataJson)) {
              _tmpPpClientDataJson = null;
            } else {
              _tmpPpClientDataJson = _cursor.getString(_cursorIndexOfPpClientDataJson);
            }
            final String _tmpPpOriginString;
            if (_cursor.isNull(_cursorIndexOfPpOriginString)) {
              _tmpPpOriginString = null;
            } else {
              _tmpPpOriginString = _cursor.getString(_cursorIndexOfPpOriginString);
            }
            final String _tmpPpId;
            if (_cursor.isNull(_cursorIndexOfPpId)) {
              _tmpPpId = null;
            } else {
              _tmpPpId = _cursor.getString(_cursorIndexOfPpId);
            }
            final String _tmpPpChallengeString;
            if (_cursor.isNull(_cursorIndexOfPpChallengeString)) {
              _tmpPpChallengeString = null;
            } else {
              _tmpPpChallengeString = _cursor.getString(_cursorIndexOfPpChallengeString);
            }
            final String _tmpPpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPpPublicKey)) {
              _tmpPpPublicKey = null;
            } else {
              _tmpPpPublicKey = _cursor.getString(_cursorIndexOfPpPublicKey);
            }
            final int _tmpIsRevoked;
            _tmpIsRevoked = _cursor.getInt(_cursorIndexOfIsRevoked);
            final long _tmpPpPasskeyLct;
            _tmpPpPasskeyLct = _cursor.getLong(_cursorIndexOfPpPasskeyLct);
            _result = new PersonPasskey(_tmpPersonPasskeyUid,_tmpPpPersonUid,_tmpPpAttestationObj,_tmpPpClientDataJson,_tmpPpOriginString,_tmpPpId,_tmpPpChallengeString,_tmpPpPublicKey,_tmpIsRevoked,_tmpPpPasskeyLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
