package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.TransferJobAndTotals;
import com.ustadmobile.lib.db.entities.TransferJob;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class TransferJobDao_Impl extends TransferJobDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TransferJob> __insertionAdapterOfTransferJob;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatusIfComplete;

  public TransferJobDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTransferJob = new EntityInsertionAdapter<TransferJob>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `TransferJob` (`tjUid`,`tjType`,`tjStatus`,`tjName`,`tjUuid`,`tjTableId`,`tjEntityUid`,`tjTimeCreated`,`tjCreationType`,`tjOiUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final TransferJob entity) {
        statement.bindLong(1, entity.getTjUid());
        statement.bindLong(2, entity.getTjType());
        statement.bindLong(3, entity.getTjStatus());
        if (entity.getTjName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getTjName());
        }
        if (entity.getTjUuid() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getTjUuid());
        }
        statement.bindLong(6, entity.getTjTableId());
        statement.bindLong(7, entity.getTjEntityUid());
        statement.bindLong(8, entity.getTjTimeCreated());
        statement.bindLong(9, entity.getTjCreationType());
        statement.bindLong(10, entity.getTjOiUid());
      }
    };
    this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJob\n"
                + "           SET tjStatus = ?\n"
                + "         WHERE tjUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatusIfComplete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJob\n"
                + "           SET tjStatus = 21\n"
                + "         WHERE tjUid = ?\n"
                + "          AND NOT EXISTS(\n"
                + "              SELECT TransferJobItem.tjiUid\n"
                + "                FROM TransferJobItem\n"
                + "               WHERE TransferJobItem.tjiTjUid = ?\n"
                + "                 AND TransferJobItem.tjiStatus != 21) \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final TransferJob job, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfTransferJob.insertAndReturnId(job);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateStatus(final int jobUid, final int status,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateStatusIfComplete(final int jobUid,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatusIfComplete.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, jobUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobUid);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateStatusIfComplete.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUid(final int jobUid, final Continuation<? super TransferJob> $completion) {
    final String _sql = "\n"
            + "        SELECT TransferJob.*\n"
            + "          FROM TransferJob\n"
            + "         WHERE TransferJob.tjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<TransferJob>() {
      @Override
      @Nullable
      public TransferJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUid");
          final int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjType");
          final int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjStatus");
          final int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow(_cursor, "tjName");
          final int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUuid");
          final int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTableId");
          final int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjEntityUid");
          final int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTimeCreated");
          final int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjCreationType");
          final int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjOiUid");
          final TransferJob _result;
          if (_cursor.moveToFirst()) {
            final int _tmpTjUid;
            _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
            final int _tmpTjType;
            _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
            final int _tmpTjStatus;
            _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
            final String _tmpTjName;
            if (_cursor.isNull(_cursorIndexOfTjName)) {
              _tmpTjName = null;
            } else {
              _tmpTjName = _cursor.getString(_cursorIndexOfTjName);
            }
            final String _tmpTjUuid;
            if (_cursor.isNull(_cursorIndexOfTjUuid)) {
              _tmpTjUuid = null;
            } else {
              _tmpTjUuid = _cursor.getString(_cursorIndexOfTjUuid);
            }
            final int _tmpTjTableId;
            _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
            final long _tmpTjEntityUid;
            _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
            final long _tmpTjTimeCreated;
            _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
            final int _tmpTjCreationType;
            _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
            final long _tmpTjOiUid;
            _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
            _result = new TransferJob(_tmpTjUid,_tmpTjType,_tmpTjStatus,_tmpTjName,_tmpTjUuid,_tmpTjTableId,_tmpTjEntityUid,_tmpTjTimeCreated,_tmpTjCreationType,_tmpTjOiUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<TransferJob> findByUidAsFlow(final int jobUid) {
    final String _sql = "\n"
            + "        SELECT TransferJob.*\n"
            + "          FROM TransferJob\n"
            + "         WHERE TransferJob.tjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"TransferJob"}, new Callable<TransferJob>() {
      @Override
      @Nullable
      public TransferJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUid");
          final int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjType");
          final int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjStatus");
          final int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow(_cursor, "tjName");
          final int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUuid");
          final int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTableId");
          final int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjEntityUid");
          final int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTimeCreated");
          final int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjCreationType");
          final int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjOiUid");
          final TransferJob _result;
          if (_cursor.moveToFirst()) {
            final int _tmpTjUid;
            _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
            final int _tmpTjType;
            _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
            final int _tmpTjStatus;
            _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
            final String _tmpTjName;
            if (_cursor.isNull(_cursorIndexOfTjName)) {
              _tmpTjName = null;
            } else {
              _tmpTjName = _cursor.getString(_cursorIndexOfTjName);
            }
            final String _tmpTjUuid;
            if (_cursor.isNull(_cursorIndexOfTjUuid)) {
              _tmpTjUuid = null;
            } else {
              _tmpTjUuid = _cursor.getString(_cursorIndexOfTjUuid);
            }
            final int _tmpTjTableId;
            _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
            final long _tmpTjEntityUid;
            _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
            final long _tmpTjTimeCreated;
            _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
            final int _tmpTjCreationType;
            _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
            final long _tmpTjOiUid;
            _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
            _result = new TransferJob(_tmpTjUid,_tmpTjType,_tmpTjStatus,_tmpTjName,_tmpTjUuid,_tmpTjTableId,_tmpTjEntityUid,_tmpTjTimeCreated,_tmpTjCreationType,_tmpTjOiUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getJobStatus(final int jobUid, final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "            (SELECT TransferJob.tjStatus\n"
            + "               FROM TransferJob\n"
            + "              WHERE tjUid = ?), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findJobByEntityAndTableUid(final int tableId, final long entityUid,
      final Continuation<? super List<TransferJob>> $completion) {
    final String _sql = "\n"
            + "        SELECT TransferJob.*\n"
            + "          FROM TransferJob\n"
            + "         WHERE EXISTS(\n"
            + "               SELECT TransferJobItem.tjiUid\n"
            + "                 FROM TransferJobItem\n"
            + "                WHERE TransferJobItem.tjiTjUid = TransferJob.tjUid\n"
            + "                  AND TransferJobItem.tjiTableId = ?\n"
            + "                  AND TransferJobItem.tjiEntityUid = ?) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<TransferJob>>() {
      @Override
      @NonNull
      public List<TransferJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUid");
          final int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjType");
          final int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjStatus");
          final int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow(_cursor, "tjName");
          final int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUuid");
          final int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTableId");
          final int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjEntityUid");
          final int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTimeCreated");
          final int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjCreationType");
          final int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjOiUid");
          final List<TransferJob> _result = new ArrayList<TransferJob>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJob _item;
            final int _tmpTjUid;
            _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
            final int _tmpTjType;
            _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
            final int _tmpTjStatus;
            _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
            final String _tmpTjName;
            if (_cursor.isNull(_cursorIndexOfTjName)) {
              _tmpTjName = null;
            } else {
              _tmpTjName = _cursor.getString(_cursorIndexOfTjName);
            }
            final String _tmpTjUuid;
            if (_cursor.isNull(_cursorIndexOfTjUuid)) {
              _tmpTjUuid = null;
            } else {
              _tmpTjUuid = _cursor.getString(_cursorIndexOfTjUuid);
            }
            final int _tmpTjTableId;
            _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
            final long _tmpTjEntityUid;
            _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
            final long _tmpTjTimeCreated;
            _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
            final int _tmpTjCreationType;
            _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
            final long _tmpTjOiUid;
            _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
            _item = new TransferJob(_tmpTjUid,_tmpTjType,_tmpTjStatus,_tmpTjName,_tmpTjUuid,_tmpTjTableId,_tmpTjEntityUid,_tmpTjTimeCreated,_tmpTjCreationType,_tmpTjOiUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<TransferJobAndTotals>> findByContentEntryUidWithTotalsAsFlow(
      final long contentEntryUid, final int jobType) {
    final String _sql = "\n"
            + "        SELECT TransferJob.*,\n"
            + "               \n"
            + "        (SELECT SUM(TransferJobItem.tjTotalSize)\n"
            + "                   FROM TransferJobItem\n"
            + "                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n"
            + "                (SELECT SUM(TransferJobItem.tjTransferred)\n"
            + "                   FROM TransferJobItem\n"
            + "                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n"
            + "    ,\n"
            + "               TransferJobError.tjeErrorStr AS latestErrorStr\n"
            + "          FROM TransferJob\n"
            + "               LEFT JOIN TransferJobError\n"
            + "                         ON TransferJobError.tjeId = \n"
            + "                            (SELECT TransferJobError.tjeId\n"
            + "                               FROM TransferJobError\n"
            + "                              WHERE TransferJob.tjStatus = 22\n"
            + "                                AND TransferJobError.tjeTjUid = TransferJob.tjUid\n"
            + "                           ORDER BY TransferJobError.tjeDismissed DESC \n"
            + "                              LIMIT 1)\n"
            + "         WHERE TransferJob.tjTableId = 738\n"
            + "           AND TransferJob.tjEntityUid IN \n"
            + "               \n"
            + "        (SELECT ContentEntryVersion.cevUid\n"
            + "                         FROM ContentEntryVersion\n"
            + "                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n"
            + "     \n"
            + "           AND (   TransferJob.tjStatus < 21\n"
            + "                OR (TransferJobError.tjeErrorStr IS NOT NULL AND NOT TransferJobError.tjeDismissed))\n"
            + "           AND TransferJob.tjType = ?   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, jobType);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"TransferJobItem", "TransferJob",
        "TransferJobError", "ContentEntryVersion"}, new Callable<List<TransferJobAndTotals>>() {
      @Override
      @NonNull
      public List<TransferJobAndTotals> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUid");
          final int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjType");
          final int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjStatus");
          final int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow(_cursor, "tjName");
          final int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUuid");
          final int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTableId");
          final int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjEntityUid");
          final int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTimeCreated");
          final int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjCreationType");
          final int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjOiUid");
          final int _cursorIndexOfTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "totalSize");
          final int _cursorIndexOfTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "transferred");
          final int _cursorIndexOfLatestErrorStr = CursorUtil.getColumnIndexOrThrow(_cursor, "latestErrorStr");
          final List<TransferJobAndTotals> _result = new ArrayList<TransferJobAndTotals>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final TransferJobAndTotals _item;
            final long _tmpTotalSize;
            _tmpTotalSize = _cursor.getLong(_cursorIndexOfTotalSize);
            final long _tmpTransferred;
            _tmpTransferred = _cursor.getLong(_cursorIndexOfTransferred);
            final String _tmpLatestErrorStr;
            if (_cursor.isNull(_cursorIndexOfLatestErrorStr)) {
              _tmpLatestErrorStr = null;
            } else {
              _tmpLatestErrorStr = _cursor.getString(_cursorIndexOfLatestErrorStr);
            }
            final TransferJob _tmpTransferJob;
            if (!(_cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
              final int _tmpTjUid;
              _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
              final int _tmpTjType;
              _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
              final int _tmpTjStatus;
              _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
              final String _tmpTjName;
              if (_cursor.isNull(_cursorIndexOfTjName)) {
                _tmpTjName = null;
              } else {
                _tmpTjName = _cursor.getString(_cursorIndexOfTjName);
              }
              final String _tmpTjUuid;
              if (_cursor.isNull(_cursorIndexOfTjUuid)) {
                _tmpTjUuid = null;
              } else {
                _tmpTjUuid = _cursor.getString(_cursorIndexOfTjUuid);
              }
              final int _tmpTjTableId;
              _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
              final long _tmpTjEntityUid;
              _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
              final long _tmpTjTimeCreated;
              _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
              final int _tmpTjCreationType;
              _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
              final long _tmpTjOiUid;
              _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
              _tmpTransferJob = new TransferJob(_tmpTjUid,_tmpTjType,_tmpTjStatus,_tmpTjName,_tmpTjUuid,_tmpTjTableId,_tmpTjEntityUid,_tmpTjTimeCreated,_tmpTjCreationType,_tmpTjOiUid);
            } else {
              _tmpTransferJob = null;
            }
            _item = new TransferJobAndTotals(_tmpTransferJob,_tmpTotalSize,_tmpTransferred,_tmpLatestErrorStr);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findOfflineItemUidForTransferJobUid(final int jobUid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT TransferJob.tjOiUid\n"
            + "                  FROM TransferJob\n"
            + "                 WHERE TransferJob.tjUid = ?), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
