package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.ActivityEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ActivityEntityDao_Impl extends ActivityEntityDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ActivityEntity> __insertionAdapterOfActivityEntity;

  private final SharedSQLiteStatement __preparedStmtOfUpdateIfMoreInfoChanged;

  private final SharedSQLiteStatement __preparedStmtOfUpdateIfNotYetDefined;

  public ActivityEntityDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfActivityEntity = new EntityInsertionAdapter<ActivityEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ActivityEntity` (`actUid`,`actIdIri`,`actType`,`actMoreInfo`,`actInteractionType`,`actCorrectResponsePatterns`,`actLct`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActivityEntity entity) {
        statement.bindLong(1, entity.getActUid());
        if (entity.getActIdIri() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getActIdIri());
        }
        if (entity.getActType() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getActType());
        }
        if (entity.getActMoreInfo() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getActMoreInfo());
        }
        statement.bindLong(5, entity.getActInteractionType());
        if (entity.getActCorrectResponsePatterns() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getActCorrectResponsePatterns());
        }
        statement.bindLong(7, entity.getActLct());
      }
    };
    this.__preparedStmtOfUpdateIfMoreInfoChanged = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ActivityEntity\n"
                + "           SET actMoreInfo = ?,\n"
                + "               actLct = ?\n"
                + "        WHERE actUid = ?\n"
                + "          AND actMoreInfo != ?      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateIfNotYetDefined = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ActivityEntity\n"
                + "           SET actType = ?,\n"
                + "               actMoreInfo = ?,\n"
                + "               actInteractionType = ?,\n"
                + "               actCorrectResponsePatterns = ?,\n"
                + "               actLct = ?\n"
                + "         WHERE actUid = ?\n"
                + "           AND (SELECT ActivityEntityInternal.actType \n"
                + "                  FROM ActivityEntity ActivityEntityInternal \n"
                + "                 WHERE ActivityEntityInternal.actUid = ?) IS NULL\n"
                + "           AND (SELECT ActivityEntityInternal.actInteractionType \n"
                + "                  FROM ActivityEntity ActivityEntityInternal \n"
                + "                 WHERE ActivityEntityInternal.actUid = ?) = 0\n"
                + "           AND (SELECT ActivityEntityInternal.actCorrectResponsePatterns \n"
                + "                  FROM ActivityEntity ActivityEntityInternal \n"
                + "                 WHERE ActivityEntityInternal.actUid = ?) IS NULL      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnoreAsync(final List<ActivityEntity> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActivityEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateIfMoreInfoChanged(final long activityUid, final String actMoreInfo,
      final long actLct, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateIfMoreInfoChanged.acquire();
        int _argIndex = 1;
        if (actMoreInfo == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, actMoreInfo);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, actLct);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, activityUid);
        _argIndex = 4;
        if (actMoreInfo == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, actMoreInfo);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateIfMoreInfoChanged.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateIfNotYetDefined(final long actUid, final String actType,
      final String actMoreInfo, final int actInteractionType,
      final String actCorrectResponsePatterns, final long actLct,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateIfNotYetDefined.acquire();
        int _argIndex = 1;
        if (actType == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, actType);
        }
        _argIndex = 2;
        if (actMoreInfo == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, actMoreInfo);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, actInteractionType);
        _argIndex = 4;
        if (actCorrectResponsePatterns == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, actCorrectResponsePatterns);
        }
        _argIndex = 5;
        _stmt.bindLong(_argIndex, actLct);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, actUid);
        _argIndex = 7;
        _stmt.bindLong(_argIndex, actUid);
        _argIndex = 8;
        _stmt.bindLong(_argIndex, actUid);
        _argIndex = 9;
        _stmt.bindLong(_argIndex, actUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateIfNotYetDefined.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long activityUid,
      final Continuation<? super ActivityEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT ActivityEntity.*\n"
            + "          FROM ActivityEntity\n"
            + "         WHERE ActivityEntity.actUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ActivityEntity>() {
      @Override
      @Nullable
      public ActivityEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actUid");
          final int _cursorIndexOfActIdIri = CursorUtil.getColumnIndexOrThrow(_cursor, "actIdIri");
          final int _cursorIndexOfActType = CursorUtil.getColumnIndexOrThrow(_cursor, "actType");
          final int _cursorIndexOfActMoreInfo = CursorUtil.getColumnIndexOrThrow(_cursor, "actMoreInfo");
          final int _cursorIndexOfActInteractionType = CursorUtil.getColumnIndexOrThrow(_cursor, "actInteractionType");
          final int _cursorIndexOfActCorrectResponsePatterns = CursorUtil.getColumnIndexOrThrow(_cursor, "actCorrectResponsePatterns");
          final int _cursorIndexOfActLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actLct");
          final ActivityEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpActUid;
            _tmpActUid = _cursor.getLong(_cursorIndexOfActUid);
            final String _tmpActIdIri;
            if (_cursor.isNull(_cursorIndexOfActIdIri)) {
              _tmpActIdIri = null;
            } else {
              _tmpActIdIri = _cursor.getString(_cursorIndexOfActIdIri);
            }
            final String _tmpActType;
            if (_cursor.isNull(_cursorIndexOfActType)) {
              _tmpActType = null;
            } else {
              _tmpActType = _cursor.getString(_cursorIndexOfActType);
            }
            final String _tmpActMoreInfo;
            if (_cursor.isNull(_cursorIndexOfActMoreInfo)) {
              _tmpActMoreInfo = null;
            } else {
              _tmpActMoreInfo = _cursor.getString(_cursorIndexOfActMoreInfo);
            }
            final int _tmpActInteractionType;
            _tmpActInteractionType = _cursor.getInt(_cursorIndexOfActInteractionType);
            final String _tmpActCorrectResponsePatterns;
            if (_cursor.isNull(_cursorIndexOfActCorrectResponsePatterns)) {
              _tmpActCorrectResponsePatterns = null;
            } else {
              _tmpActCorrectResponsePatterns = _cursor.getString(_cursorIndexOfActCorrectResponsePatterns);
            }
            final long _tmpActLct;
            _tmpActLct = _cursor.getLong(_cursorIndexOfActLct);
            _result = new ActivityEntity(_tmpActUid,_tmpActIdIri,_tmpActType,_tmpActMoreInfo,_tmpActInteractionType,_tmpActCorrectResponsePatterns,_tmpActLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
