/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.AnimatedMouseWheelScrollNode;
import androidx.compose.foundation.gestures.MouseWheelScrollNode;
import androidx.compose.foundation.gestures.RawMouseWheelScrollNode;
import androidx.compose.foundation.gestures.ScrollConfig;
import androidx.compose.foundation.gestures.ScrollingLogic;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0013\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\f\u0010\u001d\u001a\u00020\u001b*\u00020\u001eH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/gestures/MouseWheelScrollableElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/foundation/gestures/MouseWheelScrollNode;", "scrollingLogic", "Landroidx/compose/foundation/gestures/ScrollingLogic;", "mouseWheelScrollConfig", "Landroidx/compose/foundation/gestures/ScrollConfig;", "density", "", "enabled", "", "(Landroidx/compose/foundation/gestures/ScrollingLogic;Landroidx/compose/foundation/gestures/ScrollConfig;FZ)V", "getDensity", "()F", "getEnabled", "()Z", "getMouseWheelScrollConfig", "()Landroidx/compose/foundation/gestures/ScrollConfig;", "getScrollingLogic", "()Landroidx/compose/foundation/gestures/ScrollingLogic;", "create", "equals", "other", "", "hashCode", "", "update", "", "node", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "foundation"})
public final class MouseWheelScrollableElement
extends ModifierNodeElement<MouseWheelScrollNode> {
    @NotNull
    private final ScrollingLogic scrollingLogic;
    @NotNull
    private final ScrollConfig mouseWheelScrollConfig;
    private final float density;
    private final boolean enabled;

    public MouseWheelScrollableElement(@NotNull ScrollingLogic scrollingLogic, @NotNull ScrollConfig mouseWheelScrollConfig, float density, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)scrollingLogic, (String)"scrollingLogic");
        Intrinsics.checkNotNullParameter((Object)mouseWheelScrollConfig, (String)"mouseWheelScrollConfig");
        this.scrollingLogic = scrollingLogic;
        this.mouseWheelScrollConfig = mouseWheelScrollConfig;
        this.density = density;
        this.enabled = enabled;
    }

    @NotNull
    public final ScrollingLogic getScrollingLogic() {
        return this.scrollingLogic;
    }

    @NotNull
    public final ScrollConfig getMouseWheelScrollConfig() {
        return this.mouseWheelScrollConfig;
    }

    public final float getDensity() {
        return this.density;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public MouseWheelScrollNode create() {
        return this.mouseWheelScrollConfig.isSmoothScrollingEnabled() ? (MouseWheelScrollNode)new AnimatedMouseWheelScrollNode(this.scrollingLogic, this.mouseWheelScrollConfig, this.density, this.enabled) : (MouseWheelScrollNode)new RawMouseWheelScrollNode(this.scrollingLogic, this.mouseWheelScrollConfig, this.enabled);
    }

    public void update(@NotNull MouseWheelScrollNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        node.setScrollingLogic(this.scrollingLogic);
        node.setMouseWheelScrollConfig(this.mouseWheelScrollConfig);
        node.setEnabled(this.enabled);
    }

    public int hashCode() {
        int result2 = this.scrollingLogic.hashCode();
        result2 = 31 * result2 + this.mouseWheelScrollConfig.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.enabled);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MouseWheelScrollableElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scrollingLogic, (Object)((MouseWheelScrollableElement)((Object)other)).scrollingLogic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mouseWheelScrollConfig, (Object)((MouseWheelScrollableElement)((Object)other)).mouseWheelScrollConfig)) {
            return false;
        }
        return this.enabled == ((MouseWheelScrollableElement)((Object)other)).enabled;
    }

    public void inspectableProperties(@NotNull InspectorInfo $this$inspectableProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
    }
}

