/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.lang.BooleanUtils;
import org.osjava.sj.ContextFactory;
import org.osjava.sj.SimpleJndi;
import org.osjava.sj.jndi.DelimiterConvertingContext;

public class SimpleJndiContextFactory
extends ContextFactory
implements InitialContextFactory {
    private static final ConcurrentHashMap<String, DelimiterConvertingContext> contextsByRoot = new ConcurrentHashMap();

    static void clearCache() {
        contextsByRoot.clear();
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        SimpleJndiContextFactory.overwriteEnvironmentWithSystemProperties(environment);
        SimpleJndiContextFactory.initializeStandardJndiEnvironment(environment);
        Boolean isShared = Boolean.valueOf((String)environment.get("org.osjava.sj.jndi.shared"));
        if (!isShared.booleanValue()) {
            return new DelimiterConvertingContext(new SimpleJndi(environment).loadRoot());
        }
        final String root = (String)environment.get("org.osjava.sj.root");
        Context ctx = contextsByRoot.get(root);
        if (ctx != null) {
            String ignoreClose = (String)environment.get("org.osjava.sj.jndi.ignoreClose");
            ctx.addToEnvironment("org.osjava.sj.jndi.ignoreClose", BooleanUtils.toStringTrueFalse((boolean)BooleanUtils.toBoolean((String)ignoreClose)));
            return ctx;
        }
        InitialContext context = new SimpleJndi(environment).loadRoot();
        DelimiterConvertingContext delimiterConvertingContext = new DelimiterConvertingContext(context){
            private boolean isClosed;

            @Override
            public void close() throws NamingException {
                String ignoreClose;
                if (!this.isClosed && !BooleanUtils.toBoolean((String)(ignoreClose = (String)this.getEnvironment().get("org.osjava.sj.jndi.ignoreClose")))) {
                    contextsByRoot.remove(root);
                    this.target.close();
                    this.isClosed = true;
                }
            }
        };
        contextsByRoot.put(root, delimiterConvertingContext);
        return delimiterConvertingContext;
    }
}

