package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CacheEntryDao_Impl extends CacheEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CacheEntry> __insertionAdapterOfCacheEntry;

  private final EntityInsertionAdapter<CacheEntry> __insertionAdapterOfCacheEntry_1;

  private final EntityDeletionOrUpdateAdapter<CacheEntry> __deletionAdapterOfCacheEntry;

  private final EntityDeletionOrUpdateAdapter<CacheEntry> __updateAdapterOfCacheEntry;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLastAccessedTime;

  private final SharedSQLiteStatement __preparedStmtOfUpdateValidation;

  public CacheEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCacheEntry = new EntityInsertionAdapter<CacheEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheEntry entity) {
        statement.bindString(1, entity.getKey());
        statement.bindString(2, entity.getUrl());
        statement.bindString(3, entity.getMessage());
        statement.bindLong(4, entity.getStatusCode());
        statement.bindLong(5, entity.getCacheFlags());
        statement.bindLong(6, entity.getMethod());
        statement.bindLong(7, entity.getLastAccessed());
        statement.bindLong(8, entity.getLastValidated());
        if (entity.getIntegrity() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getIntegrity());
        }
        statement.bindString(10, entity.getResponseHeaders());
        statement.bindString(11, entity.getStorageUri());
        statement.bindLong(12, entity.getStorageSize());
        statement.bindLong(13, entity.getUncompressedSize());
      }
    };
    this.__insertionAdapterOfCacheEntry_1 = new EntityInsertionAdapter<CacheEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheEntry entity) {
        statement.bindString(1, entity.getKey());
        statement.bindString(2, entity.getUrl());
        statement.bindString(3, entity.getMessage());
        statement.bindLong(4, entity.getStatusCode());
        statement.bindLong(5, entity.getCacheFlags());
        statement.bindLong(6, entity.getMethod());
        statement.bindLong(7, entity.getLastAccessed());
        statement.bindLong(8, entity.getLastValidated());
        if (entity.getIntegrity() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getIntegrity());
        }
        statement.bindString(10, entity.getResponseHeaders());
        statement.bindString(11, entity.getStorageUri());
        statement.bindLong(12, entity.getStorageSize());
        statement.bindLong(13, entity.getUncompressedSize());
      }
    };
    this.__deletionAdapterOfCacheEntry = new EntityDeletionOrUpdateAdapter<CacheEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `CacheEntry` WHERE `key` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheEntry entity) {
        statement.bindString(1, entity.getKey());
      }
    };
    this.__updateAdapterOfCacheEntry = new EntityDeletionOrUpdateAdapter<CacheEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CacheEntry` SET `key` = ?,`url` = ?,`message` = ?,`statusCode` = ?,`cacheFlags` = ?,`method` = ?,`lastAccessed` = ?,`lastValidated` = ?,`integrity` = ?,`responseHeaders` = ?,`storageUri` = ?,`storageSize` = ?,`uncompressedSize` = ? WHERE `key` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheEntry entity) {
        statement.bindString(1, entity.getKey());
        statement.bindString(2, entity.getUrl());
        statement.bindString(3, entity.getMessage());
        statement.bindLong(4, entity.getStatusCode());
        statement.bindLong(5, entity.getCacheFlags());
        statement.bindLong(6, entity.getMethod());
        statement.bindLong(7, entity.getLastAccessed());
        statement.bindLong(8, entity.getLastValidated());
        if (entity.getIntegrity() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getIntegrity());
        }
        statement.bindString(10, entity.getResponseHeaders());
        statement.bindString(11, entity.getStorageUri());
        statement.bindLong(12, entity.getStorageSize());
        statement.bindLong(13, entity.getUncompressedSize());
        statement.bindString(14, entity.getKey());
      }
    };
    this.__preparedStmtOfUpdateLastAccessedTime = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CacheEntry\n"
                + "           SET lastAccessed = ?\n"
                + "         WHERE key = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateValidation = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CacheEntry\n"
                + "           SET responseHeaders = ?,\n"
                + "               lastValidated = ?,\n"
                + "               lastAccessed = ?\n"
                + "         WHERE key = ?      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final CacheEntry entry, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCacheEntry.insertAndReturnId(entry);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<CacheEntry> entry) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCacheEntry.insert(entry);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void upsertList(final List<CacheEntry> entry) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCacheEntry_1.insert(entry);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final List<CacheEntry> entries) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfCacheEntry.handleMultiple(entries);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<CacheEntry> entry) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCacheEntry.handleMultiple(entry);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateLastAccessedTime(final String key, final long lastAccessTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLastAccessedTime.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, lastAccessTime);
    _argIndex = 2;
    _stmt.bindString(_argIndex, key);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateLastAccessedTime.release(_stmt);
    }
  }

  @Override
  public void updateValidation(final String key, final String headers, final long lastValidated,
      final long lastAccessed) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateValidation.acquire();
    int _argIndex = 1;
    _stmt.bindString(_argIndex, headers);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, lastValidated);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, lastAccessed);
    _argIndex = 4;
    _stmt.bindString(_argIndex, key);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateValidation.release(_stmt);
    }
  }

  @Override
  public Object findByUrlAsync(final String url,
      final Continuation<? super CacheEntry> $completion) {
    final String _sql = "\n"
            + "        SELECT CacheEntry.*\n"
            + "          FROM CacheEntry\n"
            + "         WHERE CacheEntry.url = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, url);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CacheEntry>() {
      @Override
      @Nullable
      public CacheEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow(_cursor, "key");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow(_cursor, "statusCode");
          final int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "cacheFlags");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow(_cursor, "lastAccessed");
          final int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow(_cursor, "lastValidated");
          final int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow(_cursor, "integrity");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow(_cursor, "storageUri");
          final int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "storageSize");
          final int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "uncompressedSize");
          final CacheEntry _result;
          if (_cursor.moveToFirst()) {
            final String _tmpKey;
            _tmpKey = _cursor.getString(_cursorIndexOfKey);
            final String _tmpUrl;
            _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            final String _tmpMessage;
            _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            final int _tmpStatusCode;
            _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
            final int _tmpCacheFlags;
            _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
            final int _tmpMethod;
            _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
            final long _tmpLastAccessed;
            _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
            final long _tmpLastValidated;
            _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
            final String _tmpIntegrity;
            if (_cursor.isNull(_cursorIndexOfIntegrity)) {
              _tmpIntegrity = null;
            } else {
              _tmpIntegrity = _cursor.getString(_cursorIndexOfIntegrity);
            }
            final String _tmpResponseHeaders;
            _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
            final String _tmpStorageUri;
            _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
            final long _tmpStorageSize;
            _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
            final long _tmpUncompressedSize;
            _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
            _result = new CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public CacheEntry findEntryAndBodyByKey(final String key) {
    final String _sql = "\n"
            + "        SELECT CacheEntry.*\n"
            + "          FROM CacheEntry\n"
            + "         WHERE CacheEntry.key = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, key);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow(_cursor, "key");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
      final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
      final int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow(_cursor, "statusCode");
      final int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "cacheFlags");
      final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
      final int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow(_cursor, "lastAccessed");
      final int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow(_cursor, "lastValidated");
      final int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow(_cursor, "integrity");
      final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
      final int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow(_cursor, "storageUri");
      final int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "storageSize");
      final int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "uncompressedSize");
      final CacheEntry _result;
      if (_cursor.moveToFirst()) {
        final String _tmpKey;
        _tmpKey = _cursor.getString(_cursorIndexOfKey);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        final String _tmpMessage;
        _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
        final int _tmpStatusCode;
        _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
        final int _tmpCacheFlags;
        _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
        final int _tmpMethod;
        _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
        final long _tmpLastAccessed;
        _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
        final long _tmpLastValidated;
        _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
        final String _tmpIntegrity;
        if (_cursor.isNull(_cursorIndexOfIntegrity)) {
          _tmpIntegrity = null;
        } else {
          _tmpIntegrity = _cursor.getString(_cursorIndexOfIntegrity);
        }
        final String _tmpResponseHeaders;
        _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
        final String _tmpStorageUri;
        _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
        final long _tmpStorageSize;
        _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
        final long _tmpUncompressedSize;
        _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
        _result = new CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<CacheEntry> findByRequestBatchId(final int batchId) {
    final String _sql = "\n"
            + "        SELECT CacheEntry.*\n"
            + "          FROM CacheEntry\n"
            + "         WHERE CacheEntry.key IN\n"
            + "               (SELECT RequestedEntry.requestedKey\n"
            + "                  FROM RequestedEntry\n"
            + "                 WHERE RequestedEntry.batchId = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, batchId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow(_cursor, "key");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
      final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
      final int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow(_cursor, "statusCode");
      final int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "cacheFlags");
      final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
      final int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow(_cursor, "lastAccessed");
      final int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow(_cursor, "lastValidated");
      final int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow(_cursor, "integrity");
      final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
      final int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow(_cursor, "storageUri");
      final int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "storageSize");
      final int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "uncompressedSize");
      final List<CacheEntry> _result = new ArrayList<CacheEntry>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final CacheEntry _item;
        final String _tmpKey;
        _tmpKey = _cursor.getString(_cursorIndexOfKey);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        final String _tmpMessage;
        _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
        final int _tmpStatusCode;
        _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
        final int _tmpCacheFlags;
        _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
        final int _tmpMethod;
        _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
        final long _tmpLastAccessed;
        _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
        final long _tmpLastValidated;
        _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
        final String _tmpIntegrity;
        if (_cursor.isNull(_cursorIndexOfIntegrity)) {
          _tmpIntegrity = null;
        } else {
          _tmpIntegrity = _cursor.getString(_cursorIndexOfIntegrity);
        }
        final String _tmpResponseHeaders;
        _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
        final String _tmpStorageUri;
        _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
        final long _tmpStorageSize;
        _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
        final long _tmpUncompressedSize;
        _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
        _item = new CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<String> findEntriesWithLock(final int batchId) {
    final String _sql = "\n"
            + "        SELECT RequestedEntry.requestedKey\n"
            + "          FROM RequestedEntry\n"
            + "         WHERE RequestedEntry.batchId = ?\n"
            + "           AND EXISTS(\n"
            + "               SELECT RetentionLock.lockId\n"
            + "                 FROM RetentionLock\n"
            + "                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, batchId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<String> _result = new ArrayList<String>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final String _item;
        _item = _cursor.getString(0);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<CacheEntry> findEvictableEntries(final int batchSize) {
    final String _sql = "\n"
            + "        SELECT CacheEntry.*\n"
            + "          FROM CacheEntry\n"
            + "         WHERE NOT EXISTS(\n"
            + "               SELECT RetentionLock.lockId\n"
            + "                 FROM RetentionLock\n"
            + "                WHERE RetentionLock.lockKey = CacheEntry.key) \n"
            + "      ORDER BY lastAccessed ASC           \n"
            + "         LIMIT ?       \n"
            + "      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, batchSize);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow(_cursor, "key");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
      final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
      final int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow(_cursor, "statusCode");
      final int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "cacheFlags");
      final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
      final int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow(_cursor, "lastAccessed");
      final int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow(_cursor, "lastValidated");
      final int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow(_cursor, "integrity");
      final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
      final int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow(_cursor, "storageUri");
      final int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "storageSize");
      final int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow(_cursor, "uncompressedSize");
      final List<CacheEntry> _result = new ArrayList<CacheEntry>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final CacheEntry _item;
        final String _tmpKey;
        _tmpKey = _cursor.getString(_cursorIndexOfKey);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        final String _tmpMessage;
        _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
        final int _tmpStatusCode;
        _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
        final int _tmpCacheFlags;
        _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
        final int _tmpMethod;
        _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
        final long _tmpLastAccessed;
        _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
        final long _tmpLastValidated;
        _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
        final String _tmpIntegrity;
        if (_cursor.isNull(_cursorIndexOfIntegrity)) {
          _tmpIntegrity = null;
        } else {
          _tmpIntegrity = _cursor.getString(_cursorIndexOfIntegrity);
        }
        final String _tmpResponseHeaders;
        _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
        final String _tmpStorageUri;
        _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
        final long _tmpStorageSize;
        _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
        final long _tmpUncompressedSize;
        _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
        _item = new CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public long totalEvictableSize() {
    final String _sql = "\n"
            + "        SELECT SUM(CacheEntry.storageSize)\n"
            + "          FROM CacheEntry\n"
            + "         WHERE NOT EXISTS(\n"
            + "               SELECT RetentionLock.lockId\n"
            + "                 FROM RetentionLock\n"
            + "                WHERE RetentionLock.lockKey = CacheEntry.key)  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final long _result;
      if (_cursor.moveToFirst()) {
        _result = _cursor.getLong(0);
      } else {
        _result = 0L;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
