package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ClazzLog;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzLogDao_Impl extends ClazzLogDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog;

  private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog_1;

  private final EntityDeletionOrUpdateAdapter<ClazzLog> __updateAdapterOfClazzLog;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatusByClazzLogUid;

  public ClazzLogDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzLog = new EntityInsertionAdapter<ClazzLog>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLog entity) {
        statement.bindLong(1, entity.getClazzLogUid());
        statement.bindLong(2, entity.getClazzLogClazzUid());
        statement.bindLong(3, entity.getLogDate());
        statement.bindLong(4, entity.getTimeRecorded());
        final int _tmp = entity.getClazzLogDone() ? 1 : 0;
        statement.bindLong(5, _tmp);
        if (entity.getCancellationNote() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCancellationNote());
        }
        final int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
        statement.bindLong(7, _tmp_1);
        statement.bindLong(8, entity.getClazzLogNumPresent());
        statement.bindLong(9, entity.getClazzLogNumAbsent());
        statement.bindLong(10, entity.getClazzLogNumPartial());
        statement.bindLong(11, entity.getClazzLogScheduleUid());
        statement.bindLong(12, entity.getClazzLogStatusFlag());
        statement.bindLong(13, entity.getClazzLogMSQN());
        statement.bindLong(14, entity.getClazzLogLCSN());
        statement.bindLong(15, entity.getClazzLogLCB());
        statement.bindLong(16, entity.getClazzLogLastChangedTime());
      }
    };
    this.__insertionAdapterOfClazzLog_1 = new EntityInsertionAdapter<ClazzLog>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLog entity) {
        statement.bindLong(1, entity.getClazzLogUid());
        statement.bindLong(2, entity.getClazzLogClazzUid());
        statement.bindLong(3, entity.getLogDate());
        statement.bindLong(4, entity.getTimeRecorded());
        final int _tmp = entity.getClazzLogDone() ? 1 : 0;
        statement.bindLong(5, _tmp);
        if (entity.getCancellationNote() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCancellationNote());
        }
        final int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
        statement.bindLong(7, _tmp_1);
        statement.bindLong(8, entity.getClazzLogNumPresent());
        statement.bindLong(9, entity.getClazzLogNumAbsent());
        statement.bindLong(10, entity.getClazzLogNumPartial());
        statement.bindLong(11, entity.getClazzLogScheduleUid());
        statement.bindLong(12, entity.getClazzLogStatusFlag());
        statement.bindLong(13, entity.getClazzLogMSQN());
        statement.bindLong(14, entity.getClazzLogLCSN());
        statement.bindLong(15, entity.getClazzLogLCB());
        statement.bindLong(16, entity.getClazzLogLastChangedTime());
      }
    };
    this.__updateAdapterOfClazzLog = new EntityDeletionOrUpdateAdapter<ClazzLog>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ClazzLog` SET `clazzLogUid` = ?,`clazzLogClazzUid` = ?,`logDate` = ?,`timeRecorded` = ?,`clazzLogDone` = ?,`cancellationNote` = ?,`clazzLogCancelled` = ?,`clazzLogNumPresent` = ?,`clazzLogNumAbsent` = ?,`clazzLogNumPartial` = ?,`clazzLogScheduleUid` = ?,`clazzLogStatusFlag` = ?,`clazzLogMSQN` = ?,`clazzLogLCSN` = ?,`clazzLogLCB` = ?,`clazzLogLastChangedTime` = ? WHERE `clazzLogUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzLog entity) {
        statement.bindLong(1, entity.getClazzLogUid());
        statement.bindLong(2, entity.getClazzLogClazzUid());
        statement.bindLong(3, entity.getLogDate());
        statement.bindLong(4, entity.getTimeRecorded());
        final int _tmp = entity.getClazzLogDone() ? 1 : 0;
        statement.bindLong(5, _tmp);
        if (entity.getCancellationNote() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCancellationNote());
        }
        final int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
        statement.bindLong(7, _tmp_1);
        statement.bindLong(8, entity.getClazzLogNumPresent());
        statement.bindLong(9, entity.getClazzLogNumAbsent());
        statement.bindLong(10, entity.getClazzLogNumPartial());
        statement.bindLong(11, entity.getClazzLogScheduleUid());
        statement.bindLong(12, entity.getClazzLogStatusFlag());
        statement.bindLong(13, entity.getClazzLogMSQN());
        statement.bindLong(14, entity.getClazzLogLCSN());
        statement.bindLong(15, entity.getClazzLogLCB());
        statement.bindLong(16, entity.getClazzLogLastChangedTime());
        statement.bindLong(17, entity.getClazzLogUid());
      }
    };
    this.__preparedStmtOfUpdateStatusByClazzLogUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE ClazzLog \n"
                + "        SET clazzLogStatusFlag = ?,\n"
                + "        clazzLogLastChangedTime = ?\n"
                + "        WHERE clazzLogUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzLog.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzLog entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzLog.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ClazzLog> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzLog.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public long replace(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzLog_1.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertListAsync(final List<? extends ClazzLog> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzLog_1.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final ClazzLog entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLog.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ClazzLog clazzLog, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzLog.handle(clazzLog);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void updateStatusByClazzLogUid(final long clazzLogUid, final int newStatus,
      final long timeChanged) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatusByClazzLogUid.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, newStatus);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, timeChanged);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, clazzLogUid);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateStatusByClazzLogUid.release(_stmt);
    }
  }

  @Override
  public ClazzLog findByUid(final long uid) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
      final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
      final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
      final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
      final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
      final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
      final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
      final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
      final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
      final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
      final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
      final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
      final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
      final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
      final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
      final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
      final ClazzLog _result;
      if (_cursor.moveToFirst()) {
        _result = new ClazzLog();
        final long _tmpClazzLogUid;
        _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
        _result.setClazzLogUid(_tmpClazzLogUid);
        final long _tmpClazzLogClazzUid;
        _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
        _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
        final long _tmpLogDate;
        _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
        _result.setLogDate(_tmpLogDate);
        final long _tmpTimeRecorded;
        _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
        _result.setTimeRecorded(_tmpTimeRecorded);
        final boolean _tmpClazzLogDone;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
        _tmpClazzLogDone = _tmp != 0;
        _result.setClazzLogDone(_tmpClazzLogDone);
        final String _tmpCancellationNote;
        if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
          _tmpCancellationNote = null;
        } else {
          _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
        }
        _result.setCancellationNote(_tmpCancellationNote);
        final boolean _tmpClazzLogCancelled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
        _tmpClazzLogCancelled = _tmp_1 != 0;
        _result.setClazzLogCancelled(_tmpClazzLogCancelled);
        final int _tmpClazzLogNumPresent;
        _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
        _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
        final int _tmpClazzLogNumAbsent;
        _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
        _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
        final int _tmpClazzLogNumPartial;
        _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
        _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
        final long _tmpClazzLogScheduleUid;
        _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
        _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
        final int _tmpClazzLogStatusFlag;
        _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
        _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
        final long _tmpClazzLogMSQN;
        _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
        _result.setClazzLogMSQN(_tmpClazzLogMSQN);
        final long _tmpClazzLogLCSN;
        _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
        _result.setClazzLogLCSN(_tmpClazzLogLCSN);
        final int _tmpClazzLogLCB;
        _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
        _result.setClazzLogLCB(_tmpClazzLogLCB);
        final long _tmpClazzLogLastChangedTime;
        _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
        _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super ClazzLog> $completion) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzLog>() {
      @Override
      @Nullable
      public ClazzLog call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final ClazzLog _result;
          if (_cursor.moveToFirst()) {
            _result = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _result.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _result.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _result.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _result.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _result.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _result.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _result.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _result.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _result.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ClazzLog> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzLog"}, new Callable<ClazzLog>() {
      @Override
      @Nullable
      public ClazzLog call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final ClazzLog _result;
          if (_cursor.moveToFirst()) {
            _result = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _result.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _result.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _result.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _result.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _result.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _result.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _result.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _result.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _result.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _result.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _result.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _result.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _result.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _result.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _result.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _result.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, ClazzLog> findByClazzUidAsFactory(final long clazzUid,
      final int excludeStatus) {
    final String _sql = "\n"
            + "        SELECT ClazzLog.* \n"
            + "          FROM ClazzLog \n"
            + "         WHERE clazzLogClazzUid = ?\n"
            + "           AND clazzLog.clazzLogStatusFlag != ?\n"
            + "      ORDER BY ClazzLog.logDate DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatus);
    return new LimitOffsetPagingSource<ClazzLog>(_statement, __db, "ClazzLog") {
      @Override
      @NonNull
      protected List<ClazzLog> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogUid");
        final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogClazzUid");
        final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(cursor, "logDate");
        final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(cursor, "timeRecorded");
        final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogDone");
        final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(cursor, "cancellationNote");
        final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogCancelled");
        final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumPresent");
        final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumAbsent");
        final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogNumPartial");
        final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogScheduleUid");
        final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogStatusFlag");
        final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogMSQN");
        final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLCSN");
        final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLCB");
        final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLogLastChangedTime");
        final List<ClazzLog> _result = new ArrayList<ClazzLog>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ClazzLog _item;
          _item = new ClazzLog();
          final long _tmpClazzLogUid;
          _tmpClazzLogUid = cursor.getLong(_cursorIndexOfClazzLogUid);
          _item.setClazzLogUid(_tmpClazzLogUid);
          final long _tmpClazzLogClazzUid;
          _tmpClazzLogClazzUid = cursor.getLong(_cursorIndexOfClazzLogClazzUid);
          _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
          final long _tmpLogDate;
          _tmpLogDate = cursor.getLong(_cursorIndexOfLogDate);
          _item.setLogDate(_tmpLogDate);
          final long _tmpTimeRecorded;
          _tmpTimeRecorded = cursor.getLong(_cursorIndexOfTimeRecorded);
          _item.setTimeRecorded(_tmpTimeRecorded);
          final boolean _tmpClazzLogDone;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfClazzLogDone);
          _tmpClazzLogDone = _tmp != 0;
          _item.setClazzLogDone(_tmpClazzLogDone);
          final String _tmpCancellationNote;
          if (cursor.isNull(_cursorIndexOfCancellationNote)) {
            _tmpCancellationNote = null;
          } else {
            _tmpCancellationNote = cursor.getString(_cursorIndexOfCancellationNote);
          }
          _item.setCancellationNote(_tmpCancellationNote);
          final boolean _tmpClazzLogCancelled;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfClazzLogCancelled);
          _tmpClazzLogCancelled = _tmp_1 != 0;
          _item.setClazzLogCancelled(_tmpClazzLogCancelled);
          final int _tmpClazzLogNumPresent;
          _tmpClazzLogNumPresent = cursor.getInt(_cursorIndexOfClazzLogNumPresent);
          _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
          final int _tmpClazzLogNumAbsent;
          _tmpClazzLogNumAbsent = cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
          _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
          final int _tmpClazzLogNumPartial;
          _tmpClazzLogNumPartial = cursor.getInt(_cursorIndexOfClazzLogNumPartial);
          _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
          final long _tmpClazzLogScheduleUid;
          _tmpClazzLogScheduleUid = cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
          _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
          final int _tmpClazzLogStatusFlag;
          _tmpClazzLogStatusFlag = cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
          _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
          final long _tmpClazzLogMSQN;
          _tmpClazzLogMSQN = cursor.getLong(_cursorIndexOfClazzLogMSQN);
          _item.setClazzLogMSQN(_tmpClazzLogMSQN);
          final long _tmpClazzLogLCSN;
          _tmpClazzLogLCSN = cursor.getLong(_cursorIndexOfClazzLogLCSN);
          _item.setClazzLogLCSN(_tmpClazzLogLCSN);
          final int _tmpClazzLogLCB;
          _tmpClazzLogLCB = cursor.getInt(_cursorIndexOfClazzLogLCB);
          _item.setClazzLogLCB(_tmpClazzLogLCB);
          final long _tmpClazzLogLastChangedTime;
          _tmpClazzLogLastChangedTime = cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
          _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findByClazzUidAsync(final long clazzUid, final int excludeStatus,
      final Continuation<? super List<? extends ClazzLog>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzLog.* \n"
            + "          FROM ClazzLog \n"
            + "         WHERE ClazzLog.clazzLogClazzUid = ?\n"
            + "           AND clazzLog.clazzLogStatusFlag != ?\n"
            + "      ORDER BY ClazzLog.logDate ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatus);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLog>>() {
      @Override
      @NonNull
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllForClazzByClazzLogUid(final long clazzLogUid, final int excludeStatus,
      final Continuation<? super List<? extends ClazzLog>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzLog.* \n"
            + "          FROM ClazzLog \n"
            + "         WHERE ClazzLog.clazzLogClazzUid = \n"
            + "               (SELECT ClazzLogInner.clazzLogClazzUid\n"
            + "                  FROM ClazzLog ClazzLogInner\n"
            + "                 WHERE ClazzLogInner.clazzLogUid = ?)\n"
            + "           AND clazzLog.clazzLogStatusFlag != ?\n"
            + "      ORDER BY ClazzLog.logDate ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzLogUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatus);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLog>>() {
      @Override
      @NonNull
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzUidWithinTimeRangeAsync(final long clazzUid, final long fromTime,
      final long toTime, final int excludeStatusFilter, final int limit,
      final Continuation<? super List<? extends ClazzLog>> $completion) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n"
            + "        ORDER BY ClazzLog.logDate DESC\n"
            + "        LIMIT ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLog>>() {
      @Override
      @NonNull
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public List<ClazzLog> findByClazzUidWithinTimeRange(final long clazzUid, final long fromTime,
      final long toTime, final int excludeStatusFilter, final int limit) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n"
            + "        ORDER BY ClazzLog.logDate DESC\n"
            + "        LIMIT ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, limit);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
      final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
      final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
      final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
      final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
      final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
      final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
      final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
      final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
      final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
      final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
      final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
      final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
      final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
      final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
      final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
      final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ClazzLog _item;
        _item = new ClazzLog();
        final long _tmpClazzLogUid;
        _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
        _item.setClazzLogUid(_tmpClazzLogUid);
        final long _tmpClazzLogClazzUid;
        _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
        final long _tmpLogDate;
        _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
        _item.setLogDate(_tmpLogDate);
        final long _tmpTimeRecorded;
        _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
        _item.setTimeRecorded(_tmpTimeRecorded);
        final boolean _tmpClazzLogDone;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
        _tmpClazzLogDone = _tmp != 0;
        _item.setClazzLogDone(_tmpClazzLogDone);
        final String _tmpCancellationNote;
        if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
          _tmpCancellationNote = null;
        } else {
          _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
        }
        _item.setCancellationNote(_tmpCancellationNote);
        final boolean _tmpClazzLogCancelled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
        _tmpClazzLogCancelled = _tmp_1 != 0;
        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
        final int _tmpClazzLogNumPresent;
        _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
        final int _tmpClazzLogNumAbsent;
        _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
        final int _tmpClazzLogNumPartial;
        _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
        final long _tmpClazzLogScheduleUid;
        _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
        final int _tmpClazzLogStatusFlag;
        _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
        final long _tmpClazzLogMSQN;
        _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
        final long _tmpClazzLogLCSN;
        _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
        final int _tmpClazzLogLCB;
        _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
        _item.setClazzLogLCB(_tmpClazzLogLCB);
        final long _tmpClazzLogLastChangedTime;
        _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<List<ClazzLog>> findByClazzUidWithinTimeRangeLive(final long clazzUid,
      final long fromTime, final long toTime, final int statusFilter) {
    final String _sql = "SELECT ClazzLog.* FROM ClazzLog \n"
            + "        WHERE \n"
            + "        ClazzLog.clazzLogClazzUid = ? \n"
            + "        AND ClazzLog.logDate BETWEEN ? AND ?\n"
            + "        AND (? = 0 OR ClazzLog.clazzLogStatusFlag = ?)\n"
            + "        ORDER BY ClazzLog.logDate\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, fromTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, toTime);
    _argIndex = 4;
    _statement.bindLong(_argIndex, statusFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, statusFilter);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzLog"}, new Callable<List<ClazzLog>>() {
      @Override
      @NonNull
      public List<ClazzLog> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogUid");
          final int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogClazzUid");
          final int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow(_cursor, "logDate");
          final int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow(_cursor, "timeRecorded");
          final int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogDone");
          final int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow(_cursor, "cancellationNote");
          final int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogCancelled");
          final int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPresent");
          final int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumAbsent");
          final int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogNumPartial");
          final int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogScheduleUid");
          final int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogStatusFlag");
          final int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogMSQN");
          final int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCSN");
          final int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLCB");
          final int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogLastChangedTime");
          final List<ClazzLog> _result = new ArrayList<ClazzLog>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzLog _item;
            _item = new ClazzLog();
            final long _tmpClazzLogUid;
            _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
            _item.setClazzLogUid(_tmpClazzLogUid);
            final long _tmpClazzLogClazzUid;
            _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
            _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
            final long _tmpLogDate;
            _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
            _item.setLogDate(_tmpLogDate);
            final long _tmpTimeRecorded;
            _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
            _item.setTimeRecorded(_tmpTimeRecorded);
            final boolean _tmpClazzLogDone;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
            _tmpClazzLogDone = _tmp != 0;
            _item.setClazzLogDone(_tmpClazzLogDone);
            final String _tmpCancellationNote;
            if (_cursor.isNull(_cursorIndexOfCancellationNote)) {
              _tmpCancellationNote = null;
            } else {
              _tmpCancellationNote = _cursor.getString(_cursorIndexOfCancellationNote);
            }
            _item.setCancellationNote(_tmpCancellationNote);
            final boolean _tmpClazzLogCancelled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
            _tmpClazzLogCancelled = _tmp_1 != 0;
            _item.setClazzLogCancelled(_tmpClazzLogCancelled);
            final int _tmpClazzLogNumPresent;
            _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
            _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
            final int _tmpClazzLogNumAbsent;
            _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
            _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
            final int _tmpClazzLogNumPartial;
            _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
            _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
            final long _tmpClazzLogScheduleUid;
            _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
            _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
            final int _tmpClazzLogStatusFlag;
            _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
            _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
            final long _tmpClazzLogMSQN;
            _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
            _item.setClazzLogMSQN(_tmpClazzLogMSQN);
            final long _tmpClazzLogLCSN;
            _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
            _item.setClazzLogLCSN(_tmpClazzLogLCSN);
            final int _tmpClazzLogLCB;
            _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
            _item.setClazzLogLCB(_tmpClazzLogLCB);
            final long _tmpClazzLogLastChangedTime;
            _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
            _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<Boolean> clazzHasScheduleLive(final long clazzUid, final int excludeStatusFilter) {
    final String _sql = "\n"
            + "        SELECT EXISTS\n"
            + "               (SELECT ClazzLog.clazzLogUid \n"
            + "                  FROM ClazzLog \n"
            + "                 WHERE clazzLogClazzUid = ? \n"
            + "                 AND (? = 0 \n"
            + "                      OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n"
            + "               )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, excludeStatusFilter);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzLog"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findMostRecentClazzLogToEditUid(final long clazzUid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT ClazzLog.clazzLogUid\n"
            + "                  FROM ClazzLog\n"
            + "                 WHERE ClazzLog.clazzLogClazzUid = ?\n"
            + "                   AND (ClazzLog.clazzLogStatusFlag & 8) != 8\n"
            + "              ORDER BY ClazzLog.logDate DESC\n"
            + "                 LIMIT 1), 0)\n"
            + "\n"
            + "        \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
