package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.ContentEntryAndDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndLanguage;
import com.ustadmobile.lib.db.composites.ContentEntryAndListDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndPicture;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryPicture2;
import com.ustadmobile.lib.db.entities.ContentEntryVersion;
import com.ustadmobile.lib.db.entities.ContentEntryWithLanguage;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Float;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryDao_Impl extends ContentEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry;

  private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry_1;

  private final EntityDeletionOrUpdateAdapter<ContentEntry> __updateAdapterOfContentEntry;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryInActive;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryContentFlag;

  public ContentEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntry = new EntityInsertionAdapter<ContentEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentOwnerType`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntry entity) {
        statement.bindLong(1, entity.getContentEntryUid());
        if (entity.getTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTitle());
        }
        if (entity.getDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDescription());
        }
        if (entity.getEntryId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEntryId());
        }
        if (entity.getAuthor() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAuthor());
        }
        if (entity.getPublisher() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPublisher());
        }
        statement.bindLong(7, entity.getLicenseType());
        if (entity.getLicenseName() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLicenseName());
        }
        if (entity.getLicenseUrl() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLicenseUrl());
        }
        if (entity.getSourceUrl() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getSourceUrl());
        }
        if (entity.getThumbnailUrl() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getThumbnailUrl());
        }
        statement.bindLong(12, entity.getLastModified());
        statement.bindLong(13, entity.getPrimaryLanguageUid());
        statement.bindLong(14, entity.getLanguageVariantUid());
        statement.bindLong(15, entity.getContentFlags());
        final int _tmp = entity.getLeaf() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.getPublik() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        final int _tmp_2 = entity.getCeInactive() ? 1 : 0;
        statement.bindLong(18, _tmp_2);
        statement.bindLong(19, entity.getCompletionCriteria());
        statement.bindLong(20, entity.getMinScore());
        statement.bindLong(21, entity.getContentTypeFlag());
        statement.bindLong(22, entity.getContentOwner());
        statement.bindLong(23, entity.getContentOwnerType());
        statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
        statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
        statement.bindLong(26, entity.getContentEntryLastChangedBy());
        statement.bindLong(27, entity.getContentEntryLct());
      }
    };
    this.__insertionAdapterOfContentEntry_1 = new EntityInsertionAdapter<ContentEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentOwnerType`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntry entity) {
        statement.bindLong(1, entity.getContentEntryUid());
        if (entity.getTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTitle());
        }
        if (entity.getDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDescription());
        }
        if (entity.getEntryId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEntryId());
        }
        if (entity.getAuthor() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAuthor());
        }
        if (entity.getPublisher() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPublisher());
        }
        statement.bindLong(7, entity.getLicenseType());
        if (entity.getLicenseName() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLicenseName());
        }
        if (entity.getLicenseUrl() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLicenseUrl());
        }
        if (entity.getSourceUrl() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getSourceUrl());
        }
        if (entity.getThumbnailUrl() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getThumbnailUrl());
        }
        statement.bindLong(12, entity.getLastModified());
        statement.bindLong(13, entity.getPrimaryLanguageUid());
        statement.bindLong(14, entity.getLanguageVariantUid());
        statement.bindLong(15, entity.getContentFlags());
        final int _tmp = entity.getLeaf() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.getPublik() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        final int _tmp_2 = entity.getCeInactive() ? 1 : 0;
        statement.bindLong(18, _tmp_2);
        statement.bindLong(19, entity.getCompletionCriteria());
        statement.bindLong(20, entity.getMinScore());
        statement.bindLong(21, entity.getContentTypeFlag());
        statement.bindLong(22, entity.getContentOwner());
        statement.bindLong(23, entity.getContentOwnerType());
        statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
        statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
        statement.bindLong(26, entity.getContentEntryLastChangedBy());
        statement.bindLong(27, entity.getContentEntryLct());
      }
    };
    this.__updateAdapterOfContentEntry = new EntityDeletionOrUpdateAdapter<ContentEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContentEntry` SET `contentEntryUid` = ?,`title` = ?,`description` = ?,`entryId` = ?,`author` = ?,`publisher` = ?,`licenseType` = ?,`licenseName` = ?,`licenseUrl` = ?,`sourceUrl` = ?,`thumbnailUrl` = ?,`lastModified` = ?,`primaryLanguageUid` = ?,`languageVariantUid` = ?,`contentFlags` = ?,`leaf` = ?,`publik` = ?,`ceInactive` = ?,`completionCriteria` = ?,`minScore` = ?,`contentTypeFlag` = ?,`contentOwner` = ?,`contentOwnerType` = ?,`contentEntryLocalChangeSeqNum` = ?,`contentEntryMasterChangeSeqNum` = ?,`contentEntryLastChangedBy` = ?,`contentEntryLct` = ? WHERE `contentEntryUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntry entity) {
        statement.bindLong(1, entity.getContentEntryUid());
        if (entity.getTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getTitle());
        }
        if (entity.getDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getDescription());
        }
        if (entity.getEntryId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEntryId());
        }
        if (entity.getAuthor() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getAuthor());
        }
        if (entity.getPublisher() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getPublisher());
        }
        statement.bindLong(7, entity.getLicenseType());
        if (entity.getLicenseName() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getLicenseName());
        }
        if (entity.getLicenseUrl() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getLicenseUrl());
        }
        if (entity.getSourceUrl() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getSourceUrl());
        }
        if (entity.getThumbnailUrl() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getThumbnailUrl());
        }
        statement.bindLong(12, entity.getLastModified());
        statement.bindLong(13, entity.getPrimaryLanguageUid());
        statement.bindLong(14, entity.getLanguageVariantUid());
        statement.bindLong(15, entity.getContentFlags());
        final int _tmp = entity.getLeaf() ? 1 : 0;
        statement.bindLong(16, _tmp);
        final int _tmp_1 = entity.getPublik() ? 1 : 0;
        statement.bindLong(17, _tmp_1);
        final int _tmp_2 = entity.getCeInactive() ? 1 : 0;
        statement.bindLong(18, _tmp_2);
        statement.bindLong(19, entity.getCompletionCriteria());
        statement.bindLong(20, entity.getMinScore());
        statement.bindLong(21, entity.getContentTypeFlag());
        statement.bindLong(22, entity.getContentOwner());
        statement.bindLong(23, entity.getContentOwnerType());
        statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
        statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
        statement.bindLong(26, entity.getContentEntryLastChangedBy());
        statement.bindLong(27, entity.getContentEntryLct());
        statement.bindLong(28, entity.getContentEntryUid());
      }
    };
    this.__preparedStmtOfUpdateContentEntryInActive = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "            UPDATE ContentEntry \n"
                + "               SET ceInactive = ?,\n"
                + "                   contentEntryLct = ?        \n"
                + "            WHERE ContentEntry.contentEntryUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentEntryContentFlag = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntry \n"
                + "           SET contentTypeFlag = ?,\n"
                + "               contentEntryLct = ? \n"
                + "         WHERE ContentEntry.contentEntryUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfContentEntry.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntry entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntry.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ContentEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntry.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ContentEntry> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContentEntry.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertAsync(final ContentEntry entity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContentEntry_1.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final ContentEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntry.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ContentEntry entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfContentEntry.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void updateContentEntryInActive(final long contentEntryUid, final boolean ceInactive,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryInActive.acquire();
    int _argIndex = 1;
    final int _tmp = ceInactive ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, contentEntryUid);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateContentEntryInActive.release(_stmt);
    }
  }

  @Override
  public void updateContentEntryContentFlag(final int contentFlag, final long contentEntryUid,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryContentFlag.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, contentFlag);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, contentEntryUid);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateContentEntryContentFlag.release(_stmt);
    }
  }

  @Override
  public Object findByUidAsync(final long entryUid,
      final Continuation<? super ContentEntry> $completion) {
    final String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      @Nullable
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findEntryWithLanguageByEntryIdAsync(final long entryUuid,
      final Continuation<? super ContentEntryAndLanguage> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, Language.* \n"
            + "          FROM ContentEntry \n"
            + "               LEFT JOIN Language \n"
            + "                         ON Language.langUid = ContentEntry.primaryLanguageUid\n"
            + "         WHERE ContentEntry.contentEntryUid=?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryAndLanguage>() {
      @Override
      @Nullable
      public ContentEntryAndLanguage call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final ContentEntryAndLanguage _result;
          if (_cursor.moveToFirst()) {
            final ContentEntry _tmpContentEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpContentEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpContentEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpContentEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpContentEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpContentEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpContentEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpContentEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpContentEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpContentEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpContentEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp != 0;
              _tmpContentEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_1 != 0;
              _tmpContentEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_2 != 0;
              _tmpContentEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpContentEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpContentEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpContentEntry = null;
            }
            final Language _tmpLanguage;
            if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp_3 != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            } else {
              _tmpLanguage = null;
            }
            _result = new ContentEntryAndLanguage(_tmpContentEntry,_tmpLanguage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidWithEditDetails(final long uid,
      final Continuation<? super ContentEntryAndPicture> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, ContentEntryPicture2.*\n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN ContentEntryPicture2 \n"
            + "                         ON ContentEntryPicture2.cepUid = ?\n"
            + "         WHERE ContentEntry.contentEntryUid = ?                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryAndPicture>() {
      @Override
      @Nullable
      public ContentEntryAndPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepLct");
          final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepPictureUri");
          final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepThumbnailUri");
          final ContentEntryAndPicture _result;
          if (_cursor.moveToFirst()) {
            final ContentEntry _tmpEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp != 0;
              _tmpEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_1 != 0;
              _tmpEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_2 != 0;
              _tmpEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpEntry = null;
            }
            final ContentEntryPicture2 _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
              final long _tmpCepUid;
              _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
              final long _tmpCepLct;
              _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
              final String _tmpCepPictureUri;
              if (_cursor.isNull(_cursorIndexOfCepPictureUri)) {
                _tmpCepPictureUri = null;
              } else {
                _tmpCepPictureUri = _cursor.getString(_cursorIndexOfCepPictureUri);
              }
              final String _tmpCepThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
                _tmpCepThumbnailUri = null;
              } else {
                _tmpCepThumbnailUri = _cursor.getString(_cursorIndexOfCepThumbnailUri);
              }
              _tmpPicture = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
            } else {
              _tmpPicture = null;
            }
            _result = new ContentEntryAndPicture(_tmpEntry,_tmpPicture);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ContentEntryAndDetail> findByContentEntryUidWithDetailsAsFlow(
      final long contentEntryUid, final long clazzUid, final long courseBlockUid,
      final long accountPersonUid) {
    final String _sql = "\n"
            + "              -- When the user is viewing ContentEntryDetail where the class is specified eg \n"
            + "              -- for a ContentEntry that is part of a Clazz then results information will only be\n"
            + "              -- included if the user is a student in the class\n"
            + "              -- If the user is viewing the ContentEntryDetail via the library then the results\n"
            + "              -- information will always be included\n"
            + "              WITH IncludeResults(includeResults) AS (\n"
            + "                   SELECT CAST(\n"
            + "                      (SELECT (? = 0)\n"
            + "                           OR (\n"
            + "        (SELECT EXISTS(\n"
            + "                SELECT 1\n"
            + "                  FROM ClazzEnrolment\n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n"
            + "    )\n"
            + "                      ) AS INTEGER)\n"
            + "                  )\n"
            + "\n"
            + "              SELECT ContentEntry.*, ContentEntryVersion.*, ContentEntryPicture2.*,\n"
            + "                   ? AS sPersonUid,\n"
            + "                   ? AS sCbUid,\n"
            + "                   \n"
            + "                   (SELECT MAX(StatementEntity.extensionProgress)\n"
            + "                     FROM StatementEntity\n"
            + "                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                      AND StatementEntity.statementActorPersonUid = ?\n"
            + "                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "                   ) AS sProgress,\n"
            + "                   (SELECT CASE\n"
            + "                       -- If a successful completion statement exists, then count as success\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n"
            + "    )))\n"
            + "                            THEN 1\n"
            + "                       -- Else if no success record exists, however a fail record exists, mark as failed\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n"
            + "    )))\n"
            + "                            THEN 0\n"
            + "                            \n"
            + "                       ELSE NULL\n"
            + "                       END                    \n"
            + "                   ) AS sIsSuccess,\n"
            + "                   (SELECT EXISTS(\n"
            + "                           SELECT 1\n"
            + "                             FROM StatementEntity\n"
            + "                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                              AND StatementEntity.statementActorPersonUid = ?\n"
            + "                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n"
            + "                   ) AS sIsCompleted,\n"
            + "                   (SELECT MAX(StatementEntity.resultScoreScaled)\n"
            + "                      FROM StatementEntity\n"
            + "                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                   ) AS sScoreScaled\n"
            + "    \n"
            + "              FROM ContentEntry\n"
            + "                   LEFT JOIN ContentEntryVersion\n"
            + "                             ON ContentEntryVersion.cevUid = \n"
            + "                             (SELECT ContentEntryVersion.cevUid\n"
            + "                                FROM ContentEntryVersion\n"
            + "                               WHERE ContentEntryVersion.cevContentEntryUid = ?\n"
            + "                                 AND CAST(cevInActive AS INTEGER) = 0\n"
            + "                            ORDER BY ContentEntryVersion.cevLct DESC\n"
            + "                              LIMIT 1)\n"
            + "                   LEFT JOIN ContentEntryPicture2\n"
            + "                             ON ContentEntryPicture2.cepUid = ?   \n"
            + "             WHERE ContentEntry.contentEntryUid = ?\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 13);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, courseBlockUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, contentEntryUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment", "StatementEntity",
        "ContentEntry", "ContentEntryVersion",
        "ContentEntryPicture2"}, new Callable<ContentEntryAndDetail>() {
      @Override
      @Nullable
      public ContentEntryAndDetail call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevUid");
          final int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentEntryUid");
          final int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOpenUri");
          final int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "cevContentType");
          final int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cevManifestUrl");
          final int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevSize");
          final int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cevInActive");
          final int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLastModified");
          final int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cevLct");
          final int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevStorageSize");
          final int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cevOriginalSize");
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepLct");
          final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepPictureUri");
          final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepThumbnailUri");
          final int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sPersonUid");
          final int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sCbUid");
          final int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "sProgress");
          final int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "sIsSuccess");
          final int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "sIsCompleted");
          final int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "sScoreScaled");
          final ContentEntryAndDetail _result;
          if (_cursor.moveToFirst()) {
            final ContentEntry _tmpEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp != 0;
              _tmpEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_1 != 0;
              _tmpEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_2 != 0;
              _tmpEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpEntry = null;
            }
            final ContentEntryVersion _tmpLatestVersion;
            if (!(_cursor.isNull(_cursorIndexOfCevUid) && _cursor.isNull(_cursorIndexOfCevContentEntryUid) && _cursor.isNull(_cursorIndexOfCevOpenUri) && _cursor.isNull(_cursorIndexOfCevContentType) && _cursor.isNull(_cursorIndexOfCevManifestUrl) && _cursor.isNull(_cursorIndexOfCevSize) && _cursor.isNull(_cursorIndexOfCevInActive) && _cursor.isNull(_cursorIndexOfCevLastModified) && _cursor.isNull(_cursorIndexOfCevLct) && _cursor.isNull(_cursorIndexOfCevStorageSize) && _cursor.isNull(_cursorIndexOfCevOriginalSize))) {
              final long _tmpCevUid;
              _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
              final long _tmpCevContentEntryUid;
              _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
              final String _tmpCevOpenUri;
              if (_cursor.isNull(_cursorIndexOfCevOpenUri)) {
                _tmpCevOpenUri = null;
              } else {
                _tmpCevOpenUri = _cursor.getString(_cursorIndexOfCevOpenUri);
              }
              final String _tmpCevContentType;
              if (_cursor.isNull(_cursorIndexOfCevContentType)) {
                _tmpCevContentType = null;
              } else {
                _tmpCevContentType = _cursor.getString(_cursorIndexOfCevContentType);
              }
              final String _tmpCevManifestUrl;
              if (_cursor.isNull(_cursorIndexOfCevManifestUrl)) {
                _tmpCevManifestUrl = null;
              } else {
                _tmpCevManifestUrl = _cursor.getString(_cursorIndexOfCevManifestUrl);
              }
              final long _tmpCevSize;
              _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
              final boolean _tmpCevInActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCevInActive);
              _tmpCevInActive = _tmp_3 != 0;
              final long _tmpCevLastModified;
              _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
              final long _tmpCevLct;
              _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
              final long _tmpCevStorageSize;
              _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
              final long _tmpCevOriginalSize;
              _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
              _tmpLatestVersion = new ContentEntryVersion(_tmpCevUid,_tmpCevContentEntryUid,_tmpCevOpenUri,_tmpCevContentType,_tmpCevManifestUrl,_tmpCevSize,_tmpCevInActive,_tmpCevLastModified,_tmpCevLct,_tmpCevStorageSize,_tmpCevOriginalSize);
            } else {
              _tmpLatestVersion = null;
            }
            final ContentEntryPicture2 _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
              final long _tmpCepUid;
              _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
              final long _tmpCepLct;
              _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
              final String _tmpCepPictureUri;
              if (_cursor.isNull(_cursorIndexOfCepPictureUri)) {
                _tmpCepPictureUri = null;
              } else {
                _tmpCepPictureUri = _cursor.getString(_cursorIndexOfCepPictureUri);
              }
              final String _tmpCepThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
                _tmpCepThumbnailUri = null;
              } else {
                _tmpCepThumbnailUri = _cursor.getString(_cursorIndexOfCepThumbnailUri);
              }
              _tmpPicture = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
            } else {
              _tmpPicture = null;
            }
            final BlockStatus _tmpStatus;
            if (!(_cursor.isNull(_cursorIndexOfSPersonUid) && _cursor.isNull(_cursorIndexOfSCbUid) && _cursor.isNull(_cursorIndexOfSProgress) && _cursor.isNull(_cursorIndexOfSIsSuccess) && _cursor.isNull(_cursorIndexOfSIsCompleted) && _cursor.isNull(_cursorIndexOfSScoreScaled))) {
              final long _tmpSPersonUid;
              _tmpSPersonUid = _cursor.getLong(_cursorIndexOfSPersonUid);
              final long _tmpSCbUid;
              _tmpSCbUid = _cursor.getLong(_cursorIndexOfSCbUid);
              final Integer _tmpSProgress;
              if (_cursor.isNull(_cursorIndexOfSProgress)) {
                _tmpSProgress = null;
              } else {
                _tmpSProgress = _cursor.getInt(_cursorIndexOfSProgress);
              }
              final Boolean _tmpSIsSuccess;
              final Integer _tmp_4;
              if (_cursor.isNull(_cursorIndexOfSIsSuccess)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getInt(_cursorIndexOfSIsSuccess);
              }
              _tmpSIsSuccess = _tmp_4 == null ? null : _tmp_4 != 0;
              final boolean _tmpSIsCompleted;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfSIsCompleted);
              _tmpSIsCompleted = _tmp_5 != 0;
              final Float _tmpSScoreScaled;
              if (_cursor.isNull(_cursorIndexOfSScoreScaled)) {
                _tmpSScoreScaled = null;
              } else {
                _tmpSScoreScaled = _cursor.getFloat(_cursorIndexOfSScoreScaled);
              }
              _tmpStatus = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
            } else {
              _tmpStatus = null;
            }
            _result = new ContentEntryAndDetail(_tmpEntry,_tmpLatestVersion,_tmpPicture,_tmpStatus);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public ContentEntry findBySourceUrl(final String sourceUrl) {
    final String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, sourceUrl);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final ContentEntry _result;
      if (_cursor.moveToFirst()) {
        _result = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _result.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _result.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _result.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _result.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _result.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _result.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _result.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _result.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _result.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _result.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _result.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _result.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _result.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _result.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _result.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _result.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _result.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _result.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _result.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _result.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _result.setContentOwner(_tmpContentOwner);
        final int _tmpContentOwnerType;
        _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
        _result.setContentOwnerType(_tmpContentOwnerType);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _result.setContentEntryLct(_tmpContentEntryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findTitleByUidAsync(final long entryUid,
      final Continuation<? super String> $completion) {
    final String _sql = "SELECT title FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, ContentEntry> getChildrenByParentUid(final long parentUid) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    return new LimitOffsetPagingSource<ContentEntry>(_statement, __db, "ContentEntry", "ContentEntryParentChildJoin") {
      @Override
      @NonNull
      protected List<ContentEntry> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
        final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
        final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
        final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
        final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
        final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
        final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
        final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
        final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
        final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
        final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
        final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
        final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
        final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
        final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
        final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
        final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
        final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
        final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
        final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
        final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
        final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
        final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwnerType");
        final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
        final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
        final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
        final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
        final List<ContentEntry> _result = new ArrayList<ContentEntry>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ContentEntry _item;
          _item = new ContentEntry();
          final long _tmpContentEntryUid;
          _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
          _item.setContentEntryUid(_tmpContentEntryUid);
          final String _tmpTitle;
          if (cursor.isNull(_cursorIndexOfTitle)) {
            _tmpTitle = null;
          } else {
            _tmpTitle = cursor.getString(_cursorIndexOfTitle);
          }
          _item.setTitle(_tmpTitle);
          final String _tmpDescription;
          if (cursor.isNull(_cursorIndexOfDescription)) {
            _tmpDescription = null;
          } else {
            _tmpDescription = cursor.getString(_cursorIndexOfDescription);
          }
          _item.setDescription(_tmpDescription);
          final String _tmpEntryId;
          if (cursor.isNull(_cursorIndexOfEntryId)) {
            _tmpEntryId = null;
          } else {
            _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
          }
          _item.setEntryId(_tmpEntryId);
          final String _tmpAuthor;
          if (cursor.isNull(_cursorIndexOfAuthor)) {
            _tmpAuthor = null;
          } else {
            _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
          }
          _item.setAuthor(_tmpAuthor);
          final String _tmpPublisher;
          if (cursor.isNull(_cursorIndexOfPublisher)) {
            _tmpPublisher = null;
          } else {
            _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
          }
          _item.setPublisher(_tmpPublisher);
          final int _tmpLicenseType;
          _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
          _item.setLicenseType(_tmpLicenseType);
          final String _tmpLicenseName;
          if (cursor.isNull(_cursorIndexOfLicenseName)) {
            _tmpLicenseName = null;
          } else {
            _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
          }
          _item.setLicenseName(_tmpLicenseName);
          final String _tmpLicenseUrl;
          if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
            _tmpLicenseUrl = null;
          } else {
            _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
          }
          _item.setLicenseUrl(_tmpLicenseUrl);
          final String _tmpSourceUrl;
          if (cursor.isNull(_cursorIndexOfSourceUrl)) {
            _tmpSourceUrl = null;
          } else {
            _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
          }
          _item.setSourceUrl(_tmpSourceUrl);
          final String _tmpThumbnailUrl;
          if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
            _tmpThumbnailUrl = null;
          } else {
            _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
          }
          _item.setThumbnailUrl(_tmpThumbnailUrl);
          final long _tmpLastModified;
          _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
          _item.setLastModified(_tmpLastModified);
          final long _tmpPrimaryLanguageUid;
          _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
          _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
          final long _tmpLanguageVariantUid;
          _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
          _item.setLanguageVariantUid(_tmpLanguageVariantUid);
          final int _tmpContentFlags;
          _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
          _item.setContentFlags(_tmpContentFlags);
          final boolean _tmpLeaf;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfLeaf);
          _tmpLeaf = _tmp != 0;
          _item.setLeaf(_tmpLeaf);
          final boolean _tmpPublik;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
          _tmpPublik = _tmp_1 != 0;
          _item.setPublik(_tmpPublik);
          final boolean _tmpCeInactive;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
          _tmpCeInactive = _tmp_2 != 0;
          _item.setCeInactive(_tmpCeInactive);
          final int _tmpCompletionCriteria;
          _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
          _item.setCompletionCriteria(_tmpCompletionCriteria);
          final int _tmpMinScore;
          _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
          _item.setMinScore(_tmpMinScore);
          final int _tmpContentTypeFlag;
          _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
          _item.setContentTypeFlag(_tmpContentTypeFlag);
          final long _tmpContentOwner;
          _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
          _item.setContentOwner(_tmpContentOwner);
          final int _tmpContentOwnerType;
          _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
          _item.setContentOwnerType(_tmpContentOwnerType);
          final long _tmpContentEntryLocalChangeSeqNum;
          _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
          _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
          final long _tmpContentEntryMasterChangeSeqNum;
          _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
          _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
          final int _tmpContentEntryLastChangedBy;
          _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
          _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
          final long _tmpContentEntryLct;
          _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
          _item.setContentEntryLct(_tmpContentEntryLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object getChildrenByParentAsync(final long parentUid,
      final Continuation<? super List<? extends ContentEntry>> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*\n"
            + "          FROM ContentEntryParentChildJoin\n"
            + "               JOIN ContentEntry \n"
            + "                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n"
            + "         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      @NonNull
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _item.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getCountNumberOfChildrenByParentUUidAsync(final long parentUid,
      final Continuation<? super Integer> $completion) {
    final String _sql = "SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getContentByUuidAsync(final long parentUid,
      final Continuation<? super ContentEntry> $completion) {
    final String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      @Nullable
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllLanguageRelatedEntriesAsync(final long entryUuid,
      final Continuation<? super List<? extends ContentEntry>> $completion) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      @NonNull
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _item.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidWithLanguageAsync(final long uid,
      final Continuation<? super ContentEntryWithLanguage> $completion) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, Language.*\n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN Language \n"
            + "                      ON Language.langUid = ContentEntry.primaryLanguageUid \n"
            + "         WHERE ContentEntry.contentEntryUid = ?              \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryWithLanguage>() {
      @Override
      @Nullable
      public ContentEntryWithLanguage call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final ContentEntryWithLanguage _result;
          if (_cursor.moveToFirst()) {
            final Language _tmpLanguage;
            if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            } else {
              _tmpLanguage = null;
            }
            _result = new ContentEntryWithLanguage();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setLanguage(_tmpLanguage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public ContentEntry findByUid(final long entryUid) {
    final String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final ContentEntry _result;
      if (_cursor.moveToFirst()) {
        _result = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _result.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _result.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _result.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _result.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _result.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _result.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _result.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _result.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _result.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _result.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _result.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _result.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _result.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _result.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _result.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _result.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _result.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _result.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _result.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _result.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _result.setContentOwner(_tmpContentOwner);
        final int _tmpContentOwnerType;
        _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
        _result.setContentOwnerType(_tmpContentOwnerType);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _result.setContentEntryLct(_tmpContentEntryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<ContentEntry> findByTitle(final String title) {
    final String _sql = "SELECT * FROM ContentEntry WHERE title = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, title);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ContentEntry"}, new Callable<ContentEntry>() {
      @Override
      @Nullable
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findBySourceUrlWithContentEntryStatusAsync(final String sourceUrl,
      final Continuation<? super ContentEntry> $completion) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, sourceUrl);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      @Nullable
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, ContentEntryAndListDetail> getChildrenByParentUidWithCategoryFilterOrderByName(
      final long accountPersonUid, final long parentUid, final long langParam,
      final long categoryParam0, final int sortOrder, final boolean includeDeleted) {
    final String _sql = "\n"
            + "            WITH IncludeResults(includeResults) AS (SELECT 1)\n"
            + "            \n"
            + "            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n"
            + "                   \n"
            + "               ? AS sPersonUid,\n"
            + "               0 AS sCbUid,\n"
            + "               \n"
            + "                   (SELECT MAX(StatementEntity.extensionProgress)\n"
            + "                     FROM StatementEntity\n"
            + "                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                      AND StatementEntity.statementActorPersonUid = ?\n"
            + "                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "                   ) AS sProgress,\n"
            + "                   (SELECT CASE\n"
            + "                       -- If a successful completion statement exists, then count as success\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n"
            + "    )))\n"
            + "                            THEN 1\n"
            + "                       -- Else if no success record exists, however a fail record exists, mark as failed\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n"
            + "    )))\n"
            + "                            THEN 0\n"
            + "                            \n"
            + "                       ELSE NULL\n"
            + "                       END                    \n"
            + "                   ) AS sIsSuccess,\n"
            + "                   (SELECT EXISTS(\n"
            + "                           SELECT 1\n"
            + "                             FROM StatementEntity\n"
            + "                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                              AND StatementEntity.statementActorPersonUid = ?\n"
            + "                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n"
            + "                   ) AS sIsCompleted,\n"
            + "                   (SELECT MAX(StatementEntity.resultScoreScaled)\n"
            + "                      FROM StatementEntity\n"
            + "                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                   ) AS sScoreScaled\n"
            + "    \n"
            + "    \n"
            + "              FROM ContentEntry \n"
            + "                    LEFT JOIN ContentEntryParentChildJoin \n"
            + "                         ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                    LEFT JOIN ContentEntryPicture2\n"
            + "                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n"
            + "             WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? \n"
            + "               AND (? = 0 OR ContentEntry.primaryLanguageUid = ?)\n"
            + "               AND (? = 0 OR ? \n"
            + "                    IN (SELECT ceccjContentCategoryUid \n"
            + "                          FROM ContentEntryContentCategoryJoin \n"
            + "                         WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n"
            + "               AND (CAST(? AS INTEGER) = 1 OR CAST(ContentEntryParentChildJoin.cepcjDeleted AS INTEGER) = 0)          \n"
            + "            ORDER BY ContentEntryParentChildJoin.childIndex,\n"
            + "                     CASE(?)\n"
            + "                     WHEN 1 THEN ContentEntry.title\n"
            + "                     ELSE ''\n"
            + "                     END ASC,\n"
            + "                     CASE(?)\n"
            + "                     WHEN 2 THEN ContentEntry.title\n"
            + "                     ELSE ''\n"
            + "                     END DESC,             \n"
            + "                     ContentEntry.contentEntryUid";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 14);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, parentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, langParam);
    _argIndex = 9;
    _statement.bindLong(_argIndex, langParam);
    _argIndex = 10;
    _statement.bindLong(_argIndex, categoryParam0);
    _argIndex = 11;
    _statement.bindLong(_argIndex, categoryParam0);
    _argIndex = 12;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 13;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 14;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, __db, "StatementEntity", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2", "ContentEntryContentCategoryJoin") {
      @Override
      @NonNull
      protected List<ContentEntryAndListDetail> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
        final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
        final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
        final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
        final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
        final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
        final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
        final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
        final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
        final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
        final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
        final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
        final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
        final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
        final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
        final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
        final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
        final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
        final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
        final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
        final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
        final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
        final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwnerType");
        final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
        final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
        final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
        final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
        final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
        final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
        final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
        final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
        final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
        final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
        final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
        final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
        final int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjDeleted");
        final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepUid");
        final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepLct");
        final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepPictureUri");
        final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepThumbnailUri");
        final int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "sPersonUid");
        final int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow(cursor, "sCbUid");
        final int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow(cursor, "sProgress");
        final int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "sIsSuccess");
        final int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow(cursor, "sIsCompleted");
        final int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow(cursor, "sScoreScaled");
        final List<ContentEntryAndListDetail> _result = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ContentEntryAndListDetail _item;
          final ContentEntry _tmpContentEntry;
          if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
            _tmpContentEntry = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = cursor.getString(_cursorIndexOfTitle);
            }
            _tmpContentEntry.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = cursor.getString(_cursorIndexOfDescription);
            }
            _tmpContentEntry.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
            }
            _tmpContentEntry.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
            }
            _tmpContentEntry.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
            }
            _tmpContentEntry.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
            _tmpContentEntry.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
            }
            _tmpContentEntry.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
            }
            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
            _tmpContentEntry.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
            _tmpContentEntry.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _tmpContentEntry.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _tmpContentEntry.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _tmpContentEntry.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
            _tmpContentEntry.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
            _tmpContentEntry.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _tmpContentEntry = null;
          }
          final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
          if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
            final long _tmpCepcjParentContentEntryUid;
            _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
            final long _tmpCepcjChildContentEntryUid;
            _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
            final int _tmpChildIndex;
            _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
            _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
            final long _tmpCepcjUid;
            _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
            _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
            final long _tmpCepcjLocalChangeSeqNum;
            _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
            final long _tmpCepcjMasterChangeSeqNum;
            _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
            final int _tmpCepcjLastChangedBy;
            _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
            _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
            final long _tmpCepcjLct;
            _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
            _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
            final boolean _tmpCepcjDeleted;
            final int _tmp_4;
            _tmp_4 = cursor.getInt(_cursorIndexOfCepcjDeleted);
            _tmpCepcjDeleted = _tmp_4 != 0;
            _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
          } else {
            _tmpContentEntryParentChildJoin = null;
          }
          final ContentEntryPicture2 _tmpPicture;
          if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
            final long _tmpCepUid;
            _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
            final long _tmpCepLct;
            _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
            final String _tmpCepPictureUri;
            if (cursor.isNull(_cursorIndexOfCepPictureUri)) {
              _tmpCepPictureUri = null;
            } else {
              _tmpCepPictureUri = cursor.getString(_cursorIndexOfCepPictureUri);
            }
            final String _tmpCepThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
              _tmpCepThumbnailUri = null;
            } else {
              _tmpCepThumbnailUri = cursor.getString(_cursorIndexOfCepThumbnailUri);
            }
            _tmpPicture = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
          } else {
            _tmpPicture = null;
          }
          final BlockStatus _tmpStatus;
          if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
            final long _tmpSPersonUid;
            _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
            final long _tmpSCbUid;
            _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
            final Integer _tmpSProgress;
            if (cursor.isNull(_cursorIndexOfSProgress)) {
              _tmpSProgress = null;
            } else {
              _tmpSProgress = cursor.getInt(_cursorIndexOfSProgress);
            }
            final Boolean _tmpSIsSuccess;
            final Integer _tmp_5;
            if (cursor.isNull(_cursorIndexOfSIsSuccess)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = cursor.getInt(_cursorIndexOfSIsSuccess);
            }
            _tmpSIsSuccess = _tmp_5 == null ? null : _tmp_5 != 0;
            final boolean _tmpSIsCompleted;
            final int _tmp_6;
            _tmp_6 = cursor.getInt(_cursorIndexOfSIsCompleted);
            _tmpSIsCompleted = _tmp_6 != 0;
            final Float _tmpSScoreScaled;
            if (cursor.isNull(_cursorIndexOfSScoreScaled)) {
              _tmpSScoreScaled = null;
            } else {
              _tmpSScoreScaled = cursor.getFloat(_cursorIndexOfSScoreScaled);
            }
            _tmpStatus = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
          } else {
            _tmpStatus = null;
          }
          _item = new ContentEntryAndListDetail(_tmpContentEntry,_tmpPicture,_tmpContentEntryParentChildJoin,_tmpStatus);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public PagingSource<Integer, ContentEntryAndListDetail> getContentFromMyCourses(
      final long accountPersonUid) {
    final String _sql = "\n"
            + "        WITH IncludeResults(includeResults) AS (SELECT 1)\n"
            + "        \n"
            + "        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n"
            + "               \n"
            + "               ? AS sPersonUid,\n"
            + "               0 AS sCbUid,\n"
            + "               \n"
            + "                   (SELECT MAX(StatementEntity.extensionProgress)\n"
            + "                     FROM StatementEntity\n"
            + "                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                      AND StatementEntity.statementActorPersonUid = ?\n"
            + "                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "                   ) AS sProgress,\n"
            + "                   (SELECT CASE\n"
            + "                       -- If a successful completion statement exists, then count as success\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n"
            + "    )))\n"
            + "                            THEN 1\n"
            + "                       -- Else if no success record exists, however a fail record exists, mark as failed\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n"
            + "    )))\n"
            + "                            THEN 0\n"
            + "                            \n"
            + "                       ELSE NULL\n"
            + "                       END                    \n"
            + "                   ) AS sIsSuccess,\n"
            + "                   (SELECT EXISTS(\n"
            + "                           SELECT 1\n"
            + "                             FROM StatementEntity\n"
            + "                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                              AND StatementEntity.statementActorPersonUid = ?\n"
            + "                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n"
            + "                   ) AS sIsCompleted,\n"
            + "                   (SELECT MAX(StatementEntity.resultScoreScaled)\n"
            + "                      FROM StatementEntity\n"
            + "                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                   ) AS sScoreScaled\n"
            + "    \n"
            + "    \n"
            + "          FROM CourseBlock\n"
            + "               JOIN ContentEntry \n"
            + "                    ON CourseBlock.cbType = 104\n"
            + "                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n"
            + "               LEFT JOIN ContentEntryParentChildJoin\n"
            + "                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n"
            + "               LEFT JOIN ContentEntryPicture2\n"
            + "                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid          \n"
            + "         WHERE CourseBlock.cbClazzUid IN\n"
            + "               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "                  FROM ClazzEnrolment\n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, __db, "StatementEntity", "CourseBlock", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2", "ClazzEnrolment") {
      @Override
      @NonNull
      protected List<ContentEntryAndListDetail> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
        final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
        final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
        final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
        final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
        final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
        final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
        final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
        final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
        final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
        final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
        final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
        final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
        final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
        final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
        final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
        final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
        final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
        final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
        final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
        final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
        final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
        final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwnerType");
        final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
        final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
        final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
        final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
        final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
        final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
        final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
        final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
        final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
        final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
        final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
        final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
        final int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjDeleted");
        final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepUid");
        final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepLct");
        final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepPictureUri");
        final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepThumbnailUri");
        final int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "sPersonUid");
        final int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow(cursor, "sCbUid");
        final int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow(cursor, "sProgress");
        final int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "sIsSuccess");
        final int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow(cursor, "sIsCompleted");
        final int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow(cursor, "sScoreScaled");
        final List<ContentEntryAndListDetail> _result = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ContentEntryAndListDetail _item;
          final ContentEntry _tmpContentEntry;
          if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
            _tmpContentEntry = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = cursor.getString(_cursorIndexOfTitle);
            }
            _tmpContentEntry.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = cursor.getString(_cursorIndexOfDescription);
            }
            _tmpContentEntry.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
            }
            _tmpContentEntry.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
            }
            _tmpContentEntry.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
            }
            _tmpContentEntry.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
            _tmpContentEntry.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
            }
            _tmpContentEntry.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
            }
            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
            _tmpContentEntry.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
            _tmpContentEntry.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _tmpContentEntry.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _tmpContentEntry.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _tmpContentEntry.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
            _tmpContentEntry.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
            _tmpContentEntry.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _tmpContentEntry = null;
          }
          final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
          if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
            final long _tmpCepcjParentContentEntryUid;
            _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
            final long _tmpCepcjChildContentEntryUid;
            _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
            final int _tmpChildIndex;
            _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
            _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
            final long _tmpCepcjUid;
            _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
            _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
            final long _tmpCepcjLocalChangeSeqNum;
            _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
            final long _tmpCepcjMasterChangeSeqNum;
            _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
            final int _tmpCepcjLastChangedBy;
            _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
            _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
            final long _tmpCepcjLct;
            _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
            _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
            final boolean _tmpCepcjDeleted;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfCepcjDeleted);
            _tmpCepcjDeleted = _tmp_3 != 0;
            _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
          } else {
            _tmpContentEntryParentChildJoin = null;
          }
          final ContentEntryPicture2 _tmpPicture;
          if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
            final long _tmpCepUid;
            _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
            final long _tmpCepLct;
            _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
            final String _tmpCepPictureUri;
            if (cursor.isNull(_cursorIndexOfCepPictureUri)) {
              _tmpCepPictureUri = null;
            } else {
              _tmpCepPictureUri = cursor.getString(_cursorIndexOfCepPictureUri);
            }
            final String _tmpCepThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
              _tmpCepThumbnailUri = null;
            } else {
              _tmpCepThumbnailUri = cursor.getString(_cursorIndexOfCepThumbnailUri);
            }
            _tmpPicture = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
          } else {
            _tmpPicture = null;
          }
          final BlockStatus _tmpStatus;
          if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
            final long _tmpSPersonUid;
            _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
            final long _tmpSCbUid;
            _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
            final Integer _tmpSProgress;
            if (cursor.isNull(_cursorIndexOfSProgress)) {
              _tmpSProgress = null;
            } else {
              _tmpSProgress = cursor.getInt(_cursorIndexOfSProgress);
            }
            final Boolean _tmpSIsSuccess;
            final Integer _tmp_4;
            if (cursor.isNull(_cursorIndexOfSIsSuccess)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = cursor.getInt(_cursorIndexOfSIsSuccess);
            }
            _tmpSIsSuccess = _tmp_4 == null ? null : _tmp_4 != 0;
            final boolean _tmpSIsCompleted;
            final int _tmp_5;
            _tmp_5 = cursor.getInt(_cursorIndexOfSIsCompleted);
            _tmpSIsCompleted = _tmp_5 != 0;
            final Float _tmpSScoreScaled;
            if (cursor.isNull(_cursorIndexOfSScoreScaled)) {
              _tmpSScoreScaled = null;
            } else {
              _tmpSScoreScaled = cursor.getFloat(_cursorIndexOfSScoreScaled);
            }
            _tmpStatus = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
          } else {
            _tmpStatus = null;
          }
          _item = new ContentEntryAndListDetail(_tmpContentEntry,_tmpPicture,_tmpContentEntryParentChildJoin,_tmpStatus);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public PagingSource<Integer, ContentEntryAndListDetail> getContentByOwner(
      final long accountPersonUid) {
    final String _sql = "\n"
            + "        WITH IncludeResults(includeResults) AS (SELECT 1)\n"
            + "        \n"
            + "        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*, \n"
            + "               \n"
            + "               ? AS sPersonUid,\n"
            + "               0 AS sCbUid,\n"
            + "               \n"
            + "                   (SELECT MAX(StatementEntity.extensionProgress)\n"
            + "                     FROM StatementEntity\n"
            + "                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                      AND StatementEntity.statementActorPersonUid = ?\n"
            + "                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "                   ) AS sProgress,\n"
            + "                   (SELECT CASE\n"
            + "                       -- If a successful completion statement exists, then count as success\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n"
            + "    )))\n"
            + "                            THEN 1\n"
            + "                       -- Else if no success record exists, however a fail record exists, mark as failed\n"
            + "                       WHEN (SELECT EXISTS(\n"
            + "                                    SELECT 1\n"
            + "                                      FROM StatementEntity\n"
            + "                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       AND (\n"
            + "              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n"
            + "    )))\n"
            + "                            THEN 0\n"
            + "                            \n"
            + "                       ELSE NULL\n"
            + "                       END                    \n"
            + "                   ) AS sIsSuccess,\n"
            + "                   (SELECT EXISTS(\n"
            + "                           SELECT 1\n"
            + "                             FROM StatementEntity\n"
            + "                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                              AND StatementEntity.statementActorPersonUid = ?\n"
            + "                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n"
            + "                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n"
            + "                   ) AS sIsCompleted,\n"
            + "                   (SELECT MAX(StatementEntity.resultScoreScaled)\n"
            + "                      FROM StatementEntity\n"
            + "                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n"
            + "                       AND StatementEntity.statementActorPersonUid = ?\n"
            + "                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                   ) AS sScoreScaled\n"
            + "    \n"
            + "    \n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN ContentEntryParentChildJoin\n"
            + "                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n"
            + "               LEFT JOIN ContentEntryPicture2\n"
            + "                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n"
            + "         WHERE ContentEntry.contentOwner = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, __db, "StatementEntity", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2") {
      @Override
      @NonNull
      protected List<ContentEntryAndListDetail> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
        final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
        final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
        final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
        final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
        final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
        final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
        final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
        final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
        final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
        final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
        final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
        final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
        final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
        final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
        final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
        final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
        final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
        final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
        final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
        final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
        final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
        final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwnerType");
        final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
        final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
        final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
        final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
        final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
        final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
        final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
        final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
        final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
        final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
        final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
        final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
        final int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjDeleted");
        final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepUid");
        final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepLct");
        final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepPictureUri");
        final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepThumbnailUri");
        final int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "sPersonUid");
        final int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow(cursor, "sCbUid");
        final int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow(cursor, "sProgress");
        final int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "sIsSuccess");
        final int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow(cursor, "sIsCompleted");
        final int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow(cursor, "sScoreScaled");
        final List<ContentEntryAndListDetail> _result = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ContentEntryAndListDetail _item;
          final ContentEntry _tmpContentEntry;
          if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
            _tmpContentEntry = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = cursor.getString(_cursorIndexOfTitle);
            }
            _tmpContentEntry.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = cursor.getString(_cursorIndexOfDescription);
            }
            _tmpContentEntry.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
            }
            _tmpContentEntry.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
            }
            _tmpContentEntry.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
            }
            _tmpContentEntry.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
            _tmpContentEntry.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
            }
            _tmpContentEntry.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
            }
            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
            _tmpContentEntry.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
            _tmpContentEntry.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _tmpContentEntry.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _tmpContentEntry.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _tmpContentEntry.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
            _tmpContentEntry.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
            _tmpContentEntry.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _tmpContentEntry = null;
          }
          final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
          if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
            final long _tmpCepcjParentContentEntryUid;
            _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
            final long _tmpCepcjChildContentEntryUid;
            _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
            final int _tmpChildIndex;
            _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
            _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
            final long _tmpCepcjUid;
            _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
            _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
            final long _tmpCepcjLocalChangeSeqNum;
            _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
            final long _tmpCepcjMasterChangeSeqNum;
            _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
            _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
            final int _tmpCepcjLastChangedBy;
            _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
            _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
            final long _tmpCepcjLct;
            _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
            _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
            final boolean _tmpCepcjDeleted;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfCepcjDeleted);
            _tmpCepcjDeleted = _tmp_3 != 0;
            _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
          } else {
            _tmpContentEntryParentChildJoin = null;
          }
          final ContentEntryPicture2 _tmpPicture;
          if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
            final long _tmpCepUid;
            _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
            final long _tmpCepLct;
            _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
            final String _tmpCepPictureUri;
            if (cursor.isNull(_cursorIndexOfCepPictureUri)) {
              _tmpCepPictureUri = null;
            } else {
              _tmpCepPictureUri = cursor.getString(_cursorIndexOfCepPictureUri);
            }
            final String _tmpCepThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
              _tmpCepThumbnailUri = null;
            } else {
              _tmpCepThumbnailUri = cursor.getString(_cursorIndexOfCepThumbnailUri);
            }
            _tmpPicture = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
          } else {
            _tmpPicture = null;
          }
          final BlockStatus _tmpStatus;
          if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
            final long _tmpSPersonUid;
            _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
            final long _tmpSCbUid;
            _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
            final Integer _tmpSProgress;
            if (cursor.isNull(_cursorIndexOfSProgress)) {
              _tmpSProgress = null;
            } else {
              _tmpSProgress = cursor.getInt(_cursorIndexOfSProgress);
            }
            final Boolean _tmpSIsSuccess;
            final Integer _tmp_4;
            if (cursor.isNull(_cursorIndexOfSIsSuccess)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = cursor.getInt(_cursorIndexOfSIsSuccess);
            }
            _tmpSIsSuccess = _tmp_4 == null ? null : _tmp_4 != 0;
            final boolean _tmpSIsCompleted;
            final int _tmp_5;
            _tmp_5 = cursor.getInt(_cursorIndexOfSIsCompleted);
            _tmpSIsCompleted = _tmp_5 != 0;
            final Float _tmpSScoreScaled;
            if (cursor.isNull(_cursorIndexOfSScoreScaled)) {
              _tmpSScoreScaled = null;
            } else {
              _tmpSScoreScaled = cursor.getFloat(_cursorIndexOfSScoreScaled);
            }
            _tmpStatus = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
          } else {
            _tmpStatus = null;
          }
          _item = new ContentEntryAndListDetail(_tmpContentEntry,_tmpPicture,_tmpContentEntryParentChildJoin,_tmpStatus);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<ContentEntry> getChildrenByAll(final long parentUid) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ContentEntry _item;
        _item = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _item.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _item.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _item.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _item.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _item.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _item.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _item.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _item.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _item.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _item.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _item.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _item.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _item.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _item.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _item.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _item.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _item.setContentOwner(_tmpContentOwner);
        final int _tmpContentOwnerType;
        _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
        _item.setContentOwnerType(_tmpContentOwnerType);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _item.setContentEntryLct(_tmpContentEntryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<ContentEntry> findLiveContentEntry(final long parentUid) {
    final String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ContentEntry"}, new Callable<ContentEntry>() {
      @Override
      @Nullable
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if (_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
            _result.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public long getContentEntryUidFromXapiObjectId(final String objectId) {
    final String _sql = "SELECT COALESCE((SELECT contentEntryUid \n"
            + "                                      FROM ContentEntry \n"
            + "                                     WHERE entryId = ? \n"
            + "                                     LIMIT 1),0) AS ID";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, objectId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final long _result;
      if (_cursor.moveToFirst()) {
        _result = _cursor.getLong(0);
      } else {
        _result = 0L;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContentEntry> findSimilarIdEntryForKhan(final String sourceUrl) {
    final String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl LIKE ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, sourceUrl);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ContentEntry _item;
        _item = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _item.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _item.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _item.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _item.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _item.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _item.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _item.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _item.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _item.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _item.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _item.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _item.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _item.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _item.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _item.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _item.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _item.setContentOwner(_tmpContentOwner);
        final int _tmpContentOwnerType;
        _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
        _item.setContentOwnerType(_tmpContentOwnerType);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _item.setContentEntryLct(_tmpContentEntryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getContentEntryFromUids(final List<Long> contentEntryUids,
      final Continuation<? super List<UidAndLabel>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("Select ContentEntry.contentEntryUid AS uid, ContentEntry.title As labelName ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    from ContentEntry WHERE contentEntryUid IN (");
    final int _inputSize = contentEntryUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : contentEntryUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      @NonNull
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
