package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName;
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage;
import com.ustadmobile.lib.db.entities.Language;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryRelatedEntryJoinDao_Impl extends ContentEntryRelatedEntryJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryRelatedEntryJoin> __insertionAdapterOfContentEntryRelatedEntryJoin;

  private final EntityDeletionOrUpdateAdapter<ContentEntryRelatedEntryJoin> __updateAdapterOfContentEntryRelatedEntryJoin;

  public ContentEntryRelatedEntryJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryRelatedEntryJoin = new EntityInsertionAdapter<ContentEntryRelatedEntryJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryRelatedEntryJoin` (`cerejUid`,`cerejContentEntryUid`,`cerejRelatedEntryUid`,`cerejLastChangedBy`,`relType`,`comment`,`cerejRelLanguageUid`,`cerejLocalChangeSeqNum`,`cerejMasterChangeSeqNum`,`cerejLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryRelatedEntryJoin entity) {
        statement.bindLong(1, entity.getCerejUid());
        statement.bindLong(2, entity.getCerejContentEntryUid());
        statement.bindLong(3, entity.getCerejRelatedEntryUid());
        statement.bindLong(4, entity.getCerejLastChangedBy());
        statement.bindLong(5, entity.getRelType());
        if (entity.getComment() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getComment());
        }
        statement.bindLong(7, entity.getCerejRelLanguageUid());
        statement.bindLong(8, entity.getCerejLocalChangeSeqNum());
        statement.bindLong(9, entity.getCerejMasterChangeSeqNum());
        statement.bindLong(10, entity.getCerejLct());
      }
    };
    this.__updateAdapterOfContentEntryRelatedEntryJoin = new EntityDeletionOrUpdateAdapter<ContentEntryRelatedEntryJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContentEntryRelatedEntryJoin` SET `cerejUid` = ?,`cerejContentEntryUid` = ?,`cerejRelatedEntryUid` = ?,`cerejLastChangedBy` = ?,`relType` = ?,`comment` = ?,`cerejRelLanguageUid` = ?,`cerejLocalChangeSeqNum` = ?,`cerejMasterChangeSeqNum` = ?,`cerejLct` = ? WHERE `cerejUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryRelatedEntryJoin entity) {
        statement.bindLong(1, entity.getCerejUid());
        statement.bindLong(2, entity.getCerejContentEntryUid());
        statement.bindLong(3, entity.getCerejRelatedEntryUid());
        statement.bindLong(4, entity.getCerejLastChangedBy());
        statement.bindLong(5, entity.getRelType());
        if (entity.getComment() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getComment());
        }
        statement.bindLong(7, entity.getCerejRelLanguageUid());
        statement.bindLong(8, entity.getCerejLocalChangeSeqNum());
        statement.bindLong(9, entity.getCerejMasterChangeSeqNum());
        statement.bindLong(10, entity.getCerejLct());
        statement.bindLong(11, entity.getCerejUid());
      }
    };
  }

  @Override
  public long insert(final ContentEntryRelatedEntryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfContentEntryRelatedEntryJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryRelatedEntryJoin entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntryRelatedEntryJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ContentEntryRelatedEntryJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryRelatedEntryJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryRelatedEntryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryRelatedEntryJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<ContentEntryRelatedEntryJoin> publicContentEntryRelatedEntryJoins() {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntry ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejUid");
      final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejContentEntryUid");
      final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelatedEntryUid");
      final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLastChangedBy");
      final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(_cursor, "relType");
      final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(_cursor, "comment");
      final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelLanguageUid");
      final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLocalChangeSeqNum");
      final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejMasterChangeSeqNum");
      final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLct");
      final List<ContentEntryRelatedEntryJoin> _result = new ArrayList<ContentEntryRelatedEntryJoin>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ContentEntryRelatedEntryJoin _item;
        _item = new ContentEntryRelatedEntryJoin();
        final long _tmpCerejUid;
        _tmpCerejUid = _cursor.getLong(_cursorIndexOfCerejUid);
        _item.setCerejUid(_tmpCerejUid);
        final long _tmpCerejContentEntryUid;
        _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
        _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
        final long _tmpCerejRelatedEntryUid;
        _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
        _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
        final int _tmpCerejLastChangedBy;
        _tmpCerejLastChangedBy = _cursor.getInt(_cursorIndexOfCerejLastChangedBy);
        _item.setCerejLastChangedBy(_tmpCerejLastChangedBy);
        final int _tmpRelType;
        _tmpRelType = _cursor.getInt(_cursorIndexOfRelType);
        _item.setRelType(_tmpRelType);
        final String _tmpComment;
        if (_cursor.isNull(_cursorIndexOfComment)) {
          _tmpComment = null;
        } else {
          _tmpComment = _cursor.getString(_cursorIndexOfComment);
        }
        _item.setComment(_tmpComment);
        final long _tmpCerejRelLanguageUid;
        _tmpCerejRelLanguageUid = _cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
        _item.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
        final long _tmpCerejLocalChangeSeqNum;
        _tmpCerejLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
        _item.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
        final long _tmpCerejMasterChangeSeqNum;
        _tmpCerejMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
        _item.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
        final long _tmpCerejLct;
        _tmpCerejLct = _cursor.getLong(_cursorIndexOfCerejLct);
        _item.setCerejLct(_tmpCerejLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentEntryRelatedEntryJoin findPrimaryByTranslation(final long contentEntryUid) {
    final String _sql = "SELECT * FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejUid");
      final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejContentEntryUid");
      final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelatedEntryUid");
      final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLastChangedBy");
      final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(_cursor, "relType");
      final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(_cursor, "comment");
      final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejRelLanguageUid");
      final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLocalChangeSeqNum");
      final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejMasterChangeSeqNum");
      final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cerejLct");
      final ContentEntryRelatedEntryJoin _result;
      if (_cursor.moveToFirst()) {
        _result = new ContentEntryRelatedEntryJoin();
        final long _tmpCerejUid;
        _tmpCerejUid = _cursor.getLong(_cursorIndexOfCerejUid);
        _result.setCerejUid(_tmpCerejUid);
        final long _tmpCerejContentEntryUid;
        _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
        _result.setCerejContentEntryUid(_tmpCerejContentEntryUid);
        final long _tmpCerejRelatedEntryUid;
        _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
        _result.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
        final int _tmpCerejLastChangedBy;
        _tmpCerejLastChangedBy = _cursor.getInt(_cursorIndexOfCerejLastChangedBy);
        _result.setCerejLastChangedBy(_tmpCerejLastChangedBy);
        final int _tmpRelType;
        _tmpRelType = _cursor.getInt(_cursorIndexOfRelType);
        _result.setRelType(_tmpRelType);
        final String _tmpComment;
        if (_cursor.isNull(_cursorIndexOfComment)) {
          _tmpComment = null;
        } else {
          _tmpComment = _cursor.getString(_cursorIndexOfComment);
        }
        _result.setComment(_tmpComment);
        final long _tmpCerejRelLanguageUid;
        _tmpCerejRelLanguageUid = _cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
        _result.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
        final long _tmpCerejLocalChangeSeqNum;
        _tmpCerejLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
        _result.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
        final long _tmpCerejMasterChangeSeqNum;
        _tmpCerejMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
        _result.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
        final long _tmpCerejLct;
        _tmpCerejLct = _cursor.getLong(_cursorIndexOfCerejLct);
        _result.setCerejLct(_tmpCerejLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findAllTranslationsForContentEntryAsync(final long contentEntryUid,
      final Continuation<? super List<ContentEntryRelatedEntryJoinWithLangName>> $completion) {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.cerejContentEntryUid, ContentEntryRelatedEntryJoin.cerejRelatedEntryUid, CASE ContentEntryRelatedEntryJoin.cerejRelatedEntryUid WHEN ? THEN (SELECT name FROM Language WHERE langUid = (SELECT primaryLanguageUid FROM ContentEntry WHERE contentEntryUid = ContentEntryRelatedEntryJoin.cerejContentEntryUid)) ELSE Language.name END languageName FROM ContentEntryRelatedEntryJoin LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = ? OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ?)) AND ContentEntryRelatedEntryJoin.relType = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryRelatedEntryJoinWithLangName>>() {
      @Override
      @NonNull
      public List<ContentEntryRelatedEntryJoinWithLangName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCerejContentEntryUid = 0;
          final int _cursorIndexOfCerejRelatedEntryUid = 1;
          final int _cursorIndexOfLanguageName = 2;
          final List<ContentEntryRelatedEntryJoinWithLangName> _result = new ArrayList<ContentEntryRelatedEntryJoinWithLangName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ContentEntryRelatedEntryJoinWithLangName _item;
            _item = new ContentEntryRelatedEntryJoinWithLangName();
            final long _tmpCerejContentEntryUid;
            _tmpCerejContentEntryUid = _cursor.getLong(_cursorIndexOfCerejContentEntryUid);
            _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
            final long _tmpCerejRelatedEntryUid;
            _tmpCerejRelatedEntryUid = _cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
            _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
            final String _tmpLanguageName;
            if (_cursor.isNull(_cursorIndexOfLanguageName)) {
              _tmpLanguageName = null;
            } else {
              _tmpLanguageName = _cursor.getString(_cursorIndexOfLanguageName);
            }
            _item.setLanguageName(_tmpLanguageName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, ContentEntryRelatedEntryJoinWithLanguage> findAllTranslationsWithContentEntryUid(
      final long contentEntryUid) {
    final String _sql = "SELECT ContentEntryRelatedEntryJoin.*, Language.* FROM ContentEntryRelatedEntryJoin\n"
            + "        LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid\n"
            + "        WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = ?\n"
            + "        OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN\n"
            + "        (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = ?))\n"
            + "        AND ContentEntryRelatedEntryJoin.relType = 1\n"
            + "        ORDER BY Language.name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    return new LimitOffsetPagingSource<ContentEntryRelatedEntryJoinWithLanguage>(_statement, __db, "ContentEntryRelatedEntryJoin", "Language") {
      @Override
      @NonNull
      protected List<ContentEntryRelatedEntryJoinWithLanguage> convertRows(
          @NonNull final Cursor cursor) {
        final int _cursorIndexOfCerejUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejUid");
        final int _cursorIndexOfCerejContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejContentEntryUid");
        final int _cursorIndexOfCerejRelatedEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejRelatedEntryUid");
        final int _cursorIndexOfCerejLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLastChangedBy");
        final int _cursorIndexOfRelType = CursorUtil.getColumnIndexOrThrow(cursor, "relType");
        final int _cursorIndexOfComment = CursorUtil.getColumnIndexOrThrow(cursor, "comment");
        final int _cursorIndexOfCerejRelLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "cerejRelLanguageUid");
        final int _cursorIndexOfCerejLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLocalChangeSeqNum");
        final int _cursorIndexOfCerejMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cerejMasterChangeSeqNum");
        final int _cursorIndexOfCerejLct = CursorUtil.getColumnIndexOrThrow(cursor, "cerejLct");
        final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(cursor, "langUid");
        final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(cursor, "name");
        final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_1_standard");
        final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_2_standard");
        final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(cursor, "iso_639_3_standard");
        final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(cursor, "Language_Type");
        final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(cursor, "languageActive");
        final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langLocalChangeSeqNum");
        final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "langMasterChangeSeqNum");
        final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "langLastChangedBy");
        final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(cursor, "langLct");
        final List<ContentEntryRelatedEntryJoinWithLanguage> _result = new ArrayList<ContentEntryRelatedEntryJoinWithLanguage>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ContentEntryRelatedEntryJoinWithLanguage _item;
          final Language _tmpLanguage;
          if (!(cursor.isNull(_cursorIndexOfLangUid) && cursor.isNull(_cursorIndexOfName) && cursor.isNull(_cursorIndexOfIso6391Standard) && cursor.isNull(_cursorIndexOfIso6392Standard) && cursor.isNull(_cursorIndexOfIso6393Standard) && cursor.isNull(_cursorIndexOfLanguageType) && cursor.isNull(_cursorIndexOfLanguageActive) && cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfLangLastChangedBy) && cursor.isNull(_cursorIndexOfLangLct))) {
            _tmpLanguage = new Language();
            final long _tmpLangUid;
            _tmpLangUid = cursor.getLong(_cursorIndexOfLangUid);
            _tmpLanguage.setLangUid(_tmpLangUid);
            final String _tmpName;
            if (cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = cursor.getString(_cursorIndexOfName);
            }
            _tmpLanguage.setName(_tmpName);
            final String _tmpIso_639_1_standard;
            if (cursor.isNull(_cursorIndexOfIso6391Standard)) {
              _tmpIso_639_1_standard = null;
            } else {
              _tmpIso_639_1_standard = cursor.getString(_cursorIndexOfIso6391Standard);
            }
            _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
            final String _tmpIso_639_2_standard;
            if (cursor.isNull(_cursorIndexOfIso6392Standard)) {
              _tmpIso_639_2_standard = null;
            } else {
              _tmpIso_639_2_standard = cursor.getString(_cursorIndexOfIso6392Standard);
            }
            _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
            final String _tmpIso_639_3_standard;
            if (cursor.isNull(_cursorIndexOfIso6393Standard)) {
              _tmpIso_639_3_standard = null;
            } else {
              _tmpIso_639_3_standard = cursor.getString(_cursorIndexOfIso6393Standard);
            }
            _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
            final String _tmpLanguage_Type;
            if (cursor.isNull(_cursorIndexOfLanguageType)) {
              _tmpLanguage_Type = null;
            } else {
              _tmpLanguage_Type = cursor.getString(_cursorIndexOfLanguageType);
            }
            _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
            final boolean _tmpLanguageActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfLanguageActive);
            _tmpLanguageActive = _tmp != 0;
            _tmpLanguage.setLanguageActive(_tmpLanguageActive);
            final long _tmpLangLocalChangeSeqNum;
            _tmpLangLocalChangeSeqNum = cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
            _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
            final long _tmpLangMasterChangeSeqNum;
            _tmpLangMasterChangeSeqNum = cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
            _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
            final int _tmpLangLastChangedBy;
            _tmpLangLastChangedBy = cursor.getInt(_cursorIndexOfLangLastChangedBy);
            _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
            final long _tmpLangLct;
            _tmpLangLct = cursor.getLong(_cursorIndexOfLangLct);
            _tmpLanguage.setLangLct(_tmpLangLct);
          } else {
            _tmpLanguage = null;
          }
          _item = new ContentEntryRelatedEntryJoinWithLanguage();
          final long _tmpCerejUid;
          _tmpCerejUid = cursor.getLong(_cursorIndexOfCerejUid);
          _item.setCerejUid(_tmpCerejUid);
          final long _tmpCerejContentEntryUid;
          _tmpCerejContentEntryUid = cursor.getLong(_cursorIndexOfCerejContentEntryUid);
          _item.setCerejContentEntryUid(_tmpCerejContentEntryUid);
          final long _tmpCerejRelatedEntryUid;
          _tmpCerejRelatedEntryUid = cursor.getLong(_cursorIndexOfCerejRelatedEntryUid);
          _item.setCerejRelatedEntryUid(_tmpCerejRelatedEntryUid);
          final int _tmpCerejLastChangedBy;
          _tmpCerejLastChangedBy = cursor.getInt(_cursorIndexOfCerejLastChangedBy);
          _item.setCerejLastChangedBy(_tmpCerejLastChangedBy);
          final int _tmpRelType;
          _tmpRelType = cursor.getInt(_cursorIndexOfRelType);
          _item.setRelType(_tmpRelType);
          final String _tmpComment;
          if (cursor.isNull(_cursorIndexOfComment)) {
            _tmpComment = null;
          } else {
            _tmpComment = cursor.getString(_cursorIndexOfComment);
          }
          _item.setComment(_tmpComment);
          final long _tmpCerejRelLanguageUid;
          _tmpCerejRelLanguageUid = cursor.getLong(_cursorIndexOfCerejRelLanguageUid);
          _item.setCerejRelLanguageUid(_tmpCerejRelLanguageUid);
          final long _tmpCerejLocalChangeSeqNum;
          _tmpCerejLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCerejLocalChangeSeqNum);
          _item.setCerejLocalChangeSeqNum(_tmpCerejLocalChangeSeqNum);
          final long _tmpCerejMasterChangeSeqNum;
          _tmpCerejMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCerejMasterChangeSeqNum);
          _item.setCerejMasterChangeSeqNum(_tmpCerejMasterChangeSeqNum);
          final long _tmpCerejLct;
          _tmpCerejLct = cursor.getLong(_cursorIndexOfCerejLct);
          _item.setCerejLct(_tmpCerejLct);
          _item.setLanguage(_tmpLanguage);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
