package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseGroupSet;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseGroupSetDao_Impl extends CourseGroupSetDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseGroupSet> __insertionAdapterOfCourseGroupSet;

  private final EntityInsertionAdapter<CourseGroupSet> __insertionAdapterOfCourseGroupSet_1;

  private final EntityDeletionOrUpdateAdapter<CourseGroupSet> __updateAdapterOfCourseGroupSet;

  public CourseGroupSetDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseGroupSet = new EntityInsertionAdapter<CourseGroupSet>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseGroupSet` (`cgsUid`,`cgsName`,`cgsTotalGroups`,`cgsActive`,`cgsClazzUid`,`cgsLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupSet entity) {
        statement.bindLong(1, entity.getCgsUid());
        if (entity.getCgsName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCgsName());
        }
        statement.bindLong(3, entity.getCgsTotalGroups());
        final int _tmp = entity.getCgsActive() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getCgsClazzUid());
        statement.bindLong(6, entity.getCgsLct());
      }
    };
    this.__insertionAdapterOfCourseGroupSet_1 = new EntityInsertionAdapter<CourseGroupSet>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CourseGroupSet` (`cgsUid`,`cgsName`,`cgsTotalGroups`,`cgsActive`,`cgsClazzUid`,`cgsLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupSet entity) {
        statement.bindLong(1, entity.getCgsUid());
        if (entity.getCgsName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCgsName());
        }
        statement.bindLong(3, entity.getCgsTotalGroups());
        final int _tmp = entity.getCgsActive() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getCgsClazzUid());
        statement.bindLong(6, entity.getCgsLct());
      }
    };
    this.__updateAdapterOfCourseGroupSet = new EntityDeletionOrUpdateAdapter<CourseGroupSet>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseGroupSet` SET `cgsUid` = ?,`cgsName` = ?,`cgsTotalGroups` = ?,`cgsActive` = ?,`cgsClazzUid` = ?,`cgsLct` = ? WHERE `cgsUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseGroupSet entity) {
        statement.bindLong(1, entity.getCgsUid());
        if (entity.getCgsName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCgsName());
        }
        statement.bindLong(3, entity.getCgsTotalGroups());
        final int _tmp = entity.getCgsActive() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getCgsClazzUid());
        statement.bindLong(6, entity.getCgsLct());
        statement.bindLong(7, entity.getCgsUid());
      }
    };
  }

  @Override
  public long insert(final CourseGroupSet entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseGroupSet.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseGroupSet entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseGroupSet.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseGroupSet> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseGroupSet.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertAsync(final CourseGroupSet entity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseGroupSet_1.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseGroupSet entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseGroupSet.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final CourseGroupSet entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfCourseGroupSet.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CourseGroupSet> findAllCourseGroupSetForClazz(final long clazzUid,
      final String searchText, final int sortOrder) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseGroupSet\n"
            + "        WHERE cgsActive\n"
            + "          AND cgsClazzUid = ?\n"
            + "          AND ((? = '%') OR (cgsName LIKE ?))\n"
            + "     ORDER BY CASE(?)\n"
            + "              WHEN 1 THEN cgsName\n"
            + "              ELSE ''\n"
            + "              END ASC,\n"
            + "              CASE(?)\n"
            + "              WHEN 2 THEN cgsName\n"
            + "              ELSE ''\n"
            + "              END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 3;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 4;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 5;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<CourseGroupSet>(_statement, __db, "CourseGroupSet") {
      @Override
      @NonNull
      protected List<CourseGroupSet> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(cursor, "cgsUid");
        final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(cursor, "cgsName");
        final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(cursor, "cgsTotalGroups");
        final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(cursor, "cgsActive");
        final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "cgsClazzUid");
        final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(cursor, "cgsLct");
        final List<CourseGroupSet> _result = new ArrayList<CourseGroupSet>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CourseGroupSet _item;
          _item = new CourseGroupSet();
          final long _tmpCgsUid;
          _tmpCgsUid = cursor.getLong(_cursorIndexOfCgsUid);
          _item.setCgsUid(_tmpCgsUid);
          final String _tmpCgsName;
          if (cursor.isNull(_cursorIndexOfCgsName)) {
            _tmpCgsName = null;
          } else {
            _tmpCgsName = cursor.getString(_cursorIndexOfCgsName);
          }
          _item.setCgsName(_tmpCgsName);
          final int _tmpCgsTotalGroups;
          _tmpCgsTotalGroups = cursor.getInt(_cursorIndexOfCgsTotalGroups);
          _item.setCgsTotalGroups(_tmpCgsTotalGroups);
          final boolean _tmpCgsActive;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfCgsActive);
          _tmpCgsActive = _tmp != 0;
          _item.setCgsActive(_tmpCgsActive);
          final long _tmpCgsClazzUid;
          _tmpCgsClazzUid = cursor.getLong(_cursorIndexOfCgsClazzUid);
          _item.setCgsClazzUid(_tmpCgsClazzUid);
          final long _tmpCgsLct;
          _tmpCgsLct = cursor.getLong(_cursorIndexOfCgsLct);
          _item.setCgsLct(_tmpCgsLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<CourseGroupSet> findAllCourseGroupSetForClazzList(final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseGroupSet\n"
            + "        WHERE cgsActive\n"
            + "          AND cgsClazzUid = ?\n"
            + "     ORDER BY cgsName   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsUid");
      final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsName");
      final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsTotalGroups");
      final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsActive");
      final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsClazzUid");
      final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsLct");
      final List<CourseGroupSet> _result = new ArrayList<CourseGroupSet>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final CourseGroupSet _item;
        _item = new CourseGroupSet();
        final long _tmpCgsUid;
        _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
        _item.setCgsUid(_tmpCgsUid);
        final String _tmpCgsName;
        if (_cursor.isNull(_cursorIndexOfCgsName)) {
          _tmpCgsName = null;
        } else {
          _tmpCgsName = _cursor.getString(_cursorIndexOfCgsName);
        }
        _item.setCgsName(_tmpCgsName);
        final int _tmpCgsTotalGroups;
        _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
        _item.setCgsTotalGroups(_tmpCgsTotalGroups);
        final boolean _tmpCgsActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
        _tmpCgsActive = _tmp != 0;
        _item.setCgsActive(_tmpCgsActive);
        final long _tmpCgsClazzUid;
        _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
        _item.setCgsClazzUid(_tmpCgsClazzUid);
        final long _tmpCgsLct;
        _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
        _item.setCgsLct(_tmpCgsLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findAllCourseGroupSetForClazzListAsync(final long clazzUid,
      final Continuation<? super List<CourseGroupSet>> $completion) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseGroupSet\n"
            + "        WHERE cgsActive\n"
            + "          AND cgsClazzUid = ?\n"
            + "     ORDER BY cgsName   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupSet>>() {
      @Override
      @NonNull
      public List<CourseGroupSet> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsUid");
          final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsName");
          final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsTotalGroups");
          final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsActive");
          final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsClazzUid");
          final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsLct");
          final List<CourseGroupSet> _result = new ArrayList<CourseGroupSet>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupSet _item;
            _item = new CourseGroupSet();
            final long _tmpCgsUid;
            _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
            _item.setCgsUid(_tmpCgsUid);
            final String _tmpCgsName;
            if (_cursor.isNull(_cursorIndexOfCgsName)) {
              _tmpCgsName = null;
            } else {
              _tmpCgsName = _cursor.getString(_cursorIndexOfCgsName);
            }
            _item.setCgsName(_tmpCgsName);
            final int _tmpCgsTotalGroups;
            _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
            _item.setCgsTotalGroups(_tmpCgsTotalGroups);
            final boolean _tmpCgsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
            _tmpCgsActive = _tmp != 0;
            _item.setCgsActive(_tmpCgsActive);
            final long _tmpCgsClazzUid;
            _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
            _item.setCgsClazzUid(_tmpCgsClazzUid);
            final long _tmpCgsLct;
            _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
            _item.setCgsLct(_tmpCgsLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super CourseGroupSet> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM CourseGroupSet \n"
            + "        WHERE cgsUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseGroupSet>() {
      @Override
      @Nullable
      public CourseGroupSet call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsUid");
          final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsName");
          final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsTotalGroups");
          final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsActive");
          final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsClazzUid");
          final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsLct");
          final CourseGroupSet _result;
          if (_cursor.moveToFirst()) {
            _result = new CourseGroupSet();
            final long _tmpCgsUid;
            _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
            _result.setCgsUid(_tmpCgsUid);
            final String _tmpCgsName;
            if (_cursor.isNull(_cursorIndexOfCgsName)) {
              _tmpCgsName = null;
            } else {
              _tmpCgsName = _cursor.getString(_cursorIndexOfCgsName);
            }
            _result.setCgsName(_tmpCgsName);
            final int _tmpCgsTotalGroups;
            _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
            _result.setCgsTotalGroups(_tmpCgsTotalGroups);
            final boolean _tmpCgsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
            _tmpCgsActive = _tmp != 0;
            _result.setCgsActive(_tmpCgsActive);
            final long _tmpCgsClazzUid;
            _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
            _result.setCgsClazzUid(_tmpCgsClazzUid);
            final long _tmpCgsLct;
            _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
            _result.setCgsLct(_tmpCgsLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<CourseGroupSet> findByUidAsFlow(final long uid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM CourseGroupSet \n"
            + "        WHERE cgsUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseGroupSet"}, new Callable<CourseGroupSet>() {
      @Override
      @Nullable
      public CourseGroupSet call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsUid");
          final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsName");
          final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsTotalGroups");
          final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsActive");
          final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsClazzUid");
          final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsLct");
          final CourseGroupSet _result;
          if (_cursor.moveToFirst()) {
            _result = new CourseGroupSet();
            final long _tmpCgsUid;
            _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
            _result.setCgsUid(_tmpCgsUid);
            final String _tmpCgsName;
            if (_cursor.isNull(_cursorIndexOfCgsName)) {
              _tmpCgsName = null;
            } else {
              _tmpCgsName = _cursor.getString(_cursorIndexOfCgsName);
            }
            _result.setCgsName(_tmpCgsName);
            final int _tmpCgsTotalGroups;
            _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
            _result.setCgsTotalGroups(_tmpCgsTotalGroups);
            final boolean _tmpCgsActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCgsActive);
            _tmpCgsActive = _tmp != 0;
            _result.setCgsActive(_tmpCgsActive);
            final long _tmpCgsClazzUid;
            _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
            _result.setCgsClazzUid(_tmpCgsClazzUid);
            final long _tmpCgsLct;
            _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
            _result.setCgsLct(_tmpCgsLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
