package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseTerminologyDao_Impl extends CourseTerminologyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseTerminology> __insertionAdapterOfCourseTerminology;

  private final EntityInsertionAdapter<CourseTerminology> __insertionAdapterOfCourseTerminology_1;

  private final EntityDeletionOrUpdateAdapter<CourseTerminology> __updateAdapterOfCourseTerminology;

  public CourseTerminologyDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseTerminology = new EntityInsertionAdapter<CourseTerminology>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseTerminology` (`ctUid`,`ctTitle`,`ctTerminology`,`ctLct`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseTerminology entity) {
        statement.bindLong(1, entity.getCtUid());
        if (entity.getCtTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCtTitle());
        }
        if (entity.getCtTerminology() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCtTerminology());
        }
        statement.bindLong(4, entity.getCtLct());
      }
    };
    this.__insertionAdapterOfCourseTerminology_1 = new EntityInsertionAdapter<CourseTerminology>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CourseTerminology` (`ctUid`,`ctTitle`,`ctTerminology`,`ctLct`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseTerminology entity) {
        statement.bindLong(1, entity.getCtUid());
        if (entity.getCtTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCtTitle());
        }
        if (entity.getCtTerminology() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCtTerminology());
        }
        statement.bindLong(4, entity.getCtLct());
      }
    };
    this.__updateAdapterOfCourseTerminology = new EntityDeletionOrUpdateAdapter<CourseTerminology>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseTerminology` SET `ctUid` = ?,`ctTitle` = ?,`ctTerminology` = ?,`ctLct` = ? WHERE `ctUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseTerminology entity) {
        statement.bindLong(1, entity.getCtUid());
        if (entity.getCtTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCtTitle());
        }
        if (entity.getCtTerminology() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCtTerminology());
        }
        statement.bindLong(4, entity.getCtLct());
        statement.bindLong(5, entity.getCtUid());
      }
    };
  }

  @Override
  public long insert(final CourseTerminology entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseTerminology.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseTerminology entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseTerminology.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseTerminology> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseTerminology.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsertAsync(final CourseTerminology entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseTerminology_1.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseTerminology entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseTerminology.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final CourseTerminology entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfCourseTerminology.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CourseTerminology> findAllCourseTerminologyPagingSource() {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseTerminology\n"
            + "     ORDER BY ctTitle   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new LimitOffsetPagingSource<CourseTerminology>(_statement, __db, "CourseTerminology") {
      @Override
      @NonNull
      protected List<CourseTerminology> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(cursor, "ctUid");
        final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(cursor, "ctTitle");
        final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(cursor, "ctTerminology");
        final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(cursor, "ctLct");
        final List<CourseTerminology> _result = new ArrayList<CourseTerminology>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CourseTerminology _item;
          _item = new CourseTerminology();
          final long _tmpCtUid;
          _tmpCtUid = cursor.getLong(_cursorIndexOfCtUid);
          _item.setCtUid(_tmpCtUid);
          final String _tmpCtTitle;
          if (cursor.isNull(_cursorIndexOfCtTitle)) {
            _tmpCtTitle = null;
          } else {
            _tmpCtTitle = cursor.getString(_cursorIndexOfCtTitle);
          }
          _item.setCtTitle(_tmpCtTitle);
          final String _tmpCtTerminology;
          if (cursor.isNull(_cursorIndexOfCtTerminology)) {
            _tmpCtTerminology = null;
          } else {
            _tmpCtTerminology = cursor.getString(_cursorIndexOfCtTerminology);
          }
          _item.setCtTerminology(_tmpCtTerminology);
          final long _tmpCtLct;
          _tmpCtLct = cursor.getLong(_cursorIndexOfCtLct);
          _item.setCtLct(_tmpCtLct);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<CourseTerminology> findAllCourseTerminologyList() {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseTerminology\n"
            + "     ORDER BY ctTitle   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
      final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
      final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
      final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
      final List<CourseTerminology> _result = new ArrayList<CourseTerminology>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final CourseTerminology _item;
        _item = new CourseTerminology();
        final long _tmpCtUid;
        _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
        _item.setCtUid(_tmpCtUid);
        final String _tmpCtTitle;
        if (_cursor.isNull(_cursorIndexOfCtTitle)) {
          _tmpCtTitle = null;
        } else {
          _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
        }
        _item.setCtTitle(_tmpCtTitle);
        final String _tmpCtTerminology;
        if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
          _tmpCtTerminology = null;
        } else {
          _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
        }
        _item.setCtTerminology(_tmpCtTerminology);
        final long _tmpCtLct;
        _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
        _item.setCtLct(_tmpCtLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getTerminologyForClazz(final long clazzUid,
      final Continuation<? super CourseTerminology> $completion) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM CourseTerminology\n"
            + "               JOIN Clazz \n"
            + "               ON Clazz.clazzTerminologyUid = CourseTerminology.ctUid\n"
            + "         WHERE Clazz.clazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseTerminology>() {
      @Override
      @Nullable
      public CourseTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final CourseTerminology _result;
          if (_cursor.moveToFirst()) {
            _result = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
            _result.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (_cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
            }
            _result.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
            }
            _result.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
            _result.setCtLct(_tmpCtLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getTerminologyForAssignment(final long assignmentUid,
      final Continuation<? super CourseTerminology> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseTerminology.*\n"
            + "          FROM ClazzAssignment\n"
            + "               JOIN Clazz \n"
            + "                    ON Clazz.clazzUid = ClazzAssignment.caClazzUid\n"
            + "               JOIN CourseTerminology\n"
            + "                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "         WHERE ClazzAssignment.caUid = ? \n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseTerminology>() {
      @Override
      @Nullable
      public CourseTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final CourseTerminology _result;
          if (_cursor.moveToFirst()) {
            _result = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
            _result.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (_cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
            }
            _result.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
            }
            _result.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
            _result.setCtLct(_tmpCtLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super CourseTerminology> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM CourseTerminology \n"
            + "        WHERE ctUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseTerminology>() {
      @Override
      @Nullable
      public CourseTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final CourseTerminology _result;
          if (_cursor.moveToFirst()) {
            _result = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
            _result.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (_cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
            }
            _result.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
            }
            _result.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
            _result.setCtLct(_tmpCtLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
