package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class LanguageVariantDao_Impl extends LanguageVariantDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LanguageVariant> __insertionAdapterOfLanguageVariant;

  private final EntityDeletionOrUpdateAdapter<LanguageVariant> __updateAdapterOfLanguageVariant;

  public LanguageVariantDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLanguageVariant = new EntityInsertionAdapter<LanguageVariant>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `LanguageVariant` (`langVariantUid`,`langUid`,`countryCode`,`name`,`langVariantLocalChangeSeqNum`,`langVariantMasterChangeSeqNum`,`langVariantLastChangedBy`,`langVariantLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LanguageVariant entity) {
        statement.bindLong(1, entity.getLangVariantUid());
        statement.bindLong(2, entity.getLangUid());
        if (entity.getCountryCode() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCountryCode());
        }
        if (entity.getName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getName());
        }
        statement.bindLong(5, entity.getLangVariantLocalChangeSeqNum());
        statement.bindLong(6, entity.getLangVariantMasterChangeSeqNum());
        statement.bindLong(7, entity.getLangVariantLastChangedBy());
        statement.bindLong(8, entity.getLangVariantLct());
      }
    };
    this.__updateAdapterOfLanguageVariant = new EntityDeletionOrUpdateAdapter<LanguageVariant>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `LanguageVariant` SET `langVariantUid` = ?,`langUid` = ?,`countryCode` = ?,`name` = ?,`langVariantLocalChangeSeqNum` = ?,`langVariantMasterChangeSeqNum` = ?,`langVariantLastChangedBy` = ?,`langVariantLct` = ? WHERE `langVariantUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final LanguageVariant entity) {
        statement.bindLong(1, entity.getLangVariantUid());
        statement.bindLong(2, entity.getLangUid());
        if (entity.getCountryCode() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCountryCode());
        }
        if (entity.getName() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getName());
        }
        statement.bindLong(5, entity.getLangVariantLocalChangeSeqNum());
        statement.bindLong(6, entity.getLangVariantMasterChangeSeqNum());
        statement.bindLong(7, entity.getLangVariantLastChangedBy());
        statement.bindLong(8, entity.getLangVariantLct());
        statement.bindLong(9, entity.getLangVariantUid());
      }
    };
  }

  @Override
  public long insert(final LanguageVariant entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfLanguageVariant.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final LanguageVariant entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfLanguageVariant.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends LanguageVariant> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLanguageVariant.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final LanguageVariant entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLanguageVariant.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public LanguageVariant findByCode(final String countryCode) {
    final String _sql = "SELECT * FROM LanguageVariant WHERE countryCode = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, countryCode);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantUid");
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow(_cursor, "countryCode");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfLangVariantLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLocalChangeSeqNum");
      final int _cursorIndexOfLangVariantMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantMasterChangeSeqNum");
      final int _cursorIndexOfLangVariantLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLastChangedBy");
      final int _cursorIndexOfLangVariantLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLct");
      final LanguageVariant _result;
      if (_cursor.moveToFirst()) {
        _result = new LanguageVariant();
        final long _tmpLangVariantUid;
        _tmpLangVariantUid = _cursor.getLong(_cursorIndexOfLangVariantUid);
        _result.setLangVariantUid(_tmpLangVariantUid);
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpCountryCode;
        if (_cursor.isNull(_cursorIndexOfCountryCode)) {
          _tmpCountryCode = null;
        } else {
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
        }
        _result.setCountryCode(_tmpCountryCode);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final long _tmpLangVariantLocalChangeSeqNum;
        _tmpLangVariantLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantLocalChangeSeqNum);
        _result.setLangVariantLocalChangeSeqNum(_tmpLangVariantLocalChangeSeqNum);
        final long _tmpLangVariantMasterChangeSeqNum;
        _tmpLangVariantMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantMasterChangeSeqNum);
        _result.setLangVariantMasterChangeSeqNum(_tmpLangVariantMasterChangeSeqNum);
        final int _tmpLangVariantLastChangedBy;
        _tmpLangVariantLastChangedBy = _cursor.getInt(_cursorIndexOfLangVariantLastChangedBy);
        _result.setLangVariantLastChangedBy(_tmpLangVariantLastChangedBy);
        final long _tmpLangVariantLct;
        _tmpLangVariantLct = _cursor.getLong(_cursorIndexOfLangVariantLct);
        _result.setLangVariantLct(_tmpLangVariantLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
