package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.door.entities.OutgoingReplication;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class OutgoingReplicationDao_Impl extends OutgoingReplicationDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<OutgoingReplication> __insertionAdapterOfOutgoingReplication;

  public OutgoingReplicationDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfOutgoingReplication = new EntityInsertionAdapter<OutgoingReplication>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `OutgoingReplication` (`orUid`,`destNodeId`,`orTableId`,`orPk1`,`orPk2`,`orPk3`,`orPk4`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final OutgoingReplication entity) {
        statement.bindLong(1, entity.getOrUid());
        statement.bindLong(2, entity.getDestNodeId());
        statement.bindLong(3, entity.getOrTableId());
        statement.bindLong(4, entity.getOrPk1());
        statement.bindLong(5, entity.getOrPk2());
        statement.bindLong(6, entity.getOrPk3());
        statement.bindLong(7, entity.getOrPk4());
      }
    };
  }

  @Override
  public Object insert(final List<OutgoingReplication> outgoing,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfOutgoingReplication.insert(outgoing);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object listReplications(
      final Continuation<? super List<OutgoingReplication>> $completion) {
    final String _sql = "\n"
            + "        SELECT OutgoingReplication.*\n"
            + "          FROM OutgoingReplication\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<OutgoingReplication>>() {
      @Override
      @NonNull
      public List<OutgoingReplication> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfOrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "orUid");
          final int _cursorIndexOfDestNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "destNodeId");
          final int _cursorIndexOfOrTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "orTableId");
          final int _cursorIndexOfOrPk1 = CursorUtil.getColumnIndexOrThrow(_cursor, "orPk1");
          final int _cursorIndexOfOrPk2 = CursorUtil.getColumnIndexOrThrow(_cursor, "orPk2");
          final int _cursorIndexOfOrPk3 = CursorUtil.getColumnIndexOrThrow(_cursor, "orPk3");
          final int _cursorIndexOfOrPk4 = CursorUtil.getColumnIndexOrThrow(_cursor, "orPk4");
          final List<OutgoingReplication> _result = new ArrayList<OutgoingReplication>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final OutgoingReplication _item;
            final long _tmpOrUid;
            _tmpOrUid = _cursor.getLong(_cursorIndexOfOrUid);
            final long _tmpDestNodeId;
            _tmpDestNodeId = _cursor.getLong(_cursorIndexOfDestNodeId);
            final int _tmpOrTableId;
            _tmpOrTableId = _cursor.getInt(_cursorIndexOfOrTableId);
            final long _tmpOrPk1;
            _tmpOrPk1 = _cursor.getLong(_cursorIndexOfOrPk1);
            final long _tmpOrPk2;
            _tmpOrPk2 = _cursor.getLong(_cursorIndexOfOrPk2);
            final long _tmpOrPk3;
            _tmpOrPk3 = _cursor.getLong(_cursorIndexOfOrPk3);
            final long _tmpOrPk4;
            _tmpOrPk4 = _cursor.getLong(_cursorIndexOfOrPk4);
            _item = new OutgoingReplication(_tmpOrUid,_tmpDestNodeId,_tmpOrTableId,_tmpOrPk1,_tmpOrPk2,_tmpOrPk3,_tmpOrPk4);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
