package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonPictureDao_Impl extends PersonPictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonPicture> __insertionAdapterOfPersonPicture;

  private final EntityInsertionAdapter<PersonPicture> __insertionAdapterOfPersonPicture_1;

  private final EntityDeletionOrUpdateAdapter<PersonPicture> __updateAdapterOfPersonPicture;

  private final SharedSQLiteStatement __preparedStmtOfUpdateUri;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLct;

  private final SharedSQLiteStatement __preparedStmtOfUpdateTransferJobItemEtag;

  public PersonPictureDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonPicture = new EntityInsertionAdapter<PersonPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonPicture` (`personPictureUid`,`personPictureLct`,`personPictureUri`,`personPictureThumbnailUri`,`fileSize`,`personPictureActive`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonPicture entity) {
        statement.bindLong(1, entity.getPersonPictureUid());
        statement.bindLong(2, entity.getPersonPictureLct());
        if (entity.getPersonPictureUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPersonPictureUri());
        }
        if (entity.getPersonPictureThumbnailUri() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPersonPictureThumbnailUri());
        }
        statement.bindLong(5, entity.getFileSize());
        final int _tmp = entity.getPersonPictureActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
      }
    };
    this.__insertionAdapterOfPersonPicture_1 = new EntityInsertionAdapter<PersonPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PersonPicture` (`personPictureUid`,`personPictureLct`,`personPictureUri`,`personPictureThumbnailUri`,`fileSize`,`personPictureActive`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonPicture entity) {
        statement.bindLong(1, entity.getPersonPictureUid());
        statement.bindLong(2, entity.getPersonPictureLct());
        if (entity.getPersonPictureUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPersonPictureUri());
        }
        if (entity.getPersonPictureThumbnailUri() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPersonPictureThumbnailUri());
        }
        statement.bindLong(5, entity.getFileSize());
        final int _tmp = entity.getPersonPictureActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
      }
    };
    this.__updateAdapterOfPersonPicture = new EntityDeletionOrUpdateAdapter<PersonPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PersonPicture` SET `personPictureUid` = ?,`personPictureLct` = ?,`personPictureUri` = ?,`personPictureThumbnailUri` = ?,`fileSize` = ?,`personPictureActive` = ? WHERE `personPictureUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonPicture entity) {
        statement.bindLong(1, entity.getPersonPictureUid());
        statement.bindLong(2, entity.getPersonPictureLct());
        if (entity.getPersonPictureUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPersonPictureUri());
        }
        if (entity.getPersonPictureThumbnailUri() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPersonPictureThumbnailUri());
        }
        statement.bindLong(5, entity.getFileSize());
        final int _tmp = entity.getPersonPictureActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
        statement.bindLong(7, entity.getPersonPictureUid());
      }
    };
    this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonPicture\n"
                + "           SET personPictureUri = ?,\n"
                + "               personPictureThumbnailUri = ?,\n"
                + "               personPictureLct = ?\n"
                + "         WHERE personPictureUid = ?      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateLct = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonPicture\n"
                + "           SET personPictureLct = ?\n"
                + "         WHERE personPictureUid = ?   \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateTransferJobItemEtag = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE TransferJobItem\n"
                + "           SET tjiEntityEtag = \n"
                + "               (SELECT personPictureLct\n"
                + "                  FROM PersonPicture\n"
                + "                 WHERE personPictureUid = ?)\n"
                + "         WHERE tjiUid = ?      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfPersonPicture.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonPicture entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonPicture.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends PersonPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonPicture.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object upsert(final PersonPicture personPicture,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPersonPicture_1.insert(personPicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final PersonPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonPicture.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final PersonPicture personPicture,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfPersonPicture.handle(personPicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateUri(final long uid, final String uri, final String thumbnailUri,
      final long time, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateUri.acquire();
        int _argIndex = 1;
        if (uri == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, uri);
        }
        _argIndex = 2;
        if (thumbnailUri == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, thumbnailUri);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateUri.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateLct(final long uid, final long time,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLct.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateLct.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateTransferJobItemEtag(final long entityUid, final int transferJobItemUid,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateTransferJobItemEtag.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, entityUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, transferJobItemUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateTransferJobItemEtag.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByPersonUidAsync(final long personUid,
      final Continuation<? super PersonPicture> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM PersonPicture \n"
            + "         WHERE personPictureUid = ?\n"
            + "           AND CAST(personPictureActive AS INTEGER) = 1\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonPicture>() {
      @Override
      @Nullable
      public PersonPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonPicture _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp != 0;
            _result = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<PersonPicture> findByPersonUidLive(final long personUid) {
    final String _sql = "\n"
            + "         SELECT * \n"
            + "           FROM PersonPicture \n"
            + "          WHERE personPictureUid = ? \n"
            + "          ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PersonPicture"}, new Callable<PersonPicture>() {
      @Override
      @Nullable
      public PersonPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonPicture _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp != 0;
            _result = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<PersonPicture> findByPersonUidAsFlow(final long personUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM PersonPicture \n"
            + "         WHERE personPictureUid = ?\n"
            + "          AND CAST(personPictureActive AS INTEGER) = 1\n"
            + "        LIMIT 1\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PersonPicture"}, new Callable<PersonPicture>() {
      @Override
      @Nullable
      public PersonPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final PersonPicture _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp != 0;
            _result = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
