package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.UserSession;
import com.ustadmobile.lib.db.entities.UserSessionAndPerson;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserSessionDao_Impl extends UserSessionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserSession> __insertionAdapterOfUserSession;

  private final SharedSQLiteStatement __preparedStmtOfEndSession;

  private final SharedSQLiteStatement __preparedStmtOfEndOtherSessions;

  public UserSessionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserSession = new EntityInsertionAdapter<UserSession>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `UserSession` (`usUid`,`usPcsn`,`usLcsn`,`usLcb`,`usLct`,`usPersonUid`,`usClientNodeId`,`usStartTime`,`usEndTime`,`usStatus`,`usReason`,`usAuth`,`usSessionType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserSession entity) {
        statement.bindLong(1, entity.getUsUid());
        statement.bindLong(2, entity.getUsPcsn());
        statement.bindLong(3, entity.getUsLcsn());
        statement.bindLong(4, entity.getUsLcb());
        statement.bindLong(5, entity.getUsLct());
        statement.bindLong(6, entity.getUsPersonUid());
        statement.bindLong(7, entity.getUsClientNodeId());
        statement.bindLong(8, entity.getUsStartTime());
        statement.bindLong(9, entity.getUsEndTime());
        statement.bindLong(10, entity.getUsStatus());
        statement.bindLong(11, entity.getUsReason());
        if (entity.getUsAuth() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getUsAuth());
        }
        statement.bindLong(13, entity.getUsSessionType());
      }
    };
    this.__preparedStmtOfEndSession = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE UserSession\n"
                + "           SET usAuth = null,\n"
                + "               usStatus = ?,\n"
                + "               usReason = ?,\n"
                + "               usEndTime = ?,\n"
                + "               usLct = ?\n"
                + "         WHERE UserSession.usUid = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfEndOtherSessions = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE UserSession\n"
                + "           SET usAuth = null,\n"
                + "               usStatus = ?,\n"
                + "               usReason = ?,\n"
                + "               usLct = ?\n"
                + "         WHERE usPersonUid = ?\n"
                + "           AND usClientNodeId != ?\n"
                + "           AND usStatus != ?                     \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertSession(final UserSession session,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfUserSession.insertAndReturnId(session);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object endSession(final long sessionUid, final int newStatus, final int reason,
      final long endTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfEndSession.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, reason);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, endTime);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, endTime);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, sessionUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfEndSession.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object endOtherSessions(final long personUid, final long exemptNodeId, final int newStatus,
      final int reason, final long changeTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfEndOtherSessions.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, reason);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, exemptNodeId);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, newStatus);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfEndOtherSessions.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findSessionsByPerson(final long personUid,
      final Continuation<? super List<UserSession>> $completion) {
    final String _sql = "\n"
            + "        SELECT UserSession.*\n"
            + "          FROM UserSession\n"
            + "         WHERE usPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserSession>>() {
      @Override
      @NonNull
      public List<UserSession> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final List<UserSession> _result = new ArrayList<UserSession>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UserSession _item;
            _item = new UserSession();
            final long _tmpUsUid;
            _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
            _item.setUsUid(_tmpUsUid);
            final long _tmpUsPcsn;
            _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
            _item.setUsPcsn(_tmpUsPcsn);
            final long _tmpUsLcsn;
            _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
            _item.setUsLcsn(_tmpUsLcsn);
            final long _tmpUsLcb;
            _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
            _item.setUsLcb(_tmpUsLcb);
            final long _tmpUsLct;
            _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
            _item.setUsLct(_tmpUsLct);
            final long _tmpUsPersonUid;
            _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
            _item.setUsPersonUid(_tmpUsPersonUid);
            final long _tmpUsClientNodeId;
            _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
            _item.setUsClientNodeId(_tmpUsClientNodeId);
            final long _tmpUsStartTime;
            _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
            _item.setUsStartTime(_tmpUsStartTime);
            final long _tmpUsEndTime;
            _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
            _item.setUsEndTime(_tmpUsEndTime);
            final int _tmpUsStatus;
            _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
            _item.setUsStatus(_tmpUsStatus);
            final int _tmpUsReason;
            _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
            _item.setUsReason(_tmpUsReason);
            final String _tmpUsAuth;
            if (_cursor.isNull(_cursorIndexOfUsAuth)) {
              _tmpUsAuth = null;
            } else {
              _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
            }
            _item.setUsAuth(_tmpUsAuth);
            final int _tmpUsSessionType;
            _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
            _item.setUsSessionType(_tmpUsSessionType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<UserSessionAndPerson>> findAllLocalSessionsLive() {
    final String _sql = "\n"
            + "            SELECT UserSession.*, Person.*, PersonPicture.*\n"
            + "              FROM UserSession\n"
            + "                   JOIN Person \n"
            + "                        ON Person.personUid = UserSession.usPersonUid\n"
            + "                   LEFT JOIN PersonPicture\n"
            + "                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n"
            + "             WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "               AND UserSession.usStatus = 1        \n"
            + "               AND (UserSession.usSessionType & 8) != 8\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"UserSession", "Person",
        "PersonPicture", "SyncNode"}, new Callable<List<UserSessionAndPerson>>() {
      @Override
      @NonNull
      public List<UserSessionAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<UserSessionAndPerson> _result = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UserSessionAndPerson _item;
            final UserSession _tmpUserSession;
            if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
              _tmpUserSession = new UserSession();
              final long _tmpUsUid;
              _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
              _tmpUserSession.setUsUid(_tmpUsUid);
              final long _tmpUsPcsn;
              _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
              _tmpUserSession.setUsPcsn(_tmpUsPcsn);
              final long _tmpUsLcsn;
              _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
              _tmpUserSession.setUsLcsn(_tmpUsLcsn);
              final long _tmpUsLcb;
              _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
              _tmpUserSession.setUsLcb(_tmpUsLcb);
              final long _tmpUsLct;
              _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
              _tmpUserSession.setUsLct(_tmpUsLct);
              final long _tmpUsPersonUid;
              _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
              _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
              final long _tmpUsClientNodeId;
              _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
              _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
              final long _tmpUsStartTime;
              _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
              _tmpUserSession.setUsStartTime(_tmpUsStartTime);
              final long _tmpUsEndTime;
              _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
              _tmpUserSession.setUsEndTime(_tmpUsEndTime);
              final int _tmpUsStatus;
              _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
              _tmpUserSession.setUsStatus(_tmpUsStatus);
              final int _tmpUsReason;
              _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
              _tmpUserSession.setUsReason(_tmpUsReason);
              final String _tmpUsAuth;
              if (_cursor.isNull(_cursorIndexOfUsAuth)) {
                _tmpUsAuth = null;
              } else {
                _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
              }
              _tmpUserSession.setUsAuth(_tmpUsAuth);
              final int _tmpUsSessionType;
              _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
              _tmpUserSession.setUsSessionType(_tmpUsSessionType);
            } else {
              _tmpUserSession = null;
            }
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPersonPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPersonPicture = null;
            }
            _item = new UserSessionAndPerson(_tmpPerson,_tmpPersonPicture,_tmpUserSession);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllLocalSessionsAsync(
      final Continuation<? super List<UserSessionAndPerson>> $completion) {
    final String _sql = "\n"
            + "            SELECT UserSession.*, Person.*, PersonPicture.*\n"
            + "              FROM UserSession\n"
            + "                   JOIN Person \n"
            + "                        ON Person.personUid = UserSession.usPersonUid\n"
            + "                   LEFT JOIN PersonPicture\n"
            + "                        ON PersonPicture.personPictureUid = UserSession.usPersonUid\n"
            + "             WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "               AND UserSession.usStatus = 1        \n"
            + "               AND (UserSession.usSessionType & 8) != 8\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UserSessionAndPerson>>() {
      @Override
      @NonNull
      public List<UserSessionAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<UserSessionAndPerson> _result = new ArrayList<UserSessionAndPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UserSessionAndPerson _item;
            final UserSession _tmpUserSession;
            if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
              _tmpUserSession = new UserSession();
              final long _tmpUsUid;
              _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
              _tmpUserSession.setUsUid(_tmpUsUid);
              final long _tmpUsPcsn;
              _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
              _tmpUserSession.setUsPcsn(_tmpUsPcsn);
              final long _tmpUsLcsn;
              _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
              _tmpUserSession.setUsLcsn(_tmpUsLcsn);
              final long _tmpUsLcb;
              _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
              _tmpUserSession.setUsLcb(_tmpUsLcb);
              final long _tmpUsLct;
              _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
              _tmpUserSession.setUsLct(_tmpUsLct);
              final long _tmpUsPersonUid;
              _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
              _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
              final long _tmpUsClientNodeId;
              _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
              _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
              final long _tmpUsStartTime;
              _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
              _tmpUserSession.setUsStartTime(_tmpUsStartTime);
              final long _tmpUsEndTime;
              _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
              _tmpUserSession.setUsEndTime(_tmpUsEndTime);
              final int _tmpUsStatus;
              _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
              _tmpUserSession.setUsStatus(_tmpUsStatus);
              final int _tmpUsReason;
              _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
              _tmpUserSession.setUsReason(_tmpUsReason);
              final String _tmpUsAuth;
              if (_cursor.isNull(_cursorIndexOfUsAuth)) {
                _tmpUsAuth = null;
              } else {
                _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
              }
              _tmpUserSession.setUsAuth(_tmpUsAuth);
              final int _tmpUsSessionType;
              _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
              _tmpUserSession.setUsSessionType(_tmpUsSessionType);
            } else {
              _tmpUserSession = null;
            }
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPersonPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPersonPicture = null;
            }
            _item = new UserSessionAndPerson(_tmpPerson,_tmpPersonPicture,_tmpUserSession);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findLocalSessionByUsername(final String username,
      final Continuation<? super UserSessionAndPerson> $completion) {
    final String _sql = "\n"
            + "            SELECT UserSession.*, Person.*\n"
            + "              FROM UserSession\n"
            + "                   JOIN Person ON UserSession.usPersonUid = Person.personUid\n"
            + "             WHERE Person.username = ?\n"
            + "               AND UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "               AND UserSession.usStatus = 1        \n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<UserSessionAndPerson>() {
      @Override
      @Nullable
      public UserSessionAndPerson call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final UserSessionAndPerson _result;
          if (_cursor.moveToFirst()) {
            final UserSession _tmpUserSession;
            if (!(_cursor.isNull(_cursorIndexOfUsUid) && _cursor.isNull(_cursorIndexOfUsPcsn) && _cursor.isNull(_cursorIndexOfUsLcsn) && _cursor.isNull(_cursorIndexOfUsLcb) && _cursor.isNull(_cursorIndexOfUsLct) && _cursor.isNull(_cursorIndexOfUsPersonUid) && _cursor.isNull(_cursorIndexOfUsClientNodeId) && _cursor.isNull(_cursorIndexOfUsStartTime) && _cursor.isNull(_cursorIndexOfUsEndTime) && _cursor.isNull(_cursorIndexOfUsStatus) && _cursor.isNull(_cursorIndexOfUsReason) && _cursor.isNull(_cursorIndexOfUsAuth) && _cursor.isNull(_cursorIndexOfUsSessionType))) {
              _tmpUserSession = new UserSession();
              final long _tmpUsUid;
              _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
              _tmpUserSession.setUsUid(_tmpUsUid);
              final long _tmpUsPcsn;
              _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
              _tmpUserSession.setUsPcsn(_tmpUsPcsn);
              final long _tmpUsLcsn;
              _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
              _tmpUserSession.setUsLcsn(_tmpUsLcsn);
              final long _tmpUsLcb;
              _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
              _tmpUserSession.setUsLcb(_tmpUsLcb);
              final long _tmpUsLct;
              _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
              _tmpUserSession.setUsLct(_tmpUsLct);
              final long _tmpUsPersonUid;
              _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
              _tmpUserSession.setUsPersonUid(_tmpUsPersonUid);
              final long _tmpUsClientNodeId;
              _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
              _tmpUserSession.setUsClientNodeId(_tmpUsClientNodeId);
              final long _tmpUsStartTime;
              _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
              _tmpUserSession.setUsStartTime(_tmpUsStartTime);
              final long _tmpUsEndTime;
              _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
              _tmpUserSession.setUsEndTime(_tmpUsEndTime);
              final int _tmpUsStatus;
              _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
              _tmpUserSession.setUsStatus(_tmpUsStatus);
              final int _tmpUsReason;
              _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
              _tmpUserSession.setUsReason(_tmpUsReason);
              final String _tmpUsAuth;
              if (_cursor.isNull(_cursorIndexOfUsAuth)) {
                _tmpUsAuth = null;
              } else {
                _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
              }
              _tmpUserSession.setUsAuth(_tmpUsAuth);
              final int _tmpUsSessionType;
              _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
              _tmpUserSession.setUsSessionType(_tmpUsSessionType);
            } else {
              _tmpUserSession = null;
            }
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            _result = new UserSessionAndPerson(_tmpPerson,null,_tmpUserSession);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object countAllLocalSessionsAsync(final long maxDateOfBirth,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "        SELECT COUNT(*)\n"
            + "          FROM UserSession\n"
            + "               JOIN Person \n"
            + "                    ON UserSession.usPersonUid = Person.personUid\n"
            + "         WHERE UserSession.usClientNodeId = (\n"
            + "                   SELECT COALESCE(\n"
            + "                          (SELECT nodeClientId \n"
            + "                            FROM SyncNode\n"
            + "                           LIMIT 1), 0))\n"
            + "           AND UserSession.usStatus = 1                \n"
            + "           AND (? = 0 OR Person.dateOfBirth < ?)\n"
            + "           AND (UserSession.usSessionType & 8) != 8            \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, maxDateOfBirth);
    _argIndex = 2;
    _statement.bindLong(_argIndex, maxDateOfBirth);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<UserSession> findByUidLive(final long sessionUid) {
    final String _sql = "\n"
            + "        SELECT UserSession.*\n"
            + "          FROM UserSession\n"
            + "         WHERE UserSession.usUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, sessionUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"UserSession"}, new Callable<UserSession>() {
      @Override
      @Nullable
      public UserSession call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usUid");
          final int _cursorIndexOfUsPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usPcsn");
          final int _cursorIndexOfUsLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcsn");
          final int _cursorIndexOfUsLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "usLcb");
          final int _cursorIndexOfUsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "usLct");
          final int _cursorIndexOfUsPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "usPersonUid");
          final int _cursorIndexOfUsClientNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "usClientNodeId");
          final int _cursorIndexOfUsStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usStartTime");
          final int _cursorIndexOfUsEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "usEndTime");
          final int _cursorIndexOfUsStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "usStatus");
          final int _cursorIndexOfUsReason = CursorUtil.getColumnIndexOrThrow(_cursor, "usReason");
          final int _cursorIndexOfUsAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "usAuth");
          final int _cursorIndexOfUsSessionType = CursorUtil.getColumnIndexOrThrow(_cursor, "usSessionType");
          final UserSession _result;
          if (_cursor.moveToFirst()) {
            _result = new UserSession();
            final long _tmpUsUid;
            _tmpUsUid = _cursor.getLong(_cursorIndexOfUsUid);
            _result.setUsUid(_tmpUsUid);
            final long _tmpUsPcsn;
            _tmpUsPcsn = _cursor.getLong(_cursorIndexOfUsPcsn);
            _result.setUsPcsn(_tmpUsPcsn);
            final long _tmpUsLcsn;
            _tmpUsLcsn = _cursor.getLong(_cursorIndexOfUsLcsn);
            _result.setUsLcsn(_tmpUsLcsn);
            final long _tmpUsLcb;
            _tmpUsLcb = _cursor.getLong(_cursorIndexOfUsLcb);
            _result.setUsLcb(_tmpUsLcb);
            final long _tmpUsLct;
            _tmpUsLct = _cursor.getLong(_cursorIndexOfUsLct);
            _result.setUsLct(_tmpUsLct);
            final long _tmpUsPersonUid;
            _tmpUsPersonUid = _cursor.getLong(_cursorIndexOfUsPersonUid);
            _result.setUsPersonUid(_tmpUsPersonUid);
            final long _tmpUsClientNodeId;
            _tmpUsClientNodeId = _cursor.getLong(_cursorIndexOfUsClientNodeId);
            _result.setUsClientNodeId(_tmpUsClientNodeId);
            final long _tmpUsStartTime;
            _tmpUsStartTime = _cursor.getLong(_cursorIndexOfUsStartTime);
            _result.setUsStartTime(_tmpUsStartTime);
            final long _tmpUsEndTime;
            _tmpUsEndTime = _cursor.getLong(_cursorIndexOfUsEndTime);
            _result.setUsEndTime(_tmpUsEndTime);
            final int _tmpUsStatus;
            _tmpUsStatus = _cursor.getInt(_cursorIndexOfUsStatus);
            _result.setUsStatus(_tmpUsStatus);
            final int _tmpUsReason;
            _tmpUsReason = _cursor.getInt(_cursorIndexOfUsReason);
            _result.setUsReason(_tmpUsReason);
            final String _tmpUsAuth;
            if (_cursor.isNull(_cursorIndexOfUsAuth)) {
              _tmpUsAuth = null;
            } else {
              _tmpUsAuth = _cursor.getString(_cursorIndexOfUsAuth);
            }
            _result.setUsAuth(_tmpUsAuth);
            final int _tmpUsSessionType;
            _tmpUsSessionType = _cursor.getInt(_cursorIndexOfUsSessionType);
            _result.setUsSessionType(_tmpUsSessionType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findActiveNodeIdsByPersonUids(final List<Long> personUids,
      final Continuation<? super List<Long>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE UserSession.usPersonUid IN (");
    final int _inputSize = personUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND UserSession.usStatus = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : personUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      @NonNull
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findActiveNodesIdsByGroupUids(final List<Long> groupUids,
      final Continuation<? super List<Long>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT DISTINCT UserSession.usClientNodeId");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM UserSession");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN PersonGroupMember ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON PersonGroupMember.groupMemberPersonUid = UserSession.usPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE PersonGroupMember.groupMemberGroupUid IN (");
    final int _inputSize = groupUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : groupUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      @NonNull
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object countActiveSessionsForUserAndNode(final long personUid, final long nodeId,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "        SELECT COUNT(*)\n"
            + "          FROM UserSession\n"
            + "         WHERE UserSession.usPersonUid = ?\n"
            + "           AND UserSession.usStatus = 1\n"
            + "           AND UserSession.usClientNodeId = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, nodeId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
