package com.ustadmobile.core.db.dao.xapi;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.StateDeleteCommand;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StateDeleteCommandDao_Impl extends StateDeleteCommandDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StateDeleteCommand> __insertionAdapterOfStateDeleteCommand;

  public StateDeleteCommandDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStateDeleteCommand = new EntityInsertionAdapter<StateDeleteCommand>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `StateDeleteCommand` (`sdcActorUid`,`sdcHash`,`sdcActivityUid`,`sdcStateId`,`sdcLastMod`,`sdcRegistrationHi`,`sdcRegistrationLo`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StateDeleteCommand entity) {
        statement.bindLong(1, entity.getSdcActorUid());
        statement.bindLong(2, entity.getSdcHash());
        statement.bindLong(3, entity.getSdcActivityUid());
        if (entity.getSdcStateId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getSdcStateId());
        }
        statement.bindLong(5, entity.getSdcLastMod());
        if (entity.getSdcRegistrationHi() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getSdcRegistrationHi());
        }
        if (entity.getSdcRegistrationLo() == null) {
          statement.bindNull(7);
        } else {
          statement.bindLong(7, entity.getSdcRegistrationLo());
        }
      }
    };
  }

  @Override
  public Object insertAsync(final StateDeleteCommand deleteCommand,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStateDeleteCommand.insert(deleteCommand);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
