package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.xapi.StateIdAndLastModified;
import com.ustadmobile.lib.db.entities.xapi.StateEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StateEntityDao_Impl extends StateEntityDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StateEntity> __insertionAdapterOfStateEntity;

  public StateEntityDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStateEntity = new EntityInsertionAdapter<StateEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `StateEntity` (`seActorUid`,`seHash`,`seActivityUid`,`seStateId`,`seLastMod`,`seTimeStored`,`seContentType`,`seCompressed`,`seContent`,`seDeleted`,`seRegistrationHi`,`seRegistrationLo`,`seH5PPreloaded`,`seH5PSubContentId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StateEntity entity) {
        statement.bindLong(1, entity.getSeActorUid());
        statement.bindLong(2, entity.getSeHash());
        statement.bindLong(3, entity.getSeActivityUid());
        statement.bindString(4, entity.getSeStateId());
        statement.bindLong(5, entity.getSeLastMod());
        statement.bindLong(6, entity.getSeTimeStored());
        statement.bindString(7, entity.getSeContentType());
        statement.bindLong(8, entity.getSeCompressed());
        statement.bindString(9, entity.getSeContent());
        final int _tmp = entity.getSeDeleted() ? 1 : 0;
        statement.bindLong(10, _tmp);
        if (entity.getSeRegistrationHi() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getSeRegistrationHi());
        }
        if (entity.getSeRegistrationLo() == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, entity.getSeRegistrationLo());
        }
        final int _tmp_1 = entity.getSeH5PPreloaded() ? 1 : 0;
        statement.bindLong(13, _tmp_1);
        if (entity.getSeH5PSubContentId() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getSeH5PSubContentId());
        }
      }
    };
  }

  @Override
  public Object upsertAsync(final List<StateEntity> stateEntities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStateEntity.insert(stateEntities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByActorAndHash(final long accountPersonUid, final long actorUid,
      final long seHash, final boolean includeDeleted,
      final Continuation<? super StateEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT StateEntity.*\n"
            + "          FROM StateEntity\n"
            + "         WHERE (SELECT ActorEntity.actorPersonUid\n"
            + "                  FROM ActorEntity\n"
            + "                 WHERE ActorEntity.actorUid = ?) = ?\n"
            + "           AND seActorUid = ?\n"
            + "           AND seHash = ?\n"
            + "           AND (   CAST(? AS INTEGER) = 1 \n"
            + "                OR CAST(StateEntity.seDeleted AS INTEGER) = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, seHash);
    _argIndex = 5;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<StateEntity>() {
      @Override
      @Nullable
      public StateEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActorUid");
          final int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow(_cursor, "seHash");
          final int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActivityUid");
          final int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow(_cursor, "seStateId");
          final int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "seLastMod");
          final int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow(_cursor, "seTimeStored");
          final int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "seContentType");
          final int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow(_cursor, "seCompressed");
          final int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow(_cursor, "seContent");
          final int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "seDeleted");
          final int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationHi");
          final int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationLo");
          final int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PPreloaded");
          final int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PSubContentId");
          final StateEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpSeActorUid;
            _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
            final long _tmpSeHash;
            _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
            final long _tmpSeActivityUid;
            _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
            final String _tmpSeStateId;
            _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
            final long _tmpSeLastMod;
            _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
            final long _tmpSeTimeStored;
            _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
            final String _tmpSeContentType;
            _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
            final int _tmpSeCompressed;
            _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
            final String _tmpSeContent;
            _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
            final boolean _tmpSeDeleted;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSeDeleted);
            _tmpSeDeleted = _tmp_1 != 0;
            final Long _tmpSeRegistrationHi;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationHi)) {
              _tmpSeRegistrationHi = null;
            } else {
              _tmpSeRegistrationHi = _cursor.getLong(_cursorIndexOfSeRegistrationHi);
            }
            final Long _tmpSeRegistrationLo;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationLo)) {
              _tmpSeRegistrationLo = null;
            } else {
              _tmpSeRegistrationLo = _cursor.getLong(_cursorIndexOfSeRegistrationLo);
            }
            final boolean _tmpSeH5PPreloaded;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
            _tmpSeH5PPreloaded = _tmp_2 != 0;
            final String _tmpSeH5PSubContentId;
            if (_cursor.isNull(_cursorIndexOfSeH5PSubContentId)) {
              _tmpSeH5PSubContentId = null;
            } else {
              _tmpSeH5PSubContentId = _cursor.getString(_cursorIndexOfSeH5PSubContentId);
            }
            _result = new StateEntity(_tmpSeActorUid,_tmpSeHash,_tmpSeActivityUid,_tmpSeStateId,_tmpSeLastMod,_tmpSeTimeStored,_tmpSeContentType,_tmpSeCompressed,_tmpSeContent,_tmpSeDeleted,_tmpSeRegistrationHi,_tmpSeRegistrationLo,_tmpSeH5PPreloaded,_tmpSeH5PSubContentId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByAgentAndActivity(final long accountPersonUid, final long actorUid,
      final long seActivityUid, final Long registrationUuidHi, final Long registrationUuidLo,
      final long modifiedSince, final Continuation<? super List<StateEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT StateEntity.*\n"
            + "          FROM StateEntity\n"
            + "         WHERE (SELECT ActorEntity.actorPersonUid\n"
            + "                  FROM ActorEntity\n"
            + "                 WHERE ActorEntity.actorUid = ?) = ?\n"
            + "           AND seActorUid = ?\n"
            + "           AND seActivityUid = ?\n"
            + "           AND (? = 0 OR StateEntity.seLastMod > ?)\n"
            + "           AND ((    ? IS NULL\n"
            + "                 AND StateEntity.seRegistrationHi IS NULL\n"
            + "                 AND ? IS NULL \n"
            + "                 AND StateEntity.seRegistrationLo IS NULL)\n"
            + "             OR (    StateEntity.seRegistrationHi = ? \n"
            + "                 AND StateEntity.seRegistrationLo = ?))\n"
            + "           AND StateEntity.seStateId IS NOT NULL  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, seActivityUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, modifiedSince);
    _argIndex = 6;
    _statement.bindLong(_argIndex, modifiedSince);
    _argIndex = 7;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 8;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    _argIndex = 9;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 10;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StateEntity>>() {
      @Override
      @NonNull
      public List<StateEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActorUid");
          final int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow(_cursor, "seHash");
          final int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActivityUid");
          final int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow(_cursor, "seStateId");
          final int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "seLastMod");
          final int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow(_cursor, "seTimeStored");
          final int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "seContentType");
          final int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow(_cursor, "seCompressed");
          final int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow(_cursor, "seContent");
          final int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "seDeleted");
          final int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationHi");
          final int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationLo");
          final int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PPreloaded");
          final int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PSubContentId");
          final List<StateEntity> _result = new ArrayList<StateEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StateEntity _item;
            final long _tmpSeActorUid;
            _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
            final long _tmpSeHash;
            _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
            final long _tmpSeActivityUid;
            _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
            final String _tmpSeStateId;
            _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
            final long _tmpSeLastMod;
            _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
            final long _tmpSeTimeStored;
            _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
            final String _tmpSeContentType;
            _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
            final int _tmpSeCompressed;
            _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
            final String _tmpSeContent;
            _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
            final boolean _tmpSeDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSeDeleted);
            _tmpSeDeleted = _tmp != 0;
            final Long _tmpSeRegistrationHi;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationHi)) {
              _tmpSeRegistrationHi = null;
            } else {
              _tmpSeRegistrationHi = _cursor.getLong(_cursorIndexOfSeRegistrationHi);
            }
            final Long _tmpSeRegistrationLo;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationLo)) {
              _tmpSeRegistrationLo = null;
            } else {
              _tmpSeRegistrationLo = _cursor.getLong(_cursorIndexOfSeRegistrationLo);
            }
            final boolean _tmpSeH5PPreloaded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
            _tmpSeH5PPreloaded = _tmp_1 != 0;
            final String _tmpSeH5PSubContentId;
            if (_cursor.isNull(_cursorIndexOfSeH5PSubContentId)) {
              _tmpSeH5PSubContentId = null;
            } else {
              _tmpSeH5PSubContentId = _cursor.getString(_cursorIndexOfSeH5PSubContentId);
            }
            _item = new StateEntity(_tmpSeActorUid,_tmpSeHash,_tmpSeActivityUid,_tmpSeStateId,_tmpSeLastMod,_tmpSeTimeStored,_tmpSeContentType,_tmpSeCompressed,_tmpSeContent,_tmpSeDeleted,_tmpSeRegistrationHi,_tmpSeRegistrationLo,_tmpSeH5PPreloaded,_tmpSeH5PSubContentId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getStateIds(final long accountPersonUid, final long actorUid,
      final long seActivityUid, final Long registrationUuidHi, final Long registrationUuidLo,
      final long modifiedSince,
      final Continuation<? super List<StateIdAndLastModified>> $completion) {
    final String _sql = "\n"
            + "        SELECT StateEntity.seStateId, StateEntity.seLastMod\n"
            + "          FROM StateEntity\n"
            + "         WHERE (SELECT ActorEntity.actorPersonUid\n"
            + "                  FROM ActorEntity\n"
            + "                 WHERE ActorEntity.actorUid = ?) = ?\n"
            + "           AND seActorUid = ?\n"
            + "           AND seActivityUid = ?\n"
            + "           AND (? = 0 OR StateEntity.seLastMod > ?)\n"
            + "           AND ((    ? IS NULL\n"
            + "                 AND StateEntity.seRegistrationHi IS NULL\n"
            + "                 AND ? IS NULL \n"
            + "                 AND StateEntity.seRegistrationLo IS NULL)\n"
            + "             OR (    StateEntity.seRegistrationHi = ? \n"
            + "                 AND StateEntity.seRegistrationLo = ?))\n"
            + "           AND StateEntity.seStateId IS NOT NULL \n"
            + "           AND CAST(StateEntity.seDeleted AS INTEGER) = 0      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, seActivityUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, modifiedSince);
    _argIndex = 6;
    _statement.bindLong(_argIndex, modifiedSince);
    _argIndex = 7;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 8;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    _argIndex = 9;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 10;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StateIdAndLastModified>>() {
      @Override
      @NonNull
      public List<StateIdAndLastModified> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSeStateId = 0;
          final int _cursorIndexOfSeLastMod = 1;
          final List<StateIdAndLastModified> _result = new ArrayList<StateIdAndLastModified>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StateIdAndLastModified _item;
            final String _tmpSeStateId;
            _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
            final long _tmpSeLastMod;
            _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
            _item = new StateIdAndLastModified(_tmpSeStateId,_tmpSeLastMod);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getH5PPreload(final long accountPersonUid, final long actorUid,
      final long seActivityUid, final Long registrationUuidHi, final Long registrationUuidLo,
      final Continuation<? super List<StateEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT StateEntity.*\n"
            + "          FROM StateEntity\n"
            + "         WHERE (SELECT ActorEntity.actorPersonUid\n"
            + "                  FROM ActorEntity\n"
            + "                 WHERE ActorEntity.actorUid = ?) = ?\n"
            + "           AND seActorUid = ?\n"
            + "           AND seActivityUid = ? \n"
            + "           AND ((    ? IS NULL\n"
            + "                 AND StateEntity.seRegistrationHi IS NULL\n"
            + "                 AND ? IS NULL \n"
            + "                 AND StateEntity.seRegistrationLo IS NULL)\n"
            + "             OR (    StateEntity.seRegistrationHi = ? \n"
            + "                 AND StateEntity.seRegistrationLo = ?))\n"
            + "           AND StateEntity.seH5PSubContentId IS NOT NULL      \n"
            + "           AND CAST(StateEntity.seH5PPreloaded AS INTEGER) = 1      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 8);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, seActivityUid);
    _argIndex = 5;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 6;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    _argIndex = 7;
    if (registrationUuidHi == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidHi);
    }
    _argIndex = 8;
    if (registrationUuidLo == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindLong(_argIndex, registrationUuidLo);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StateEntity>>() {
      @Override
      @NonNull
      public List<StateEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActorUid");
          final int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow(_cursor, "seHash");
          final int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "seActivityUid");
          final int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow(_cursor, "seStateId");
          final int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "seLastMod");
          final int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow(_cursor, "seTimeStored");
          final int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "seContentType");
          final int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow(_cursor, "seCompressed");
          final int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow(_cursor, "seContent");
          final int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "seDeleted");
          final int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationHi");
          final int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "seRegistrationLo");
          final int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PPreloaded");
          final int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow(_cursor, "seH5PSubContentId");
          final List<StateEntity> _result = new ArrayList<StateEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StateEntity _item;
            final long _tmpSeActorUid;
            _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
            final long _tmpSeHash;
            _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
            final long _tmpSeActivityUid;
            _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
            final String _tmpSeStateId;
            _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
            final long _tmpSeLastMod;
            _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
            final long _tmpSeTimeStored;
            _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
            final String _tmpSeContentType;
            _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
            final int _tmpSeCompressed;
            _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
            final String _tmpSeContent;
            _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
            final boolean _tmpSeDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSeDeleted);
            _tmpSeDeleted = _tmp != 0;
            final Long _tmpSeRegistrationHi;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationHi)) {
              _tmpSeRegistrationHi = null;
            } else {
              _tmpSeRegistrationHi = _cursor.getLong(_cursorIndexOfSeRegistrationHi);
            }
            final Long _tmpSeRegistrationLo;
            if (_cursor.isNull(_cursorIndexOfSeRegistrationLo)) {
              _tmpSeRegistrationLo = null;
            } else {
              _tmpSeRegistrationLo = _cursor.getLong(_cursorIndexOfSeRegistrationLo);
            }
            final boolean _tmpSeH5PPreloaded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
            _tmpSeH5PPreloaded = _tmp_1 != 0;
            final String _tmpSeH5PSubContentId;
            if (_cursor.isNull(_cursorIndexOfSeH5PSubContentId)) {
              _tmpSeH5PSubContentId = null;
            } else {
              _tmpSeH5PSubContentId = _cursor.getString(_cursorIndexOfSeH5PSubContentId);
            }
            _item = new StateEntity(_tmpSeActorUid,_tmpSeHash,_tmpSeActivityUid,_tmpSeStateId,_tmpSeLastMod,_tmpSeTimeStored,_tmpSeContentType,_tmpSeCompressed,_tmpSeContent,_tmpSeDeleted,_tmpSeRegistrationHi,_tmpSeRegistrationLo,_tmpSeH5PPreloaded,_tmpSeH5PSubContentId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
